/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.text.IFormat;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public final class ObjectSymbol
extends ObjectDecor {
    Symbol sym;
    private static Point gp = new Point();

    public ObjectSymbol() {
        this(null, 0, 0.0, 0.0, 0.0f);
    }

    public ObjectSymbol(Symbol symbol, int n, double d, double d2, float f) {
        super(n, d, d2, f);
        this.sym = symbol;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Sym:");
        stringBuffer.append(" ");
        if (this.getOska() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append("O=");
            stringBuffer.append(IFormat.i04.format(this.getOska()).toString());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" ");
            stringBuffer.append("Y=");
            stringBuffer.append(IFormat.f_1.format(this.y).toString());
            stringBuffer.append(" ");
            stringBuffer.append("X=");
            stringBuffer.append(IFormat.f_1.format(this.x).toString());
        }
        if (this.hasDecorLocation()) {
            stringBuffer.append(" ");
            stringBuffer.append("y=");
            stringBuffer.append(IFormat.f_1.format(this.yt).toString());
            stringBuffer.append(" ");
            stringBuffer.append("x=");
            stringBuffer.append(IFormat.f_1.format(this.xt).toString());
        }
        stringBuffer.append(" ");
        stringBuffer.append("W=");
        stringBuffer.append(IFormat.f_1.format((double)(this.getAngle() * 200.0f) / Math.PI).toString());
        return stringBuffer.toString();
    }

    public static Object parseDatLine(String string) throws IException {
        ObjectSymbol objectSymbol = new ObjectSymbol();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    int n = string2.indexOf(61);
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    if (string3.equalsIgnoreCase("O")) {
                        int n2 = Integer.parseInt(string4);
                        objectSymbol.setOska(n2);
                        try {
                            objectSymbol.sym = Symbol.getSymbol(n2);
                            continue;
                        }
                        catch (Exception exception) {
                            throw new IException("Symbol mit dem Oska " + n2 + " nicht vorhanden");
                        }
                    }
                    if (string3.equals("Y")) {
                        objectSymbol.y = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equals("X")) {
                        objectSymbol.x = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equals("y")) {
                        objectSymbol.yt = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equals("x")) {
                        objectSymbol.xt = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("W")) {
                        objectSymbol.setAngle((float)(Double.valueOf(string4) / 200.0 * Math.PI));
                        continue;
                    }
                    throw new IException("unzul\u00e4ssige Variable: " + string3);
                }
                catch (IException iException) {
                    throw iException;
                }
                catch (Exception exception) {
                    throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
            }
        }
        return objectSymbol;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(62);
        dataOutput.writeShort(this.getOska());
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.hasDecorLocation()) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeFloat(this.getAngle());
        KafPlotIOConstants.writeString(dataOutput, this.sym != null ? this.sym.getName() : null);
    }

    public static ObjectSymbol readObject(DataInput dataInput) throws IOException {
        ObjectSymbol objectSymbol = new ObjectSymbol();
        objectSymbol.setOska(dataInput.readShort());
        objectSymbol.y = dataInput.readDouble();
        objectSymbol.x = dataInput.readDouble();
        if (dataInput.readByte() != 0) {
            objectSymbol.yt = dataInput.readDouble();
            objectSymbol.xt = dataInput.readDouble();
        }
        objectSymbol.setAngle(dataInput.readFloat());
        try {
            objectSymbol.sym = Symbol.getSymbol(KafPlotIOConstants.readString(dataInput));
        }
        catch (IException iException) {
            objectSymbol.sym = Symbol.UNDEF;
        }
        return objectSymbol;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!iGraphics.contains(this.y, this.x)) {
            return;
        }
        if (this.sym != null) {
            Graphics graphics = iGraphics.getGraphics();
            if (bl2) {
                iGraphics.setXORMode();
            } else {
                iGraphics.setPaintMode();
            }
            gp = iGraphics.getGraphicPoint(this.y, this.x, gp);
            Symbol.setForeground(this.getForeground());
            Symbol.setBackground(this.getBackground());
            this.sym.draw(graphics, ObjectSymbol.gp.x, ObjectSymbol.gp.y, iGraphics.getRotation() + (double)this.getAngle(), 0.2, (byte)2);
        }
    }
}

