/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.TextArt;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.text.IFormat;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public final class ObjectText
extends ObjectDecor {
    private static final TextArt TA = TextArt.create(2);
    private String text;
    private TextArt ta = TA;
    private byte pos;
    private float scale;
    private float width;
    private static Point gp = new Point();

    public ObjectText() {
        this(null, 0, 0.0, 0.0, 0.0f);
    }

    public ObjectText(String string, int n, double d, double d2, float f) {
        super(n, d, d2, f);
        this.text = string;
    }

    public ObjectText(String string, int n, double d, double d2, float f, byte by, float f2, float f3) {
        super(n, d, d2, f);
        this.text = string;
        this.pos = by;
        this.scale = f2;
        this.width = f3;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "OT: " + this.text;
    }

    public final String toGeografOutLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TA");
        stringBuffer.append(n);
        stringBuffer.append(": ");
        stringBuffer.append(GGIOProperties.getDosString(this.text));
        stringBuffer.append("\n");
        stringBuffer.append("TE");
        stringBuffer.append(n);
        stringBuffer.append(": ,");
        stringBuffer.append(this.getOska());
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.hasDecorLocation() ? this.yt : this.y).toString());
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.hasDecorLocation() ? this.xt : this.x).toString());
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.y).toString());
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.x).toString());
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_1.format((double)this.getAngle() * 200.0 / Math.PI).toString());
        stringBuffer.append(",0,0,1,0,0.0000,0,0.0000,0.0000,0.000000");
        return stringBuffer.toString();
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Txt:");
        stringBuffer.append(" ");
        if (this.text != null) {
            String string = this.text.replace(' ', '_').replace('\n', '\\');
            stringBuffer.append(string);
            if (this.getOska() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append("O=");
                stringBuffer.append(IFormat.i04.format(this.getOska()).toString());
            }
            if (this.hasLocation()) {
                stringBuffer.append(" ");
                stringBuffer.append("Y=");
                stringBuffer.append(IFormat.f_1.format(this.y).toString());
                stringBuffer.append(" ");
                stringBuffer.append("X=");
                stringBuffer.append(IFormat.f_1.format(this.x).toString());
            }
            if (this.hasDecorLocation()) {
                stringBuffer.append(" ");
                stringBuffer.append("y=");
                stringBuffer.append(IFormat.f_1.format(this.yt).toString());
                stringBuffer.append(" ");
                stringBuffer.append("x=");
                stringBuffer.append(IFormat.f_1.format(this.xt).toString());
            }
            stringBuffer.append(" ");
            stringBuffer.append("W=");
            stringBuffer.append(IFormat.f_1.format((double)this.getAngle() * 200.0 / Math.PI).toString());
        }
        return stringBuffer.toString();
    }

    public static Object parseDatLine(String string) throws IException {
        ObjectText objectText = new ObjectText();
        if (string != null) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.indexOf(61) > -1) {
                    throw new IException("unzul\u00e4ssiges Zeichen: '=' in der Zeichenkette: " + string2);
                }
                objectText.setText(string2.replace('_', ' ').replace('\\', '\n'));
            }
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                String string3 = null;
                String string4 = null;
                try {
                    int n = string2.indexOf(61);
                    string3 = string2.substring(0, n);
                    string4 = string2.substring(n + 1);
                }
                catch (Exception exception) {
                    throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
                try {
                    if (string3.equalsIgnoreCase("O")) {
                        objectText.setOska(Integer.parseInt(string4));
                        continue;
                    }
                    if (string3.equals("Y")) {
                        objectText.y = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equals("X")) {
                        objectText.x = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equals("y")) {
                        objectText.yt = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equals("x")) {
                        objectText.xt = Double.valueOf(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("W")) {
                        objectText.setAngle((float)(Double.valueOf(string4) / 200.0 * Math.PI));
                        continue;
                    }
                    throw new IException("unzul\u00e4ssige Variable: " + string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
            }
        }
        return objectText;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(61);
        dataOutput.writeShort(this.getOska());
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.hasDecorLocation()) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeFloat(this.getAngle());
        KafPlotIOConstants.writeString(dataOutput, this.text);
    }

    public static ObjectText readObject(DataInput dataInput) throws IOException {
        ObjectText objectText = new ObjectText();
        objectText.setOska(dataInput.readShort());
        objectText.y = dataInput.readDouble();
        objectText.x = dataInput.readDouble();
        if (dataInput.readByte() != 0) {
            objectText.yt = dataInput.readDouble();
            objectText.xt = dataInput.readDouble();
        }
        objectText.setAngle(dataInput.readFloat());
        objectText.text = KafPlotIOConstants.readString(dataInput);
        return objectText;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!iGraphics.contains(this.y, this.x)) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        graphics.setColor(this.getForeground());
        if (bl2) {
            iGraphics.setXORMode();
        } else {
            iGraphics.setPaintMode();
        }
        TextSymbol.paint(graphics, this.text, iGraphics.getGraphicPoint(this.y, this.x, gp), this.ta, 0, 0, (double)this.getAngle() + iGraphics.getRotation(), 1.0);
    }
}

