/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.text.GeoNumberFormat;
import java.awt.Graphics;
import java.util.Vector;

public class OrthoLinie
extends Vector {
    private Punkt oa = null;
    private Punkt oe = null;
    private double sm = 1.0;
    private double xa;
    private double ya;
    private double xe;
    private double ye;
    private double x0;
    private double y0;
    private double X0;
    private double Y0;
    private double maxDist;
    private double o;
    private double a;
    private double oT;
    private double aT;
    private boolean param = false;
    private boolean _drawText = true;

    public OrthoLinie() {
    }

    public OrthoLinie(Punkt punkt, Punkt punkt2) {
        this.setAnfangsPunkt(punkt);
        this.setEndPunkt(punkt2);
    }

    public OrthoLinie(Punkt punkt, Punkt punkt2, double d, double d2) {
        this.setAnfangsPunkt(punkt);
        this.setEndPunkt(punkt2);
        this.setAnfangsMass(d);
        this.setAnfangsOrdinate(d2);
    }

    public OrthoLinie(Punkt punkt, Punkt punkt2, double d, double d2, double d3, double d4) {
        this.setAnfangsPunkt(punkt);
        this.setEndPunkt(punkt2);
        this.setAnfangsMasse(d, d2);
        this.setEndMasse(d3, d4);
    }

    public void setAnfangsPunkt(Punkt punkt) {
        this.oa = punkt;
        this.xa = 0.0;
        this.ya = 0.0;
        this.param = false;
    }

    public Punkt getAnfangsPunkt() {
        if (this.oa == null && this.size() > 0) {
            this.oa = (Punkt)this.firstElement();
        }
        return this.oa;
    }

    public Punkt getAnfangsNullPunkt() {
        if (this.ya == 0.0) {
            return this.getAnfangsPunkt();
        }
        return this.getPunktOf(this.xa, 0.0);
    }

    public void setEndPunkt(Punkt punkt) {
        this.oe = punkt;
        this.xe = 0.0;
        this.ye = 0.0;
        this.param = false;
    }

    public Punkt getEndPunkt() {
        if (this.oe == null && this.size() > 0) {
            this.oe = (Punkt)this.lastElement();
        }
        return this.oe;
    }

    public void setMasstab(double d) {
        this.sm = d;
        this.param = false;
    }

    public double getMasstab() {
        return this.sm;
    }

    public void setAnfangsMass(double d) {
        this.xa = d;
        this.param = false;
    }

    public double getAnfangsMass() {
        return this.xa;
    }

    public void setAnfangsOrdinate(double d) {
        this.ya = d;
        this.param = false;
    }

    public double getAnfangsOrdinate() {
        return this.ya;
    }

    public void setAnfangsMasse(double d, double d2) {
        this.xa = d;
        this.ya = d2;
        this.param = false;
    }

    public void setEndMass(double d) {
        this.xe = d;
        this.param = false;
    }

    public double getEndMass() {
        if (!this.param) {
            this.setTrafoParameter();
        }
        return this.xe;
    }

    public void setEndOrdinate(double d) {
        this.ye = d;
        this.param = false;
    }

    public double getEndOrdinate() {
        return this.ye;
    }

    public void setEndMasse(double d, double d2) {
        this.xe = d;
        this.ye = d2;
        this.param = false;
    }

    public void setMaxEinrechenDistance(double d) {
        this.maxDist = d;
    }

    public double getMaxEinrechenDistance() {
        return this.maxDist;
    }

    public boolean isStrecke() {
        return this.size() == 0 && this.xa == 0.0 && this.ya == 0.0 && this.ye == 0.0;
    }

    public Messung getEndMessung() {
        if (!this.param) {
            this.setTrafoParameter();
        }
        Messung messung = this.getMessungOf(this.oe);
        if (this.isStrecke()) {
            return new Messung(220, this.oa, this.oe, messung.l1, 0.0);
        }
        return messung;
    }

    public Punkt getPunktAt(int n) {
        return (Punkt)this.elementAt(n);
    }

    public Messung getMessungAt(int n) {
        return this.getMessungOf((Punkt)this.elementAt(n));
    }

    public Messung getMessungOf(Punkt punkt) {
        if (!this.param) {
            this.setTrafoParameter();
        }
        return new Messung(200, punkt, null, this.xa + (this.aT * (punkt.x - this.oa.x) - this.oT * (punkt.y - this.oa.y)), this.ya + (this.oT * (punkt.x - this.oa.x) + this.aT * (punkt.y - this.oa.y)));
    }

    public Punkt getPunktOf(Messung messung) {
        return this.getPunktOf(messung.l1, messung.l2);
    }

    public Punkt getPunktOf(double d, double d2) {
        if (!this.param) {
            this.setTrafoParameter();
        }
        return new Punkt(0L, this.oa.y + this.o * (d - this.xa) + this.a * (d2 - this.ya), this.oa.x + this.a * (d - this.xa) - this.o * (d2 - this.ya));
    }

    public Punkt getLotfusspunktAt(int n) {
        return this.getLotfusspunktOf((Punkt)this.elementAt(n));
    }

    public Punkt getLotfusspunktOf(Punkt punkt) {
        if (!this.param) {
            this.setTrafoParameter();
        }
        Punkt punkt2 = new Punkt();
        double d = this.xa + (this.aT * (punkt.x - this.oa.x) - this.oT * (punkt.y - this.oa.y));
        double d2 = this.ya + (this.oT * (punkt.x - this.oa.x) + this.aT * (punkt.y - this.oa.y));
        punkt2.y = this.oa.y + this.o * (d - this.xa) + this.a * -this.ya;
        punkt2.x = this.oa.x + this.a * (d - this.xa) - this.o * -this.ya;
        return punkt2;
    }

    public double getA() {
        if (!this.param) {
            this.setTrafoParameter();
        }
        return this.a;
    }

    public double getO() {
        if (!this.param) {
            this.setTrafoParameter();
        }
        return this.o;
    }

    public void setPunktInLinieAt(int n) throws SurveyException {
        if (!this.param) {
            this.setTrafoParameter();
        }
        Punkt punkt = (Punkt)this.elementAt(n);
        double d = this.xa + (this.aT * (punkt.x - this.oa.x) - this.oT * (punkt.y - this.oa.y));
        double d2 = this.ya + (this.oT * (punkt.x - this.oa.x) + this.aT * (punkt.y - this.oa.y));
        double d3 = this.oa.y + this.o * (d - this.xa) + this.a * -this.ya;
        double d4 = this.oa.x + this.a * (d - this.xa) - this.o * -this.ya;
        punkt.dy = (float)(d3 - (punkt.y - (double)punkt.dy));
        punkt.dx = (float)(d4 - (punkt.x - (double)punkt.dx));
        punkt.dl = (float)Math.abs(d2);
        punkt.y = d3;
        punkt.x = d4;
        if (Math.abs(d2) > this.maxDist) {
            throw new SurveyException("Fehler in Einrechenlinie von Punkt " + this.oa.nr + " nach Punkt " + this.oe.nr, "Einrechenpunkt " + punkt.nr + " wurde mit einer Abweichung von " + GeoNumberFormat.koo03.format(d2).toString() + " eingerechnet");
        }
    }

    private void setTrafoParameter() {
        if (this.oa == null && this.size() > 0) {
            this.oa = (Punkt)this.firstElement();
        }
        if (this.oe == null && this.size() > 0) {
            this.oe = (Punkt)this.lastElement();
        }
        if (this.oa == null || this.oe == null || this.oa == this.oe) {
            return;
        }
        this.sm = DataBase.getStreckeMasstab((this.oa.y + this.oe.y) / 2.0);
        double d = ((this.oe.x - this.oa.x) * (this.oe.x - this.oa.x) + (this.oe.y - this.oa.y) * (this.oe.y - this.oa.y)) * (this.sm * this.sm);
        if (this.xe == 0.0) {
            this.xe = this.xa + Math.sqrt(d - (this.ye - this.ya) * (this.ye - this.ya));
        }
        double d2 = (this.xe - this.xa) * (this.xe - this.xa) + (this.ye - this.ya) * (this.ye - this.ya);
        this.o = ((this.xe - this.xa) * (this.oe.y - this.oa.y) - (this.ye - this.ya) * (this.oe.x - this.oa.x)) / d2;
        this.a = ((this.ye - this.ya) * (this.oe.y - this.oa.y) + (this.xe - this.xa) * (this.oe.x - this.oa.x)) / d2;
        double d3 = this.a * this.a + this.o * this.o;
        this.oT = -this.o / d3;
        this.aT = this.a / d3;
        this.param = true;
    }

    private boolean isCorrectParameter() {
        return !Double.isNaN(this.xe) && !Double.isNaN(this.o) && !Double.isNaN(this.a) && !Double.isNaN(this.oT) && !Double.isNaN(this.aT);
    }

    public void drawSymbol(IGraphics iGraphics) {
        this.drawSymbol(iGraphics, false);
    }

    public void drawSymbol(IGraphics iGraphics, boolean bl) {
        Graphics graphics = iGraphics.getGraphics();
        if (this.oa == null) {
            return;
        }
        if (!this.param) {
            this.setTrafoParameter();
        }
        if (!this.param) {
            if (this.oa != null) {
                this.oa.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, true);
            }
        } else if (!this.isCorrectParameter()) {
            new Messung(-100, this.oa, this.oe).drawSymbol(iGraphics, bl);
        } else {
            Punkt punkt = this.oa;
            Punkt punkt2 = this.oe;
            Messung messung = null;
            Messung messung2 = null;
            Messung messung3 = null;
            if (this.ya != 0.0) {
                punkt = this.getLotfusspunktOf(this.oa);
                messung = new Messung(200, this.oa, punkt);
                messung.drawSymbol(iGraphics, bl);
            }
            if (this.oa != null) {
                this.oa.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
            }
            if (this.ye != 0.0) {
                punkt2 = this.getLotfusspunktOf(this.oe);
                messung2 = new Messung(200, this.oe, punkt2);
                messung2.drawSymbol(iGraphics, bl);
                this.oe.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
            }
            if (this.oe != null && this.oe != this.oa) {
                this.oe.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
            }
            messung = new Messung(-100, punkt, punkt2);
            messung.drawSymbol(iGraphics, bl);
            for (int i = 0; i < this.size(); ++i) {
                Punkt punkt3;
                Object e = this.elementAt(i);
                if (!(e instanceof Punkt) || (punkt3 = (Punkt)e) == this.oa || punkt3 == this.oe || punkt3.y == 0.0 || punkt3.x == 0.0) continue;
                Punkt punkt4 = this.getLotfusspunktOf(punkt3);
                messung3 = new Messung(200, punkt3, punkt4);
                messung3.drawSymbol(iGraphics, bl);
                messung3 = this.getMessungOf(punkt3);
                if (messung3.l1 < this.xa) {
                    messung3 = new Messung(-100, punkt4, punkt);
                    messung3.drawSymbol(iGraphics, bl);
                } else if (messung3.l1 > this.xe) {
                    messung3 = new Messung(-100, punkt4, punkt2);
                    messung3.drawSymbol(iGraphics, bl);
                }
                punkt3.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
            }
        }
    }
}

