/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.INumTextField;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.text.GeoNumberFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class OrthoLinieDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "OK";
    private static final String DO_COMMAND = "\u00dcbernehmen";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String VOID = " ";
    private OrthoLinie O;
    private INumTextField oaTextField;
    private INumTextField xaTextField;
    private INumTextField yaTextField;
    private INumTextField oeTextField;
    private INumTextField xeTextField;
    private INumTextField yeTextField;
    private INumTextField onTextField;
    private INumTextField xnTextField;
    private INumTextField ynTextField;

    public OrthoLinieDialog(IFrame iFrame, String string) {
        this(iFrame, string, null);
    }

    public OrthoLinieDialog(IFrame iFrame, String string, OrthoLinie orthoLinie) {
        super(iFrame, string, true);
        this.O = orthoLinie;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createOrthoLiniePanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setOrthoLinie(orthoLinie);
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(true);
    }

    private IPanel createOrthoLiniePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Punktnummer", 1);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Abzisse", 1);
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Ordinate", 1);
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Anfangspunkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.oaTextField = new INumTextField(12);
        iPanel.add(this.oaTextField);
        this.oaTextField.addActionListener(this);
        this.oaTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.oaTextField, gridBagConstraints);
        this.xaTextField = new INumTextField(8);
        iPanel.add(this.xaTextField);
        this.xaTextField.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.xaTextField, gridBagConstraints);
        this.yaTextField = new INumTextField(8);
        iPanel.add(this.yaTextField);
        this.yaTextField.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.yaTextField, gridBagConstraints);
        label = new Label("Endpunkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.oeTextField = new INumTextField(12);
        iPanel.add(this.oeTextField);
        this.oeTextField.addActionListener(this);
        this.oeTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.oeTextField, gridBagConstraints);
        this.xeTextField = new INumTextField(8);
        iPanel.add(this.xeTextField);
        this.xeTextField.addActionListener(this);
        this.xeTextField.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.xeTextField, gridBagConstraints);
        this.yeTextField = new INumTextField(8);
        iPanel.add(this.yeTextField);
        this.yeTextField.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.yeTextField, gridBagConstraints);
        label = new Label("Neupunkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.onTextField = new INumTextField(12);
        iPanel.add(this.onTextField);
        this.onTextField.addActionListener(this);
        this.onTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.onTextField, gridBagConstraints);
        this.xnTextField = new INumTextField(8);
        iPanel.add(this.xnTextField);
        this.xnTextField.addActionListener(this);
        this.xnTextField.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.xnTextField, gridBagConstraints);
        this.ynTextField = new INumTextField(8);
        iPanel.add(this.ynTextField);
        this.ynTextField.addActionListener(this);
        this.ynTextField.setEditable(false);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.ynTextField, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(DO_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        Button button3 = new Button(ABORT_COMMAND);
        button3.addActionListener(this);
        panel.add(button3);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (actionEvent.getActionCommand().equals(DO_COMMAND) || object instanceof INumTextField) {
            if (this.actionListener != null && this.actionCommand != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
            this.setOrthoLinie(this.O);
        } else if (actionEvent.getActionCommand().equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    public void setOrthoLinie(OrthoLinie orthoLinie) {
        this.O = orthoLinie;
        if (orthoLinie == null) {
            return;
        }
        Punkt punkt = orthoLinie.getAnfangsPunkt();
        this.oaTextField.setText(punkt != null ? GeoNumberFormat.nr.format(KafPlotProperties.getVisiblePunktNummer(punkt)).toString() : VOID);
        this.xaTextField.setText(punkt != null ? GeoNumberFormat.m43.format(orthoLinie.getAnfangsMass()).toString() : VOID);
        this.yaTextField.setText(punkt != null ? GeoNumberFormat.m43.format(orthoLinie.getAnfangsOrdinate()).toString() : VOID);
        Punkt punkt2 = orthoLinie.getEndPunkt();
        this.oeTextField.setText(punkt2 != null ? GeoNumberFormat.nr.format(KafPlotProperties.getVisiblePunktNummer(punkt2)).toString() : VOID);
        this.xeTextField.setText(punkt2 != null ? GeoNumberFormat.m43.format(orthoLinie.getEndMass()).toString() : VOID);
        this.yeTextField.setText(punkt2 != null ? GeoNumberFormat.m43.format(orthoLinie.getEndOrdinate()).toString() : VOID);
        Punkt punkt3 = orthoLinie.size() > 0 ? (Punkt)orthoLinie.elementAt(0) : null;
        Messung messung = punkt3 != null ? orthoLinie.getMessungOf(punkt3) : null;
        this.onTextField.setText(punkt3 != null ? GeoNumberFormat.nr.format(KafPlotProperties.getVisiblePunktNummer(punkt3)).toString() : VOID);
        this.xnTextField.setText(punkt3 != null ? GeoNumberFormat.m43.format(messung.l1).toString() : VOID);
        this.ynTextField.setText(punkt3 != null ? GeoNumberFormat.m43.format(messung.l2).toString() : VOID);
    }

    public OrthoLinie getOrthoLinie() {
        return this.O;
    }

    public OrthoLinie getUpdatedOrthoLinie() {
        this.setValues();
        return this.O;
    }

    private void setValues() {
        try {
            this.O.setAnfangsMass(new Double(this.xaTextField.getText()));
        }
        catch (Exception exception) {
            this.O.setAnfangsMass(0.0);
        }
        try {
            this.O.setAnfangsOrdinate(new Double(this.yaTextField.getText()));
        }
        catch (Exception exception) {
            this.O.setAnfangsOrdinate(0.0);
        }
        this.O.setEndMass(0.0);
        try {
            this.O.setEndOrdinate(new Double(this.yeTextField.getText()));
        }
        catch (Exception exception) {
            this.O.setEndOrdinate(0.0);
        }
    }

    @Override
    protected void doStandardAction() {
        if (this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

