/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import java.util.Enumeration;

public class Oska
implements IntegerHashObject {
    public static final int GEB_DAR_TYP0 = 0;
    public static final int GEB_DAR_TYP1 = 1;
    public static final int GEB_DAR_TYP2 = 2;
    public static final int GEB_DAR_TYP3 = 3;
    public static final int GEB_DAR_TYP4 = 4;
    public static final int GEB_DAR_TYP5 = 5;
    public static final int GEB_DAR_TYP6 = 6;
    public static final int GEB_DAR_TYP7 = 7;
    public static final int FOLIE_FLURSTUECKE = 1;
    public static final int FOLIE_GEMARKUNG = 2;
    public static final int FOLIE_POLITISCHE_GRENZEN = 3;
    public static final int FOLIE_GEBAEUDE = 11;
    public static final int FOLIE_NUTZUNG = 21;
    public static final int FOLIE_GRENZEINRICHTUNG = 23;
    public static final int FOLIE_GELAENDEFORM = 28;
    public static final int FOLIE_BODENSCHAETZUNG = 42;
    public static final int FOLIE_NP0 = 50;
    public static final int FOLIE_NP1 = 51;
    public static final int FOLIE_NP2 = 52;
    public static final int FOLIE_NP3 = 53;
    public static final int FOLIE_NP4 = 54;
    public static final int FOLIE_NP9 = 59;
    public static final int FOLIE_GRENZEN_KOMMUNAL = 61;
    public static final int FOLIE_GRENZEN_BELASTUNG = 62;
    public static final int FOLIE_ANDERE_GRENZEN = 63;
    public static final int FOLIE_TOPOGRAPHIE = 81;
    public static final int FOLIE_WEITERE_TOPOGRAPHIE = 82;
    public static final int FOLIE_GEBAEUDE_TOP = 84;
    public static final int FOLIE_LAENDERSPEZIFIK = 85;
    public static final int FOLIE_GEBAEUDE_TOP2 = 86;
    public static final int UNDEF = 0;
    public static final int VOID = 0;
    public static final int GP_KA = 117;
    public static final int GP_VERM = 118;
    public static final int GP_UNVERM = 119;
    public static final int AP = 122;
    public static final int AP_SONST = 123;
    public static final int HFP = 148;
    public static final int HE = 151;
    public static final int ZP = 152;
    public static final int TP_HOCH = 161;
    public static final int TP_BODEN = 162;
    public static final int TP_EXZ_OBER = 164;
    public static final int TP_EXZ_UNTER = 165;
    public static final int STAAT = 211;
    public static final int LAND = 212;
    public static final int KREIS = 214;
    public static final int GEMEINDE = 215;
    public static final int AMT = 223;
    public static final int GEMEINDETEIL = 224;
    public static final int GEMARKUNG = 231;
    public static final int FLUR = 232;
    public static final int FLST = 233;
    public static final int FLST_STR = 239;
    public static final int NUTZUNG = 241;
    public static final int OBJEKTDEF = 242;
    public static final int OBJEKTDEFGR = 243;
    public static final int FLST_MARKSTEIN = 245;
    public static final int GEB_DIGIT = 914;
    public static final int GEBAEUDE84 = 915;
    public static final int RP = 966;
    public static final int HOCHHAUS = 1011;
    public static final int OEFF_GEB = 1012;
    public static final int GEBAEUDE = 1013;
    public static final int OFFEN_GEB = 1014;
    public static final int UNTERIRD_GEB = 1016;
    public static final int ONAME_HSNR = 1031;
    public static final int ONAME_LNR = 1032;
    public static final int OTEXT_GZ = 1033;
    public static final int ONAME_PSNR = 1034;
    public static final int ONAME_HSNR_M = 1035;
    public static final int DURCHF_GEB = 1041;
    public static final int DURCHF_STRASSE = 1042;
    public static final int ARKADE = 1043;
    public static final int FREITREPPE = 1044;
    public static final int UEBERDACHUNG = 1045;
    public static final int AUFGEST_GEB = 1046;
    public static final int AUSKRAGEND_GEB = 1047;
    public static final int RAMPE = 1048;
    public static final int SCHORNSTEIN = 1049;
    public static final int OBJEKT_KOO = 9999;
    private static final IntegerHashList oskas = new IntegerHashList();
    int oska = 0;
    String name = null;

    public static String getDefaultText(int n) {
        switch (n) {
            case 1111: {
                return "Parlament";
            }
            case 1112: {
                return "Rathaus";
            }
            case 1113: {
                return "Post";
            }
            case 1114: {
                return "Zollamt";
            }
            case 1115: {
                return "Gericht";
            }
            case 1121: {
                return "Schule";
            }
            case 1124: {
                return "Forschungsinstitut";
            }
            case 1133: {
                return "Konzertgeb\u00e4ude";
            }
            case 1134: {
                return "Museum";
            }
            case 1136: {
                return "Veranstaltungsgeb\u00e4ude";
            }
            case 1151: {
                return "Krankenhaus";
            }
            case 1161: {
                return "Freizeitheim";
            }
            case 1163: {
                return "Seniorenfreizeitst\u00e4tte";
            }
            case 1164: {
                return "Fremdenheim";
            }
            case 1171: {
                return "Polizei";
            }
            case 1172: {
                return "Feuerwehr";
            }
            case 1173: {
                return "Kaserne";
            }
            case 1174: {
                return "Schutzbunker";
            }
            case 1175: {
                return "Justizvollzugsanstalt";
            }
            case 1181: {
                return "Trauerhalle";
            }
            case 1182: {
                return "Krematorium";
            }
            case 1191: {
                return "Bahnhof";
            }
            case 1197: {
                return "Omnibusbahnhof";
            }
            case 1371: {
                return "Kinderheim";
            }
            case 1375: {
                return "Schullandheim";
            }
            case 1462: {
                return "Jugendherberge";
            }
            case 1463: {
                return "Herberge";
            }
            case 1473: {
                return "H\u00fctte";
            }
            case 1731: {
                return "Tankstelle";
            }
            case 1774: {
                return "Saline";
            }
            case 1911: {
                return "Windm\u00fchle";
            }
            case 2311: {
                return "Stra\u00dfenmeisterei";
            }
            case 2364: 
            case 2365: 
            case 2366: {
                return "Ga";
            }
            case 2367: {
                return "C.P.";
            }
            case 2511: {
                return "Wasserwerk";
            }
            case 2512: {
                return "Pumpwerk";
            }
            case 2513: {
                return "Pumpstelle";
            }
            case 2514: {
                return "Wasserturm";
            }
            case 2521: {
                return "Elektrizit\u00e4tswerk";
            }
            case 2522: {
                return "Umspannwerk";
            }
            case 2571: {
                return "Gaswerk";
            }
            case 2572: {
                return "Gasometer";
            }
            case 2581: {
                return "Heizwerk";
            }
            case 2591: {
                return "Pumpwerk";
            }
            case 2611: {
                return "Kl\u00e4ranlage";
            }
            case 2621: {
                return "Abfallager";
            }
            case 2622: {
                return "Abfallverbrennungsanlage";
            }
            case 2736: {
                return "Forsthaus";
            }
            case 2811: {
                return "Sporthalle";
            }
            case 2821: {
                return "Hallenbad";
            }
            case 2891: {
                return "Aussichtsturm";
            }
            case 2921: {
                return "ungenutztes Geb\u00e4ude";
            }
            case 319: {
                return "Graben";
            }
            case 441: {
                return "Fels";
            }
            case 271: {
                return "ZG";
            }
            case 272: {
                return "ges. \u00dcberschw Gr";
            }
            case 276: {
                return "NSG";
            }
            case 277: {
                return "LSG";
            }
            case 278: {
                return "WSG";
            }
            case 279: {
                return "L\u00e4rmSB";
            }
            case 281: {
                return "HQuSG";
            }
            case 282: {
                return "PSG";
            }
            case 283: {
                return "Denkmalbereich";
            }
            case 284: {
                return "GSG";
            }
            case 285: {
                return "AL";
            }
            case 286: {
                return "Flurb";
            }
            case 287: {
                return "Uml";
            }
            case 288: {
                return "San";
            }
            case 921: {
                return "BoSoG";
            }
            case 922: {
                return "Verm\u00f6gZu";
            }
            case 923: {
                return "\u00dcbergabe Besch";
            }
            case 3101: {
                return "Abbauland";
            }
            case 3111: {
                return "Sandgrube";
            }
            case 3121: {
                return "Kiesgrube";
            }
            case 3131: {
                return "Lehmgrube";
            }
            case 3132: {
                return "Tongrube";
            }
            case 3133: {
                return "Mergelgrube";
            }
            case 3201: {
                return "Halde";
            }
            case 3211: {
                return "Erdhalde";
            }
            case 3231: {
                return "Schlackenhalde";
            }
            case 3241: {
                return "Abraumhalde";
            }
            case 3301: {
                return "Lagerplatz";
            }
            case 3311: {
                return "Kohle-Lagerplatz";
            }
            case 3321: {
                return "\u00d6l-Lagerplatz";
            }
            case 3331: {
                return "Baustoffe-Lagerplatz";
            }
            case 3341: {
                return "Altmaterial-Lagerplatz";
            }
            case 3351: {
                return "Ausstellungsgel\u00e4nde";
            }
            case 3361: {
                return "Betriebsgel\u00e4nde";
            }
            case 3621: {
                return "Bruchfeld";
            }
            case 3912: {
                return "Gradierwerk";
            }
            case 3928: {
                return "Kran";
            }
            case 3931: {
                return "Silo";
            }
            case 4101: {
                return "Sportfl\u00e4che";
            }
            case 4111: 
            case 4112: 
            case 4118: {
                return "Sportplatz";
            }
            case 4121: {
                return "Golfplatz";
            }
            case 4131: {
                return "Pferderennbahn";
            }
            case 4132: {
                return "Autorennbahn";
            }
            case 4133: {
                return "Motorradrennbahn";
            }
            case 4134: {
                return "Radrennbahn";
            }
            case 4138: {
                return "Rennbahn";
            }
            case 4141: {
                return "Reitplatz";
            }
            case 4151: {
                return "Schie\u00dfstand";
            }
            case 4161: {
                return "Strandbad";
            }
            case 4162: {
                return "Freibad";
            }
            case 4168: {
                return "Bad";
            }
            case 4171: {
                return "Eisbahn";
            }
            case 4172: {
                return "Rollschuhbahn";
            }
            case 4181: {
                return "Tennisplatz";
            }
            case 4191: {
                return "Sprungschanze";
            }
            case 4201: {
                return "Gr\u00fcnanlage";
            }
            case 4221: {
                return "Spielplatz";
            }
            case 4222: {
                return "Bolzplatz";
            }
            case 4231: {
                return "Zoo";
            }
            case 4241: {
                return "Wildgehege";
            }
            case 4251: {
                return "Botanischer Garten";
            }
            case 4271: {
                return "Wochenendplatz";
            }
            case 5141: {
                return "Gehweg";
            }
            case 5151: {
                return "Geh- und Radweg";
            }
            case 5161: {
                return "Radweg";
            }
            case 5212: 
            case 5213: 
            case 5214: 
            case 5218: 
            case 5222: {
                return "Weg";
            }
            case 5227: {
                return "Furt";
            }
            case 5231: {
                return "Gang";
            }
            case 5241: {
                return "Radweg";
            }
            case 5251: {
                return "Fu\u00df- und Radweg";
            }
            case 5261: {
                return "Reitweg";
            }
            case 5321: {
                return "Rastplatz";
            }
            case 5331: {
                return "Marktplatz";
            }
            case 5341: {
                return "Mehrzweckplatz";
            }
            case 5402: {
                return "Wstd";
            }
            case 5411: 
            case 5418: {
                return "Eisenbahn";
            }
            case 5465: {
                return "G\u00fcterbahnhof";
            }
            case 5481: 
            case 5482: {
                return "S-Bahn";
            }
            case 5511: 
            case 5512: 
            case 5513: 
            case 5514: {
                return "Flughafen";
            }
            case 5521: 
            case 5522: {
                return "Landeplatz";
            }
            case 5531: {
                return "Segelflugplatz";
            }
            case 5611: {
                return "Werft";
            }
            case 5612: {
                return "Trockendock";
            }
            case 5614: {
                return "Hafenanlage";
            }
            case 5624: {
                return "F\u00e4hranlage";
            }
            case 8011: {
                return "Qu";
            }
            case 8013: {
                return "HQu";
            }
            case 8017: {
                return "GQu";
            }
            case 8018: {
                return "Qu";
            }
            case 8081: {
                return "Sperrmauer";
            }
            case 8082: {
                return "Sperrdamm";
            }
            case 8091: {
                return "P";
            }
            case 8092: {
                return "SP";
            }
            case 8093: {
                return "HWP";
            }
            case 8095: {
                return "EICHPF";
            }
            case 8098: {
                return "P";
            }
            case 8503: 
            case 8508: {
                return "Graben";
            }
            case 8621: {
                return "Stausee";
            }
            case 8699: {
                return "See";
            }
            case 8801: {
                return "Teich";
            }
            case 8802: {
                return "Weiher";
            }
            case 8808: {
                return "Teich/Weiher";
            }
            case 9101: {
                return "\u00dcbungsgel\u00e4nde";
            }
            case 9111: {
                return "Verkehrs\u00fcbungsplatz";
            }
            case 9121: {
                return "Dressurplatz";
            }
            case 9131: 
            case 9132: {
                return "\u00dcbungsplatz";
            }
            case 9201: {
                return "Schutzfl\u00e4che";
            }
            case 9231: {
                return "R\u00fcckhaltebecken";
            }
            case 9241: 
            case 9242: {
                return "L\u00e4rmschutz";
            }
            case 9251: 
            case 9252: {
                return "Damm";
            }
            case 9261: 
            case 9262: {
                return "Deich";
            }
            case 9311: {
                return "Stadtmauer";
            }
            case 9321: {
                return "Turm";
            }
            case 9331: {
                return "Gedenkst\u00e4tte";
            }
            case 9333: {
                return "ND";
            }
            case 9335: {
                return "H\u00f6hle";
            }
            case 9336: 
            case 9337: {
                return "ND";
            }
            case 9352: {
                return "Ruine";
            }
            case 9361: {
                return "Ausgrabungsst\u00e4tte";
            }
            case 9392: {
                return "Pfahlbau";
            }
            case 9393: {
                return "Hochacker";
            }
            case 9394: {
                return "Alte Schanze";
            }
            case 9421: {
                return "Friedhof (Park)";
            }
            case 9431: {
                return "Ehrenfriedhof";
            }
            case 9521: {
                return "D\u00fcne";
            }
            case 9531: {
                return "Stillg. Abbauland";
            }
        }
        return null;
    }

    public static String getRissText(int n) {
        switch (n) {
            case 1004: {
                return "Wi";
            }
            case 1165: {
                return "KiTa";
            }
            case 1211: 
            case 1221: 
            case 1231: 
            case 1301: 
            case 1311: 
            case 1321: 
            case 1331: 
            case 1341: 
            case 1361: 
            case 1381: 
            case 1399: {
                return "Wh";
            }
            case 1411: {
                return "B\u00fcro";
            }
            case 1471: {
                return "Gst";
            }
            case 1701: 
            case 1711: 
            case 1721: 
            case 1741: 
            case 1742: 
            case 1743: {
                return "Wi";
            }
            case 1744: {
                return "Schp";
            }
            case 1748: 
            case 1749: 
            case 1799: {
                return "Wi";
            }
            case 2111: 
            case 2121: 
            case 2131: {
                return "Wh";
            }
            case 2161: {
                return "Wi";
            }
            case 2364: 
            case 2365: 
            case 2366: {
                return "Ga";
            }
            case 2612: {
                return "WC";
            }
            case 2711: {
                return "Wh";
            }
            case 2721: {
                return "Sch";
            }
            case 2723: {
                return "Schp";
            }
            case 2724: {
                return "St";
            }
            case 2726: {
                return "Sch/St";
            }
            case 2727: {
                return "St";
            }
            case 2729: {
                return "Wi";
            }
            case 2731: {
                return "Wh/Wi";
            }
            case 2863: {
                return "Ghs";
            }
            case 2874: {
                return "St";
            }
            case 2921: {
                return "ungen.";
            }
        }
        return Oska.getDefaultText(n);
    }

    public static String getItem(int n) {
        return IFormat.i04.format(n) + "  " + Oska.toString(n);
    }

    public static String toString(int n) {
        String string = Oska.getOskaName(n);
        if (string == null) {
            return "ohne";
        }
        return string;
    }

    public static String getOskaName(int n) {
        if (n < 10000) {
            Oska oska = (Oska)oskas.get(n);
            if (oska != null) {
                return oska.getName();
            }
            return null;
        }
        return Alkis.getObjectName(n);
    }

    public static int getOska(String string) {
        Enumeration enumeration = oskas.elements();
        while (enumeration.hasMoreElements()) {
            Oska oska = (Oska)enumeration.nextElement();
            if (!oska.getName().equals(string)) continue;
            return oska.getNr();
        }
        return 0;
    }

    public static int getFolie(int n) {
        if (n < 200) {
            switch (n) {
                case 161: 
                case 162: 
                case 164: 
                case 165: {
                    return 50;
                }
                case 122: 
                case 123: {
                    return 51;
                }
                case 117: 
                case 118: 
                case 119: {
                    return 52;
                }
                case 151: {
                    return 53;
                }
                case 152: {
                    return 54;
                }
                case 148: {
                    return 59;
                }
            }
            return 0;
        }
        if (n < 300) {
            switch (n) {
                case 233: 
                case 235: 
                case 239: 
                case 245: {
                    return 1;
                }
                case 231: 
                case 232: {
                    return 2;
                }
                case 211: 
                case 212: 
                case 214: 
                case 215: 
                case 223: 
                case 224: {
                    return 3;
                }
                case 225: {
                    return 61;
                }
                case 236: 
                case 237: 
                case 238: {
                    return 62;
                }
                case 271: 
                case 272: 
                case 273: 
                case 275: 
                case 276: 
                case 277: 
                case 278: 
                case 279: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: {
                    return 63;
                }
                case 251: 
                case 252: {
                    return 81;
                }
            }
            return 0;
        }
        if (n < 400) {
            return 23;
        }
        if (n < 500) {
            return 28;
        }
        if (n < 1000) {
            switch (n) {
                case 618: {
                    return 2;
                }
                case 611: 
                case 612: 
                case 613: 
                case 917: {
                    return 3;
                }
                case 930: 
                case 931: {
                    return 61;
                }
                case 646: {
                    return 81;
                }
            }
            return 0;
        }
        if (n % 10 == 0) {
            return 21;
        }
        if (n < 3000) {
            return 11;
        }
        switch (n) {
            case 5101: 
            case 5201: 
            case 5301: 
            case 5401: 
            case 5501: 
            case 5701: 
            case 8058: 
            case 8108: 
            case 8208: 
            case 8301: 
            case 8408: 
            case 8601: {
                return 81;
            }
            case 8118: 
            case 8119: 
            case 8151: 
            case 8152: {
                return 85;
            }
        }
        return 82;
    }

    public static Enumeration oskas() {
        return oskas.elements();
    }

    public static Enumeration sortedElements() {
        return oskas.sortedElements();
    }

    public static Symbol getSymbol(int n) {
        switch (n) {
            case 118: 
            case 8118: {
                return Symbol.GP;
            }
            case 119: 
            case 8119: {
                return Symbol.UV;
            }
            case 122: 
            case 123: {
                return Symbol.AP;
            }
            case 151: 
            case 152: 
            case 8151: 
            case 8152: {
                return Symbol.GEB;
            }
            case 161: 
            case 162: 
            case 164: 
            case 165: 
            case 966: {
                return Symbol.TP;
            }
        }
        return Symbol.UNDEF;
    }

    public static boolean isLinienFoermigObject(int n) {
        switch (n / 100) {
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMetricFoermigObject(int n) {
        switch (n / 100) {
            case 52: 
            case 85: {
                return true;
            }
        }
        return false;
    }

    public static int getGebaeudeDarstellung(int n) {
        switch (n) {
            case 1001: {
                return 1;
            }
            case 1003: {
                return 1;
            }
            case 1004: {
                return 4;
            }
            case 1005: {
                return 3;
            }
            case 1006: {
                return 4;
            }
            case 1911: {
                return 4;
            }
            case 1913: {
                return 4;
            }
            case 2302: {
                return 5;
            }
            case 2831: {
                return 5;
            }
            case 2363: {
                return 7;
            }
            case 2311: {
                return 5;
            }
            case 2312: {
                return 5;
            }
            case 2301: {
                return 6;
            }
            case 2818: {
                return 6;
            }
            case 2819: {
                return 6;
            }
            case 2921: {
                return 4;
            }
        }
        if (n >= 1101 && n <= 1199) {
            return 2;
        }
        if (n >= 1211 && n <= 1499) {
            return 5;
        }
        if (n >= 1701 && n <= 1799) {
            return 6;
        }
        if (n >= 2891 && n <= 2899) {
            return 5;
        }
        if (n >= 2101 && n <= 2199) {
            return 5;
        }
        if (n >= 2731 && n <= 2738) {
            return 5;
        }
        if (n == 2711) {
            return 5;
        }
        if (n >= 2801 && n <= 2812) {
            return 5;
        }
        if (n >= 2821 && n <= 2829) {
            return 5;
        }
        if (n >= 2841 && n <= 2862) {
            return 5;
        }
        if (n >= 2313 && n <= 2799) {
            return 6;
        }
        if (n >= 2863 && n <= 2889) {
            return 6;
        }
        return 0;
    }

    public Oska(int n, String string) {
        this.oska = n;
        this.name = string;
    }

    @Override
    public final int intHashKey() {
        return this.oska;
    }

    public int getNr() {
        return this.oska;
    }

    public String getName() {
        return this.name;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.oska)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("objektschluessel", stringArray);
    }

    public static int createOska(int n, int n2) {
        int n3 = 0;
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 180: 
                    case 182: 
                    case 183: {
                        n3 = 161;
                        break block0;
                    }
                }
                n3 = 162;
                break;
            }
            case 1: {
                n3 = 122;
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: 
                    case 99: {
                        n3 = 117;
                        break block0;
                    }
                    case 30: 
                    case 35: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 70: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 94: 
                    case 98: {
                        n3 = 119;
                        break block0;
                    }
                }
                n3 = 118;
                break;
            }
            case 3: {
                n3 = 151;
                break;
            }
            case 4: {
                n3 = 152;
                break;
            }
            case 7: 
            case 8: {
                n3 = 0;
                break;
            }
            case 9: {
                n3 = 148;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    public static int createPunktArt(int n) {
        switch (n) {
            case 161: 
            case 162: 
            case 164: 
            case 165: 
            case 966: {
                return 0;
            }
            case 122: 
            case 123: {
                return 1;
            }
            case 117: 
            case 118: 
            case 119: {
                return 2;
            }
            case 151: {
                return 3;
            }
            case 152: {
                return 4;
            }
            case 148: {
                return 9;
            }
        }
        return -1;
    }

    static {
        oskas.put(new Oska(0, "ohne"));
        oskas.put(new Oska(117, "Grenzpunkt k.A."));
        oskas.put(new Oska(118, "abgem. Grenzpunkt"));
        oskas.put(new Oska(119, "n. abgem. Grenzpunkt"));
        oskas.put(new Oska(122, "Aufnahmepunkt"));
        oskas.put(new Oska(123, "sonst. Aufnahmepunkt"));
        oskas.put(new Oska(148, "H\u00f6henfestpunkt"));
        oskas.put(new Oska(151, "Geb\u00e4udepunkt"));
        oskas.put(new Oska(152, "topographischer Punkt"));
        oskas.put(new Oska(161, "Trig. Hochpunkt"));
        oskas.put(new Oska(162, "Trig. Bodenpunkt"));
        oskas.put(new Oska(164, "Exzentrum oberirdisch"));
        oskas.put(new Oska(165, "Exzentrum unterirdisch"));
        oskas.put(new Oska(231, "Gemarkung"));
        oskas.put(new Oska(232, "Flur"));
        oskas.put(new Oska(233, "Flurst\u00fcck"));
        oskas.put(new Oska(239, "Flst im StrL"));
        oskas.put(new Oska(241, "Nutzungartengrenze"));
        oskas.put(new Oska(242, "Objektdefinition"));
        oskas.put(new Oska(243, "Objektdefinition gro\u00dfer Obj."));
        oskas.put(new Oska(914, "Geb\u00e4ude, digitalisiert"));
        oskas.put(new Oska(966, "Referenzpunkt"));
        oskas.put(new Oska(1011, "Hochhausbegrenzunglinie"));
        oskas.put(new Oska(1012, "Begrenzungslinie eines \u00f6ffentlichen Geb\u00e4udes"));
        oskas.put(new Oska(1013, "Begrenzungslinie eines nicht \u00f6ffenlichen Geb\u00e4udes"));
        oskas.put(new Oska(1014, "offene Begrenzungslinie eines Geb\u00e4udes"));
        oskas.put(new Oska(1016, "Begrenzungslinie eines unterirdischen Geb\u00e4udes"));
        oskas.put(new Oska(1031, "Objektname bei Hauptgeb\u00e4uden"));
        oskas.put(new Oska(1032, "Objektname bei Nebengeb\u00e4uden"));
        oskas.put(new Oska(1033, "Gescho\u00dfzahl"));
        oskas.put(new Oska(1034, "Objektname bei Hauptgeb\u00e4uden mit Pseudonummer"));
        oskas.put(new Oska(1035, "Objektname bei Hauptgeb\u00e4uden mit zusammengefa\u00dften Nummern"));
        oskas.put(new Oska(1041, "Durchfahrt im Geb\u00e4ude"));
        oskas.put(new Oska(1042, "Durchfahrt an \u00fcberbauter Stra\u00dfe"));
        oskas.put(new Oska(1043, "Arkade"));
        oskas.put(new Oska(1044, "Freitreppe"));
        oskas.put(new Oska(1045, "Markierung f\u00fcr \u00dcberdachung"));
        oskas.put(new Oska(1046, "Markierung f\u00fcr aufgest\u00e4ndertes Geb\u00e4ude"));
        oskas.put(new Oska(1047, "auskragendes Gescho\u00df"));
        oskas.put(new Oska(1048, "Rampe"));
        oskas.put(new Oska(1049, "Schornstein"));
        oskas.put(new Oska(9999, "Objektkoordiante"));
        oskas.put(new Oska(1101, "\u00f6ffentl. Geb. (ex. Nutz. unbek)"));
        oskas.put(new Oska(1116, "Konsulat, Botschaft"));
        oskas.put(new Oska(1118, "Geb. f. \u00f6ff. Verwaltung (ex. Nutz. unbek)"));
        oskas.put(new Oska(1119, "Geb. f. \u00f6ff. Verwaltung (nicht 1111-1118)"));
        oskas.put(new Oska(1122, "Berufs-, Fach-, Volkshochschule"));
        oskas.put(new Oska(1123, "FH, Uni"));
        oskas.put(new Oska(1128, "Bildungs u. Forschungseinrichtung (ex. Nutz. unbek)"));
        oskas.put(new Oska(1129, "Bildungs u. Forschungseinrichtung (nicht 1121-1128)"));
        oskas.put(new Oska(1131, "Schlo\u00df, Burg"));
        oskas.put(new Oska(1132, "Theater, Oper"));
        oskas.put(new Oska(1135, "Rundfunk, Fernsehen"));
        oskas.put(new Oska(1137, "B\u00fccherei"));
        oskas.put(new Oska(1138, "Geb. f. kulturelle Zwecke (ex. Nutz. unbek)"));
        oskas.put(new Oska(1139, "Geb. f. kulturelle Zwecke (nicht 1131-1138)"));
        oskas.put(new Oska(1144, "Gemeindehaus, K\u00fcsterei"));
        oskas.put(new Oska(1145, "Gotteshaus anderer Religionsgemeinschaften"));
        oskas.put(new Oska(1148, "kirchliche Einrichtungen  (ex. Nutz. unbek)"));
        oskas.put(new Oska(1149, "kirchliche Einrichtungen  (nicht 1141-1148)"));
        oskas.put(new Oska(1152, "Heil-, Pflegeanstalt"));
        oskas.put(new Oska(1158, "Gesundheitseinrichtungen (ex. Nutz. unbek)"));
        oskas.put(new Oska(1159, "Gesundheitseinrichtungen (nicht 1151-1158)"));
        oskas.put(new Oska(1162, "Freizeithaus"));
        oskas.put(new Oska(1165, "Kindergarten"));
        oskas.put(new Oska(1168, "Sozialeinrichtungen (ex. Nutz. unbek)"));
        oskas.put(new Oska(1169, "Sozialeinrichtungen (nicht 1161-1168)"));
        oskas.put(new Oska(1178, "Sicherheitseinrichtungen (ex. Nutz. unbek)"));
        oskas.put(new Oska(1179, "Sicherheitseinrichtungen (nicht 1171-1178)"));
        oskas.put(new Oska(1188, "Friedhofsgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(1189, "Friedhofsgeb\u00e4ude (nicht 1181-1188)"));
        oskas.put(new Oska(1198, "Empfangsgeb. f. Verkehrsteilnehmer"));
        oskas.put(new Oska(1199, "sonst. Empfangsgeb. f. Verkehrsteilnehmer"));
        oskas.put(new Oska(1211, "Wohnhaus in Reihe"));
        oskas.put(new Oska(1221, "Freistehender Wohnblock"));
        oskas.put(new Oska(1231, "Wohnblock in geschlossener Bauweise"));
        oskas.put(new Oska(1301, "Wohnhaus (ex. Nutz. unbek)"));
        oskas.put(new Oska(1311, "Einzelhaus"));
        oskas.put(new Oska(1321, "Doppelhaus"));
        oskas.put(new Oska(1331, "Reihenhaus"));
        oskas.put(new Oska(1341, "Gruppenhaus"));
        oskas.put(new Oska(1361, "Hochhaus"));
        oskas.put(new Oska(1372, "Seniorenwohnhaus, Seniorenheim"));
        oskas.put(new Oska(1373, "Arbeitnehmerwohnheim, Schwesternwohnheim"));
        oskas.put(new Oska(1374, "Studentenwohnheim, Sch\u00fclerwohnheim"));
        oskas.put(new Oska(1378, "Wohnheim (ex. Nutz. unbek)"));
        oskas.put(new Oska(1379, "Wohnheim (nicht 1371-1377)"));
        oskas.put(new Oska(1381, "Behelfsm\u00e4\u00dfiges Wohngeb\u00e4ude"));
        oskas.put(new Oska(1399, "Wohngeb. (nicht 1301-1398)"));
        oskas.put(new Oska(1401, "Geb\u00e4ude f\u00fcr Handel und Wirtschaft (allgemein)"));
        oskas.put(new Oska(1411, "Verwaltungsgeb\u00e4ude, B\u00fcrogeb\u00e4ude"));
        oskas.put(new Oska(1421, "Kreditinstitutsgeb\u00e4ude, Bankgeb\u00e4ude"));
        oskas.put(new Oska(1431, "Versicherungsgeb\u00e4ude"));
        oskas.put(new Oska(1441, "Kaufhaus"));
        oskas.put(new Oska(1442, "Einkaufszentrum"));
        oskas.put(new Oska(1443, "Markthalle"));
        oskas.put(new Oska(1444, "Ladengeb\u00e4ude"));
        oskas.put(new Oska(1445, "Kiosk"));
        oskas.put(new Oska(1448, "Handel (ex. Nutz. unbek)"));
        oskas.put(new Oska(1449, "Handel (nicht 1441-1447)"));
        oskas.put(new Oska(1451, "Geb\u00e4ude f\u00fcr Messe, Ausstellung"));
        oskas.put(new Oska(1461, "Hotel, Pension"));
        oskas.put(new Oska(1468, "Beherbergung (ex. Nutz. unbek)"));
        oskas.put(new Oska(1469, "Beherbergung (nicht 1461-1467)"));
        oskas.put(new Oska(1471, "Gastst\u00e4tte"));
        oskas.put(new Oska(1472, "Rastst\u00e4tte an Autobahn oder Fernstra\u00dfe"));
        oskas.put(new Oska(1474, "Kantine"));
        oskas.put(new Oska(1478, "Restauration (ex. Nutz. unbek)"));
        oskas.put(new Oska(1479, "Restauration (nicht 1471-1477)"));
        oskas.put(new Oska(1481, "Festsaal"));
        oskas.put(new Oska(1482, "Kino"));
        oskas.put(new Oska(1483, "Kegelhalle, Bowlinghalle"));
        oskas.put(new Oska(1484, "Spielkasino"));
        oskas.put(new Oska(1488, "Vergn\u00fcgungsst\u00e4tte (ex. Nutz. unbek)"));
        oskas.put(new Oska(1489, "Vergn\u00fcgungsst\u00e4tte (nicht 1481-1487)"));
        oskas.put(new Oska(1499, "andere Geb. f. Handel und Diestl. (nicht 1411-1498)"));
        oskas.put(new Oska(1701, "Geb\u00e4ude f\u00fcr Gewerbe und Industrie (ex. Nutz. unbek)"));
        oskas.put(new Oska(1711, "Fabrik"));
        oskas.put(new Oska(1721, "Werkstatt"));
        oskas.put(new Oska(1731, "Tankstelle"));
        oskas.put(new Oska(1741, "K\u00fchlhaus"));
        oskas.put(new Oska(1742, "Speicher"));
        oskas.put(new Oska(1743, "Lagerhalle"));
        oskas.put(new Oska(1744, "Lagerschuppen"));
        oskas.put(new Oska(1748, "Lagerung (ex. Nutz. unbek)"));
        oskas.put(new Oska(1749, "Lagerung (nicht 1741-1747)"));
        oskas.put(new Oska(1751, "Transportgeb\u00e4ude"));
        oskas.put(new Oska(1761, "Forschungsgeb\u00e4ude"));
        oskas.put(new Oska(1778, "Grundstoff (ex. Nutz. unbek)"));
        oskas.put(new Oska(1779, "Grundstoff (nicht 1771-1777)"));
        oskas.put(new Oska(1781, "Betriebliche Sozialeinrichtung"));
        oskas.put(new Oska(1799, "Geb. f. Gewerbe und Industrie (nicht 1711-1798)"));
        oskas.put(new Oska(1911, "Windm\u00fchle"));
        oskas.put(new Oska(1913, "Wasserm\u00fchle, Sch\u00f6pfwerk"));
        oskas.put(new Oska(2101, "Gemischt genutztes Geb. mit Wohnungen"));
        oskas.put(new Oska(2111, "Wohngeb. mit \u00f6ff Einrichtungen"));
        oskas.put(new Oska(2121, "Wohngeb. mit Handel und Diestl."));
        oskas.put(new Oska(2131, "Wohngeb. mit Gewerbe & Industrie"));
        oskas.put(new Oska(2141, "\u00f6ff Geb. mit Wohnungen"));
        oskas.put(new Oska(2151, "Handel & Dienstl mit Wohnungen"));
        oskas.put(new Oska(2161, "Gewerbe & Industrie mit Wohnungen"));
        oskas.put(new Oska(2199, "Gemischt genutztes Geb. mit Wohnungen (nicht 2111-2198)"));
        oskas.put(new Oska(2301, "Geb\u00e4ude f\u00fcr Verkehr (ex. Nutz. unbek)"));
        oskas.put(new Oska(2312, "Wartehalle"));
        oskas.put(new Oska(2313, "Fahrzeughalle"));
        oskas.put(new Oska(2318, "Stra\u00dfenverkehrsgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2319, "Stra\u00dfenverkehr (nicht 2311-2317)"));
        oskas.put(new Oska(2321, "Bahnw\u00e4rterhaus"));
        oskas.put(new Oska(2322, "Lokschuppen, Wagenhalle"));
        oskas.put(new Oska(2323, "Blockstellengeb\u00e4ude"));
        oskas.put(new Oska(2324, "G\u00fcterbahnhofsgeb\u00e4ude"));
        oskas.put(new Oska(2328, "Schienenverkehrsgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2329, "Schienenverkehr (nicht 2321-2327)"));
        oskas.put(new Oska(2332, "Flugzeughalle"));
        oskas.put(new Oska(2338, "Geb\u00e4ude f\u00fcr Luftfahrt (ex. Nutz. unbek)"));
        oskas.put(new Oska(2339, "Luftfahrt (nicht2331-2337)"));
        oskas.put(new Oska(2341, "Werft"));
        oskas.put(new Oska(2342, "Dock"));
        oskas.put(new Oska(2343, "Schleuse"));
        oskas.put(new Oska(2344, "Bootshaus"));
        oskas.put(new Oska(2348, "Schiffahrtsgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2349, "Schiffahrt (nicht 2341-2347)"));
        oskas.put(new Oska(2351, "Spannwerk"));
        oskas.put(new Oska(2358, "Geb\u00e4ude f\u00fcr Seilbahn (ex. Nutz. unbek)"));
        oskas.put(new Oska(2359, "Seilbahn (nicht 2351-2357)"));
        oskas.put(new Oska(2399, "Geb. zu Verkehrsanlagen (nicht 2311-2398)"));
        oskas.put(new Oska(2501, "Geb\u00e4ude f\u00fcr Versorgung (ex. Nutz. unbek)"));
        oskas.put(new Oska(2515, "Wasserbeh\u00e4lter"));
        oskas.put(new Oska(2518, "Geb\u00e4ude f\u00fcr Wasserversorgung (ex. Nutz. unbek)"));
        oskas.put(new Oska(2519, "Wasserversorgung (nicht 2511-2517)"));
        oskas.put(new Oska(2528, "Geb\u00e4ude f\u00fcr Elektrizit\u00e4tsversorgung (ex. Nutz. unbek)"));
        oskas.put(new Oska(2529, "Elektrizit\u00e4tsversorgung (nicht 2521-2527)"));
        oskas.put(new Oska(2541, "Sendeturm, Fernmeldeturm"));
        oskas.put(new Oska(2548, "Geb\u00e4ude f\u00fcr Funk- und Fernmeldewesen (ex. Nutz. unbek)"));
        oskas.put(new Oska(2549, "Funk- und Fernmeldewesen (nicht 2541-2547)"));
        oskas.put(new Oska(2551, "\u00d6ltank"));
        oskas.put(new Oska(2561, "Oberirdisches Geb\u00e4ude an unterirdischen Leitungen"));
        oskas.put(new Oska(2599, "Geb f. Versorgung (nicht 2511-2598)"));
        oskas.put(new Oska(2601, "Geb\u00e4ude f\u00fcr Entsorgung (ex. Nutz. unbek)"));
        oskas.put(new Oska(2612, "Bed\u00fcrfnisanstalt"));
        oskas.put(new Oska(2619, "Entw\u00e4sserung (nicht 2611-2617)"));
        oskas.put(new Oska(2623, "Betriebsgeb\u00e4ude einer M\u00fclldeponie"));
        oskas.put(new Oska(2628, "Geb\u00e4ude f\u00fcr M\u00fcllbeseitigung (ex. Nutz. unbek)"));
        oskas.put(new Oska(2629, "M\u00fcllbeseitigung (nicht 2621-2628)"));
        oskas.put(new Oska(2699, "Geb f. Entsorgung (nicht 2611.2698)"));
        oskas.put(new Oska(2701, "Geb\u00e4ude f\u00fcr Land- und Forstwirtschaft (ex. Nutz. unbek)"));
        oskas.put(new Oska(2711, "Landwirtschaftliches Wohngeb\u00e4ude"));
        oskas.put(new Oska(2721, "Scheune"));
        oskas.put(new Oska(2723, "Schuppen"));
        oskas.put(new Oska(2724, "Stall"));
        oskas.put(new Oska(2725, "Futtersilo"));
        oskas.put(new Oska(2726, "Scheune und Stall"));
        oskas.put(new Oska(2727, "Geb\u00e4ude f\u00fcr Tiergro\u00dfhaltung"));
        oskas.put(new Oska(2728, "Landwirtschaftliches Betriebsgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2729, "Betrieb (nicht 2721-2727)"));
        oskas.put(new Oska(2731, "Landwirtschaftliches Wohn- und Betriebsgeb\u00e4ude"));
        oskas.put(new Oska(2737, "Jagdhaus, Jagdh\u00fctte"));
        oskas.put(new Oska(2738, "Landwirtschaftliches Wohn- und Betriebsgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2741, "Gew\u00e4chshaus, Treibhaus"));
        oskas.put(new Oska(2748, "Gew\u00e4chshaus (ex. Nutz. unbek)"));
        oskas.put(new Oska(2799, "Geb. f. Land und Forstwirtschaft (nicht 2711-2798)"));
        oskas.put(new Oska(2801, "Geb\u00e4ude f\u00fcr Erholung (ex. Nutz. unbek)"));
        oskas.put(new Oska(2812, "Sportplatzgeb\u00e4ude"));
        oskas.put(new Oska(2818, "Geb\u00e4ude f\u00fcr Sport (ex. Nutz. unbek)"));
        oskas.put(new Oska(2819, "Sport (nicht 2811-2817)"));
        oskas.put(new Oska(2822, "Geb\u00e4ude der Freibadanlage"));
        oskas.put(new Oska(2828, "Badegeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2829, "Badegeb\u00e4ude (nicht 2821-2827)"));
        oskas.put(new Oska(2831, "Trib\u00fcne"));
        oskas.put(new Oska(2841, "Badegeb\u00e4ude f\u00fcr medizinische Zwecke"));
        oskas.put(new Oska(2842, "Sanatorium"));
        oskas.put(new Oska(2848, "Kurgeb\u00e4ude (ex. Nutz. unbek)"));
        oskas.put(new Oska(2849, "Kur (nicht 2841-2847)"));
        oskas.put(new Oska(2851, "Campingplatzgeb\u00e4ude"));
        oskas.put(new Oska(2861, "Ferienhaus"));
        oskas.put(new Oska(2862, "Wochenendhaus"));
        oskas.put(new Oska(2863, "Gartenhaus"));
        oskas.put(new Oska(2869, "Freizeithaus (nicht 2861-2867)"));
        oskas.put(new Oska(2871, "Empfangsgeb\u00e4ude"));
        oskas.put(new Oska(2872, "Aquarium, Terrarium"));
        oskas.put(new Oska(2873, "Tierschauhaus"));
        oskas.put(new Oska(2874, "Stall"));
        oskas.put(new Oska(2878, "Geb\u00e4ude f\u00fcr Zoologie (ex. Nutz. unbek)"));
        oskas.put(new Oska(2879, "Zoologie (nicht 2871-2877)"));
        oskas.put(new Oska(2881, "Empfangsgeb\u00e4ude"));
        oskas.put(new Oska(2882, "Gew\u00e4chshaus"));
        oskas.put(new Oska(2883, "Pflanzenschauhaus"));
        oskas.put(new Oska(2888, "Geb\u00e4ude f\u00fcr Botanik (ex. Nutz. unbek)"));
        oskas.put(new Oska(2889, "Botanik (nicht 2881-2887)"));
        oskas.put(new Oska(2894, "Schutzh\u00fctte"));
        oskas.put(new Oska(2899, "Wandern (nicht 2891-2897)"));
    }
}

