/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IList;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class PaintObjectDialog
extends IOptionDialog
implements ActionListener,
ItemListener,
DataBaseListener {
    protected static final String SELECT_COMMAND = "Alle";
    protected static final String DESELECT_COMMAND = "Keine";
    protected static final String CHANGE_COMMAND = "Umkehren";
    protected IList objectList;
    protected Vector O;

    public PaintObjectDialog(IFrame iFrame, String string, Vector vector) {
        super(iFrame, string);
        this.O = vector;
        this.setListLayout();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SELECT_COMMAND)) {
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                this.objectList.select(i);
            }
            this.itemStateChanged(new ItemEvent(this.objectList, 1, this.objectList.getItem(0), 701));
        } else if (string.equals(DESELECT_COMMAND)) {
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                this.objectList.deselect(i);
            }
            this.itemStateChanged(new ItemEvent(this.objectList, 2, this.objectList.getItem(0), 701));
        } else if (string.equals(CHANGE_COMMAND)) {
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                if (this.objectList.isSelected(i)) {
                    this.objectList.deselect(i);
                    continue;
                }
                this.objectList.select(i);
            }
            this.itemStateChanged(new ItemEvent(this.objectList, 1, this.objectList.getItem(0), 701));
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        this.setListLayout();
    }

    public boolean equals(Object object) {
        if (object instanceof PaintObjectDialog) {
            PaintObjectDialog paintObjectDialog = (PaintObjectDialog)object;
            return paintObjectDialog.getTitle().equals(super.getTitle());
        }
        return false;
    }

    @Override
    protected IPanel layoutDialogPanel() {
        IPanel iPanel = new IPanel(new BorderLayout(5, 5));
        iPanel.setBorder(new IBorder(1));
        this.objectList = new IList(10, true);
        iPanel.add("North", this.objectList);
        this.objectList.addItemListener(this);
        iPanel.add("South", this.createSelectPanel());
        return iPanel;
    }

    protected IPanel createSelectPanel() {
        IPanel iPanel = new IPanel(new FlowLayout(1));
        Button button = new Button(SELECT_COMMAND);
        iPanel.add(button);
        button.addActionListener(this);
        button = new Button(DESELECT_COMMAND);
        iPanel.add(button);
        button.addActionListener(this);
        button = new Button(CHANGE_COMMAND);
        iPanel.add(button);
        button.addActionListener(this);
        return iPanel;
    }

    @Override
    protected void setOptions() {
        for (int i = 0; i < this.O.size(); ++i) {
            PaintObject paintObject = (PaintObject)this.O.elementAt(i);
            paintObject.setVisible(this.objectList.isIndexSelected(i));
        }
    }

    protected void setListLayout() {
        Object object;
        int n;
        if (this.isVisible()) {
            block0: for (n = 0; n < this.objectList.getItemCount(); ++n) {
                object = this.objectList.getItem(n);
                for (int i = 0; i < this.O.size(); ++i) {
                    PaintObject paintObject = (PaintObject)this.O.elementAt(i);
                    if (!paintObject.getName().equals(object)) continue;
                    paintObject.setVisible(this.objectList.isSelected(n));
                    continue block0;
                }
            }
        }
        this.objectList.removeAll();
        for (n = 0; n < this.O.size(); ++n) {
            object = (PaintObject)this.O.elementAt(n);
            this.objectList.addItem(object.getName());
            if (!object.isVisible()) continue;
            this.objectList.select(n);
        }
    }
}

