/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.geom.DPoint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class Plotbox
extends DPoint {
    public static final int NO = 0;
    public static final int ZOOM = 1;
    public static final int MOVE = 2;
    public static final int TURN = 3;
    private int mouseCommand = 1;
    public double width;
    public double height;
    public double orientation;

    public Plotbox() {
        this(0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Plotbox(double d, double d2, double d3, double d4, double d5) {
        super(d, d2);
        this.width = d3;
        this.height = d4;
        this.orientation = -d5;
    }

    @Override
    public String toString() {
        return "Plotbox: " + (int)this.width + "," + (int)this.height;
    }

    public void setMouseCommand(int n) {
        this.mouseCommand = n;
    }

    public int getMouseCommand() {
        return this.mouseCommand;
    }

    public void drawSymbol(IGraphics iGraphics, boolean bl) {
        Graphics graphics = iGraphics.getGraphics();
        double d = Math.sin(this.orientation);
        double d2 = Math.cos(this.orientation);
        DPoint dPoint = new DPoint(this.y + (-d2 * this.width / 2.0 - d * this.height / 2.0), this.x + (-d * this.width / 2.0 + d2 * this.height / 2.0));
        DPoint dPoint2 = new DPoint(this.y + (d2 * this.width / 2.0 - d * this.height / 2.0), this.x + (d * this.width / 2.0 + d2 * this.height / 2.0));
        DPoint dPoint3 = new DPoint(this.y + (-d2 * this.width / 2.0 + d * this.height / 2.0), this.x + (-d * this.width / 2.0 - d2 * this.height / 2.0));
        DPoint dPoint4 = new DPoint(this.y + (d2 * this.width / 2.0 + d * this.height / 2.0), this.x + (d * this.width / 2.0 - d2 * this.height / 2.0));
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        Point point4 = new Point();
        point = iGraphics.getGraphicPoint(dPoint, point);
        point2 = iGraphics.getGraphicPoint(dPoint2, point2);
        point3 = iGraphics.getGraphicPoint(dPoint3, point3);
        point4 = iGraphics.getGraphicPoint(dPoint4, point4);
        Polygon polygon = new Polygon();
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point4.x, point4.y);
        polygon.addPoint(point3.x, point3.y);
        graphics.setColor(Color.white);
        if (bl) {
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setXORMode(new Color(245, 245, 245));
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            graphics.setXORMode(new Color(100, 100, 100));
        }
        graphics.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        if (bl) {
            graphics.drawLine(point3.x, point3.y, point2.x, point2.y);
        }
        graphics.setPaintMode();
    }
}

