/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class PolarAufnahme
extends Vector {
    private Punkt ps = null;
    private Punkt pa = null;
    private double r0;
    private double t0;
    private double sm;
    private boolean param = false;

    public PolarAufnahme() {
        this(1.0);
    }

    public PolarAufnahme(double d) {
        this.sm = d;
    }

    public void setStandPunkt(Punkt punkt) {
        this.ps = punkt;
        this.param = false;
    }

    public Punkt getStandPunkt() {
        return this.ps;
    }

    public void setAnschlussPunkt(Punkt punkt) {
        this.pa = punkt;
        this.param = false;
    }

    public Punkt getAnschlussPunkt() {
        return this.pa;
    }

    public void setAnschlussRichtung(double d) {
        this.r0 = Math.PI * (d / 200.0);
        this.param = false;
    }

    public double getAnschlussRichtung() {
        return 200.0 * (this.r0 / Math.PI);
    }

    public void addPunkt(Punkt punkt) {
        super.addElement(punkt);
    }

    public Punkt getPunktAt(int n) {
        return (Punkt)this.elementAt(n);
    }

    public Messung getMessungAt(int n) {
        return this.getMessungOf(this.getPunktAt(n));
    }

    public Messung getMessungOf(Punkt punkt) {
        double d;
        double d2;
        double d3;
        if (!this.param) {
            this.setTrafoParameter();
        }
        if (Math.abs(d3 = Math.atan2(d2 = punkt.y - this.ps.y, d = punkt.x - this.ps.x) - this.t0 + this.r0) < 1.5E-6) {
            d3 = 0.0;
        }
        double d4 = d3 = d3 >= 0.0 ? 200.0 * d3 / Math.PI : 200.0 * (d3 + Math.PI * 2) / Math.PI;
        if (d3 >= 400.0) {
            d3 -= 400.0;
        }
        double d5 = Math.sqrt(d2 * d2 + d * d) * this.sm;
        return new Messung(230, this.ps, punkt, d3, d5);
    }

    private void setTrafoParameter() {
        if (this.pa == null || this.ps == null) {
            return;
        }
        this.t0 = Math.atan2(this.pa.y - this.ps.y, this.pa.x - this.ps.x);
        this.param = true;
    }

    public void drawSymbol(IGraphics iGraphics) {
        this.drawSymbol(iGraphics, false);
    }

    public void drawSymbol(IGraphics iGraphics, boolean bl) {
        Graphics graphics = iGraphics.getGraphics();
        if (!this.param) {
            this.setTrafoParameter();
        }
        if (this.ps != null) {
            this.ps.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
        }
        if (this.pa != null && this.pa != this.ps) {
            this.pa.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
        }
        if (this.ps == null || this.pa == null) {
            return;
        }
        Messung messung = new Messung(bl ? -200 : 230, this.ps, this.pa);
        messung.drawSymbol(iGraphics, bl);
        Point point = new Point();
        for (int i = 0; i < this.size(); ++i) {
            Punkt punkt = (Punkt)this.elementAt(i);
            if (punkt == this.ps || punkt == this.pa) continue;
            punkt.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl);
            messung = new Messung(bl ? -200 : 230, this.ps, punkt);
            messung.drawSymbol(iGraphics, bl);
            if (!bl) continue;
            messung = this.getMessungOf(punkt);
            int n = (int)Math.rint(90.0 - 180.0 * (this.t0 / Math.PI));
            int n2 = (int)Math.rint((messung.l1 - this.getAnschlussRichtung()) * -0.9);
            if (n2 > 0) {
                n2 -= 360;
            }
            point = iGraphics.getGraphicPoint(this.ps, point);
            iGraphics.setXORMode();
            graphics.drawArc(point.x - 20, point.y - 20, 40, 40, n, n2);
        }
    }
}

