/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.INumTextField;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.PolarAufnahme;
import de.geocalc.kafplot.Punkt;
import de.geocalc.text.GeoNumberFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PolarAufnahmeDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "OK";
    private static final String DO_COMMAND = "\u00dcbernehmen";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String VOID = " ";
    private PolarAufnahme A;
    private INumTextField psTextField;
    private INumTextField paTextField;
    private INumTextField raTextField;
    private INumTextField saTextField;
    private INumTextField pnTextField;
    private INumTextField rnTextField;
    private INumTextField snTextField;

    public PolarAufnahmeDialog(IFrame iFrame, String string) {
        this(iFrame, string, null);
    }

    public PolarAufnahmeDialog(IFrame iFrame, String string, PolarAufnahme polarAufnahme) {
        super(iFrame, string, true);
        this.A = polarAufnahme;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createPolarAufnahmePanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setPolarAufnahme(polarAufnahme);
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(true);
    }

    private IPanel createPolarAufnahmePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Punktnummer", 1);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Richtung", 1);
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Strecke", 1);
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Standpunkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.psTextField = new INumTextField(12);
        iPanel.add(this.psTextField);
        this.psTextField.addActionListener(this);
        this.psTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.psTextField, gridBagConstraints);
        label = new Label("Anschlu\u00dfpunkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.paTextField = new INumTextField(12);
        iPanel.add(this.paTextField);
        this.paTextField.addActionListener(this);
        this.paTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.paTextField, gridBagConstraints);
        this.raTextField = new INumTextField(8);
        iPanel.add(this.raTextField);
        this.raTextField.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.raTextField, gridBagConstraints);
        this.saTextField = new INumTextField(8);
        iPanel.add(this.saTextField);
        this.saTextField.addActionListener(this);
        this.saTextField.setEditable(false);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.saTextField, gridBagConstraints);
        label = new Label("Neupunkt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.pnTextField = new INumTextField(12);
        iPanel.add(this.pnTextField);
        this.pnTextField.addActionListener(this);
        this.pnTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.pnTextField, gridBagConstraints);
        this.rnTextField = new INumTextField(8);
        iPanel.add(this.rnTextField);
        this.rnTextField.addActionListener(this);
        this.rnTextField.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.rnTextField, gridBagConstraints);
        this.snTextField = new INumTextField(8);
        iPanel.add(this.snTextField);
        this.snTextField.addActionListener(this);
        this.snTextField.setEditable(false);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.snTextField, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(DO_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        Button button3 = new Button(ABORT_COMMAND);
        button3.addActionListener(this);
        panel.add(button3);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (actionEvent.getActionCommand().equals(DO_COMMAND) || object instanceof INumTextField) {
            if (this.actionListener != null && this.actionCommand != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
            this.setPolarAufnahme(this.A);
        } else if (actionEvent.getActionCommand().equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    public void setPolarAufnahme(PolarAufnahme polarAufnahme) {
        this.A = polarAufnahme;
        if (polarAufnahme == null) {
            return;
        }
        Punkt punkt = polarAufnahme.getStandPunkt();
        this.psTextField.setText(punkt != null ? GeoNumberFormat.nr.format(KafPlotProperties.getVisiblePunktNummer(punkt)).toString() : VOID);
        Punkt punkt2 = polarAufnahme.getAnschlussPunkt();
        Messung messung = punkt2 != null ? polarAufnahme.getMessungOf(punkt2) : null;
        this.paTextField.setText(punkt2 != null ? GeoNumberFormat.nr.format(KafPlotProperties.getVisiblePunktNummer(punkt2)).toString() : VOID);
        this.raTextField.setText(punkt2 != null ? GeoNumberFormat.m34.format(polarAufnahme.getAnschlussRichtung()).toString() : VOID);
        this.saTextField.setText(punkt2 != null ? GeoNumberFormat.m43.format(messung.l2).toString() : VOID);
        Punkt punkt3 = polarAufnahme.size() > 0 ? (Punkt)polarAufnahme.elementAt(0) : null;
        Messung messung2 = punkt3 != null ? polarAufnahme.getMessungOf(punkt3) : null;
        this.pnTextField.setText(punkt3 != null ? GeoNumberFormat.nr.format(KafPlotProperties.getVisiblePunktNummer(punkt3)).toString() : VOID);
        this.rnTextField.setText(punkt3 != null ? GeoNumberFormat.m34.format(messung2.l1).toString() : VOID);
        this.snTextField.setText(punkt3 != null ? GeoNumberFormat.m43.format(messung2.l2).toString() : VOID);
    }

    public PolarAufnahme getPolarAufnahme() {
        return this.A;
    }

    public PolarAufnahme getUpdatedPolarAufnahme() {
        this.setValues();
        return this.A;
    }

    private void setValues() {
        try {
            this.A.setAnschlussRichtung(new Double(this.raTextField.getText()));
        }
        catch (Exception exception) {
            this.A.setAnschlussRichtung(0.0);
        }
    }

    @Override
    protected void doStandardAction() {
        if (this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

