/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.geom.BorderedGeoTransform;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GraphicClip;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Nordpfeil;
import de.geocalc.kafplot.Plotbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class PrintPage
extends Component
implements Printable {
    private static double DPI_SCALE = 0.75;
    private static double PRINT_SCALE = DPI_SCALE * 0.8;
    private static int WEST = 0;
    private static int NORTH = 0;
    private static int EAST = 0;
    private static int SOUTH = 0;
    private static final int STH = 60;
    DataBase db;
    Plotbox pb;

    public static final void setPrintScale(double d) {
        d = Math.min(2.0, d);
        d = Math.max(0.2, d);
        PRINT_SCALE = DPI_SCALE * d;
    }

    public static void setPageBorder(int n, int n2, int n3, int n4) {
        WEST = PrintPage.inch_72(n);
        NORTH = PrintPage.inch_72(n2);
        EAST = PrintPage.inch_72(n3);
        SOUTH = PrintPage.inch_72(n4);
    }

    private static final int inch_72(int n) {
        return (int)Math.rint((double)n * 2.83464);
    }

    public PrintPage(DataBase dataBase) {
        this.db = dataBase;
        this.pb = DataBase.PLOTBOX;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.pb == null || n > 0) {
            return 1;
        }
        Dimension dimension = null;
        if (WEST == 0 && NORTH == 0 && EAST == 0 && SOUTH == 0) {
            dimension = new Dimension((int)pageFormat.getImageableWidth() - 1, (int)pageFormat.getImageableHeight() - 1);
            graphics.translate((int)pageFormat.getImageableX() + WEST, (int)pageFormat.getImageableY() + NORTH);
        } else {
            dimension = new Dimension((int)pageFormat.getWidth() - WEST - EAST - 1, (int)pageFormat.getHeight() - NORTH - SOUTH - 1);
            graphics.translate(WEST, NORTH);
        }
        dimension = new Dimension((int)Math.rint((double)dimension.width / PRINT_SCALE), (int)Math.rint((double)dimension.height / PRINT_SCALE));
        ((Graphics2D)graphics).scale(PRINT_SCALE, PRINT_SCALE);
        BorderedGeoTransform borderedGeoTransform = new BorderedGeoTransform(-this.pb.y, -this.pb.x, this.pb.orientation, (double)(Math.max(dimension.width, dimension.height) - 60) / Math.abs(this.pb.height));
        borderedGeoTransform.setOffset((dimension.height - 60) / 2, dimension.width / 2);
        IGraphics iGraphics = new IGraphics(graphics, borderedGeoTransform, new Rectangle(0, 0, dimension.width, dimension.height));
        graphics.setClip(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 60 - 3);
        this.drawStempel(iGraphics, 1, dimension.height - 60 - 2, dimension.width - 2, 60);
        iGraphics.setViewRect(graphics.getClipBounds());
        GraphicClip graphicClip = new GraphicClip(this.db, iGraphics, new Rectangle(-10, -10, dimension.width + 20, dimension.height - 60 + 20));
        graphicClip.setSize(dimension.width, dimension.height - 60);
        graphicClip.setEllipseMasstab(KafPlotProperties.getEllipseZoom());
        graphics.setClip(2, 2, dimension.width - 3, dimension.height - 60 - 4);
        graphicClip.print(graphics);
        return 0;
    }

    private void drawStempel(IGraphics iGraphics, int n, int n2, int n3, int n4) {
        Graphics graphics = iGraphics.getGraphics();
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawLine(n + n3 - 50, n2, n + n3 - 50, n2 + n4);
        Font font = new Font("Serif", 0, 14);
        Font font2 = new Font("Serif", 1, 14);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        FontMetrics fontMetrics2 = this.getFontMetrics(font2);
        int n5 = fontMetrics2.getLeading();
        int n6 = n2 + 6 + fontMetrics2.getHeight() / 2;
        int n7 = n2 + 23 + fontMetrics2.getHeight() / 2;
        int n8 = n2 + 40 + fontMetrics2.getHeight() / 2;
        int n9 = n + 5;
        int n10 = 0;
        graphics.setFont(font2);
        String string = "Projekt:";
        graphics.drawString(string, n9, n6);
        n10 = Math.max(n10, fontMetrics2.stringWidth(string));
        string = "Bearbeiter:";
        graphics.drawString(string, n9, n8);
        n10 = Math.max(n10, fontMetrics2.stringWidth(string));
        n9 += n10 + 5;
        n10 = 0;
        graphics.setFont(font);
        if (DataBase.projekt != null) {
            graphics.drawString(DataBase.projekt, n9, n6);
            n10 = Math.max(n10, fontMetrics.stringWidth(DataBase.projekt));
        }
        if (DataBase.source != null) {
            graphics.drawString(DataBase.source, n9, n7);
            n10 = Math.max(n10, fontMetrics.stringWidth(DataBase.source));
        }
        if (DataBase.bearbeiter != null) {
            graphics.drawString(DataBase.bearbeiter, n9, n8);
            n10 = Math.max(n10, fontMetrics.stringWidth(DataBase.bearbeiter));
        }
        graphics.drawLine(n9 += n10 + 10, n2, n9, n2 + n4);
        n10 = 0;
        graphics.setFont(font2);
        string = "Gemeinde:";
        graphics.drawString(string, n9 += 5, n6);
        n10 = Math.max(n10, fontMetrics2.stringWidth(string));
        string = "Gemarkung:";
        graphics.drawString(string, n9, n7);
        n10 = Math.max(n10, fontMetrics2.stringWidth(string));
        int n11 = n9 + n10 + 5;
        graphics.setFont(font);
        if (DataBase.gemeinde != null) {
            graphics.drawString(DataBase.gemeinde, n11, n6);
        }
        if (DataBase.gemarkung != null) {
            graphics.drawString(DataBase.gemarkung, n11, n7);
        }
        graphics.setFont(font2);
        string = "Flur:";
        graphics.drawString(string, n9, n8);
        n9 += fontMetrics2.stringWidth(string) + 5;
        graphics.setFont(font);
        if (DataBase.flur != null) {
            graphics.drawString(DataBase.flur, n9, n8);
            n9 += fontMetrics.stringWidth(DataBase.flur) + 10;
        } else {
            n9 += 20;
        }
        graphics.setFont(font2);
        string = "Flurst\u00fcck:";
        graphics.drawString(string, n9, n8);
        n9 += fontMetrics2.stringWidth(string) + 5;
        graphics.setFont(font);
        if (DataBase.flurstueck != null) {
            graphics.drawString(DataBase.flurstueck, n9, n8);
        }
        Nordpfeil nordpfeil = new Nordpfeil();
        nordpfeil.setLocation(n + n3 - 25, n2 + n4 - 33);
        nordpfeil.setSize(40);
        nordpfeil.setAngle(iGraphics.getRotation());
        nordpfeil.drawSymbol(graphics);
    }
}

