/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Bundesland;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataBaseChecker;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.KafDatProperties;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotFrame;
import de.geocalc.kafplot.KafPlotModules;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.LineDisplayProp;
import de.geocalc.kafplot.LokalTransform;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.PrintPage;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.AgaReader;
import de.geocalc.kafplot.io.AlkReader;
import de.geocalc.kafplot.io.FortfuehrungIOProperties;
import de.geocalc.kafplot.io.GeografOutReader;
import de.geocalc.kafplot.io.GeografOutWriter;
import de.geocalc.kafplot.io.GgRissWriter;
import de.geocalc.kafplot.io.GsiPolarReader;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.IPunktReader;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.LeicaPolarReader;
import de.geocalc.kafplot.io.MessungParser;
import de.geocalc.kafplot.io.NasReader;
import de.geocalc.kafplot.io.VeraenderungIOProperties;
import de.geocalc.kafplot.io.aga.AgaIOProperties;
import de.geocalc.kafplot.io.alkis.AlkisIOProperties;
import de.geocalc.kafplot.io.alkis.NasIOProperties;
import de.geocalc.kafplot.io.caddy.CaddyIOProperties;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.wldge.WldgeIOProperties;
import de.geocalc.util.VariableNotFoundException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyLoader {
    public static final String DEFAULT_LIST = "KafPlot.properties";
    public static final String KAFDAT_LIST = "KafDat.properties";
    public static final String TRANSFER_LIST = "transfer.properties";
    public static final String GEOGRAF_LIST = "geograf.properties";
    public static final String CADDY_LIST = "caddy.properties";
    public static final String GEMARKUNGEN_LIST = "gemarkungen.properties";
    public static final String GEMARKUNGEN_NUMBERS_LIST = "gemarkungen.pnr.properties";
    public static final String STRASSEN_LIST = "strassen.properties";
    public static final String AEMTER_LIST = "aemter.properties";
    public static final String VERMARKUNGEN_LIST = "vermarkungen.properties";
    public static final String NUTZUNGEN_LIST = "nutzung.properties";
    public static final String LGA_LIST = "lagegenauigkeit.properties";
    public static final String THEMES_LIST = "themes.properties";
    public static final String DISPLAY_LIST = "display.properties";
    public static final String TRANSFORM_LIST = "trafoparameter.properties";
    public static final String LICENCE_LIST = "kafplot.licence";
    private static final char UNDER_LINE = '_';
    private static final char SEPARATOR = '/';
    private static final char SPACE = ' ';
    private static final String ENCODING = "Cp1252";
    private Properties properties = null;

    public static final LineNumberReader createReader(InputStream inputStream) throws IOException {
        return new LineNumberReader(new InputStreamReader(inputStream, ENCODING));
    }

    public void loadProperties(String string) throws IOException {
        this.loadProperties(string, string);
    }

    public void loadKatalogData() {
        try {
            this.loadProperties(GEMARKUNGEN_LIST);
            this.loadProperties(STRASSEN_LIST);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadProperties(String string, String string2) throws IOException {
        block45: {
            try {
                try {
                    if (string.equals(KAFDAT_LIST)) {
                        try {
                            KafDatProperties.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            KafDatProperties.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        break block45;
                    }
                    if (string.equals(GEOGRAF_LIST)) {
                        InputStream inputStream;
                        InputStream inputStream2 = inputStream = new File(string2).exists() ? new FileInputStream(new File(string2)) : this.getClass().getResourceAsStream("/" + string2);
                        if (inputStream != null) {
                            GeografProperties.load(inputStream);
                        }
                        return;
                    }
                    if (string.equals(CADDY_LIST)) {
                        InputStream inputStream;
                        InputStream inputStream3 = inputStream = new File(string2).exists() ? new FileInputStream(new File(string2)) : this.getClass().getResourceAsStream("/" + string2);
                        if (inputStream != null) {
                            CaddyIOProperties.load(inputStream);
                        }
                        return;
                    }
                    if (string.equals(VERMARKUNGEN_LIST)) {
                        try {
                            VermarkungsArt.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            VermarkungsArt.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        return;
                    }
                    if (string.equals(NUTZUNGEN_LIST)) {
                        try {
                            NutzungsArt.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            NutzungsArt.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        return;
                    }
                    if (string.equals(LGA_LIST)) {
                        return;
                    }
                    if (string.equals(GEMARKUNGEN_LIST)) {
                        try {
                            Gemeinde.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Gemeinde.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        return;
                    }
                    if (string.equals(STRASSEN_LIST)) {
                        try {
                            Strasse.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Strasse.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        return;
                    }
                    if (string.equals(AEMTER_LIST)) {
                        try {
                            KatAmt.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            KatAmt.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        return;
                    }
                    if (string.equals(DISPLAY_LIST)) {
                        try {
                            LineDisplayProp.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        catch (NullPointerException nullPointerException) {}
                        break block45;
                    }
                    if (string.equals(LICENCE_LIST)) {
                        try {
                            KafPlotVersion.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        catch (NullPointerException nullPointerException) {}
                        break block45;
                    }
                    if (string.equals(TRANSFORM_LIST)) {
                        try {
                            LokalTransform.load(new FileInputStream(new File(string2)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            LokalTransform.load(this.getClass().getResourceAsStream("/" + string2));
                        }
                        break block45;
                    }
                    if (string.equals(THEMES_LIST)) {
                        PropertyLoader.loadThemes(this.getClass().getResourceAsStream("/" + string2));
                        break block45;
                    }
                    this.properties = new Properties();
                    try {
                        this.properties.load(new FileInputStream(new File(string2)));
                    }
                    catch (Exception exception) {
                        this.properties.load(this.getClass().getResourceAsStream("/" + string2));
                    }
                    if (string.equals(TRANSFER_LIST)) {
                        this.readTransferList(this.properties);
                    } else {
                        String string3 = null;
                        if (string3 == null) {
                            string3 = System.getProperty("ComSpec");
                        }
                        if (string3 == null) {
                            string3 = System.getProperty("comspec");
                        }
                        if (string3 == null) {
                            string3 = System.getProperty("COMSPEC");
                        }
                        if (string3 == null) {
                            string3 = System.getProperty("Comspec");
                        }
                        KafPlotProperties.setComSpec(string3);
                        this.readDefaultList(this.properties);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException("Die Datei <" + string2 + "> wurde nicht gefunden\nstellen Sie sicher, da\u00df die Datei in einem CLASSPATH-Verzeichnis vorliegt");
                }
            }
            catch (IOException iOException) {
                throw new IOException("Fehler beim Lesen der Installationsdatei <" + string2 + ">!\n" + iOException.getMessage());
            }
        }
    }

    public void readDefaultList(Properties properties) throws IOException {
        String string;
        String string2;
        Object object;
        int n;
        int n2;
        int n3;
        this.properties = properties;
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n3 = Integer.parseInt(properties.getProperty("KafPlotFrame.ScrX").trim());
            n2 = Integer.parseInt(properties.getProperty("KafPlotFrame.ScrY").trim());
            n = Integer.parseInt(properties.getProperty("KafPlotFrame.ScrB").trim());
            int n4 = Integer.parseInt(properties.getProperty("KafPlotFrame.ScrH").trim());
            KafPlotFrame.FRAME_X = Math.max(Math.max(n3, 0), Math.min(n3, dimension.width - 10));
            KafPlotFrame.FRAME_Y = Math.max(Math.max(n2, 0), Math.min(n2, dimension.height - 10));
            KafPlotFrame.FRAME_B = Math.max(470, Math.min(n, dimension.width - n3));
            KafPlotFrame.FRAME_H = Math.max(315, Math.min(n4, dimension.height - n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.saveThemeOnChange = Integer.parseInt(properties.getProperty("KafPlotFrame.saveThemeOnChange").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.setDirectlyDialogs(Integer.parseInt(properties.getProperty("KafPlotFrame.activeDialogs").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.getUpdateInfo(Integer.parseInt(properties.getProperty("KafPlot.getUpdateInfo").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n5 = Integer.parseInt(properties.getProperty("PrintPage.links").trim());
            n3 = Integer.parseInt(properties.getProperty("PrintPage.oben").trim());
            n2 = Integer.parseInt(properties.getProperty("PrintPage.rechts").trim());
            n = Integer.parseInt(properties.getProperty("PrintPage.unten").trim());
            PrintPage.setPageBorder(n5, n3, n2, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PrintPage.setPrintScale(Double.parseDouble(properties.getProperty("PrintPage.scale").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotModules.setState(1, Integer.parseInt(properties.getProperty("KafPlotModules.SaveDat").trim()) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotModules.setState(2, Integer.parseInt(properties.getProperty("KafPlotModules.SaveDatAs").trim()) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotModules.setState(3, Integer.parseInt(properties.getProperty("KafPlotModules.CreateElements").trim()) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.externCommandSocket = Integer.parseInt(properties.getProperty("KafPlot.externCommandSocket").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.setEtrsGkTransformer(properties.getProperty("TrafoFileReader.etrs_gk").trim());
            KafPlotProperties.setGkEtrsTransformer(properties.getProperty("TrafoFileReader.gk_etrs").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = properties.getProperty("HelpV1.command").trim();
            if (object != null) {
                KafPlotProperties.helpCommandV1 = object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = properties.getProperty("HelpV2.command").trim();
            if (object != null) {
                KafPlotProperties.helpCommandV2 = object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.setThreadMode(Integer.parseInt(properties.getProperty("KafPlot.threadMode").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = new Double(properties.getProperty("KoordinatenSystem.etrs_min_y").trim());
            double d = (Double)object;
            object = new Double(properties.getProperty("KoordinatenSystem.etrs_max_y").trim());
            double d2 = (Double)object;
            KoordinatenSystem.setArea(489, d, d2);
            object = new Double(properties.getProperty("KoordinatenSystem.gk_min_y").trim());
            d = (Double)object;
            object = new Double(properties.getProperty("KoordinatenSystem.gk_max_y").trim());
            d2 = (Double)object;
            KoordinatenSystem.setArea(150, d, d2);
        }
        catch (Exception exception) {
            throw new IOException("Fehler beim Lesen der KoordinatenSystem-Variablen");
        }
        if ((KafPlotProperties.getEtrsGkTransformer() != null || KafPlotProperties.getGkEtrsTransformer() != null) && KafPlotProperties.getComSpec() == null) {
            try {
                DataBase.maxLinieDistance = Double.valueOf(properties.getProperty("DataBase.maxLinieDistance").trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            KatasternachweisIOProperties.setBundesland(Bundesland.parseBundesland(properties.getProperty("KatasternachweisWriter.version").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_WITH_GRENZEN = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitGrenzen").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_WITH_GEBAEUDE = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitGebaeude").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_SHORT_LINES = Integer.parseInt(properties.getProperty("KatasternachweisWriter.kurzLaenge").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_RISS_BEMERKUNG = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitRissBemerkungen").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_RISS_BESTIMMUNG = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitBestimmung").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_RISS_KONTROLLE = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitKontrollBestimmung").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_RISS_KOMBI_MESS = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitMessungKombiniert").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_IDENT_TITEL = Integer.parseInt(properties.getProperty("KatasternachweisWriter.identTitel").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_IDENT_ALL_MESSUNG = Integer.parseInt(properties.getProperty("KatasternachweisWriter.allMessung").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_IDENT_MAP_POINTS = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitKartenPunkt").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_LOKAL_PUNKT = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitLokalPunkt").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.WRITE_SAP_LSP = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitSapLsp").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.USE_GEWICHTE = Integer.parseInt(properties.getProperty("KatasternachweisWriter.mitGewichte").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.FORMAT_MM = Integer.parseInt(properties.getProperty("KatasternachweisWriter.formatMM").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.MAX_ANSCHLUSS_STATUS = Integer.parseInt(properties.getProperty("KatasternachweisWriter.maxAnschlussStatus").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.PARSE_POINT_NUMBER = Integer.parseInt(properties.getProperty("KatasternachweisWriter.parsePointNumber").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.ALTPUNKT_KENNUNG = properties.getProperty("KatasternachweisWriter.altpunktKennung").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.TEST_LSP = Integer.parseInt(properties.getProperty("KatasternachweisWriter.testLsp").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.TEST_SP = Integer.parseInt(properties.getProperty("KatasternachweisWriter.testSp").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.TEST_LGA = Integer.parseInt(properties.getProperty("KatasternachweisWriter.testLga").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.TEST_LZK = Integer.parseInt(properties.getProperty("KatasternachweisWriter.testLzk").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.HIDE_ERROR_MESSAGES = Integer.parseInt(properties.getProperty("KatasternachweisWriter.versteckeFehler").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.ABM_AS_TEXT = Integer.parseInt(properties.getProperty("KatasternachweisWriter.abmarkungText").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.setGpsName(properties.getProperty("KatasternachweisWriter.gpsName").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.setVermTitle(properties.getProperty("KatasternachweisWriter.vermTitle").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.setVermPrefix(properties.getProperty("KatasternachweisWriter.vermPrefix").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.setAmtTitle(properties.getProperty("KatasternachweisWriter.amtTitle").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasternachweisIOProperties.setAmtPrefix(properties.getProperty("KatasternachweisWriter.amtPrefix").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.setBundesland(Bundesland.parseBundesland(properties.getProperty("FortfuehrungWriter.version").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.WRITE_END_NUMMER = new Integer(properties.getProperty("FortfuehrungWriter.endNummer").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.WRITE_END_AREA = new Integer(properties.getProperty("FortfuehrungWriter.endArea").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.WRITE_VOID_LINE = new Integer(properties.getProperty("FortfuehrungWriter.voidLine").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.DIFF_DOKU = new Double(properties.getProperty("FortfuehrungWriter.diffDoku").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.INTERSECT_MIN_ABS = new Double(properties.getProperty("FortfuehrungWriter.intersectMinAbs").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FortfuehrungIOProperties.INTERSECT_MIN_PERC = new Double(properties.getProperty("FortfuehrungWriter.intersectMinPerc").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            VeraenderungIOProperties.writeOldPoints(Integer.parseInt(properties.getProperty("VeraenderungWriter.writeOldPoints").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            VeraenderungIOProperties.writeDiffLines(Integer.parseInt(properties.getProperty("VeraenderungWriter.writeDiffLines").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            VeraenderungIOProperties.writeVoidLines(Integer.parseInt(properties.getProperty("VeraenderungWriter.writeVoidLines").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            VeraenderungIOProperties.writeEntstehung(Integer.parseInt(properties.getProperty("VeraenderungWriter.writeEntstehung").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.A1 = new Double(properties.getProperty("KatasterParameter.a1").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.A2 = new Double(properties.getProperty("KatasterParameter.a2").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.A3 = new Double(properties.getProperty("KatasterParameter.a3").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.AF = new Double(properties.getProperty("KatasterParameter.af").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.E1 = new Double(properties.getProperty("KatasterParameter.e1").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.E2 = new Double(properties.getProperty("KatasterParameter.e2").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.E3 = new Double(properties.getProperty("KatasterParameter.e3").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.EF = new Double(properties.getProperty("KatasterParameter.ef").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KatasterParameter.USE_GEWICHTE = Integer.parseInt(properties.getProperty("KatasterParameter.mitGewichte").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MessungParser.progressiveGeomSearchMode = Integer.parseInt(properties.getProperty("DatReader.progressiveGeomSearchMode").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafkaIOProperties.setVars(properties.getProperty("DatReader.daten").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafkaIOProperties.setAutoPa(Integer.parseInt(properties.getProperty("DatReader.autoPA").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafkaIOProperties.setAutoEnt(Integer.parseInt(properties.getProperty("DatReader.autoENT").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GeografOutReader.setObjectSearch(Integer.parseInt(properties.getProperty("GeografOutReader.objektSuche").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GeografOutReader.setObjectSearchOfDigit(Integer.parseInt(properties.getProperty("GeografOutReader.objektSucheAusDigit").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GeografOutWriter.moveObjectKoo = Integer.parseInt(properties.getProperty("GeografOutWriter.moveObjectKoo").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GGIOProperties.versionPlan = Integer.parseInt(properties.getProperty("GeografOutWriter.versionPlan").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GGIOProperties.versionRiss = Integer.parseInt(properties.getProperty("GeografOutWriter.versionRiss").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GGIOProperties.lengthAsFormula = Integer.parseInt(properties.getProperty("GeografOutWriter.laengeTextFormel").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GGIOProperties.nutzungAsText = Integer.parseInt(properties.getProperty("GeografOutWriter.nutzungText").trim()) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GGIOProperties.setCooSystem(properties.getProperty("GeografOutWriter.system").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GgRissWriter.setDefaultdifferPnr(Integer.parseInt(properties.getProperty("GgRissWriter.differPnr").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GgRissWriter.setDefaultdifferLen(Integer.parseInt(properties.getProperty("GgRissWriter.differLen").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GgRissWriter.setDefaultdifferGre(Integer.parseInt(properties.getProperty("GgRissWriter.differGre").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AlkReader.setNewNumber(Long.parseLong(properties.getProperty("AlkReader.newNumber").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            EdbsIOProperties.setOutStandardLga(Integer.parseInt(properties.getProperty("EdbsWriter.lsp").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            EdbsIOProperties.setOutStandardOska(Integer.parseInt(properties.getProperty("EdbsWriter.oska").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasReader.setPnrReduction(this.longProp("NasReader.pnrReduction"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasReader.setYAddition(this.doubleProp("NasReader.yAddition"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasReader.setNewNumber(this.longProp("NasReader.newNumber"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasIOProperties.readBGU(this.booleanProp("NasReader.readBGU"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasIOProperties.readBBU(this.booleanProp("NasReader.readBBU"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasIOProperties.readBoden(this.booleanProp("NasReader.readBoden"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasIOProperties.readPunktExtends(this.booleanProp("NasReader.readPointExtends"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NasIOProperties.writeVoidBa(this.booleanProp("NasFFWriter.writeVoidBA"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AlkisIOProperties.setImportPnrReduction(Long.parseLong(properties.getProperty("AlkisReader.pnrReduction").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AlkisIOProperties.setImportYReduction(Double.parseDouble(properties.getProperty("AlkisReader.yReduction").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AlkisIOProperties.setExportPnrAddition(Long.parseLong(properties.getProperty("AlkisWriter.pnrAddition").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AlkisIOProperties.setExportYAddition(Double.parseDouble(properties.getProperty("AlkisWriter.yAddition").trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            EdbsIOProperties.setInStandardCleanAreas(Integer.parseInt(properties.getProperty("AlkReader.cleanGeom").trim()) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IOProperties.setExportFileTypes(properties.getProperty("Export.types").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (properties.getProperty("Proxy.proxyHost") != null && System.getProperty("proxySet") == null) {
            object = properties.getProperty("Proxy.proxyHost").trim();
            String string3 = properties.getProperty("Proxy.proxyPort").trim();
            String string4 = properties.getProperty("Proxy.nonProxyHosts").trim();
            String string5 = properties.getProperty("Proxy.proxyPW").trim();
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", (String)object);
            if (string3 != null) {
                System.setProperty("proxyPort", string3);
            }
            if (string4 != null) {
                System.setProperty("nonProxyHosts", string4);
            }
            if (string5 != null) {
                System.setProperty("proxyPW", string5);
            }
        }
        int n6 = 1;
        while ((string2 = properties.getProperty("WmsReader.url" + n6)) != null) {
            KafPlotProperties.addWmsServer(string2);
            ++n6;
        }
        try {
            DataBaseChecker.checkNummer = this.booleanProp("DataBaseChecker.checkNummer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkNummerId = this.booleanProp("DataBaseChecker.checkNummerId");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkNummerNb = this.booleanProp("DataBaseChecker.checkNummerNb");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkUmnum = this.booleanProp("DataBaseChecker.checkUmnum");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAufnahme = this.booleanProp("DataBaseChecker.checkAufnahme");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAufnahmeGpsLage = this.booleanProp("DataBaseChecker.checkAufnahmeGpsLage");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAufnahmePolLage = this.booleanProp("DataBaseChecker.checkAufnahmePolLage");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAufnahmeNivHoehe = this.booleanProp("DataBaseChecker.checkAufnahmeNivHoehe");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAufnahmePolHoehe = this.booleanProp("DataBaseChecker.checkAufnahmePolHoehe");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkConfig = this.booleanProp("DataBaseChecker.checkKonfiguration");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkKatNachw = this.booleanProp("DataBaseChecker.checkKatNachw");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkPunktLage = this.booleanProp("DataBaseChecker.checkPunktLage");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkLagegenauigkeit = this.booleanProp("DataBaseChecker.checkLagegenauigkeit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAufnahme = this.booleanProp("DataBaseChecker.checkAufnahme");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkKontrolliertheit = this.booleanProp("DataBaseChecker.checkKontrolliertheit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkLageabweichung = this.booleanProp("DataBaseChecker.checkLageabweichung");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFestpunkte = this.booleanProp("DataBaseChecker.checkFestpunkte");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkLG = this.booleanProp("DataBaseChecker.checkLG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkArt = this.booleanProp("DataBaseChecker.checkArt");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkGrenzpunktArt = this.booleanProp("DataBaseChecker.checkGrenzpunktArt");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkUmringArt = this.booleanProp("DataBaseChecker.checkUmringArt");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkLineOska = this.booleanProp("DataBaseChecker.checkLineOska");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkTeilung = this.booleanProp("DataBaseChecker.checkTeilung");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkObjGeom = this.booleanProp("DataBaseChecker.checkObjGeom");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFlstUmring = this.booleanProp("DataBaseChecker.checkFlstUmring");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkLineLength = this.booleanProp("DataBaseChecker.checkLineLength");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFlstSchleife = this.booleanProp("DataBaseChecker.checkFlstSchleife");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFreiePunkte = this.booleanProp("DataBaseChecker.checkFreiePunkte");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFlaecheSumme = this.booleanProp("DataBaseChecker.checkFlaecheSumme");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkObjectKoo = this.booleanProp("DataBaseChecker.checkObjectKoo");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkUeberbau = this.booleanProp("DataBaseChecker.checkUeberbau");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkMultiArea = this.booleanProp("DataBaseChecker.checkMultiArea");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkBuchArea = this.booleanProp("DataBaseChecker.checkBuchArea");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkObjAtt = this.booleanProp("DataBaseChecker.checkObjAtt");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkAlb = this.booleanProp("DataBaseChecker.checkAlb");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkGebSoll = this.booleanProp("DataBaseChecker.checkGebSoll");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFlstNutzung = this.booleanProp("DataBaseChecker.checkFlstNutzung");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkFlstLagebez = this.booleanProp("DataBaseChecker.checkFlstLagebez");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkGebNutzung = this.booleanProp("DataBaseChecker.checkGebNutzung");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkGebPseudo = this.booleanProp("DataBaseChecker.checkGebPseudo");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkGebLage = this.booleanProp("DataBaseChecker.checkGebLage");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DataBaseChecker.checkStrassenland = this.booleanProp("DataBaseChecker.checkStrassenland");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = properties.getProperty("DataBaseChecker.pa2");
            if (string != null) {
                DataBaseChecker.loadPaOskas(2, string);
            }
        }
        catch (IOException iOException) {
            throw new IOException("DataBaseChecker.pa2, " + iOException.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = properties.getProperty("DataBaseChecker.pa3");
            if (string != null) {
                DataBaseChecker.loadPaOskas(3, string);
            }
        }
        catch (IOException iOException) {
            throw new IOException("DataBaseChecker.pa3, " + iOException.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IFileReader.setDefaultReadModus(this.intProp("IFileReader.readModus"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IFileReader.setDefaultPnrModus(this.intProp("IFileReader.pnrModus"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IFileReader.setNewNumber(this.longProp("IFileReader.newNumber"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setImportOption(this.intProp("WldgeIOProperties.importOption"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setImportAll(this.booleanProp("WldgeIOProperties.importAll"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setAddDifferenz(this.doubleProp("WldgeIOProperties.addDifferenz"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setPercentDifferenz(this.doubleProp("WldgeIOProperties.percentDifferenz"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setStammstueckSoll(this.booleanProp("WldgeIOProperties.stammstueckSoll"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setNutzungFlaecheArt(this.intProp("WldgeIOProperties.nutzungFlaecheArt"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WldgeIOProperties.setNutzungSpec(this.intProp("WldgeIOProperties.nutzungSpec"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KpvIOProperties.writeErrors(this.booleanProp("KpvIOProperties.writeErrors"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KpvIOProperties.setAreaSwitch(this.intProp("KpvIOProperties.areaSwitch"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KpvIOProperties.setGemarkungen(this.stringProp("KpvIOProperties.gemarkungen"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = properties.getProperty("FileName.rissliste");
            if (string != null) {
                KafPlotProperties.setRisslisteFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.nachweis");
            if (string != null) {
                KafPlotProperties.setNachweisFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.einrechnung");
            if (string != null) {
                KafPlotProperties.setEinrechnungFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.beleg");
            if (string != null) {
                KafPlotProperties.setBelegFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.veraenderung");
            if (string != null) {
                KafPlotProperties.setVeraenderungFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.export");
            if (string != null) {
                KafPlotProperties.setExportFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.check");
            if (string != null) {
                KafPlotProperties.setCheckFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            string = properties.getProperty("FileName.import");
            if (string != null) {
                KafPlotProperties.setImportCheckFileName(string);
            }
        }
        catch (VariableNotFoundException variableNotFoundException) {
            throw new IOException(variableNotFoundException.getMessage());
        }
        try {
            KafPlotColor.BACKGROUND = this.colorProp("KafPlotColor.BACKGROUND");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotColor.GITTER = this.colorProp("KafPlotColor.GITTER");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.isPunktMoveStrukturVisible = this.booleanProp("KafPlotProperties.drawPunktMove");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            KafPlotProperties.setPunktBgScaleValue(this.doubleProp("KafPlotProperties.punktBgScale"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readTransferList(Properties properties) throws IOException {
        this.properties = properties;
        try {
            IPolarReader.setMitteln(new Integer(properties.getProperty("IPolarReader.mitteln")) != 0);
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.mitteln");
        }
        try {
            IPolarReader.setReduzieren(new Integer(properties.getProperty("IPolarReader.reduzieren")) != 0);
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.reduzieren");
        }
        try {
            IPolarReader.setStreckeDiff(new Double(properties.getProperty("IPolarReader.sDiffZul")));
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.sDiffZul");
        }
        try {
            IPolarReader.setRichtungDiff(new Double(properties.getProperty("IPolarReader.rDiffZul")));
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.rDiffZul");
        }
        try {
            IPolarReader.setZenitDiff(new Double(properties.getProperty("IPolarReader.zDiffZul")));
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.zDiffZul");
        }
        try {
            IPolarReader.setTrigDist(Integer.parseInt(properties.getProperty("IPolarReader.zTrigDist")) > 0);
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.zTrigDist");
        }
        try {
            IPolarReader.setTrigSteuerdaten(Integer.parseInt(properties.getProperty("IPolarReader.zSteuerdaten")) > 0);
        }
        catch (Exception exception) {
            throw new IOException("Ung\u00fcltiger Wert in der Variablen:  IPolarReader.zSteuerdaten");
        }
        try {
            IPolarReader.setIgnoreR0(Integer.parseInt(properties.getProperty("IPolarReader.ignoreR0")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IPolarReader.setIgnoreR(new Double(properties.getProperty("IPolarReader.ignoreR")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.readHorizontalDist(Integer.parseInt(properties.getProperty("AgaReader.readHorizontalDist")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.readPnrLast(Integer.parseInt(properties.getProperty("AgaReader.readPnrLast")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.readReferenz(Integer.parseInt(properties.getProperty("AgaReader.readReferenz")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.setStationKennung(properties.getProperty("AgaReader.stationKennung"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.setPunktnummerFirstKennung(properties.getProperty("AgaReader.punktnummerFirstKennung"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.setPunktnummerLastKennung(properties.getProperty("AgaReader.punktnummerLastKennung"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.setQExzLabel(Integer.parseInt(properties.getProperty("AgaReader.qExzLabel")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.setLExzLabel(Integer.parseInt(properties.getProperty("AgaReader.lExzLabel")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.readPPM(Integer.parseInt(properties.getProperty("AgaReader.readPPM")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaReader.readPrismKonstant(Integer.parseInt(properties.getProperty("AgaReader.readPrismK")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AgaIOProperties.punktcode = Integer.parseInt(properties.getProperty("AgaIOProperties.punktcode")) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LeicaPolarReader.setStationKennung(properties.getProperty("LeicaPolarReader.stationKennung"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = properties.getProperty("LeicaPolarReader.stpktCodeWord");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-.,");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        LeicaPolarReader.setStandpunktCode(Integer.parseInt(string2));
                        GsiPolarReader.setStpktCode(Integer.parseInt(string2));
                        break;
                    }
                    case 1: {
                        LeicaPolarReader.setStandpunktIdent(Integer.parseInt(string2));
                        GsiPolarReader.setStandpunktIdent(Integer.parseInt(string2));
                    }
                }
                ++n;
            }
            LeicaPolarReader.setStationKennung(properties.getProperty("LeicaPolarReader.stationKennung"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IPunktReader.reduceY(Integer.parseInt(properties.getProperty("IPunktReader.reduceY")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IPunktReader.reducePnr(Integer.parseInt(properties.getProperty("IPunktReader.reducePnr")) > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean booleanProp(String string) throws Exception {
        return Integer.parseInt(this.properties.getProperty(string)) > 0;
    }

    private int intProp(String string) throws Exception {
        return Integer.parseInt(this.properties.getProperty(string));
    }

    private long longProp(String string) throws Exception {
        return Long.parseLong(this.properties.getProperty(string));
    }

    private double doubleProp(String string) throws Exception {
        return new Double(this.properties.getProperty(string));
    }

    private String stringProp(String string) throws Exception {
        return this.properties.getProperty(string);
    }

    private Color colorProp(String string) throws Exception {
        return KafPlotColor.parseColor(this.properties.getProperty(string));
    }

    public static void loadThemes(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream, ENCODING)));
            Properties properties = new Properties();
            String string2 = null;
            while ((string = lineNumberReader.readLine()) != null) {
                try {
                    if (string.length() == 0 || string.startsWith("#")) continue;
                    if ((string = string.trim()).startsWith("[")) {
                        if (string2 != null) {
                            KafPlotProperties.saveTheme(string2, properties);
                        }
                        string2 = string.substring(string.indexOf(91) + 1, string.indexOf(93));
                        properties = new Properties();
                        continue;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "= ");
                    properties.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                }
                catch (Exception exception) {}
            }
            if (string2 != null) {
                KafPlotProperties.saveTheme(string2, properties);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

