/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IInscription;
import de.geocalc.awt.IInscriptionComponent;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.io.DxfConstants;
import de.geocalc.io.DxfFileWriter;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KatasterElement;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Lagezuverlaessigkeit;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktParameterVoid;
import de.geocalc.kafplot.PunktStatus;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.StatElement;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.aga.AgaIOProperties;
import de.geocalc.kafplot.io.alkis.AlkisIOProperties;
import de.geocalc.kafplot.io.caddy.CaddyIOProperties;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.sta.StaIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.Sortable;
import de.geocalc.util.sml.Tag;
import de.geocalc.xml.Node;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class Punkt
extends DPoint
implements Cloneable,
KatasterElement,
PunktContainer,
Exceptionable,
Messager,
Drawable,
LongHashObject,
DatObject,
TagObject,
Sortable,
Comparable,
StatElement {
    public static final int UNKNOWN = 0;
    public static final int PNR = 101;
    public static final int UM_PNR = 102;
    public static final int PS = 200;
    public static final int PA = 201;
    public static final int EB = 202;
    public static final int VA = 203;
    public static final int LS = 204;
    public static final int LG = 205;
    public static final int LZ = 206;
    public static final int HS = 207;
    public static final int HG = 208;
    public static final int DS = 209;
    public static final int SP = 210;
    public static final int ZL = 211;
    public static final int VVA = 220;
    public static final int VVT = 221;
    public static final int OSKA = 222;
    public static final int PST = 223;
    public static final int Y = 301;
    public static final int X = 302;
    public static final int H = 303;
    public static final int DY = 351;
    public static final int DX = 352;
    public static final int A = 401;
    public static final int B = 402;
    public static final int T = 403;
    public static final int LSP = 411;
    public static final int HSP = 412;
    public static final int LHSP = 413;
    public static final int SW = 451;
    public static final int ONLINE = 901;
    public static final int KAT_ALL = 1000;
    public static final int KAT_NEU = 1001;
    public static final int KAT_AEND = 1002;
    public static final int KAT_DIFF = 1003;
    public static final int KAT_ALT = 1004;
    public static final int KAT_NUTZ = 1005;
    public static final int KAT_GEB = 1006;
    private static final char TEXT_DELIM = '\n';
    public long nr;
    private long umnum;
    public float g;
    public float h;
    public float dy;
    public float dx;
    public float dh;
    public float dl;
    public float lsp;
    public float hsp;
    public float lhsp;
    public float zl;
    public float ag;
    public float az;
    private byte ps;
    private byte ks;
    public int a;
    public int b;
    public short t;
    public int sw;
    private PunktParameter oldParam = PunktParameterVoid.VOID;
    private PunktParameter aktParam = PunktParameterVoid.VOID;
    private Stat stat = null;
    private int flags;
    private int umnumFlags;
    private static final int FLAG_STANDPUNKT = 2;
    private static final int FLAG_REFERENZ = 4;
    private static final int FLAG_INLINIE = 8;
    private static final int FLAG_TRAFOPP = 16;
    private static final int FLAG_DIGITPP = 32;
    private static final int FLAG_KOO_DIFF = 64;
    private static final int FLAG_ON = 128;
    private static final int FLAG_FORTFUEHRUNG = 256;
    private static final int FLAG_STANDHOEHE = 512;
    private static final int FLAG_MESS_GPS = 1024;
    private static final int FLAG_MESS_EIG = 2048;
    private static final int FLAG_MESS_POL = 4096;
    private static final int FLAG_MESS_KNW = 8192;
    private static final int FLAG_UM_PNR = 0x100000;
    private static final int FLAG_SWITCH_NBZ = 0x200000;
    private static final int FLAG_ERR_HOLD_KOO = 0x800000;
    private static final int FLAG_MASTER = 0x1000000;
    private static final int FLAG_SLAVE = 0x2000000;
    private static final int FLAG_INDIREKT = 0x4000000;
    private static final int FLAG_ZEIGT_AUF = 0x8000000;
    private static final int FLAG_TRAFO = 0x10000000;
    private static final int FLAG_USED_LINE = 0x20000000;
    private static final int FLAG_USED = 0x40000000;
    private static final int FLAG_TEMP1 = Integer.MIN_VALUE;
    private String riss;
    private String bemerkung;
    public static final long NUMBEZ_NUMMER = -9L;
    public static final long OHNE_NUMMER = 0L;
    public static final float HSP_FEST = 1.0E-6f;
    private static final double RO = 63.66197723675813;
    private static Color foreground = Color.black;
    private static Color background = Color.white;
    private static Random random = new Random();
    private static final String TRA = "<TR>";
    private static final String TRE = "</TR>";
    private static final String TDA = "<TD>";
    private static final String TDE = "</TD>";
    private static final String TDM = "</TD><TD>";
    public static final String TABLE_HEADER_ALL = "<TR><TH>Nummer</TH><TH>Rechtswert</TH><TH>Hochwert</TH><TH>H&ouml;he</TH><TH>Pa</TH><TH>Lg</TH><TH>Lz</TH><TH>Ea</TH><TH>Eq</TH><TH>Va</TH><TH>Vb</TH><TH>Bemerkung</TH></TR>";
    public static final String TABLE_HEADER_PNR = "<TR><TH>Nummer</TH></TR>";
    private static final double OBER_VERM = 1.0;
    private static final double UNTER_VERM = 0.5;
    private static final double RAISED = 1.4;
    private static final double TRAFO = 1.6;
    private static final double D_FAK = 0.2;
    private static final int RA_TRAFO = 2;
    private static final int RA_MARK = 4;
    private static Color colorBg;
    private static Color colorOv;
    private static Color colorUv;
    private static Color colorTv;

    public Punkt() {
        this(0L, 0.0, 0.0);
    }

    public Punkt(DPoint dPoint) {
        this(0L, dPoint.y, dPoint.x);
    }

    public Punkt(double d, double d2) {
        this(0L, d, d2);
    }

    public Punkt(long l) {
        this(l, 0.0, 0.0);
    }

    public Punkt(long l, double d, double d2) {
        this(l, d, d2, 0.0f);
    }

    public Punkt(long l, double d, double d2, float f) {
        this.nr = l;
        this.y = d;
        this.x = d2;
        this.h = f;
        this.aktParam = PunktParameterVoid.VOID;
        this.setOn(true);
    }

    public Punkt(long l, int n, int n2, double d, double d2) {
        this(l, n, n2, d, d2, 0.0f, 0, 0, 0, 0);
    }

    public Punkt(long l, int n, int n2, int n3, char c, double d, double d2) {
        this(l, n, n2, d, d2, 0.0f, 0, 0, 0, 0);
    }

    public Punkt(long l, int n, int n2, double d, double d2, float f, int n3, int n4, int n5, int n6) {
        PunktParameterALK punktParameterALK = new PunktParameterALK();
        this.nr = l;
        punktParameterALK.setPa(n);
        punktParameterALK.setVa(n2);
        this.y = d;
        this.x = d2;
        this.h = f;
        this.setOn(true);
        punktParameterALK.setLs(n3);
        punktParameterALK.setLg(n4);
        punktParameterALK.setHs(n5);
        punktParameterALK.setHg(n6);
        punktParameterALK.setVva(0);
        punktParameterALK.setVvt(0);
        this.sw = 0;
        this.initParameter(punktParameterALK);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public long getNr() {
        return this.getUmnum() > 0L ? this.getUmnum() : this.nr;
    }

    public long getNr(boolean bl) {
        return !bl ? this.nr : this.getNr();
    }

    public long getNr5() {
        return this.getNr() % 100000L;
    }

    public static long getNr5(long l) {
        return l % 100000L;
    }

    public long getNr6() {
        return this.getNr() % 1000000L;
    }

    public static long getNr6(long l) {
        return l % 1000000L;
    }

    public long getKatNr() {
        if (!this.isKatasterPunkt()) {
            return this.getNr();
        }
        return this.getNr5();
    }

    public String buildAlkisNr(boolean bl) {
        if (this.hasTag("PKN")) {
            String string = this.getTag("PKN").getValue();
            return bl ? string : IFormat.getRightString(string, 6);
        }
        if (this.getKafPa() > 0) {
            return Long.toString(bl ? AlkisIOProperties.getExportPnrAddition() + this.buildKatNr(14, this.getNr()) : this.getNr6());
        }
        return "v" + IFormat.i.format(this.getNr());
    }

    public long buildKatNr(int n) {
        return this.buildKatNr(n, this.getNr());
    }

    public long buildKatNr(int n, boolean bl) {
        return this.buildKatNr(n, this.getNr(bl));
    }

    public long buildKatNr(int n, long l) {
        if (!this.isKatasterPunkt()) {
            return l;
        }
        int n2 = this.createNb();
        int n3 = this.getModel();
        if (n3 == 1) {
            switch (n) {
                case 0: {
                    return l;
                }
                case 5: {
                    return Punkt.getNr5(l);
                }
                case 6: {
                    return (long)this.getPa() * 100000L + Punkt.getNr5(l);
                }
                case 7: {
                    return (long)this.getNb2(n2) * 100000L + Punkt.getNr5(l);
                }
                case 8: {
                    return (long)this.getNb2(n2) * 1000000L + (long)this.getPa() * 100000L + Punkt.getNr5(l);
                }
                case 9: {
                    return (long)this.getNb4(n2) * 100000L + Punkt.getNr5(l);
                }
                case 10: {
                    return (long)this.getNb4(n2) * 1000000L + (long)this.getPa() * 100000L + Punkt.getNr5(l);
                }
                case 11: {
                    return (long)n2 / 10000000L * 10000000000L + (long)this.getNb4(n2) * 1000000L + (long)this.getPa() * 100000L + Punkt.getNr5(l);
                }
                case 13: {
                    return (long)n2 * 100000L + Punkt.getNr5(l);
                }
                case 14: {
                    return (long)n2 * 1000000L + (long)this.getPa() * 100000L + Punkt.getNr5(l);
                }
                case 94: {
                    return (long)Punkt.getNb8Alk(n2) * 1000000L + (long)this.getPa() * 100000L + Punkt.getNr5(l);
                }
            }
        } else if (n3 == 2) {
            switch (n) {
                case 0: {
                    return l;
                }
                case 5: {
                    return Punkt.getNr5(l);
                }
                case 6: {
                    return Punkt.getNr6(l);
                }
                case 8: {
                    return (long)this.getNb2(n2) * 1000000L + Punkt.getNr6(l);
                }
                case 10: {
                    return (long)this.getNb4(n2) * 1000000L + Punkt.getNr6(l);
                }
                case 11: {
                    return (long)n2 / 10000000L * 10000000000L + (long)this.getNb4(n2) * 1000000L + Punkt.getNr6(l);
                }
                case 12: {
                    return (long)this.getNb6(n2) * 1000000L + Punkt.getNr6(l);
                }
                case 14: {
                    return (long)n2 * 1000000L + Punkt.getNr6(l);
                }
                case 15: {
                    return ((long)KafkaIOProperties.meridianDecade * 100000000L + (long)n2) * 1000000L + Punkt.getNr6(l);
                }
            }
        }
        return l;
    }

    public int getNumPa() {
        return this.getNumPa(this.aktParam);
    }

    public int getNumPa(PunktParameter punktParameter) {
        int n = punktParameter.getModel();
        if (n == 1) {
            return punktParameter.getModPa();
        }
        if (n == 2) {
            return (int)(this.getNr() % 1000000L / 100000L);
        }
        return 0;
    }

    public int getNb2() {
        return (int)this.y / 1000 % 10 * 10 + (int)this.x / 1000 % 10;
    }

    private int getNb2(int n) {
        return n / 10000 % 10 * 10 + n % 10;
    }

    public int getNb4() {
        return (int)this.y / 1000 % 100 * 100 + (int)this.x / 1000 % 100;
    }

    private int getNb4(int n) {
        return n / 10000 % 100 * 100 + n % 100;
    }

    private int getNb6(int n) {
        return n / 10000 % 1000 * 1000 + n % 1000;
    }

    public String getNbAsString() {
        return (int)this.y / 1000 % 100 + "." + (int)this.x / 1000 % 100;
    }

    public int getNb8Alk() {
        return Punkt.getNb8Alk(this.getNb8());
    }

    private static int getNb8Alk(int n) {
        return n / 1000000 * 1000000 + n % 10000 / 100 * 10000 + n % 1000000 / 10000 * 100 + n % 100;
    }

    public int createNb() {
        if (this.hasTag("NBZ")) {
            return Integer.parseInt(this.getTag("NBZ").getValue());
        }
        if (this.isSwitchNBZ()) {
            return Punkt.createNb(this.y - (double)this.dy, this.x - (double)this.dx);
        }
        return Punkt.createNb(this.y, this.x);
    }

    public int createKooNb() {
        return Punkt.createNb(this.y, this.x);
    }

    public int createNb(long l) {
        return (int)(l / 1000000L);
    }

    public static final int createNb(double d, double d2) {
        return (int)d / 1000 * 10000 + (int)d2 / 1000;
    }

    public static String createNbAsString(int n) {
        return n / 10000 + "." + n % 10000;
    }

    public int getLongNb() {
        return this.createNb();
    }

    public int getNb8() {
        return this.createNb();
    }

    @Override
    public int getModel() {
        return this.aktParam.getModel();
    }

    public void setOldParameter(PunktParameter punktParameter) {
        this.oldParam = PunktParameter.intern(punktParameter);
    }

    public PunktParameter getOldParameter() {
        return (PunktParameter)this.oldParam.clone();
    }

    public boolean hasParameter() {
        return !this.aktParam.equals(PunktParameterVoid.VOID);
    }

    public PunktParameter getParameter() {
        return (PunktParameter)this.aktParam.clone();
    }

    public PunktParameter getParameter(int n) {
        if (n == 1 && this.aktParam.getModel() != 1) {
            return this.aktParam.toAlkModel();
        }
        return (PunktParameter)this.aktParam.clone();
    }

    public void initParameter(PunktParameter punktParameter) {
        PunktParameter punktParameter2;
        this.oldParam = punktParameter2 = PunktParameter.intern(punktParameter);
        this.aktParam = punktParameter2;
    }

    public void updateParameter(PunktParameter punktParameter) {
        this.aktParam = PunktParameter.intern(punktParameter);
    }

    public int getPa() {
        return this.aktParam.getPa();
    }

    public int getKafPa() {
        return this.aktParam.getKafPa();
    }

    public int getVa() {
        return this.aktParam.getVa();
    }

    public int getKafVa() {
        return this.aktParam.getKafVa();
    }

    public int getVb() {
        return this.aktParam.getVb();
    }

    public int getKafVb() {
        return this.aktParam.getKafVb();
    }

    public int getVva() {
        return this.aktParam.getVva();
    }

    public int getKafVva() {
        return this.aktParam.getKafVva();
    }

    public int getVvt() {
        return this.aktParam.getVvt();
    }

    public int getKafVvt() {
        return this.aktParam.getKafVvt();
    }

    public int getLs() {
        return this.aktParam.getLs();
    }

    public int getKafLs() {
        return this.aktParam.getKafLs();
    }

    public int getLg() {
        return this.aktParam.getLg();
    }

    public int getKafLg() {
        return this.aktParam.getKafLg();
    }

    public float getLl() {
        return this.aktParam.getLl();
    }

    public float getKafLl() {
        return this.aktParam.getKafLl();
    }

    public int getLz() {
        return this.aktParam.getLz();
    }

    public int getKafLz() {
        return this.aktParam.getKafLz();
    }

    public int getEa() {
        return this.aktParam.getEa();
    }

    public int getKafEa() {
        return this.aktParam.getKafEa();
    }

    public int getEq() {
        return this.aktParam.getEq();
    }

    public int getKafEq() {
        return this.aktParam.getKafEq();
    }

    public int getHs() {
        return this.aktParam.getHs();
    }

    public int getKafHs() {
        return this.aktParam.getKafHs();
    }

    public int getHg() {
        return this.aktParam.getHg();
    }

    public int getKafHg() {
        return this.aktParam.getKafHg();
    }

    public int getPst() {
        return this.aktParam.getPst();
    }

    public int getKafPst() {
        return this.aktParam.getKafPst();
    }

    public int getArt() {
        return this.aktParam.getArt();
    }

    public int getKafArt() {
        return this.aktParam.getKafArt();
    }

    public int getEb() {
        return this.aktParam.getEb();
    }

    public int getKafEb() {
        return this.aktParam.getKafEb();
    }

    public int getOska() {
        return this.aktParam.getOska();
    }

    public int getKafOska() {
        return this.aktParam.getKafOska();
    }

    public int getFolie() {
        return this.aktParam.getFolie();
    }

    public int getKafFolie() {
        return this.aktParam.getKafFolie();
    }

    @Override
    public boolean hasStatistik() {
        return this.stat != null;
    }

    @Override
    public void setStatistik(Stat stat) {
        this.stat = stat;
    }

    @Override
    public Stat getStatistik() {
        return this.stat;
    }

    @Override
    public boolean contains(Punkt punkt) {
        return punkt == this;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        punktTable.put(this);
        return punktTable;
    }

    public final void setRiss(String string) {
        this.riss = string;
    }

    public final String getRiss() {
        return this.riss;
    }

    @Override
    public final void setBemerkung(String string) {
        this.bemerkung = string;
    }

    @Override
    public final void addBemerkung(String string) {
        this.bemerkung = this.bemerkung == null ? string : this.bemerkung + string;
    }

    @Override
    public final void addTag(String string) {
        this.bemerkung = this.bemerkung == null ? string : string + this.bemerkung;
    }

    @Override
    public final boolean hasTag(String string) {
        return this.bemerkung != null && Tag.hasTag(this.bemerkung, string);
    }

    public Tag getTag(String string) {
        return Tag.parseTag(this.bemerkung, string);
    }

    @Override
    public final String getBemerkung() {
        return this.bemerkung == null ? this.bemerkung : this.bemerkung.replace('\n', ' ');
    }

    @Override
    public final boolean hasBemerkung() {
        return this.bemerkung != null;
    }

    @Override
    public final String getBemerkungText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (Tag.hasTag(this.bemerkung)) {
            return Tag.parseText(this.getBemerkung());
        }
        return this.getBemerkung();
    }

    public void addNewBemerkung(String object) {
        object = String.valueOf('\n') + (String)object;
        this.bemerkung = this.bemerkung == null ? object : this.bemerkung + (String)object;
    }

    public boolean hasOldBemerkung() {
        return this.bemerkung != null && this.bemerkung.indexOf(10) != 0;
    }

    public String getOldBemerkung() {
        if (this.bemerkung != null) {
            int n = this.bemerkung.indexOf(10);
            return n < 0 ? this.bemerkung : this.bemerkung.substring(0, n);
        }
        return null;
    }

    public boolean hasNewBemerkung() {
        return this.bemerkung != null && this.bemerkung.indexOf(10) >= 0;
    }

    public String getNewBemerkung() {
        if (this.bemerkung != null) {
            int n = this.bemerkung.indexOf(10);
            return n < 0 ? null : this.bemerkung.substring(n + 1);
        }
        return null;
    }

    public void setUmnum(long l) {
        this.umnum = l;
    }

    public long getUmnum() {
        return this.umnum;
    }

    public boolean isAutoUmnum() {
        return this.umnum != 0L && !this.isFlagUM_PNR();
    }

    public final String getFormatedStatistikName(int n) {
        if (n == 1) {
            return "Y-Koordinate";
        }
        if (n == 2) {
            return "X-Koordinate";
        }
        return "";
    }

    private PunktParameter createParameter(int n, int n2) {
        return new PunktParameterALK(n, n2);
    }

    private PunktParameter createParameter(int n, long l) {
        return new PunktParameterALK(n, l);
    }

    @Override
    public int hashCode() {
        return (int)(this.nr ^ this.nr >> 32);
    }

    @Override
    public boolean isLt(Sortable sortable) {
        if (sortable instanceof Punkt) {
            return this.nr < ((Punkt)sortable).nr;
        }
        return this.hashCode() < sortable.hashCode();
    }

    @Override
    public int compareTo(Object object) {
        Punkt punkt = (Punkt)object;
        if (this.nr < punkt.nr) {
            return -1;
        }
        if (this.nr > punkt.nr) {
            return 1;
        }
        return 0;
    }

    @Override
    public final long longHashKey() {
        return this.nr;
    }

    public void setSymbolWinkel(double d) {
        this.sw = (int)Math.rint(d * 10000.0);
    }

    public double getSymbolWinkel() {
        return (double)this.sw / 10000.0;
    }

    public void setGl(float f) {
        this.g = f;
    }

    public float getGl() {
        return this.g;
    }

    public float getDS() {
        return (float)Math.sqrt((double)this.dx * (double)this.dx + (double)this.dy * (double)this.dy);
    }

    public float getSP() {
        double d = (double)this.a / 1000.0;
        double d2 = (double)this.b / 1000.0;
        return (float)Math.sqrt(d * d + d2 * d2);
    }

    public float getOutSP() {
        if (this.ks == 2) {
            if (KafkaIOProperties.isWPNG() && (this.ps == 1 || this.ps == 2 || this.ps == 5)) {
                return this.g;
            }
            return this.getSP();
        }
        if (this.ks == 1) {
            if (KafkaIOProperties.isWPSG() && (this.ps == 1 || this.ps == 2 || this.ps == 5)) {
                return this.g;
            }
            return this.getSP();
        }
        if (this.ps == 1 || this.ps == 2) {
            return this.g;
        }
        return this.getSP();
    }

    public float getRissSP() {
        if (this.ks == 2) {
            if (KafkaIOProperties.isWPNG() && (this.ps == 1 || this.ps == 2 || this.ps == 5)) {
                return this.g;
            }
            return this.getSP();
        }
        if (this.ks == 1) {
            if (KafkaIOProperties.isWPSG() && (this.ps == 1 || this.ps == 2 || this.ps == 5)) {
                return this.g;
            }
            return this.getSP();
        }
        return this.getSP();
    }

    public float getZL() {
        return this.zl;
    }

    public void setAG(float f) {
        this.ag = f;
    }

    public float getAG() {
        return this.ag;
    }

    public void setAZ(float f) {
        this.az = f;
    }

    public float getAZ() {
        return this.az;
    }

    public float getAbsoluteMf() {
        if (this.ps == 1) {
            return 0.0f;
        }
        if (this.ps == 2) {
            return this.getDS();
        }
        return this.getSP();
    }

    public float getLSP() {
        return this.lsp;
    }

    public void setPs(int n) {
        this.ps = (byte)n;
    }

    public void setPsOfCommand(int n) {
        switch (n) {
            case 940: {
                this.setPs(0);
                break;
            }
            case 941: {
                if (this.ps != 1 && this.ps != 2) {
                    this.y -= (double)this.dy;
                    this.x -= (double)this.dx;
                }
                this.setPs(1);
                break;
            }
            case 942: {
                if (this.ps == 2) {
                    this.y += (double)this.dy;
                    this.x += (double)this.dx;
                }
                this.setPs(1);
                break;
            }
            case 943: {
                if (this.ps != 1 && this.ps != 2) {
                    this.y -= (double)this.dy;
                    this.x -= (double)this.dx;
                }
                this.setPs(2);
                break;
            }
            case 944: {
                if (this.ps == 2) {
                    this.y += (double)this.dy;
                    this.x += (double)this.dx;
                }
                this.setPs(2);
                break;
            }
            case 945: {
                this.setPs(3);
                break;
            }
            case 946: {
                this.setPs(5);
            }
        }
        this.dy = 0.0f;
        this.dx = 0.0f;
    }

    public int getPs() {
        return this.ps;
    }

    public int getInternalPs() {
        return this.ks;
    }

    public void setInternalPs(int n) {
        this.ks = (byte)n;
    }

    public int getVaVorgefunden() {
        return this.aktParam.getKafVva() > 0 ? this.aktParam.getModVva() : this.aktParam.getModVa();
    }

    public int buildPunktStatus(int n) {
        switch (n) {
            case -1: {
                return PunktStatus.getDefaultPaStatus(this.getKafPa());
            }
            case -3: {
                if ((this.aktParam.getKafLg() == 0 || this.aktParam.getKafLg() == 99) && this.getLSP() >= 0.0f) {
                    return PunktStatus.getDefaultLspStatus(this.getLSP());
                }
                return PunktStatus.getDefaultLgStatus(this.aktParam.getKafLg());
            }
        }
        return n;
    }

    public void set2dKoordinaten(double d, double d2) {
        this.y = d;
        this.x = d2;
    }

    public boolean hasLocation() {
        return this.y != 0.0 && this.x != 0.0;
    }

    public void getParameter(Punkt punkt) {
        this.initParameter(punkt.getParameter());
    }

    public void updateParameter(Punkt punkt, int n) {
        boolean bl = false;
        switch (n) {
            case 101: {
                this.nr = punkt.nr;
                break;
            }
            case 102: {
                this.umnum = punkt.umnum;
                break;
            }
            case 200: {
                this.ps = punkt.ps;
                break;
            }
            case 301: {
                if (punkt.y == 0.0) break;
                this.y = punkt.y;
                break;
            }
            case 302: {
                if (punkt.x == 0.0) break;
                this.x = punkt.x;
                break;
            }
            case 303: {
                if (punkt.h == 0.0f) break;
                this.h = punkt.h;
                break;
            }
            case 351: {
                this.dy = punkt.dy;
                break;
            }
            case 352: {
                this.dx = punkt.dx;
                break;
            }
            case 401: {
                this.a = punkt.a;
                break;
            }
            case 402: {
                this.b = punkt.b;
                break;
            }
            case 403: {
                this.t = punkt.t;
                break;
            }
            case 411: {
                if (punkt.lsp == 0.0f) break;
                this.lsp = punkt.lsp;
                break;
            }
            case 412: {
                if (punkt.hsp == 0.0f) break;
                this.hsp = punkt.hsp;
                break;
            }
            case 413: {
                if (punkt.lhsp == 0.0f) break;
                this.lhsp = punkt.lhsp;
                break;
            }
            case 451: {
                this.sw = punkt.sw;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            PunktParameter punktParameter = punkt.getParameter();
            PunktParameter punktParameter2 = this.getParameter();
            switch (n) {
                case 201: {
                    punktParameter2.setPa(punktParameter.getPa());
                    break;
                }
                case 202: {
                    punktParameter2.setEb(punktParameter.getEb());
                    break;
                }
                case 203: {
                    punktParameter2.setVa(punktParameter.getVa());
                    break;
                }
                case 204: {
                    punktParameter2.setLs(punktParameter.getLs());
                    break;
                }
                case 205: {
                    punktParameter2.setLg(punktParameter.getLg());
                    break;
                }
                case 206: {
                    punktParameter2.setLz(punktParameter.getLz());
                    break;
                }
                case 207: {
                    punktParameter2.setHs(punktParameter.getHs());
                    break;
                }
                case 208: {
                    punktParameter2.setHg(punktParameter.getHg());
                    break;
                }
                case 220: {
                    punktParameter2.setVva(punktParameter.getVva());
                    break;
                }
                case 221: {
                    punktParameter2.setVvt(punktParameter.getVvt());
                }
            }
            this.initParameter(punktParameter2);
        }
    }

    public void addParameter(Punkt punkt, int n) {
        boolean bl = false;
        switch (n) {
            case 101: {
                if (this.nr >= 0L) break;
                this.nr = punkt.nr;
                break;
            }
            case 102: {
                if (this.umnum >= 0L) break;
                this.umnum = punkt.umnum;
                break;
            }
            case 200: {
                if (this.ps > 0) break;
                this.ps = punkt.ps;
                break;
            }
            case 301: {
                if (this.y != 0.0) break;
                this.y = punkt.y;
                break;
            }
            case 302: {
                if (this.x != 0.0) break;
                this.x = punkt.x;
                break;
            }
            case 303: {
                if (this.h != 0.0f) break;
                this.h = punkt.h;
                break;
            }
            case 351: {
                if (this.dy != 0.0f) break;
                this.dy = punkt.dy;
                break;
            }
            case 352: {
                if (this.dx != 0.0f) break;
                this.dx = punkt.dx;
                break;
            }
            case 401: {
                if (this.a != 0) break;
                this.a = punkt.a;
                break;
            }
            case 402: {
                if (this.b != 0) break;
                this.b = punkt.b;
                break;
            }
            case 403: {
                if (this.t != 0) break;
                this.t = punkt.t;
                break;
            }
            case 411: {
                if (this.lsp != 0.0f) break;
                this.lsp = punkt.lsp;
                break;
            }
            case 412: {
                if (this.hsp != 0.0f) break;
                this.hsp = punkt.hsp;
                break;
            }
            case 413: {
                if (this.lhsp != 0.0f) break;
                this.lhsp = punkt.lhsp;
                break;
            }
            case 451: {
                if (this.sw != 0) break;
                this.sw = punkt.sw;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            PunktParameter punktParameter = punkt.getParameter();
            PunktParameter punktParameter2 = this.getParameter();
            switch (n) {
                case 201: {
                    if (punktParameter2.getKafPa() > -1) break;
                    punktParameter2.setPa(punktParameter.getPa());
                    break;
                }
                case 202: {
                    if (punktParameter2.getKafEb() > 0) break;
                    punktParameter2.setEb(punktParameter.getEb());
                    break;
                }
                case 203: {
                    if (punktParameter2.getKafVa() > 0) break;
                    punktParameter2.setVa(punktParameter.getVa());
                    break;
                }
                case 204: {
                    if (punktParameter2.getKafLs() > 0) break;
                    punktParameter2.setLs(punktParameter.getLs());
                    break;
                }
                case 205: {
                    if (punktParameter2.getKafLg() != 0) break;
                    punktParameter2.setLg(punktParameter.getLg());
                    break;
                }
                case 206: {
                    if (punktParameter2.getKafLz() > 0) break;
                    punktParameter2.setLz(punktParameter.getLz());
                    break;
                }
                case 207: {
                    if (punktParameter2.getKafHs() > 0) break;
                    punktParameter2.setHs(punktParameter.getHs());
                    break;
                }
                case 208: {
                    if (punktParameter2.getKafHg() != 0) break;
                    punktParameter2.setHg(punktParameter.getHg());
                    break;
                }
                case 220: {
                    if (punktParameter2.getKafVva() > 0) break;
                    punktParameter2.setVva(punktParameter.getVva());
                    break;
                }
                case 221: {
                    if (punktParameter2.getKafVvt() != 0) break;
                    punktParameter2.setVvt(punktParameter.getVvt());
                }
            }
            this.initParameter(punktParameter2);
        }
    }

    public void getValues(Punkt punkt) {
        this.initParameter(punkt.getParameter());
        this.nr = punkt.nr;
        this.ps = punkt.ps;
        this.y = punkt.y;
        this.x = punkt.x;
        this.h = punkt.h;
        this.dy = punkt.dy;
        this.dx = punkt.dx;
        this.a = punkt.a;
        this.b = punkt.b;
        this.t = punkt.t;
        this.flags = punkt.flags;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof Punkt) {
            return ((Punkt)object).nr == this.nr;
        }
        return false;
    }

    public void setUmnumFlag(int n) {
        this.umnumFlags |= n;
    }

    public boolean isUmnumFlag(int n) {
        return (this.umnumFlags & n) != 0;
    }

    public void setStandPunkt(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isStandPunkt() {
        return (this.flags & 2) != 0;
    }

    public void setStandHoehe(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public boolean isStandHoehe() {
        return (this.flags & 0x200) != 0;
    }

    public void setReferenzPunkt(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isReferenzPunkt() {
        return (this.flags & 4) != 0;
    }

    public void setGpsPunkt(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isGpsPunkt() {
        return (this.flags & 0x400) != 0;
    }

    public void setEigenePunkt(boolean bl) {
        this.flags = bl ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    public boolean isEigenePunkt() {
        return (this.flags & 0x800) != 0;
    }

    public void setPolarPunkt(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    public boolean isPolarPunkt() {
        return (this.flags & 0x1000) != 0;
    }

    public void setNachweisPunkt(boolean bl) {
        this.flags = bl ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
    }

    public boolean isNachweisPunkt() {
        return (this.flags & 0x2000) != 0;
    }

    public void setInLinie(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isInLinie() {
        return (this.flags & 8) != 0;
    }

    public void setTrafo(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10000000) : (this.flags &= 0xEFFFFFFF);
    }

    public boolean isTrafo() {
        return (this.flags & 0x10000000) != 0;
    }

    public void setTrafoPP(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isTrafoPP() {
        return (this.flags & 0x10) != 0;
    }

    public void setDigitPP(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public boolean isDigitPP() {
        return (this.flags & 0x20) != 0;
    }

    public void setKooDiff(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public boolean isKooDiff() {
        return (this.flags & 0x40) != 0;
    }

    public void setMasterPoint(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000000) : (this.flags &= 0xFEFFFFFF);
    }

    public boolean isMasterPoint() {
        return (this.flags & 0x1000000) != 0;
    }

    public void setSlavePoint(boolean bl) {
        this.flags = bl ? (this.flags |= 0x2000000) : (this.flags &= 0xFDFFFFFF);
    }

    public boolean isSlavePoint() {
        return (this.flags & 0x2000000) != 0;
    }

    public void setIndirektPoint(boolean bl) {
        this.flags = bl ? (this.flags |= 0x4000000) : (this.flags &= 0xFBFFFFFF);
    }

    public boolean isIndirektPoint() {
        return (this.flags & 0x4000000) != 0;
    }

    public void setZeigtAufPoint(boolean bl) {
        this.flags = bl ? (this.flags |= 0x8000000) : (this.flags &= 0xF7FFFFFF);
    }

    public boolean isZeigtAufPoint() {
        return (this.flags & 0x8000000) != 0;
    }

    public void setErrHoldKoo(boolean bl) {
        this.flags = bl ? (this.flags |= 0x800000) : (this.flags &= 0xFF7FFFFF);
    }

    public boolean isErrHoldKoo() {
        return (this.flags & 0x800000) != 0;
    }

    public void setOn(boolean bl) {
        this.flags = bl ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    @Override
    public boolean isOn() {
        return (this.flags & 0x80) != 0;
    }

    public void setFortfuehrung(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public boolean isFortfuehrung() {
        return (this.flags & 0x100) != 0;
    }

    public void setFlagUM_PNR(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    public boolean isFlagUM_PNR() {
        return (this.flags & 0x100000) != 0;
    }

    public void setSwitchNBZ(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    public boolean isSwitchNBZ() {
        return (this.flags & 0x200000) != 0;
    }

    public void setUsedLine(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20000000) : (this.flags &= 0xDFFFFFFF);
    }

    public boolean isUsedLine() {
        return (this.flags & 0x20000000) != 0;
    }

    public void setUsed(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40000000) : (this.flags &= 0xBFFFFFFF);
    }

    public boolean isUsed() {
        return (this.flags & 0x40000000) != 0;
    }

    public void setTempFlag1(boolean bl) {
        this.flags = bl ? (this.flags |= Integer.MIN_VALUE) : (this.flags &= Integer.MAX_VALUE);
    }

    public boolean isTempFlag1() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public boolean isKontrolliert() {
        return this.lsp != 0.0f;
    }

    public boolean isLageFestgelegt() {
        PunktParameter punktParameter = this.getParameter();
        if (punktParameter.getKafVa() <= 0) {
            return false;
        }
        switch (punktParameter.getKafVa()) {
            case 0: {
                return false;
            }
            case 10: 
            case 19: 
            case 99: {
                break;
            }
            default: {
                return true;
            }
        }
        switch (punktParameter.getKafVva()) {
            case 0: 
            case 10: 
            case 94: 
            case 99: {
                return false;
            }
        }
        return true;
    }

    public boolean isNeuVermarkt() {
        return this.aktParam.getEb() == 48 || this.isVermarkungGeaendert();
    }

    public boolean isVermarkungGeaendert() {
        return this.getKafVva() > 0 && this.getKafVva() != 19 && this.getKafVa() != 10;
    }

    public boolean isVermarkungVorgefunden() {
        if (this.aktParam.getKafVva() == 10 || this.aktParam.getKafVva() == 19 || this.aktParam.getKafVva() == 99) {
            return false;
        }
        return this.aktParam.getKafVa() != 10 && this.aktParam.getKafVa() != 19 && this.aktParam.getKafVa() != 99 || this.aktParam.getModVa() == this.oldParam.getModVa();
    }

    public boolean isTiefVermarkt() {
        return this.aktParam.getKafVvt() < 0 && (!this.isVermarkungGeaendert() || VermarkungsArt.isUnvermarkt(this.aktParam.getKafVva()));
    }

    public boolean isGezogen() {
        return this.aktParam.getKafVva() == 2 && this.aktParam.getKafVa() == 10;
    }

    public boolean isKatasterPunkt() {
        return this.getKafPa() > 0;
    }

    public boolean isLokalPunkt() {
        return this.getKafPa() == -1;
    }

    private boolean isRissPunkt() {
        return this.getKafPa() != -1 || (this.isStandPunkt() || this.isReferenzPunkt()) && KafPlotProperties.isAufnahmeVisible();
    }

    @Override
    public boolean isVisible() {
        if (KafPlotProperties.getColorSwitch() == 1004) {
            return !(!KafPlotProperties.isUnusedPunktVisible() && !this.isFortfuehrung() || !KafPlotProperties.isAllPointsVisible && !this.isRissPunkt() || !KafPlotProperties.isPointWithOutLinesVisible && !this.isUsedLine() || KafPlotProperties.isPunktFilterEnabled() && !KafPlotProperties.getPunktFilter().isPunktEnabled(this));
        }
        return !(!KafPlotProperties.isUnusedPunktVisible() && !this.isOn() || !KafPlotProperties.isAllPointsVisible && !this.isRissPunkt() || !KafPlotProperties.isPointWithOutLinesVisible && !this.isUsedLine() || KafPlotProperties.isPunktFilterEnabled() && !KafPlotProperties.getPunktFilter().isPunktEnabled(this));
    }

    public boolean isKatasterNeupunkt() {
        if (!this.isKatasterPunkt()) {
            return false;
        }
        if (this.getInternalPs() == 0) {
            return this.oldParam.getKafPa() < 0;
        }
        return true;
    }

    public boolean isKatasterNeupunktBestand() {
        if (this.isKatasterNeupunkt()) {
            return this.oldParam.getKafPa() > 0;
        }
        return false;
    }

    public boolean isKatasterNeuFestgestellt() {
        return this.aktParam.getEb() == 41;
    }

    public boolean isLagefestpunkt() {
        return this.aktParam.getKafPa() == 8 || this.aktParam.getKafPa() == 7 || this.aktParam.getEb() == 19 || this.aktParam.getEb() == 59;
    }

    public boolean isKatNummer() {
        return this.nr >= 10000L && this.nr < 100000L;
    }

    @Override
    public boolean isKatasterElement() {
        return this.aktParam.isKatasterElement();
    }

    public boolean isKatasterExportElement() {
        return this.isKatasterElement() && this.getPa() != 96 && this.getPa() != 95;
    }

    @Override
    public boolean isKatasterNeuElement() {
        if (!this.isKatasterElement()) {
            return false;
        }
        if (this.getInternalPs() == 0) {
            return this.oldParam.getKafPa() < 0;
        }
        return true;
    }

    public boolean isKatasterAenderungElement() {
        if (this.isKatasterNachweisElement() && this.oldParam.getKafPa() > 0) {
            if (this.isOn() && this.ps != 1 && this.ps != 2) {
                return true;
            }
            return this.aktParam.getPst() == 12 || this.aktParam.getPst() == 13;
        }
        return false;
    }

    @Override
    public boolean isKatasterNachweisElement() {
        if (!this.isKatasterPunkt()) {
            return false;
        }
        switch (this.getInternalPs()) {
            case 0: {
                return this.oldParam.getKafPa() > 0 && this.aktParam.getKafPa() > 0;
            }
            case -2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DatObject createKatasterElement() {
        Punkt punkt = (Punkt)this.clone();
        if (this.getModel() == 1) {
            switch (punkt.aktParam.getEb()) {
                case 41: 
                case 48: {
                    PunktParameterALK punktParameterALK = (PunktParameterALK)punkt.getParameter();
                    punktParameterALK.setEb(1);
                    punkt.initParameter(punktParameterALK);
                    break;
                }
                case 42: {
                    PunktParameterALK punktParameterALK = (PunktParameterALK)punkt.getParameter();
                    punktParameterALK.setEb(2);
                    punkt.initParameter(punktParameterALK);
                    break;
                }
            }
        }
        return punkt;
    }

    @Override
    public Message getMessage() {
        String string = this.getExceptionableName();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.aktParam.getKafPa() != -1 || this.aktParam.getEb() != 0 || this.aktParam.getKafVa() != 0) {
            stringBuffer.append("  A=");
            if (this.aktParam.getKafPa() != -1) {
                stringBuffer.append(this.aktParam.getOutPa());
            } else {
                stringBuffer.append("  ");
            }
            stringBuffer.append("  Eb=");
            if (this.aktParam.getEb() != 0) {
                stringBuffer.append(IFormat.i.format(this.aktParam.getEb()).toString());
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("  Va=");
            if (this.aktParam.getKafVa() != 0) {
                stringBuffer.append(this.aktParam.getOutVa());
            } else {
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("  [");
        stringBuffer.append(IFormat.f_3.format(this.y).toString());
        stringBuffer.append(", ");
        stringBuffer.append(IFormat.f_3.format(this.x).toString());
        stringBuffer.append("]");
        Object object = "";
        int n = KafPlotProperties.getColorPunktSwitch();
        if (n == 2102 && this.aktParam.getKafLg() != 0) {
            object = (String)object + "LGA=" + this.aktParam.getOutLg();
        } else if (n == 2103 && this.aktParam.getKafLz() != 0) {
            object = (String)object + "LZK=" + this.aktParam.getOutLz();
        } else if (n == 2104 && this.aktParam.getKafEa() != 0) {
            object = (String)object + "EA=" + this.aktParam.getOutEa();
        } else if (n == 2105 && this.aktParam.getKafEq() != 0) {
            object = (String)object + "EQ=" + this.aktParam.getOutEq();
        } else if (n == 2106 && this.aktParam.getPst() != -1) {
            object = (String)object + "PST=" + this.aktParam.getOutPst();
        }
        n = KafPlotProperties.getFehlerSwitch();
        if (n == 701) {
            object = (String)object + (KafPlotProperties.isEllipseAreaVisible ? " SP=" + IFormat.f_3.format(this.getSP()) : " a=" + IFormat.f_3.format((double)this.a * 0.001) + " b=" + IFormat.f_3.format((double)this.b * 0.001));
        } else if (n == 702) {
            object = (String)object + (KafPlotProperties.isEllipseAreaVisible ? " DS=" + IFormat.f_3.format(this.getDS()) : " dy=" + IFormat.f_3.format(this.dy) + " dx=" + IFormat.f_3.format(this.dx));
        } else if (n == 704) {
            object = (String)object + " AG=" + IFormat.f_3.format(this.ag);
        } else if (n == 705) {
            object = (String)object + " AZ=" + IFormat.f_3.format(this.az);
        } else if (n == 703) {
            object = (String)object + " ZL=" + IFormat.f_3.format(this.zl);
        } else if (n == 706) {
            object = (String)object + " DH=" + IFormat.f_3.format(this.dh);
        }
        return new Message(this, string, stringBuffer.toString() + "   " + (String)object);
    }

    @Override
    public final String getClassName() {
        if (this.ps == 1) {
            return "Festpunkt";
        }
        if (this.ps == 2) {
            return "Anschlusspunkt";
        }
        if (this.ps == 0) {
            return "N\u00e4herungspunkt";
        }
        if (this.ps == 3) {
            return "H\u00f6henpunkt";
        }
        if (this.ps == 5) {
            return "Ung\u00fcltiger Punkt";
        }
        if (this.ps == -2) {
            return "Neupunkt";
        }
        return "Punkt";
    }

    @Override
    public final String getObjectName() {
        return Long.toString(this.nr);
    }

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public final String toDebugString() {
        return this.getExceptionableName();
    }

    public DPoint getOriginal() {
        if (this.ps == 0 || this.ps == 5) {
            return new DPoint(this.y - (double)this.dy, this.x - (double)this.dx);
        }
        return this;
    }

    public boolean isMoved() {
        if (!(this.ps != 1 && this.ps != 2 || this.isKooDiff())) {
            return false;
        }
        return this.getDS() > 3.0E-4f;
    }

    public DPoint getDisplayOriginal() {
        if (this.ps == 0 || this.ps == 5) {
            return new DPoint(this.y - (double)this.dy, this.x - (double)this.dx);
        }
        if (this.isKooDiff() && (this.ps == 1 || this.ps == 2)) {
            return new DPoint(this.y - (double)this.dy, this.x - (double)this.dx);
        }
        return this;
    }

    public DPoint getMoved() {
        return new DPoint(this.y - (double)this.dy, this.x - (double)this.dx);
    }

    public String createKatasterPunktString() {
        int n = this.getKafPa();
        if (n < 0) {
            return "";
        }
        if (n == 0) {
            return PunktArt.toString(this.getParameter().getModPa());
        }
        int n2 = this.getInternalPs();
        if (n2 == 0) {
            return "Altpunkt";
        }
        if (n2 == 2) {
            return this.isKatasterNeupunktBestand() ? "Altpunkt" : "Neupunkt";
        }
        if (n2 == 1) {
            return "SAP-Punkt";
        }
        return "";
    }

    public String createKoordinateString() {
        return this.createKoordinateString(true);
    }

    public String createKoordinateString(boolean bl) {
        if (this.isKatasterPunkt()) {
            if (this.getInternalPs() == 2) {
                if (this.isKatasterNeupunktBestand()) {
                    if (this.ps == 1 || this.ps == 2) {
                        return KatasternachweisIOProperties.writeRissKontrolle() ? "KOO gepr\u00fcft" : "";
                    }
                    return bl ? "KOO bestimmt" : "KOO";
                }
                return bl ? "KOO bestimmt" : "";
            }
            if (this.isOn()) {
                switch (this.getPs()) {
                    case 1: 
                    case 2: {
                        return bl && KatasternachweisIOProperties.writeRissKontrolle() ? "KOO gepr\u00fcft" : "";
                    }
                }
                if (this.isErrHoldKoo()) {
                    return bl && KatasternachweisIOProperties.writeRissKontrolle() ? "KOO gepr\u00fcft" : "";
                }
                if (this.oldParam.getEq() != 1000) {
                    return bl ? "KOO bestimmt" : "KOO";
                }
                return bl ? "KOO ge\u00e4ndert" : "KOO";
            }
            return bl ? "KOO ungepr\u00fcft" : "";
        }
        return "";
    }

    public String createKoordinateZusatzString() {
        if (this.isInLinie()) {
            return "eingerechnet (" + IFormat.f_3.format(this.dl) + ")";
        }
        return "";
    }

    public String createBestimmungString() {
        if (this.isGpsPunkt() && this.isPolarPunkt()) {
            return KatasternachweisIOProperties.writeRissKombiMess() ? "kombiniert" : KatasternachweisIOProperties.getGpsName() + ", polar";
        }
        if (this.isGpsPunkt()) {
            return KatasternachweisIOProperties.getGpsName();
        }
        if (this.isPolarPunkt()) {
            return "polar";
        }
        if (this.isEigenePunkt()) {
            return "Bandma\u00df";
        }
        if (this.isNachweisPunkt()) {
            return "berechnet";
        }
        if (DataBase.isSchnittPunkt(this)) {
            return "Schnittpunkt";
        }
        if (DataBase.isHomogenisierungPunkt(this)) {
            return "homogenisiert";
        }
        if (DataBase.isTrafoPunkt(this)) {
            return "transformiert";
        }
        if (DataBase.isDigitPunkt(this)) {
            return "digitalisiert";
        }
        return "";
    }

    public String createAttStatusString() {
        if (this.getInternalPs() != 0 || this.aktParam.getPst() == 13) {
            return "";
        }
        switch (this.getPs()) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            default: {
                return "";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        PunktParameter punktParameter = this.getOldParameter();
        PunktParameter punktParameter2 = this.getParameter();
        if (!punktParameter.getOutPa().equals(punktParameter2.getOutPa())) {
            stringBuffer.append("PAT");
        }
        if (punktParameter.getModVa() != punktParameter2.getModVa()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (punktParameter.getModPa() == 10 || punktParameter.getModPa() == 11 || punktParameter.getModPa() == 60) {
                stringBuffer.append("VMA");
            } else {
                stringBuffer.append("ABM");
            }
        }
        if (!punktParameter.getOutVb().equals(punktParameter2.getOutVb())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("BZA");
        }
        if (!punktParameter.getOutLg().equals(punktParameter2.getOutLg())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GST");
        }
        if (!punktParameter.getOutLl().equals(punktParameter2.getOutLl())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GWT");
        }
        if (!punktParameter.getOutLz().equals(punktParameter2.getOutLz())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("LZK");
        }
        if (!punktParameter.getOutArt().equals(punktParameter2.getOutArt())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ART");
        }
        if (!punktParameter.getOutEq().equals(punktParameter2.getOutEq())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("DES");
            if (punktParameter2.getKafEq() != 1000) {
                stringBuffer.append("=" + punktParameter2.getOutEq());
            }
        }
        if (!punktParameter.getOutLs().equals(punktParameter2.getOutLs())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("KST");
        }
        return stringBuffer.toString();
    }

    public IInscription getVermarkungsInscription(IInscription iInscription) {
        IInscriptionComponent iInscriptionComponent;
        int n = 0;
        if (iInscription == null) {
            iInscription = new IInscription(new Point());
        }
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(this.aktParam.getVva());
        String string = VermarkungsArt.getVermarkungsArt(this.aktParam.getVa()).getKuerzel();
        String string2 = !vermarkungsArt.isUnvermarkt() ? vermarkungsArt.getKuerzel() : null;
        int n2 = this.aktParam.getKafVva();
        if (n2 == 19) {
            string = vermarkungsArt.getKuerzel();
            string2 = null;
        } else if (n2 == 99) {
            string2 = string;
            string = vermarkungsArt.getKuerzel();
        }
        if (string != null) {
            if (this.aktParam.getKafVvt() == 0 || string2 != null) {
                iInscriptionComponent = new IInscriptionComponent(string, 0, n++);
                iInscription.add(iInscriptionComponent);
            } else {
                iInscriptionComponent = new IInscriptionComponent((this.aktParam.getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(this.aktParam.getKafVvt()) / 10.0).toString() : string) + "\t" + (this.aktParam.getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(this.aktParam.getKafVvt()) / 10.0).toString() : string), 0, n++);
                iInscription.add(iInscriptionComponent);
            }
            iInscriptionComponent.setFont(KafPlotProperties.getVaFont());
            iInscriptionComponent.setForeground(this.isNeuVermarkt() ? KafPlotColor.GP_NEU : KafPlotColor.GP_VORHANDEN);
        }
        if (string2 != null) {
            if (this.aktParam.getKafVvt() == 0) {
                iInscriptionComponent = new IInscriptionComponent(string2, 0, n);
                iInscription.add(iInscriptionComponent);
            } else {
                iInscriptionComponent = new IInscriptionComponent((this.aktParam.getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(this.aktParam.getKafVvt()) / 10.0).toString() : string2) + "\t" + (this.aktParam.getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(this.aktParam.getKafVvt()) / 10.0).toString() : string2), 0, n);
                iInscription.add(iInscriptionComponent);
            }
            iInscriptionComponent.setFont(KafPlotProperties.getVaFont());
            iInscriptionComponent.setForeground(KafPlotColor.GP_VORHANDEN);
            iInscriptionComponent = new IInscriptionComponent("aufgef.", 1, n);
            iInscription.add(iInscriptionComponent);
            iInscriptionComponent.setFont(KafPlotProperties.getVaFont());
            iInscriptionComponent.setForeground(KafPlotColor.GP_VORHANDEN);
        }
        return iInscription;
    }

    @Override
    public String toString() {
        return new String(this.ps + " " + this.nr + " " + this.getUmnum() + " " + this.aktParam.getOutPa() + " " + this.aktParam.getOutVa() + " " + this.y + " " + this.x + " " + this.aktParam.getLs() + " " + this.aktParam.getOutLg());
    }

    public String toKplLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(IFormat.i14.format(this.nr));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        if (this.h != 0.0f) {
            stringBuffer.append(IFormat.f6_4.format(this.h));
        } else {
            stringBuffer.append("           ");
        }
        stringBuffer.append(" ");
        if (this.ps == 1) {
            stringBuffer.append(IFormat.f3_3.format(0.0));
        } else if (this.ps == 2) {
            stringBuffer.append(IFormat.f3_3.format(this.dy));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.ps == 1) {
            stringBuffer.append(IFormat.f3_3.format(0.0));
        } else if (this.ps == 2) {
            stringBuffer.append(IFormat.f3_3.format(this.dx));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.ps == 1) {
            stringBuffer.append(IFormat.f3_3.format(0.0));
        } else if (this.ps == 2) {
            stringBuffer.append(IFormat.f3_3.format(this.getDS()));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.ps == 1) {
            stringBuffer.append("       ");
        } else if (this.a != 0 || this.b != 0) {
            stringBuffer.append(IFormat.f3_3.format(this.getSP()));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.ps == 1) {
            stringBuffer.append("       ");
        } else if (this.a != 0 || this.b != 0) {
            stringBuffer.append(IFormat.f3_3.format(this.getLSP()));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.hsp != 0.0f) {
            stringBuffer.append(IFormat.f2_4.format(this.hsp));
        } else {
            stringBuffer.append("       ");
        }
        return stringBuffer.toString();
    }

    public String toKpdLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(IFormat.i14.format(this.nr));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        if (this.h != 0.0f) {
            stringBuffer.append(IFormat.f6_4.format(this.h));
        } else {
            stringBuffer.append("           ");
        }
        if (this.dy == 0.0f && this.dx == 0.0f && this.dh == 0.0f) {
            return stringBuffer.toString();
        }
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.y + (double)this.dy));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.x + (double)this.dx));
        stringBuffer.append(" ");
        if (this.dh != 0.0f) {
            stringBuffer.append(IFormat.f6_4.format(this.h + this.dh));
        } else {
            stringBuffer.append("           ");
        }
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f3_3.format(this.dy));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f3_3.format(this.dx));
        stringBuffer.append(" ");
        if (this.dh != 0.0f) {
            stringBuffer.append(IFormat.f3_4.format(this.dh));
        } else {
            stringBuffer.append("        ");
        }
        return stringBuffer.toString();
    }

    public String toHomLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.nr);
        stringBuffer.append(" ");
        double d = this.y;
        double d2 = this.x;
        PunktMove punktMove = (PunktMove)DataBase.PM.get(this.nr);
        if (punktMove != null) {
            d += (double)punktMove.getMoveY();
            d2 += (double)punktMove.getMoveX();
        } else if (this.getPs() == 0 || this.getPs() == 5) {
            d -= (double)this.dy;
            d2 -= (double)this.dx;
        }
        stringBuffer.append(IFormat.f7_3.format(d));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(d2));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    @Override
    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (KafkaIOProperties.datVersion >= 2) {
            stringBuffer.append(IFormat.i01.format(Math.max(this.getPs(), 0)));
            stringBuffer.append(this.getPs() == 5 && this.isErrHoldKoo() ? "2" : " ");
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.i14.format(this.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.getNr() : this.nr)));
            stringBuffer.append(" ");
            double d = this.y;
            double d2 = this.x;
            if (!KafkaIOProperties.isWPNK()) {
                switch (this.getPs()) {
                    case 0: {
                        d -= (double)this.dy;
                        d2 -= (double)this.dx;
                        break;
                    }
                    case 5: {
                        if (this.isErrHoldKoo()) break;
                        d -= (double)this.dy;
                        d2 -= (double)this.dx;
                    }
                }
            }
            stringBuffer.append(IFormat.f7_3.format(d));
            stringBuffer.append("  ");
            stringBuffer.append(IFormat.f7_3.format(d2));
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f2_3.format(this.g != 0.0f ? (double)this.g : (double)KafkaIOProperties.defaultPg));
            stringBuffer.append(KafkaIOProperties.writeHoehe && this.h != 0.0f ? IFormat.f5_4.format(this.h) : "          ");
            if (this.oldParam instanceof PunktParameterALKIS) {
                this.appendAlkisParameter(stringBuffer, (PunktParameterALKIS)this.getOldParameter(), false);
            } else if (this.oldParam instanceof PunktParameterALK) {
                PunktParameterALK punktParameterALK = (PunktParameterALK)this.getOldParameter();
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutPa());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutVa());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutLs());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutLg());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutHs());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutHg());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutEb());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutVvt());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutVva());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutLz());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutOska());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameterALK.getOutPst());
                if (this.hasOldBemerkung()) {
                    stringBuffer.append("  ");
                    stringBuffer.append(this.getOldBemerkung());
                }
            }
            if (this.hasOldBemerkung()) {
                IFormat.append(stringBuffer, 119, this.getOldBemerkung());
            }
        } else {
            stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(this.getPs(), 0)).toString());
            stringBuffer.append(" ");
            stringBuffer.append(GeoNumberFormat.nr13.format(this.getNr()).toString());
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
            stringBuffer.append(" ");
            stringBuffer.append(GeoNumberFormat.koo13.format(this.g != 0.0f ? (double)this.g : (double)0.025f).toString());
            stringBuffer.append("  ");
            stringBuffer.append(KafkaIOProperties.writeHoehe ? GeoNumberFormat.koo43.format(this.h).toString() : "        ");
            stringBuffer.append(" ");
            PunktParameter punktParameter = this.aktParam;
            if (punktParameter.getKafPa() != -1) {
                stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModPa(), 0)).toString());
                stringBuffer.append("  ");
                stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModVa(), 0)).toString());
                stringBuffer.append("  ");
                stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModLs(), 0)).toString());
                stringBuffer.append("  ");
                stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : " ");
                stringBuffer.append("  ");
                stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModHs(), 0)).toString());
                stringBuffer.append("  ");
                stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModHg(), 0)).toString());
                stringBuffer.append("  ");
                stringBuffer.append(GeoNumberFormat.nr02n.format(Math.max(punktParameter.getModEb(), 0)).toString());
                stringBuffer.append(" ");
                if (punktParameter.getKafVvt() != 0) {
                    stringBuffer.append(GeoNumberFormat.nr03n.format(punktParameter.getModVvt()).toString());
                } else {
                    stringBuffer.append("   ");
                }
                stringBuffer.append("  ");
                if (punktParameter.getKafVva() > 0) {
                    stringBuffer.append(GeoNumberFormat.nr03n.format(punktParameter.getModVva()).toString());
                } else {
                    stringBuffer.append("   ");
                }
                stringBuffer.append("  ");
                if (punktParameter.getLz() > 0) {
                    stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModLz(), 0)).toString());
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append("  ");
                if (punktParameter.getOska() > 0) {
                    stringBuffer.append(GeoNumberFormat.nr04n.format(Math.max(punktParameter.getModOska(), 0)).toString());
                } else {
                    stringBuffer.append("    ");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toDatLine(double d, boolean bl) {
        KafkaIOProperties.defaultPg = (float)d;
        KafkaIOProperties.writeHoehe = bl;
        return this.toDatLine();
    }

    public String toSystraLine() {
        return this.toSystraLine(this.getPs() == 1 || this.getPs() == 2, true);
    }

    public String toSystraLine(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(250);
        PunktParameter punktParameter = this.aktParam;
        if (this.aktParam instanceof PunktParameterALK) {
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.i14.format(this.buildKatNr(StaIOProperties.getPnrModus(), KafkaIOProperties.writeUmnum ? this.getNr() : this.nr)));
            stringBuffer.append("   ");
            stringBuffer.append(IFormat.f7_4.format(this.y));
            stringBuffer.append("   ");
            stringBuffer.append(IFormat.f7_4.format(this.x));
            stringBuffer.append("     ");
            stringBuffer.append(KafkaIOProperties.writeHoehe && this.h != 0.0f ? IFormat.f5_4.format(this.h) : "          ");
            stringBuffer.append(IFormat.f5_4.format(bl2 ? (double)this.g * 100.0 : 0.0));
            stringBuffer.append(IFormat.i2.format(bl ? 1L : 0L));
            stringBuffer.append(IFormat.getSpaces(31));
            stringBuffer.append("  ");
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.getLeftString(this.getRiss() != null ? this.getRiss() : "", 15));
            stringBuffer.append("                   ");
            stringBuffer.append("          ");
            stringBuffer.append(" ");
            stringBuffer.append(this.getKafPa() >= 0 ? IFormat.i4.format(punktParameter.getModPa()) : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(punktParameter.getKafVa() >= 0 ? IFormat.i3.format(punktParameter.getModVa()) : "   ");
            stringBuffer.append("  ");
            stringBuffer.append("    ");
            stringBuffer.append("     ");
            stringBuffer.append(IFormat.getLeftString(this.getBemerkungText() != null ? this.getBemerkungText() : "", 25));
            stringBuffer.append("     ");
            stringBuffer.append(IFormat.getLeftString(DataBase.getSourceName(), 25));
            stringBuffer.append("     ");
            stringBuffer.append(IFormat.i02.format(DataBase.projektDate.get(5)) + "." + IFormat.i02.format(DataBase.projektDate.get(2) + 1) + "." + IFormat.i04.format(DataBase.projektDate.get(1)));
        } else {
            stringBuffer.append(StaIOProperties.getPunktNummer(this));
            stringBuffer.append("   ");
            stringBuffer.append(KafkaIOProperties.meridianDecade);
            stringBuffer.append(IFormat.f7_3.format(this.y));
            stringBuffer.append("    ");
            stringBuffer.append(IFormat.f7_3.format(this.x));
            stringBuffer.append("     ");
            stringBuffer.append(IFormat.f5_4.format(KafkaIOProperties.writeHoehe && this.h != 0.0f ? (double)this.h : -1000.0));
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f5_3.format(bl2 ? (double)this.g * 100.0 : 0.0));
            stringBuffer.append(IFormat.i2.format(bl ? 1L : 0L));
            stringBuffer.append(IFormat.getSpaces(70));
            stringBuffer.append(IFormat.f4_3.format(0.0));
        }
        return stringBuffer.toString();
    }

    public String toXdesyLine() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("P ");
        stringBuffer.append(IFormat.i14.format(this.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.getNr() : this.nr)));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i02.format(this.ps <= 0 || this.ps == 5 ? 11L : 0L));
        stringBuffer.append(" ");
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        return stringBuffer.toString();
    }

    public String toPdkLine() {
        return this.toPdkLine(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum, IOProperties.isHoeheModus());
    }

    public String toPdkLine(int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(IFormat.i01.format(Math.max(this.getPs(), 0)));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.i14.format(this.buildKatNr(n, bl ? this.getNr() : this.nr)));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f2_3.format(this.g != 0.0f ? (double)this.g : (double)0.025f));
        stringBuffer.append(bl2 && this.h != 0.0f ? IFormat.f5_4.format(this.h) : "          ");
        if (this.getParameter() instanceof PunktParameterALKIS) {
            this.appendAlkisParameter(stringBuffer, (PunktParameterALKIS)this.getParameter(), false);
        } else {
            PunktParameter punktParameter = this.getParameter(1);
            if (punktParameter != PunktParameter.VOID) {
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutPa());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutVa());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutLs());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutLg());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutHs());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutHg());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutEb());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutVvt());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutVva());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutLz());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutOska());
                stringBuffer.append(" ");
                stringBuffer.append(punktParameter.getOutPst());
            }
        }
        if (this.bemerkung != null) {
            stringBuffer.append("         ");
            stringBuffer.append(this.getBemerkung());
        }
        return stringBuffer.toString();
    }

    public String toHtmTableRowLine(int n, boolean bl, boolean bl2) {
        PunktParameter punktParameter = this.getParameter(2);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(TRA);
        stringBuffer.append(TDA);
        stringBuffer.append(this.buildKatNr(n, bl ? this.getNr() : this.nr));
        stringBuffer.append(TDE);
        if (!bl2) {
            String string;
            stringBuffer.append(TDA);
            stringBuffer.append(IFormat.f_3k.format(this.y));
            stringBuffer.append(TDM);
            stringBuffer.append(IFormat.f_3k.format(this.x));
            stringBuffer.append(TDM);
            if (this.h != 0.0f) {
                stringBuffer.append(IFormat.f_3k.format(this.h));
            }
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutPa());
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutLg());
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutLz());
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutEa());
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutEq());
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutVa());
            stringBuffer.append(TDM);
            stringBuffer.append(punktParameter.getOutVb());
            stringBuffer.append(TDM);
            if (this.bemerkung != null && (string = this.getBemerkungText()) != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(TDE);
        }
        stringBuffer.append(TRE);
        return stringBuffer.toString();
    }

    public String toUmnumLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("8  ");
        stringBuffer.append(IFormat.i14.format(this.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.getNr() : this.nr)));
        stringBuffer.append(" ");
        if (!KafkaIOProperties.writeUmnum && this.umnum != 0L) {
            if (this.isFlagUM_PNR()) {
                stringBuffer.append(IFormat.i14.format(this.getNr()));
            } else {
                stringBuffer.append("             ");
                stringBuffer.append('#');
            }
        } else {
            stringBuffer.append("              ");
        }
        stringBuffer.append(" ");
        if (this.aktParam instanceof PunktParameterALKIS) {
            PunktParameter punktParameter = this.aktParam;
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(1) ? punktParameter.getOutPa() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(4096) ? punktParameter.getOutPst() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(16) ? punktParameter.getOutLg() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(32) ? punktParameter.getOutLl() : "      ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(64) ? punktParameter.getOutLz() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(32768) ? punktParameter.getOutEa() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(65536) ? punktParameter.getOutEq() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(131072) ? punktParameter.getOutArt() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(4) ? punktParameter.getOutVa() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(16384) ? punktParameter.getOutVb() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(1024) ? punktParameter.getOutVvt() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(512) ? punktParameter.getOutVva() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(8) ? punktParameter.getOutLs() : "    ");
        } else if (this.aktParam instanceof PunktParameterALK) {
            PunktParameterALK punktParameterALK = (PunktParameterALK)this.aktParam;
            PunktParameterALK punktParameterALK2 = this.oldParam instanceof PunktParameterALK ? (PunktParameterALK)this.oldParam : new PunktParameterALK();
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(1) ? punktParameterALK.getOutPa() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(4) ? punktParameterALK.getOutVa() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(8) ? punktParameterALK.getOutLs() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(16) ? punktParameterALK.getOutLg() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(128) ? punktParameterALK.getOutHs() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(256) ? punktParameterALK.getOutHg() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(2) ? punktParameterALK.getOutEb() : "  ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(1024) ? punktParameterALK.getOutVvt() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(512) ? punktParameterALK.getOutVva() : "   ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(64) ? punktParameterALK.getOutLz() : " ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(2048) ? punktParameterALK.getOutOska() : "    ");
            stringBuffer.append(" ");
            stringBuffer.append(KafkaIOProperties.writeFullParameter || this.isUmnumFlag(4096) ? punktParameterALK.getOutPst() : " ");
        }
        if (this.hasNewBemerkung()) {
            stringBuffer.append(IFormat.getSpaces(99 - stringBuffer.length()));
            stringBuffer.append(this.getNewBemerkung());
        }
        return stringBuffer.toString();
    }

    public String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        PunktParameter punktParameter = this.getParameter();
        stringBuffer.append(XmlIOProperties.openln("punkt"));
        stringBuffer.append(XmlIOProperties.dataln("nr", Long.toString(this.nr)));
        if (this.getUmnum() > 0L) {
            stringBuffer.append(XmlIOProperties.dataln("unr", Long.toString(this.getUmnum())));
        }
        if (this.isKatasterPunkt()) {
            stringBuffer.append(XmlIOProperties.dataln("knr", Long.toString(this.buildKatNr(14))));
        }
        if (this.getPs() >= 0) {
            stringBuffer.append(XmlIOProperties.dataln("ps", Integer.toString(this.getPs())));
        }
        if (punktParameter.getKafPa() > -1) {
            stringBuffer.append(XmlIOProperties.dataln("pa", punktParameter.getOutPa()));
        }
        if (punktParameter.getKafEb() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("eb", punktParameter.getOutEb()));
        }
        if (punktParameter.getKafVa() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("va", punktParameter.getOutVa()));
        }
        if (punktParameter.getKafOska() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("os", punktParameter.getOutOska()));
        }
        if (punktParameter.getKafLs() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("ls", punktParameter.getOutLs()));
        }
        if (punktParameter.getKafLg() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("lg", punktParameter.getOutLg()));
        }
        if (punktParameter.getKafLz() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("lz", punktParameter.getOutLz()));
        }
        if (punktParameter.getKafVva() > 0) {
            stringBuffer.append(XmlIOProperties.dataln("vva", punktParameter.getOutVva()));
        }
        if (punktParameter.getKafVvt() != 0) {
            stringBuffer.append(XmlIOProperties.dataln("vvt", punktParameter.getOutVvt()));
        }
        stringBuffer.append(XmlIOProperties.dataln("y", IFormat.f_3.format(this.y).toString()));
        stringBuffer.append(XmlIOProperties.dataln("x", IFormat.f_3.format(this.x).toString()));
        if (IOProperties.isHoeheModus() && (double)this.h != 0.0) {
            stringBuffer.append(XmlIOProperties.dataln("h", IFormat.f_3.format(this.h)));
        }
        if ((double)this.dx != 0.0 || (double)this.dy != 0.0) {
            stringBuffer.append(XmlIOProperties.dataln("dy", IFormat.f_3.format(this.dy).toString()));
            stringBuffer.append(XmlIOProperties.dataln("dx", IFormat.f_3.format(this.dx).toString()));
        }
        if ((double)this.dl != 0.0) {
            stringBuffer.append(XmlIOProperties.dataln("dl", IFormat.f_3.format(this.dl).toString()));
        }
        if ((double)this.lsp != 0.0) {
            stringBuffer.append(XmlIOProperties.dataln("lsp", IFormat.f_3.format(this.lsp).toString()));
        }
        if (this.a != 0 || this.b != 0 || this.t != 0) {
            stringBuffer.append(XmlIOProperties.dataln("ela", IFormat.i.format(this.a).toString()));
            stringBuffer.append(XmlIOProperties.dataln("elb", IFormat.i.format(this.b).toString()));
            stringBuffer.append(XmlIOProperties.dataln("elt", IFormat.f_1.format((double)this.t / 10.0).toString()));
        }
        stringBuffer.append(XmlIOProperties.close("punkt"));
        return stringBuffer.toString();
    }

    public String toDatDigitLine(double d, double d2) {
        return this.toDatDigitLine(d, d2, false);
    }

    public String toDatDigitLine(double d, double d2, boolean bl) {
        return this.toDatDigitLine(d, d2, bl ? 1 : 2, bl);
    }

    public String toDatDigitLine(double d, double d2, int n, boolean bl) {
        if (KafkaIOProperties.datVersion >= 2) {
            StringBuffer stringBuffer = new StringBuffer(70);
            stringBuffer.append(IFormat.i1.format(n));
            stringBuffer.append("  ");
            stringBuffer.append(IFormat.i14.format(this.nr));
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f7_3.format(this.y));
            stringBuffer.append("  ");
            stringBuffer.append(IFormat.f7_3.format(this.x));
            stringBuffer.append(" ");
            if (n != 2 || bl) {
                stringBuffer.append(IFormat.f3_3.format(d));
                stringBuffer.append(" ");
                stringBuffer.append(IFormat.f3_3.format(d2));
                stringBuffer.append(" ");
            }
            if (this.hasBemerkung()) {
                stringBuffer.append(IFormat.getSpaces(100 - stringBuffer.length()));
                stringBuffer.append(this.getBemerkungText());
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(55);
        stringBuffer.append(GeoNumberFormat.nr01n.format(n).toString() + " " + GeoNumberFormat.nr13.format(this.nr).toString() + "  " + GeoNumberFormat.koo73.format(this.y).toString() + "  " + GeoNumberFormat.koo73.format(this.x).toString());
        if (n != 2) {
            stringBuffer.append(" " + GeoNumberFormat.koo03.format(d).toString() + "  " + GeoNumberFormat.koo03.format(d2).toString());
        }
        return stringBuffer.toString();
    }

    public String toGeografLine() {
        String string = GeografProperties.getArt(this);
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        String string2 = GeografProperties.getPunktNummer(this);
        stringBuffer.append(IFormat.getRightString(string2, 15));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.getRightString(string, 14));
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        if (IOProperties.isHoeheModus() && this.h != 0.0f) {
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.koo43.format(this.h).toString());
        }
        return stringBuffer.toString();
    }

    public String toGeografLine(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(80);
        String string = GeografProperties.getPunktNummer(this);
        stringBuffer.append(GeoNumberFormat.getSpaces(Math.max(15 - string.length(), 0)));
        stringBuffer.append(string);
        stringBuffer.append("  ");
        if (n >= 0) {
            stringBuffer.append(GeoNumberFormat.nr04.format(n).toString());
        } else {
            stringBuffer.append("    ");
        }
        stringBuffer.append(GeoNumberFormat.nr04n.format(n2).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        if (IOProperties.isHoeheModus() && this.h != 0.0f) {
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.koo43.format(this.h).toString());
        }
        return stringBuffer.toString();
    }

    public String toGeografOutLine(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("PK" + n + ": ");
        stringBuffer.append(GeografProperties.getPunktNummer(this));
        stringBuffer.append(",");
        stringBuffer.append(new Integer(n2));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.y));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.x));
        stringBuffer.append(",");
        if (IOProperties.isHoeheModus() && this.h != 0.0f) {
            stringBuffer.append(IFormat.f_3.format(this.h));
        }
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.getSymbolWinkel() * 63.66197723675813));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.i.format(3L));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.i.format(IOProperties.isHoeheModus() && this.h != 0.0f ? 3L : 0L));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(0.0));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(0.0));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(0.0));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.i.format(0L));
        stringBuffer.append(",");
        stringBuffer.append(",");
        stringBuffer.append("0,0,0,0,0,0,0.0,0,0");
        return stringBuffer.toString();
    }

    public String toQuickLine() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.nr);
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y));
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x));
        return stringBuffer.toString();
    }

    public String toULO8ALK(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(150);
        PunktParameter punktParameter = this.getParameter(1);
        stringBuffer.append("EDBS01450000FEIN");
        stringBuffer.append(IFormat.i06.format(n));
        stringBuffer.append("  0000ULO8ALK 00010001");
        stringBuffer.append(IFormat.i08.format(this.getNb8Alk()));
        stringBuffer.append(IFormat.i06.format((long)(this.y * 1000.0)));
        stringBuffer.append(IFormat.i06.format((long)(this.x * 1000.0)));
        stringBuffer.append(" 000000010001");
        stringBuffer.append(IFormat.i03.format(PunktArt.getStandardFolie(punktParameter.getPa())));
        stringBuffer.append(IFormat.i04.format(Math.max(0, punktParameter.getOska())));
        stringBuffer.append("  P   ");
        stringBuffer.append(Punkt.createObjectName(4, n));
        stringBuffer.append(IFormat.i06.format(n2));
        stringBuffer.append("00010001");
        stringBuffer.append("1513  ");
        stringBuffer.append(IFormat.i04.format(Math.max(0, punktParameter.getOska())));
        long l = this.getNr(IOProperties.isUmnum());
        if (this.getKafPa() >= 0) {
            l = this.buildKatNr(94, l);
        }
        stringBuffer.append(IFormat.getLeftString("  " + l, 33));
        stringBuffer.append("  ");
        stringBuffer.append("0000");
        return stringBuffer.toString();
    }

    static String createObjectName(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n3 = n2 % 36;
            if (n3 <= 9) {
                stringBuffer.insert(0, (char)(48 + n3));
            } else {
                stringBuffer.insert(0, (char)(55 + n3));
            }
            n2 /= 36;
        }
        return stringBuffer.toString();
    }

    public String toAlkisPunktLine() {
        return this.toAlkisPunktLine(false, false, null);
    }

    public String toAlkisPunktLine(boolean bl, boolean bl2, String string) {
        PunktParameter punktParameter = this.getParameter();
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        if (bl2) {
            stringBuffer.append("*");
        } else {
            n = bl ? PunktStatus.getDefaultStatus(punktParameter) : this.getPs();
            if ((n = Math.max(n, 0)) == 5) {
                n = 0;
            }
            stringBuffer.append(IFormat.i01.format(n));
        }
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i15.format(this.nr));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.getRightString(this.buildAlkisNr(true), 15));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f8_3.format(AlkisIOProperties.getExportYAddition() + this.y));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f2_3.format(this.g != 0.0f ? (double)this.g : (double)KafkaIOProperties.defaultPg));
        stringBuffer.append(IOProperties.isHoeheModus() && this.h != 0.0f ? IFormat.f5_4.format(this.h) : "          ");
        if (this.getParameter() instanceof PunktParameterALKIS) {
            this.appendAlkisParameter(stringBuffer, (PunktParameterALKIS)this.getParameter(), true);
            if (string != null) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void appendAlkisParameter(StringBuffer stringBuffer, PunktParameterALKIS punktParameterALKIS, boolean bl) {
        if (bl && punktParameterALKIS.getKafPa() == 0) {
            stringBuffer.append(" BT  +");
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getKafLg() != 0 ? punktParameterALKIS.getOutLg() : "2100");
            stringBuffer.append(IFormat.getSpaces(8));
            stringBuffer.append(punktParameterALKIS.getKafLz() != 0 ? punktParameterALKIS.getOutLz() : "2");
            stringBuffer.append(IFormat.getSpaces(31));
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutPa());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutPst());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutLg());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutLl());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutLz());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutEa());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutEq());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutArt());
            stringBuffer.append(" ");
            stringBuffer.append(bl ? IFormat.i04.format(punktParameterALKIS.getModVa()) : punktParameterALKIS.getOutVa());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutVb());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutVvt());
            stringBuffer.append(" ");
            stringBuffer.append(punktParameterALKIS.getOutLs());
        }
    }

    public String toEdbsLine(int n, int n2, String string, int n3, boolean bl, int n4) {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(204);
        stringBuffer.append("EDBS01660000FEIN");
        stringBuffer.append(GeoNumberFormat.nr06n.format(n).toString());
        stringBuffer.append("  0000ULPUNN  00010001");
        stringBuffer.append(GeoNumberFormat.nr08n.format(this.getNb8Alk()).toString());
        stringBuffer.append(GeoNumberFormat.nr01n.format(this.getNumPa(punktParameter)).toString());
        stringBuffer.append(GeoNumberFormat.nr05n.format(this.getNr5()).toString());
        stringBuffer.append(" ");
        stringBuffer.append(punktParameter.getKafPst() > -1 ? IFormat.i1.format(punktParameter.getModPst()) : " ");
        stringBuffer.append(GeoNumberFormat.nr07n.format(n2).toString());
        stringBuffer.append("    ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(punktParameter.getModVa()).toString());
        if (bl && punktParameter.getOska() > 0) {
            stringBuffer.append(GeoNumberFormat.nr04n.format(punktParameter.getModOska()).toString());
        } else {
            stringBuffer.append("    ");
        }
        if (this.hasTag("edbs.ent")) {
            stringBuffer.append(EdbsIOProperties.toEdbsString(IFormat.getLeftString(Tag.parseTag(this.bemerkung, "edbs.ent").getValue(), 15)));
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append("               ");
        stringBuffer.append(" 00000001");
        stringBuffer.append(GeoNumberFormat.nr03n.format(punktParameter.getModLs()));
        stringBuffer.append(GeoNumberFormat.nr10n.format(this.y * 1000.0));
        stringBuffer.append(GeoNumberFormat.nr10n.format(this.x * 1000.0));
        if (n4 == 9) {
            stringBuffer.append('P');
            stringBuffer.append(IFormat.i8.format((int)Math.rint(this.getOutSP() * 1000.0f)));
        } else if (n4 == 0) {
            stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : " ");
            if (punktParameter.getKafLg() == 99) {
                stringBuffer.append(IFormat.i8.format((int)Math.rint(this.getOutSP() * 1000.0f)));
            } else {
                stringBuffer.append("        ");
            }
        } else {
            stringBuffer.append('P');
            if (this.ps == 1 || this.ps == 2) {
                stringBuffer.append(IFormat.i8.format((int)Math.rint(this.g * 1000.0f)).toString());
            } else {
                stringBuffer.append(IFormat.i8.format((int)Math.rint(this.lsp * 1000.0f)).toString());
            }
        }
        stringBuffer.append(GeoNumberFormat.nr01n.format(punktParameter.getModLz()).toString());
        stringBuffer.append(GeoNumberFormat.nr03n.format(n3).toString());
        stringBuffer.append("         ");
        if (IOProperties.isHoeheModus() && this.h != 0.0f) {
            stringBuffer.append("0001");
            stringBuffer.append(IFormat.i03.format(punktParameter.getModHs()));
            stringBuffer.append(IFormat.i8.format((int)Math.rint((double)this.h * 10000.0)));
            stringBuffer.append(IFormat.i03.format(n3));
            stringBuffer.append("00");
            if (punktParameter.getHg() != -1) {
                stringBuffer.append(IFormat.i01.format(punktParameter.getModHg()));
            } else {
                stringBuffer.append('H');
                stringBuffer.append(IFormat.i4.format((int)Math.rint(this.hsp * 1000.0f)));
            }
            stringBuffer.append("0");
            stringBuffer.append(IFormat.i03.format(n3));
            stringBuffer.append(IFormat.getLeftString(string, 9));
        } else {
            stringBuffer.append("0000");
        }
        stringBuffer.append("000000000000");
        return stringBuffer.toString();
    }

    public String toGsbLine() {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(GeoNumberFormat.nr04n.format(this.getNb4()).toString());
        stringBuffer.append(".");
        stringBuffer.append(GeoNumberFormat.nr05n.format(this.getNr5()).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModPa(), 0)));
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(punktParameter.getModVa()).toString());
        stringBuffer.append("          ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModLs(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : " ");
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        return stringBuffer.toString();
    }

    public String toPdbLine() {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(GeoNumberFormat.nr05n.format(this.getNr5()).toString());
        stringBuffer.append("       ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModPa(), 0)).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModVa(), 0)).toString());
        stringBuffer.append("          ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModLs(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : "0");
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        stringBuffer.append("   ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModHs(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModHg(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo43.format(this.h).toString());
        return stringBuffer.toString();
    }

    public String toTtpLine(boolean bl) {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(135);
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr09.format(this.getNr(bl) % 1000000000L).toString());
        stringBuffer.append(" , ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append(" , ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        stringBuffer.append(" , ");
        stringBuffer.append(IOProperties.isHoeheModus() && (double)this.h != 0.0 ? GeoNumberFormat.koo73.format(this.h).toString() : "           ");
        stringBuffer.append(" , ");
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr05.format(this.getNr(bl) / 1000000000L).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModLs(), 0)).toString());
        stringBuffer.append(" ");
        stringBuffer.append("    ");
        stringBuffer.append(" ");
        stringBuffer.append("          ");
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModLs(), 0)).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModVa(), 0)).toString());
        stringBuffer.append(" ");
        stringBuffer.append("  ");
        stringBuffer.append(" ");
        stringBuffer.append(this.getPs() >= 0 ? GeoNumberFormat.nr01n.format(punktParameter.getModPst()).toString() : " ");
        stringBuffer.append(" ");
        stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : " ");
        stringBuffer.append(" ");
        stringBuffer.append(punktParameter.getLz() > 0 ? GeoNumberFormat.nr01n.format(punktParameter.getModLz()).toString() : " ");
        stringBuffer.append(" ");
        stringBuffer.append("               ");
        stringBuffer.append(" ");
        stringBuffer.append("                  ");
        return stringBuffer.toString();
    }

    public String toSoftLine(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(75);
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.i14.format(this.getNr(bl)));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        stringBuffer.append(IOProperties.isHoeheModus() ? IFormat.f4_3.format(this.h) : "        ");
        stringBuffer.append("    ");
        stringBuffer.append(0);
        stringBuffer.append("         ");
        stringBuffer.append(0);
        return stringBuffer.toString();
    }

    public String toItrLine() {
        StringBuffer stringBuffer = new StringBuffer(75);
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.i13.format(this.getNr(IOProperties.isUmnum())));
        stringBuffer.append(".0 ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.f4_3.format(IOProperties.isHoeheModus() ? (double)this.h : 0.0));
        stringBuffer.append("                     ");
        return stringBuffer.toString();
    }

    public String toCaddyLine() {
        StringBuffer stringBuffer = new StringBuffer(90);
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i14.format(this.getNr(IOProperties.isUmnum())));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append("    ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append("   ");
        stringBuffer.append(IFormat.f4_3.format(IOProperties.isHoeheModus() ? (double)this.h : 0.0));
        stringBuffer.append(" ");
        stringBuffer.append(CaddyIOProperties.getCode(this.aktParam.getModVa()));
        stringBuffer.append(IFormat.getSpaces(86 - stringBuffer.length()));
        return stringBuffer.toString();
    }

    public String toAgaLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("5=");
        stringBuffer.append(this.getNr(IOProperties.isUmnum()));
        PunktParameter punktParameter = this.getParameter(1);
        if (AgaIOProperties.punktcode && punktParameter.getKafPa() >= 0 || punktParameter.getKafVa() >= 0) {
            stringBuffer.append("\n4=");
            if (punktParameter.getKafPa() >= 0) {
                stringBuffer.append(punktParameter.getModPa());
            }
            if (punktParameter.getKafVa() >= 0) {
                stringBuffer.append(IFormat.i03.format(punktParameter.getModVa()));
            }
        }
        stringBuffer.append("\n37=");
        stringBuffer.append(IFormat.f_3.format(this.x));
        stringBuffer.append("\n38=");
        stringBuffer.append(IFormat.f_3.format(this.y));
        if (IOProperties.isHoeheModus() && this.h != 0.0f) {
            stringBuffer.append("\n39=");
            stringBuffer.append(IFormat.f_3.format(this.h));
        }
        return stringBuffer.toString();
    }

    public String toCsvLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNr(IOProperties.isUmnum()));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.y));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.x));
        if (IOProperties.isHoeheModus() && this.h != 0.0f) {
            stringBuffer.append(",");
            stringBuffer.append(IFormat.f_3.format(this.h));
        }
        return stringBuffer.toString();
    }

    public static String toZenoDefLine() {
        return "FID;VID;X;Y;Z;Nummer;Art;GST;LZK;ABM;BZA;RHO;ON";
    }

    public String toZenoLine(int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(";");
        stringBuffer.append(n2);
        stringBuffer.append(";");
        stringBuffer.append(IFormat.f_3.format(this.y % 1000000.0));
        stringBuffer.append(";");
        stringBuffer.append(IFormat.f_3.format(this.x));
        stringBuffer.append(";");
        stringBuffer.append(IFormat.f_3.format(this.h != 0.0f && IOProperties.isHoeheModus() ? (double)this.h : DataBase.getGelHoehe()));
        if (bl) {
            PunktParameter punktParameter = this.getParameter(2);
            stringBuffer.append(";");
            stringBuffer.append(this.getNr(IOProperties.isUmnum()));
            stringBuffer.append(";");
            if (punktParameter.getKafPa() > -1) {
                stringBuffer.append(PunktArt.toIdString(punktParameter.getPa()));
            }
            stringBuffer.append(";");
            if (punktParameter.getKafLg() > 0) {
                stringBuffer.append(punktParameter.getLg());
            }
            stringBuffer.append(";");
            if (punktParameter.getKafLz() > 0) {
                stringBuffer.append(Lagezuverlaessigkeit.toIdString(punktParameter.getLz()));
            }
            stringBuffer.append(";");
            if (punktParameter.getKafVa() > 0) {
                stringBuffer.append(VermarkungsArt.toIdString(punktParameter.getVa()));
            }
            stringBuffer.append(";");
            if (punktParameter.getKafVb() > 0) {
                stringBuffer.append(VermarkungsArt.toVbIdString(punktParameter.getVb()));
            }
            stringBuffer.append(";");
            if (punktParameter.getKafVvt() != 0) {
                stringBuffer.append(punktParameter.getVvt());
            }
            stringBuffer.append(";");
            stringBuffer.append(this.isOn() ? "J" : "N");
        }
        return stringBuffer.toString();
    }

    public String toGpsKooLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i14.format(this.getNr(IOProperties.isUmnum())));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f6_3.format(this.y % 1000000.0));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        if (IOProperties.isHoeheModus()) {
            stringBuffer.append("  ");
            stringBuffer.append(IFormat.f4_3.format(this.h != 0.0f ? (double)this.h : DataBase.getGelHoehe()));
        }
        return stringBuffer.toString();
    }

    public String toDbkLine(boolean bl) {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(85);
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr13.format(this.getNr(bl)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.koo43.format(this.h).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModPa(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModVa(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModLs(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : " ");
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModHs(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModHg(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr02n.format(Math.max(punktParameter.getModEb(), 0)).toString());
        if (punktParameter.getKafVvt() < 0) {
            stringBuffer.append(" ");
        } else {
            stringBuffer.append("  ");
        }
        stringBuffer.append(GeoNumberFormat.nr02n.format(punktParameter.getModVvt()).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(punktParameter.getModVva(), 0)).toString());
        stringBuffer.append("  ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(punktParameter.getModLz(), 0)).toString());
        return stringBuffer.toString();
    }

    public String toIdbLine() {
        return this.toIdbLine(null);
    }

    public String toIdbLine(String string) {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(60);
        if (punktParameter.getKafPa() > 0) {
            stringBuffer.append(GeoNumberFormat.nr01n.format(punktParameter.getModPa()).toString());
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(GeoNumberFormat.nr05n.format(this.getNr5()).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.y).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.koo73.format(this.x).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(0, punktParameter.getModLs())).toString());
        stringBuffer.append(" ");
        stringBuffer.append(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : " ");
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr01n.format(Math.max(0, punktParameter.getModPst())).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr03n.format(Math.max(0, punktParameter.getModVa())).toString());
        stringBuffer.append(",");
        stringBuffer.append("   ");
        stringBuffer.append(",");
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toKivLine(int n) {
        PunktParameter punktParameter = this.getParameter(1);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(IFormat.i07.format(n));
        stringBuffer.append(" ");
        if (this.getKafPa() >= 0) {
            stringBuffer.append(IFormat.i011.format(this.buildKatNr(11)));
        } else {
            stringBuffer.append("     ");
            if (punktParameter.getKafPa() >= 0) {
                stringBuffer.append(IFormat.i01.format(punktParameter.getModPa()));
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(IFormat.i5.format(this.getNr()));
        }
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.i10.format((long)Math.rint(this.y * 1000.0)));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.i10.format((long)Math.rint(this.x * 1000.0)));
        stringBuffer.append("  0000");
        return stringBuffer.toString();
    }

    public Node toGml() throws Exception {
        PunktParameter punktParameter = this.getParameter();
        Node node = new Node("Punkt");
        node.addNode(new Node("kafplot:nummer", Long.toString(this.nr)));
        if (this.umnum > 0L) {
            node.addNode(new Node("kafplot:nummerNeu", Long.toString(this.umnum)));
        }
        if (this.isKatasterPunkt()) {
            node.addNode(new Node("kafplot:nummerKat", Long.toString(this.buildKatNr(14))));
        }
        if (this.getPs() >= 0) {
            node.addNode(new Node("kafplot:rechenstatus", Integer.toString(this.getPs())));
        }
        if (punktParameter.getKafPa() >= 0) {
            node.addNode(new Node("kafplot:punktart", Integer.toString(punktParameter.getModPa())));
        }
        if (punktParameter.getKafEb() > 0) {
            node.addNode(new Node("kafplot:ebene", Integer.toString(punktParameter.getModEb())));
        }
        if (punktParameter.getKafVa() > 0) {
            node.addNode(new Node("kafplot:vermarkung", Integer.toString(punktParameter.getModVa())));
        }
        if (punktParameter.getKafFolie() > 0) {
            node.addNode(new Node("kafplot:folie", Integer.toString(punktParameter.getModFolie())));
        }
        if (punktParameter.getKafOska() > 0) {
            node.addNode(new Node("kafplot:oska", Integer.toString(punktParameter.getModOska())));
        }
        if (punktParameter.getKafLs() > 0) {
            node.addNode(new Node("kafplot:lagestatus", Integer.toString(punktParameter.getModLs())));
        }
        if (punktParameter.getKafLg() != 0) {
            node.addNode(new Node("kafplot:lagegenauigkeitstatus", punktParameter.getOutLg()));
        }
        if (punktParameter.getKafLz() > 0) {
            node.addNode(new Node("kafplot:lagezuverlaessigkeit", Integer.toString(punktParameter.getModLz())));
        }
        if (punktParameter.getKafVva() > 0) {
            node.addNode(new Node("kafplot:vermarkung_vorgefunden", Integer.toString(punktParameter.getModVva())));
        }
        if (punktParameter.getKafVvt() != 0) {
            node.addNode(new Node("kafplot:vermarkung_tiefe", Integer.toString(punktParameter.getModVvt())));
        }
        Node node2 = new Node("kafplot:position");
        node2.addNode(new Node("gml:point", IFormat.f0_3.format(this.y) + " " + IFormat.f0_3.format(this.x)));
        node.addNode(node2);
        return node;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.write(11);
        PunktNummer.writeObject(this.nr, dataOutput);
        PunktNummer.writeObject(this.getUmnum(), dataOutput);
        dataOutput.writeByte(this.ps);
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.h != 0.0f) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.h);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.dy != 0.0f || this.dx != 0.0f) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.dy);
            dataOutput.writeFloat(this.dx);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.dl != 0.0f) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.dl);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.lsp != 0.0f) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.lsp);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(KpvIOProperties.getPunktParameterId(this.getParameter()));
        dataOutput.writeShort(this.sw);
        if (this.a != 0 || this.b != 0) {
            dataOutput.writeByte(3);
            dataOutput.writeShort(this.a);
            dataOutput.writeShort(this.b);
            dataOutput.writeShort(this.t);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.hasStatistik() && KpvIOProperties.writeStatistik()) {
            this.getStatistik().writeObject(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeFloat(this.zl);
        dataOutput.writeFloat(this.ag);
        dataOutput.writeFloat(this.az);
        dataOutput.writeInt(this.flags);
        KafPlotIOConstants.writeString(dataOutput, this.riss);
        KafPlotIOConstants.writeString(dataOutput, this.bemerkung);
    }

    public static Punkt readObject(DataInput dataInput) throws IOException {
        Punkt punkt = new Punkt();
        punkt.nr = PunktNummer.readObject(dataInput);
        punkt.setUmnum(PunktNummer.readObject(dataInput));
        punkt.ps = dataInput.readByte();
        if (KpvIOProperties.RVER < 200) {
            dataInput.readInt();
        }
        punkt.y = dataInput.readDouble();
        punkt.x = dataInput.readDouble();
        if (dataInput.readByte() != 0) {
            punkt.h = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            punkt.dy = dataInput.readFloat();
            punkt.dx = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            punkt.dl = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            punkt.lsp = dataInput.readFloat();
        }
        if (KpvIOProperties.RVER < 110) {
            PunktParameterALK punktParameterALK = new PunktParameterALK();
            if (dataInput.readByte() != 0) {
                punktParameterALK.setPa(dataInput.readByte());
                punktParameterALK.setEb(dataInput.readByte());
                punktParameterALK.setVa(dataInput.readShort());
                punktParameterALK.setLs(dataInput.readShort());
                punktParameterALK.setLg((char)dataInput.readByte());
                punktParameterALK.setFolie(dataInput.readShort());
                punktParameterALK.setOska(dataInput.readShort());
                punktParameterALK.setPst(dataInput.readByte());
            }
            punktParameterALK.setLz(dataInput.readByte());
            if (dataInput.readByte() != 0) {
                punktParameterALK.setHs(dataInput.readShort());
                punktParameterALK.setHg(dataInput.readByte());
            }
            if (dataInput.readByte() != 0) {
                punktParameterALK.setVva(dataInput.readShort());
                punktParameterALK.setVvt(dataInput.readShort());
            }
            punkt.initParameter(punktParameterALK);
        } else {
            punkt.initParameter(KpvIOProperties.getPunktParameterVal(dataInput.readShort()));
        }
        punkt.sw = dataInput.readShort();
        if (dataInput.readByte() != 0) {
            punkt.a = dataInput.readShort();
            punkt.b = dataInput.readShort();
            punkt.t = dataInput.readShort();
        }
        if (KpvIOProperties.RVER >= 110) {
            punkt.setStatistik(Stat.readObject(dataInput));
        }
        if (KpvIOProperties.RVER >= 111) {
            punkt.zl = dataInput.readFloat();
        }
        if (KpvIOProperties.RVER >= 112) {
            punkt.ag = dataInput.readFloat();
            punkt.az = dataInput.readFloat();
        }
        punkt.flags = dataInput.readInt();
        punkt.setRiss(KafPlotIOConstants.readString(dataInput));
        if (KpvIOProperties.RVER >= 116) {
            punkt.bemerkung = KafPlotIOConstants.readString(dataInput);
        }
        return punkt;
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(this.y, this.x, 0.0, 0.0);
    }

    @Override
    public DDimension getSize() {
        return new DDimension(0.0, 0.0);
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.contains(this.y, this.x);
    }

    @Override
    public final DPoint getHashPoint() {
        if (this.isMasterPoint()) {
            return new DPoint(this.y - 2.0E-4, this.x + 3.0E-4);
        }
        if (this.isSlavePoint()) {
            return new DPoint(this.y + 2.0E-4, this.x - 3.0E-4);
        }
        int n = Long.bitCount(this.nr);
        int n2 = (int)(this.nr % 21L);
        double d = (double)this.h * 1.0E-6;
        return new DPoint(this.y + 1.0E-5 * (double)n + d, this.x + 1.0E-5 * (double)n2 - d);
    }

    public int getRissSymbolRadius() {
        return Punkt.getRissSymbol(this.aktParam.getPa(), VermarkungsArt.getVermarkungsArt(this.aktParam.getVa()), this.aktParam.getOska()).getWidth();
    }

    public int getSymbolRadius(boolean bl, boolean bl2) {
        double d = !bl ? (double)Symbol.UNDEF.getWidth() : (this.isInLinie() ? (double)Symbol.INLINIE.getWidth() : (double)this.getRissSymbolRadius());
        return (int)Math.rint(d * 0.2);
    }

    public static final void setForeground(Color color) {
        foreground = color;
    }

    public static final Color getForeground() {
        return foreground;
    }

    public static final void setBackground(Color color) {
        background = color;
    }

    public static final Color getBackground() {
        return background;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawForeground(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawSymbol(iGraphics, bl, bl2);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public Color getBackgroundColor() {
        PunktParameter punktParameter;
        Color color = KafPlotColor.BACKGROUND;
        boolean bl = KafPlotProperties.getColorSwitch() == 1004 ? this.isFortfuehrung() : this.isOn();
        int n = KafPlotProperties.getColorPunktSwitch();
        PunktParameter punktParameter2 = punktParameter = KafPlotProperties.isOldAttPointColorize ? this.oldParam : this.aktParam;
        color = n == 2102 ? KafPlotProperties.lgaColor.getColor(new Integer(punktParameter.getKafLg() != 0 ? punktParameter.getKafLg() : Lagegenauigkeit.createFromLl(punktParameter.getKafLl()))) : (n == 2103 ? KafPlotProperties.lzkColor.getColor(new Integer(punktParameter.getLz())) : (n == 2104 ? KafPlotProperties.peaColor.getColor(new Integer(punktParameter.getEa())) : (n == 2105 ? KafPlotProperties.peqColor.getColor(new Integer(punktParameter.getEq())) : (n == 2106 ? KafPlotProperties.pstColor.getColor(new Integer(punktParameter.getPst())) : (n == 2107 ? KafPlotProperties.kquColor.getColor(new Integer(punktParameter.getPq())) : (bl ? KafPlotProperties.pktColor.getColor(new Integer(this.getPs())) : (this.getPs() == 1 || this.getPs() == 2 ? KafPlotColor.OFFLINE_BG : KafPlotColor.BACKGROUND)))))));
        return color;
    }

    public Color getForegroundColor(boolean bl, boolean bl2) {
        Color color = Color.black;
        int n = KafPlotProperties.getColorSwitch();
        if (n == 1001 || n == 1009 || n == 1004) {
            boolean bl3 = this.isGezogen();
            boolean bl4 = n == 1004 ? this.isFortfuehrung() : this.isOn();
            VermarkungsArt vermarkungsArt = null;
            if (this.aktParam.getKafVva() > 0) {
                vermarkungsArt = VermarkungsArt.getVermarkungsArt(this.aktParam.getVva());
            }
            color = bl4 ? (bl ? (n == 1004 && this.aktParam.getKafPa() != 1 ? (this.ks == 0 ? KafPlotColor.GP_VORHANDEN : KafPlotColor.GP_NEU) : (this.aktParam.getEb() == 1 || this.aktParam.getEb() == 41 ? (this.aktParam.getKafVva() == 0 || bl3 || vermarkungsArt != null && (vermarkungsArt.getKafArt() == 19 || vermarkungsArt.getKafArt() == 99) ? KafPlotColor.GP_VORHANDEN : ((this.aktParam.getKafVa() == 10 || this.aktParam.getKafVa() == 99) && this.aktParam.getKafVva() == 3 ? KafPlotColor.GP_VORHANDEN : KafPlotColor.GP_NEU)) : Ebene.getColor(this.aktParam.getEb()))) : (this.getPs() == 1 ? KafPlotProperties.pktColor.getColor(new Integer(this.getPs())) : KafPlotColor.UNDEF)) : KafPlotColor.OFFLINE_FG;
        } else {
            color = bl ? Color.black : KafPlotColor.UNDEF;
        }
        return color;
    }

    public void drawSymbol(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (iGraphics.contains(this.y, this.x)) {
            Point point = iGraphics.getGraphicPoint(this, new Point());
            this.drawSymbol(iGraphics, point.x, point.y, bl, bl2, false);
        }
    }

    public void printSymbol(IGraphics iGraphics, Point point, boolean bl) {
        this.drawSymbol(iGraphics, point.x, point.y, bl, false, true);
    }

    public void drawSymbol(IGraphics iGraphics, Point point, boolean bl) {
        this.drawSymbol(iGraphics, point.x, point.y, bl, false);
    }

    public void drawSymbol(IGraphics iGraphics, Point point, boolean bl, boolean bl2) {
        this.drawSymbol(iGraphics, point.x, point.y, bl, bl2);
    }

    public void drawSymbol(IGraphics iGraphics, int n, int n2, boolean bl) {
        this.drawSymbol(iGraphics, n, n2, bl, false);
    }

    public void drawSymbol(IGraphics iGraphics, int n, int n2, boolean bl, boolean bl2) {
        this.drawSymbol(iGraphics, n, n2, bl, bl2, false);
    }

    public void drawSymbol(IGraphics iGraphics, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        Graphics graphics = iGraphics.getGraphics();
        double d = this.getSymbolWinkel() + iGraphics.getRotation();
        Symbol symbol = null;
        Symbol symbol2 = null;
        boolean bl4 = this.isGezogen();
        boolean bl5 = this.isTiefVermarkt();
        int n3 = KafPlotProperties.getColorSwitch();
        if (n3 == 1001 || n3 == 1009 || n3 == 1004) {
            Cloneable cloneable;
            boolean bl6 = n3 == 1004 ? this.isFortfuehrung() : this.isOn();
            VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(this.aktParam.getVa());
            VermarkungsArt vermarkungsArt2 = null;
            if (this.aktParam.getKafVva() > 0) {
                vermarkungsArt2 = VermarkungsArt.getVermarkungsArt(this.aktParam.getVva());
            }
            if (bl) {
                if (n3 == 1004 && !bl6 && vermarkungsArt.getArt() <= 0) {
                    return;
                }
                if (bl4) {
                    symbol = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt2, this.getOska());
                } else if (vermarkungsArt2 != null && (vermarkungsArt2.getKafArt() == 19 || vermarkungsArt2.getKafArt() == 99 || vermarkungsArt2.getKafArt() == 10)) {
                    symbol = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt, this.getOska());
                } else {
                    symbol = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt, this.getOska());
                    if (vermarkungsArt2 != null && !vermarkungsArt2.isUnvermarkt()) {
                        symbol2 = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt2, this.getOska());
                    } else if (n3 == 1001 && this.aktParam.getVb() == 1000) {
                        symbol2 = Symbol.R_;
                    }
                    if (n3 == 1004 && symbol == Symbol.UNDEF) {
                        symbol = Symbol.UV;
                    }
                }
            } else {
                symbol = Symbol.UNDEF;
            }
            int n4 = KafPlotProperties.getColorPunktSwitch();
            colorBg = this.getBackgroundColor();
            if (bl6) {
                colorUv = KafPlotColor.GP_VORHANDEN;
                if (bl) {
                    if (n3 == 1004 && this.aktParam.getKafPa() != 1) {
                        colorOv = this.ks == 0 ? KafPlotColor.GP_VORHANDEN : KafPlotColor.GP_NEU;
                    } else if (this.aktParam.getEb() == 1 || this.aktParam.getEb() == 41) {
                        colorOv = this.aktParam.getKafVva() == 0 || bl4 || vermarkungsArt2 != null && (vermarkungsArt2.getKafArt() == 19 || vermarkungsArt2.getKafArt() == 99) ? KafPlotColor.GP_VORHANDEN : ((this.aktParam.getKafVa() == 10 || this.aktParam.getKafVa() == 99) && this.aktParam.getKafVva() == 3 ? KafPlotColor.GP_VORHANDEN : KafPlotColor.GP_NEU);
                        colorTv = KafPlotColor.GP_VORHANDEN;
                    } else {
                        colorTv = colorOv = Ebene.getColor(this.aktParam.getEb());
                    }
                } else {
                    colorOv = this.getPs() == 1 ? KafPlotProperties.pktColor.getColor(new Integer(this.getPs())) : KafPlotColor.UNDEF;
                }
            } else {
                if (KafPlotProperties.getColorSwitch() == 1004) {
                    colorBg = KafPlotColor.BACKGROUND;
                }
                colorUv = KafPlotColor.OFFLINE_FG;
                colorOv = KafPlotColor.OFFLINE_FG;
                colorTv = KafPlotColor.OFFLINE_FG;
            }
            if (this.isZeigtAufPoint()) {
                try {
                    cloneable = (Punkt)DataBase.P.get(Long.parseLong(this.getTag("IND").getValue()));
                    if (cloneable != null) {
                        double d2 = DLine.getOrientation(this.y, this.x, ((Punkt)cloneable).y, ((Punkt)cloneable).x) + iGraphics.getRotation() - 1.5707963267948966;
                        double d3 = Math.cos(d2);
                        double d4 = Math.sin(d2);
                        graphics.setColor(colorOv);
                        Point point = iGraphics.getGraphicPoint((DPoint)((Object)cloneable), new Point());
                        graphics.drawLine(n, n2, point.x, point.y);
                        graphics.drawLine(point.x, point.y, point.x - (int)Math.rint(d3 * 12.0 + d4 * 6.0), point.y - (int)Math.rint(d4 * 12.0 - d3 * 6.0));
                        graphics.drawLine(point.x, point.y, point.x - (int)Math.rint(d3 * 12.0 - d4 * 6.0), point.y - (int)Math.rint(d4 * 12.0 + d3 * 6.0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl2) {
                symbol.draw(graphics, n, n2, d, 0.27999999999999997, (byte)1);
            } else {
                Symbol.setForeground(colorOv);
                Symbol.setBackground(colorBg);
                if (bl) {
                    if (n4 != 2101 && symbol == Symbol.UV) {
                        cloneable = Symbol.R;
                        Symbol.setBackground(colorBg);
                        ((Symbol)cloneable).draw(graphics, n, n2, 0.0, 0.2, (byte)1);
                    }
                    if (bl5) {
                        Symbol.TIEF.draw(graphics, n, n2, d, 0.2, (byte)2);
                    }
                    if (KafPlotProperties.isPunktBgScale && n4 != 2101 && colorBg != KafPlotColor.BACKGROUND && symbol != Symbol.UNDEF) {
                        symbol.draw(graphics, n, n2, d, 0.2 * KafPlotProperties.punktBgScaleValue, (byte)1);
                        symbol.draw(graphics, n, n2, d, 0.2, (byte)0);
                    } else {
                        symbol.draw(graphics, n, n2, d, 0.2, (byte)2);
                    }
                    if (symbol2 != null) {
                        Symbol.setForeground(colorTv);
                        Symbol.TIEF.draw(graphics, n, n2, d, (symbol == Symbol.UV ? 1.0 : 0.5) * 0.2, (byte)2);
                        symbol2.draw(graphics, n, n2, d, (symbol == Symbol.UV ? 1.0 : 0.5) * 0.2, (byte)2);
                    }
                    if (this.isInLinie()) {
                        // empty if block
                    }
                    if (bl4) {
                        Symbol.setForeground(KafPlotColor.GP_NEU);
                        Symbol.GEZOGEN.draw(graphics, n, n2, d, 0.2, (byte)0);
                    }
                } else {
                    Symbol.UNDEF.draw(graphics, n, n2, d, 0.2, (byte)2);
                }
            }
        } else {
            Symbol symbol3 = Symbol.UNDEF;
            if (this.getModel() == 1) {
                if (bl) {
                    symbol3 = this.getKarteSymbol();
                }
                switch (this.getOska()) {
                    case 151: 
                    case 152: 
                    case 8151: 
                    case 8152: {
                        Symbol.setForeground(Color.black);
                        break;
                    }
                    default: {
                        Symbol.setForeground(bl ? Color.black : KafPlotColor.UNDEF);
                        break;
                    }
                }
            } else if (this.getModel() == 2) {
                symbol3 = this.getKarteSymbol();
                Symbol.setForeground(bl ? Ebene.getColor(this.aktParam.getEb()) : KafPlotColor.UNDEF);
            }
            if (bl && symbol3 == Symbol.UNDEF) {
                return;
            }
            Symbol.setBackground(KafPlotColor.BACKGROUND);
            symbol3.draw(graphics, n, n2, 0.0, 0.2, (byte)2);
        }
    }

    public Symbol getRissSymbol() {
        return Punkt.getRissSymbol(this.aktParam.getKafPa(), VermarkungsArt.getVermarkungsArt(this.aktParam.getKafVva() > 0 ? this.aktParam.getVva() : this.aktParam.getVa()), this.getOska());
    }

    public static Symbol getRissSymbol(int n, VermarkungsArt vermarkungsArt, int n2) {
        switch (n) {
            case 8: {
                return Symbol.TP;
            }
            case 9: {
                return Symbol.MB;
            }
            case 7: {
                return Symbol.AP;
            }
            case 2: {
                return Symbol.UV;
            }
        }
        if (vermarkungsArt.getArt() <= 0) {
            return Oska.getSymbol(n2);
        }
        Symbol symbol = vermarkungsArt.getSymbol();
        if (symbol == null) {
            return Symbol.UNDEF;
        }
        return symbol;
    }

    public Symbol getKarteSymbol() {
        int n = this.getModel();
        if (n == 2) {
            switch (this.aktParam.getModPa()) {
                case 10: {
                    return Symbol.AP;
                }
                case 11: {
                    return Symbol.SP;
                }
                case 20: 
                case 29: {
                    switch (this.aktParam.getKafVa()) {
                        case 10: 
                        case 11: 
                        case 19: 
                        case 99: {
                            return Symbol.UV;
                        }
                    }
                    return Symbol.GP;
                }
                case 30: 
                case 39: 
                case 40: 
                case 49: 
                case 50: {
                    return Symbol.UNDEF;
                }
                case 60: {
                    return Symbol.VP;
                }
                case 71: {
                    return Symbol.TP;
                }
                case 72: 
                case 73: {
                    return Symbol.MB;
                }
                case 74: {
                    return Symbol.TP;
                }
            }
            return Symbol.UNDEF;
        }
        if (n == 1) {
            return Oska.getSymbol(this.getOska());
        }
        return Symbol.UNDEF;
    }

    public void drawTrafoSymbol(IGraphics iGraphics, Point point, boolean bl) {
        this.drawMarkSymbol(iGraphics, point.x, point.y, bl, false, false, 0.2, 2);
    }

    public void printTrafoSymbol(IGraphics iGraphics, Point point, boolean bl) {
        this.drawMarkSymbol(iGraphics, point.x, point.y, bl, true, false, 0.2, 2);
    }

    public void fillTrafoSymbol(IGraphics iGraphics, Point point, boolean bl) {
        this.drawMarkSymbol(iGraphics, point.x, point.y, bl, false, true, 0.2, 2);
    }

    public void drawMarkSymbol(IGraphics iGraphics, int n, int n2, boolean bl, boolean bl2) {
        this.drawMarkSymbol(iGraphics, n, n2, bl, bl2, false, 0.2, 4);
    }

    private void drawMarkSymbol(IGraphics iGraphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, double d, int n3) {
        Graphics graphics = iGraphics.getGraphics();
        double d2 = this.getSymbolWinkel() + iGraphics.getRotation();
        Symbol symbol = null;
        if (KafPlotProperties.getColorSwitch() == 1001 || KafPlotProperties.getColorSwitch() == 1009 || KafPlotProperties.getColorSwitch() == 1004) {
            VermarkungsArt vermarkungsArt;
            VermarkungsArt vermarkungsArt2 = VermarkungsArt.getVermarkungsArt(this.aktParam.getVa());
            VermarkungsArt vermarkungsArt3 = vermarkungsArt = this.aktParam.getKafVva() > 0 ? VermarkungsArt.getVermarkungsArt(this.aktParam.getVva()) : null;
            symbol = bl ? (this.isGezogen() ? Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt, this.getOska()) : Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt2, this.getOska())) : Symbol.UNDEF;
        } else {
            Symbol symbol2 = symbol = bl ? this.getKarteSymbol() : Symbol.UNDEF;
        }
        if (bl2) {
            Symbol.setForeground(Color.white);
            Symbol.setBackground(Color.white);
        } else {
            Symbol.setBackground(background);
            Symbol.setForeground(foreground);
        }
        double d3 = ((double)symbol.getWidth() * d + (double)n3) / (double)symbol.getWidth();
        if (!bl3 && symbol == Symbol.UV) {
            d3 = (1.5 * d + (double)n3) / 1.5;
        }
        symbol.draw(graphics, n, n2, d2, d3, bl3 ? (byte)2 : 0);
    }

    public void writeSymbol(DxfFileWriter dxfFileWriter) {
        double d = -this.getSymbolWinkel() * 180.0 / Math.PI;
        Symbol symbol = null;
        Symbol symbol2 = null;
        if (KafPlotProperties.getColorSwitch() == 1001 || KafPlotProperties.getColorSwitch() == 1009 || KafPlotProperties.getColorSwitch() == 1004) {
            boolean bl = this.isGezogen();
            boolean bl2 = this.isTiefVermarkt();
            VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(this.aktParam.getVa());
            VermarkungsArt vermarkungsArt2 = null;
            if (this.aktParam.getKafVva() > 0) {
                vermarkungsArt2 = VermarkungsArt.getVermarkungsArt(this.aktParam.getVva());
            }
            if (bl) {
                symbol = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt2, this.aktParam.getOska());
            } else if (vermarkungsArt2 != null && vermarkungsArt2.getKatasterArt() == 99) {
                symbol = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt2, this.aktParam.getOska());
            } else {
                symbol = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt, this.aktParam.getOska());
                if (vermarkungsArt2 != null && !vermarkungsArt2.isUnvermarkt()) {
                    symbol2 = Punkt.getRissSymbol(this.aktParam.getKafPa(), vermarkungsArt2, this.aktParam.getOska());
                }
            }
            colorUv = KafPlotColor.GP_VORHANDEN;
            if (this.aktParam.getEb() == 1 || this.aktParam.getEb() == 41) {
                colorOv = this.aktParam.getKafVva() == 0 || bl || vermarkungsArt2 != null && (vermarkungsArt2.getKatasterArt() == 99 || vermarkungsArt2.getKatasterArt() == 98) ? KafPlotColor.GP_VORHANDEN : KafPlotColor.GP_NEU;
                colorTv = KafPlotColor.GP_VORHANDEN;
            } else {
                colorTv = colorOv = Ebene.getColor(this.aktParam.getEb());
            }
            int n = DxfConstants.getDxfColor(colorOv);
            int n2 = DxfConstants.getDxfColor(colorUv);
            String string = DxfConstants.getDxfString(Ebene.getEbeneName(this.aktParam.getEb()));
            if (symbol != null) {
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(symbol.getName()), this, 1.0, symbol.isAbsolute() ? 0.0 : d, string, n);
            }
            if (symbol2 != null) {
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(symbol2.getName()), this, 0.5, symbol2.isAbsolute() ? 0.0 : d, string, n2);
            }
            if (bl2) {
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(Symbol.TIEF.getName()), this, 1.0, d, string, n);
            }
            if (this.isInLinie()) {
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(Symbol.INLINIE.getName()), this, 1.0, d, string, n);
            }
            if (bl) {
                dxfFileWriter.writeInsert(DxfConstants.getDxfString(Symbol.GEZOGEN.getName()), this, 1.0, symbol.isAbsolute() ? 0.0 : d, string, DxfConstants.getDxfColor(KafPlotColor.GP_NEU));
            }
        } else {
            symbol = this.getKarteSymbol();
            dxfFileWriter.writeInsert(DxfConstants.getDxfString(symbol.getName()), this, 1.0, symbol.isAbsolute() ? 0.0 : d, DxfConstants.getDxfString(Ebene.getEbeneName(this.aktParam.getEb())), DxfConstants.getDxfColor(Ebene.getColor(this.aktParam.getEb())));
        }
    }
}

