/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import java.util.Enumeration;
import java.util.Hashtable;

public final class PunktArt {
    public static final int KAF_UNDEF = -1;
    public static final int KAF_INTERN = 0;
    public static final int KAF_GRENZ_PUNKT = 1;
    public static final int KAF_GEBAEUDE_PUNKT = 2;
    public static final int KAF_SONST_PUNKT = 3;
    public static final int KAF_AUFNAHME_PUNKT = 7;
    public static final int KAF_LAGE_FESTPUNKT = 8;
    public static final int KAF_HOEHE_FESTPUNKT = 9;
    private static final String UNDEF_ID = "";
    private static final String UNDEF_STRING = "ohne";
    private static final PunktArt _ALK_TP = new PunktArt(0, "0", "Trigonometrischer Punkt", 8);
    private static final PunktArt _ALK_AP = new PunktArt(1, "1", "Aufnahmepunkt", 7);
    private static final PunktArt _ALK_GP = new PunktArt(2, "2", "Grenzpunkt", 1);
    private static final PunktArt _ALK_HE = new PunktArt(3, "3", "Geb\u00e4udepunkt", 2);
    private static final PunktArt _ALK_ZP = new PunktArt(4, "4", "topographischer Punkt", 3);
    private static final PunktArt _ALK_KP = new PunktArt(7, "7", "Kleinpunkt", 3);
    private static final PunktArt _ALK_SF = new PunktArt(8, "8", "Schwerefestpunkt", 9);
    private static final PunktArt _ALK_NP = new PunktArt(9, "9", "Nivellementspunkt", 9);
    private static final PunktArt _ALKIS_AP = new PunktArt(10, "AP", "Aufnahmepunkt", 7);
    private static final PunktArt _ALKIS_SP = new PunktArt(11, "SP", "Sicherungspunkt", 7);
    private static final PunktArt _ALKIS_GP = new PunktArt(20, "GP", "Grenzpunkt", 1);
    private static final PunktArt _ALKIS_GPU = new PunktArt(29, "GPU", "Grenzpunkt unabh\u00e4ngig", 1);
    private static final PunktArt _ALKIS_BG = new PunktArt(30, "BG", "Besonderer Geb\u00e4udepunkt", 2);
    private static final PunktArt _ALKIS_BGU = new PunktArt(39, "BGU", "Besonderer Geb\u00e4udepunkt unabh\u00e4ngig", 2);
    private static final PunktArt _ALKIS_BB = new PunktArt(40, "BB", "Besonderer Bauwerkspunkt", 2);
    private static final PunktArt _ALKIS_BBU = new PunktArt(49, "BBU", "Besonderer Bauwerkspunkt unabh\u00e4ngig", 2);
    private static final PunktArt _ALKIS_BT = new PunktArt(50, "BT", "Besonderer topografischer Punkt", 3);
    private static final PunktArt _ALKIS_SV = new PunktArt(60, "SV", "Sonstiger Vermessungspunkt", 3);
    private static final PunktArt _ALKIS_LF = new PunktArt(71, "LF", "Lagefestpunkt", 8);
    private static final PunktArt _ALKIS_HF = new PunktArt(72, "HF", "H\u00f6henfestpunkt", 9);
    private static final PunktArt _ALKIS_SF = new PunktArt(73, "SF", "Schwerefestpunkt", 9);
    private static final PunktArt _ALKIS_RS = new PunktArt(74, "RS", "Referenzstationspunkt", 8);
    private static final PunktArt _ALKIS_I = new PunktArt(90, "I", "Hilfspunkt", 0);
    private static final PunktArt _ALKIS_N = new PunktArt(91, "N", "Nutzungsartenpunkt", 0);
    private static final PunktArt _ALKIS_G = new PunktArt(92, "G", "Grenzeinrichtungpunkt", 0);
    private static final PunktArt _ALKIS_T = new PunktArt(93, "T", "Topografiepunkt", 0);
    private static final PunktArt _ALKIS_R = new PunktArt(94, "R", "Referenzstation", 0);
    private static final PunktArt _ALKIS_S = new PunktArt(95, "S", "Standpunkt", 0);
    private static final PunktArt _ALKIS_K = new PunktArt(96, "K", "Kleinpunkt", 0);
    private static final PunktArt _UNDEF = new PunktArt(-1, "", "ohne", -1);
    private static final Hashtable<String, PunktArt> ids = new Hashtable();
    private static final Hashtable<Integer, PunktArt> keys = new Hashtable();
    private static final Hashtable<String, Integer> trans = new Hashtable();
    private int mod_art;
    private int kaf_art;
    private String id_string;
    private String name;
    private static final int GG_UNDEF = 0;
    private static final int GG_TP = 1;
    private static final int GG_AP = 4;
    private static final int GG_GP_VERM = 1;
    private static final int GG_GP_UNVERM = 0;
    private static final int GG_GP_TIEF = 3;
    private static final int GG_GP_KREUZ = 5;
    private static final int GG_HE = 0;
    private static final int GG_ZP = 0;
    private static final int GG_KP = 0;
    private static final int GG_SP = 0;
    private static final int GG_NP = 0;
    private static final int TIEFER = 10;
    private static final int IN_LINIE = 20;

    public static Hashtable<String, Integer> getTranslator() {
        return trans;
    }

    public static int AlkisToAlk(int n) {
        switch (n) {
            case 10: 
            case 11: {
                return 1;
            }
            case 20: 
            case 29: {
                return 2;
            }
            case 30: 
            case 39: {
                return 3;
            }
            case 40: 
            case 49: 
            case 50: {
                return 4;
            }
            case 60: {
                return 7;
            }
            case 71: {
                return 0;
            }
            case 72: {
                return 9;
            }
            case 73: {
                return 8;
            }
            case 74: {
                return 0;
            }
        }
        return -1;
    }

    public static PunktArt getArt(int n) {
        PunktArt punktArt = keys.get(new Integer(n));
        return punktArt != null ? punktArt : _UNDEF;
    }

    public static int parseString(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            stringBuffer.append(Character.toUpperCase(c));
        }
        PunktArt punktArt = ids.get(stringBuffer.toString());
        if (punktArt == null) {
            throw new Exception("PunktArt " + string + " nicht definiert");
        }
        return punktArt.mod_art;
    }

    public static String toIdString(int n) {
        PunktArt punktArt = keys.get(new Integer(n));
        return punktArt != null ? punktArt.id_string : UNDEF_ID;
    }

    public static int toKafArt(int n) {
        PunktArt punktArt = keys.get(new Integer(n));
        return punktArt != null ? punktArt.kaf_art : -1;
    }

    public static String toString(int n) {
        PunktArt punktArt = keys.get(new Integer(n));
        return punktArt != null ? punktArt.name : UNDEF_STRING;
    }

    public static boolean isKatasterElement(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 20: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 49: 
            case 50: 
            case 60: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return true;
            }
        }
        return false;
    }

    public PunktArt() {
        this(-1, UNDEF_ID, UNDEF_STRING, -1);
    }

    public PunktArt(int n, String string, String string2, int n2) {
        this.mod_art = n;
        this.id_string = string;
        this.name = string2;
        this.kaf_art = n2;
    }

    public int getKafArt() {
        return this.kaf_art;
    }

    public int getModelArt() {
        return this.mod_art;
    }

    public String getId() {
        return this.id_string;
    }

    public String getName() {
        return this.name;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.mod_art)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("punktart", stringArray);
    }

    public static Enumeration arten() {
        return keys.elements();
    }

    public static final String getItem(int n) {
        return n + "  " + PunktArt.toString(n);
    }

    public String toString() {
        return PunktArt.toString(this.mod_art);
    }

    static int getGeografPunktArt(Punkt punkt) {
        PunktParameter punktParameter = punkt.getParameter();
        if (punktParameter.getEb() == 0) {
            return 0;
        }
        int n = punktParameter.getEb() * 100;
        switch (punktParameter.getKafPa()) {
            case 8: {
                return n + 4;
            }
            case 1: {
                if (punktParameter.getModVa() > 0 && punktParameter.getModVa() <= 27 || punktParameter.getModVa() >= 40 && punktParameter.getModVa() <= 54) {
                    return n + 1;
                }
                if (punktParameter.getModVa() == 35) {
                    return n + 3;
                }
                if (punktParameter.getModVa() == 60) {
                    return n + 5;
                }
                return n + 0;
            }
            case 2: {
                return n + 0;
            }
            case 3: {
                return n + 0;
            }
            case 9: {
                return n + 0;
            }
        }
        return 0;
    }

    static int getGeografRissPunktArt(Punkt punkt) {
        int n = PunktArt.getGeografPunktArt(punkt);
        return n;
    }

    public static int getStandardFolie(int n) {
        if (n >= 0 && n <= 9) {
            return 50 + n;
        }
        return 59;
    }

    static {
        keys.put(new Integer(0), _ALK_TP);
        keys.put(new Integer(1), _ALK_AP);
        keys.put(new Integer(2), _ALK_GP);
        keys.put(new Integer(3), _ALK_HE);
        keys.put(new Integer(4), _ALK_ZP);
        keys.put(new Integer(7), _ALK_KP);
        keys.put(new Integer(8), _ALK_SF);
        keys.put(new Integer(9), _ALK_NP);
        keys.put(new Integer(10), _ALKIS_AP);
        keys.put(new Integer(11), _ALKIS_SP);
        keys.put(new Integer(20), _ALKIS_GP);
        keys.put(new Integer(29), _ALKIS_GPU);
        keys.put(new Integer(30), _ALKIS_BG);
        keys.put(new Integer(39), _ALKIS_BGU);
        keys.put(new Integer(40), _ALKIS_BB);
        keys.put(new Integer(49), _ALKIS_BBU);
        keys.put(new Integer(50), _ALKIS_BT);
        keys.put(new Integer(60), _ALKIS_SV);
        keys.put(new Integer(71), _ALKIS_LF);
        keys.put(new Integer(72), _ALKIS_HF);
        keys.put(new Integer(73), _ALKIS_SF);
        keys.put(new Integer(74), _ALKIS_RS);
        keys.put(new Integer(90), _ALKIS_I);
        keys.put(new Integer(91), _ALKIS_N);
        keys.put(new Integer(92), _ALKIS_G);
        keys.put(new Integer(93), _ALKIS_T);
        keys.put(new Integer(94), _ALKIS_R);
        keys.put(new Integer(95), _ALKIS_S);
        keys.put(new Integer(96), _ALKIS_K);
        keys.put(new Integer(-1), _UNDEF);
        ids.put("0", _ALK_TP);
        ids.put("1", _ALK_AP);
        ids.put("2", _ALK_GP);
        ids.put("3", _ALK_HE);
        ids.put("4", _ALK_ZP);
        ids.put("7", _ALK_KP);
        ids.put("8", _ALK_SF);
        ids.put("9", _ALK_NP);
        ids.put("AP", _ALKIS_AP);
        ids.put("SP", _ALKIS_SP);
        ids.put("GP", _ALKIS_GP);
        ids.put("GPU", _ALKIS_GPU);
        ids.put("BG", _ALKIS_BG);
        ids.put("BGU", _ALKIS_BGU);
        ids.put("BB", _ALKIS_BB);
        ids.put("BBU", _ALKIS_BBU);
        ids.put("BT", _ALKIS_BT);
        ids.put("SV", _ALKIS_SV);
        ids.put("LF", _ALKIS_LF);
        ids.put("HF", _ALKIS_HF);
        ids.put("SF", _ALKIS_SF);
        ids.put("RS", _ALKIS_RS);
        ids.put("I", _ALKIS_I);
        ids.put("N", _ALKIS_N);
        ids.put("G", _ALKIS_G);
        ids.put("T", _ALKIS_T);
        ids.put("R", _ALKIS_R);
        ids.put("S", _ALKIS_S);
        ids.put("K", _ALKIS_K);
        ids.put(UNDEF_ID, _UNDEF);
        Enumeration<String> enumeration = ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            trans.put(string, ids.get(string).getModelArt());
        }
    }
}

