/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ISwitchColorizer;
import de.geocalc.kafplot.ColorizeDialog;
import de.geocalc.kafplot.KafPlotProperties;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PunktCheckOptionDialog
extends IOptionDialog
implements ItemListener,
ComponentListener {
    Checkbox pstCb;
    Checkbox gstCb;
    Checkbox lzkCb;
    Checkbox peaCb;
    Checkbox peqCb;
    Checkbox kstCb;
    Checkbox kquCb;
    Checkbox oldACb;
    Checkbox lineCb;
    ColorizeDialog colDialog;
    Point loc;

    public PunktCheckOptionDialog(IFrame iFrame, String string) {
        super(iFrame, string, 0);
        this.setListLayout();
        this.addComponentListener(this);
        this.requestFocus();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.lineCb) {
            KafPlotProperties.isLineOfPointColorize = this.lineCb.getState();
        } else if (itemEvent.getSource() == this.oldACb) {
            KafPlotProperties.isOldAttPointColorize = this.oldACb.getState();
        } else {
            int n = KafPlotProperties.getColorPunktSwitch();
            if (this.pstCb.getState()) {
                n = 2101;
            } else if (this.gstCb.getState()) {
                n = 2102;
            } else if (this.lzkCb.getState()) {
                n = 2103;
            } else if (this.peaCb.getState()) {
                n = 2104;
            } else if (this.peqCb.getState()) {
                n = 2105;
            } else if (this.kstCb.getState()) {
                n = 2106;
            } else if (this.kquCb.getState()) {
                n = 2107;
            }
            KafPlotProperties.setColorPunktSwitch(n);
            this.setColDialog(n);
        }
        if (this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    private void setColDialog(int n) {
        ISwitchColorizer iSwitchColorizer = null;
        String string = "";
        if (n == 2101) {
            iSwitchColorizer = KafPlotProperties.pktColor;
            string = "Punktstatus";
        } else if (n == 2102) {
            iSwitchColorizer = KafPlotProperties.lgaColor;
            string = "Lagegenauigkeit";
        } else if (n == 2103) {
            iSwitchColorizer = KafPlotProperties.lzkColor;
            string = "Lagezuverl\u00e4ssigkeit";
        } else if (n == 2104) {
            iSwitchColorizer = KafPlotProperties.peaColor;
            string = "Entstehungsart";
        } else if (n == 2105) {
            iSwitchColorizer = KafPlotProperties.peqColor;
            string = "Entstehungsquelle";
        } else if (n == 2106) {
            iSwitchColorizer = KafPlotProperties.pstColor;
            string = "Katasterstatus";
        } else if (n == 2107) {
            iSwitchColorizer = KafPlotProperties.kquColor;
            string = "Katasterqualit\u00e4t";
        }
        if (iSwitchColorizer != null) {
            Point point = null;
            if (this.colDialog != null && this.colDialog.isVisible()) {
                point = this.colDialog.getLocationOnScreen();
                this.colDialog.setVisible(false);
                this.colDialog.dispose();
            }
            if (point == null) {
                point = this.getLocationOnScreen();
                point.x += this.getWidth() + this.getInsets().right * 2;
                point.y -= this.getInsets().bottom;
            }
            this.colDialog = new ColorizeDialog(this.parent, string, iSwitchColorizer);
            this.colDialog.setActionCommand(this.getActionCommand());
            this.colDialog.addActionListener(this.getActionListener());
            this.colDialog.setModal(false);
            this.colDialog.setLocation(point);
            this.colDialog.setVisible(true);
        }
    }

    @Override
    protected IPanel layoutDialogPanel() {
        IPanel iPanel = new IPanel(new BorderLayout(5, 5));
        IPanel iPanel2 = new IPanel(new GridLayout(10, 1));
        iPanel2.setBorder(new IBorder(1));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        int n = KafPlotProperties.getColorPunktSwitch();
        this.pstCb = new Checkbox("Punktstatus", n == 2101, checkboxGroup);
        iPanel2.add(this.pstCb);
        this.gstCb = new Checkbox("Lagegenauigkeit", n == 2102, checkboxGroup);
        iPanel2.add(this.gstCb);
        this.lzkCb = new Checkbox("Lagezuverl\u00e4ssigkeit", n == 2103, checkboxGroup);
        iPanel2.add(this.lzkCb);
        this.peaCb = new Checkbox("Entstehungsart", n == 2104, checkboxGroup);
        iPanel2.add(this.peaCb);
        this.peqCb = new Checkbox("Entstehungsquelle", n == 2105, checkboxGroup);
        iPanel2.add(this.peqCb);
        this.kstCb = new Checkbox("Katasterstatus", n == 2106, checkboxGroup);
        iPanel2.add(this.kstCb);
        this.kquCb = new Checkbox("Katasterqualit\u00e4t", n == 2107, checkboxGroup);
        iPanel2.add(this.kquCb);
        iPanel2.add(new Label(""));
        this.oldACb = new Checkbox("Altkataster", KafPlotProperties.isOldAttPointColorize);
        iPanel2.add(this.oldACb);
        this.lineCb = new Checkbox("Linienf\u00e4rbung", KafPlotProperties.isLineOfPointColorize);
        iPanel2.add(this.lineCb);
        this.pstCb.addItemListener(this);
        this.gstCb.addItemListener(this);
        this.lzkCb.addItemListener(this);
        this.peaCb.addItemListener(this);
        this.peqCb.addItemListener(this);
        this.kstCb.addItemListener(this);
        this.kquCb.addItemListener(this);
        this.oldACb.addItemListener(this);
        this.lineCb.addItemListener(this);
        iPanel.add("North", iPanel2);
        return iPanel;
    }

    @Override
    protected void setOptions() {
    }

    private void setListLayout() {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        Point point = this.loc;
        this.loc = this.getLocationOnScreen();
        if (this.colDialog != null && this.colDialog.isVisible()) {
            this.colDialog.setLocation(this.colDialog.getLocationOnScreen().x + (this.loc.x - point.x), this.colDialog.getLocationOnScreen().y + (this.loc.y - point.y));
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.loc = this.getLocationOnScreen();
        this.setColDialog(KafPlotProperties.getColorPunktSwitch());
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    protected void endDialog() {
        if (this.colDialog != null) {
            this.colDialog.setVisible(false);
            this.colDialog.dispose();
        }
        super.endDialog();
    }
}

