/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.util.BooleanFilter;
import de.geocalc.util.Filter;
import de.geocalc.util.IntegerListFilter;
import de.geocalc.util.LongFilter;

public class PunktFilter
extends Filter {
    protected LongFilter pnrFilter;
    protected IntegerListFilter paFilter;
    protected BooleanFilter onFilter;
    protected boolean invert = false;
    private int ausgabeTyp;

    public PunktFilter() {
        this(-1);
    }

    public PunktFilter(int n) {
        this.ausgabeTyp = n;
        this.setDefaultValues(n);
    }

    @Override
    public boolean isEnabled() {
        return this.pnrFilter.isEnabled() || this.paFilter.isEnabled() || this.onFilter.isEnabled();
    }

    public void setInvert(boolean bl) {
        this.invert = bl;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public boolean isPunktEnabled(Punkt punkt) {
        if (!this.pnrFilter.isValidValue(punkt.nr)) {
            return this.invert;
        }
        if (!this.paFilter.isValidValue(punkt.getPa())) {
            return this.invert;
        }
        if (!this.onFilter.isValidValue(punkt.isOn())) {
            return this.invert;
        }
        return !this.invert;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Punkt) {
            return this.isPunktEnabled((Punkt)object);
        }
        return false;
    }

    public Filter getFilter(int n) {
        switch (n) {
            case 101: {
                return this.pnrFilter;
            }
            case 201: {
                return this.paFilter;
            }
            case 901: {
                return this.onFilter;
            }
        }
        return null;
    }

    private void setDefaultValues(int n) {
        this.ausgabeTyp = n;
        switch (n) {
            case 123: 
            case 124: 
            case 125: 
            case 128: 
            case 130: {
                this.pnrFilter = new LongFilter(1L, 99999999999999L);
                this.pnrFilter.setEnabled(false);
                this.pnrFilter.setEditable(true);
                this.paFilter = new IntegerListFilter(DataBase.model.getPunktArten(false), false);
                this.paFilter.setTranslator(PunktArt.getTranslator());
                this.paFilter.setEnabled(true);
                this.paFilter.setEditable(true);
                this.onFilter = new BooleanFilter();
                this.onFilter.setEnabled(true);
                this.onFilter.setEditable(true);
                break;
            }
            case 121: 
            case 122: 
            case 127: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: 
            case 502: 
            case 520: 
            case 594: 
            case 595: 
            case 605: 
            case 606: 
            case 609: {
                this.pnrFilter = new LongFilter(1L, 99999999999999L);
                this.pnrFilter.setEnabled(false);
                this.pnrFilter.setEditable(true);
                this.paFilter = new IntegerListFilter(DataBase.model.getPunktArten(true), true);
                this.paFilter.setTranslator(PunktArt.getTranslator());
                this.paFilter.setEnabled(false);
                this.paFilter.setEditable(true);
                this.onFilter = new BooleanFilter();
                this.onFilter.setEnabled(true);
                this.onFilter.setEditable(true);
                break;
            }
            case 503: 
            case 509: {
                this.pnrFilter = new LongFilter(1L, 99999999999999L, false);
                this.pnrFilter.setEnabled(false);
                this.pnrFilter.setEditable(false);
                this.paFilter = new IntegerListFilter(DataBase.model.getPunktArten(true), false);
                this.paFilter.setTranslator(PunktArt.getTranslator());
                this.paFilter.setEnabled(false);
                this.onFilter = new BooleanFilter();
                this.onFilter.setEnabled(true);
                this.onFilter.setEditable(true);
                break;
            }
            default: {
                this.pnrFilter = new LongFilter(1L, 99999999999999L, false);
                this.pnrFilter.setEnabled(false);
                this.pnrFilter.setEditable(false);
                this.paFilter = new IntegerListFilter(DataBase.model.getPunktArten(true), false);
                this.paFilter.setTranslator(PunktArt.getTranslator());
                this.paFilter.setEnabled(false);
                this.paFilter.setEditable(false);
                this.onFilter = new BooleanFilter();
                this.onFilter.setEnabled(true);
                this.onFilter.setEditable(true);
            }
        }
    }
}

