/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;
import java.awt.Graphics;
import java.awt.Point;

public class PunktIdentitaet
implements DatObject {
    public Punkt ist;
    public Punkt soll;
    public String bemIst;
    public String bemSoll;
    private static final int MB = 20;
    private static final int S_LIM = 1;

    public PunktIdentitaet() {
        this(null, null, null, null);
    }

    public PunktIdentitaet(Punkt punkt, Punkt punkt2) {
        this(punkt, punkt2, null, null);
    }

    public PunktIdentitaet(Punkt punkt, Punkt punkt2, String string, String string2) {
        this.ist = punkt;
        this.soll = punkt2;
        this.bemIst = string;
        this.bemSoll = string2;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    @Override
    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("7 ");
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i14.format(this.ist.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.ist.getNr() : this.ist.nr)));
        stringBuffer.append(" ");
        stringBuffer.append(this.soll != null ? IFormat.i14.format(this.soll.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.soll.getNr() : this.soll.nr)) : "              ");
        stringBuffer.append(" ");
        if (this.bemIst != null) {
            stringBuffer.append(this.bemIst);
        }
        if (this.bemSoll != null) {
            stringBuffer.append("; ");
            stringBuffer.append(this.bemSoll);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ist == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.ist.nr + " > ");
        }
        if (this.soll == null) {
            stringBuffer.append(" null");
        } else {
            stringBuffer.append(" " + this.soll.nr);
        }
        if (this.bemIst == null) {
            stringBuffer.append(" : null");
        } else {
            stringBuffer.append(" : " + this.bemIst);
        }
        if (this.bemSoll == null) {
            stringBuffer.append(" : null");
        } else {
            stringBuffer.append(" : " + this.bemSoll);
        }
        return stringBuffer.toString();
    }

    public void drawSymbol(IGraphics iGraphics, boolean bl) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = iGraphics.getGraphicPoint(this.ist);
        Point point2 = iGraphics.getGraphicPoint(this.soll);
        graphics.setColor(KafPlotColor.IDENT);
        double d = Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
        if (d < 2.0) {
            for (int i = 20; i > 16; --i) {
                graphics.drawOval(point.x - i, point.y - i, 2 * i, 2 * i);
            }
        } else {
            double d2 = (double)(point.x - point2.x) / d;
            double d3 = (double)(point.y - point2.y) / d;
            int n = (int)(Math.atan2(point2.x - point.x, point2.y - point.y) * 180.0 / Math.PI);
            for (int i = 20; i > 15; --i) {
                int n2 = (int)Math.rint(-d3 * (double)i);
                int n3 = (int)Math.rint(d2 * (double)i);
                graphics.drawArc(point.x - i, point.y - i, 2 * i, 2 * i, n, 180);
                graphics.drawArc(point2.x - i, point2.y - i, 2 * i, 2 * i, n + 180, 180);
                graphics.drawLine(point.x + n2, point.y + n3, point2.x + n2, point2.y + n3);
                graphics.drawLine(point.x - n2, point.y - n3, point2.x - n2, point2.y - n3);
            }
        }
        graphics.setPaintMode();
    }
}

