/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IColor;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashObject;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class PunktMove
extends InputObject
implements LongHashObject,
Exceptionable,
Messager,
Drawable {
    private static int defaultPunktStatus = 1;
    private Punkt op;
    private float my;
    private float mx;
    private byte ps = (byte)2;
    private static final int PFL = 10;
    private static final int PFB = 3;

    public static void setDefaultPunktStatus(int n) {
        defaultPunktStatus = n;
    }

    public static int getDefaultPunktStatus() {
        return defaultPunktStatus;
    }

    public PunktMove(Punkt punkt, float f, float f2, int n) {
        this.op = punkt;
        this.my = f;
        this.mx = f2;
        this.setOperation(n);
    }

    public static PunktMove parseTag(String string) {
        PunktMove punktMove = new PunktMove(null, 0.0f, 0.0f, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    punktMove.ps = (byte)Integer.parseInt(string2);
                    break;
                }
                case 1: {
                    punktMove.my = Float.valueOf(string2).floatValue();
                    break;
                }
                case 2: {
                    punktMove.mx = Float.valueOf(string2).floatValue();
                }
            }
            ++n;
        }
        return punktMove;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PunktMove) {
            return this.op != null && this.op.equals(((PunktMove)object).getPunkt());
        }
        return false;
    }

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return 2;
    }

    @Override
    public int need() {
        if (this.step == 0) {
            return 64;
        }
        return InputProperties.getInputFangSwitch() == 903 ? 1024 : 32;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        return null;
    }

    public void setObject(Object object, int n) {
        if (n == 0) {
            this.setPunkt((Punkt)object);
        } else if (n == 1) {
            DPoint dPoint = (DPoint)object;
            this.setMove((float)(dPoint.y - this.op.y), (float)(dPoint.x - this.op.x));
        }
        this.lastIn = object;
    }

    @Override
    public void setObject(Object object, boolean bl) {
        if (this.step == 0) {
            this.setPunkt((Punkt)object);
        } else if (this.step == 1) {
            DPoint dPoint = (DPoint)object;
            this.setMove((float)(dPoint.y - this.op.y), (float)(dPoint.x - this.op.x));
        }
        if (bl) {
            ++this.step;
        }
        this.lastIn = object;
    }

    @Override
    public Cursor getCurrentCursor() {
        return this.getStep() == 1 ? Cursor.getPredefinedCursor(1) : Cursor.getDefaultCursor();
    }

    public void setMove(DPoint dPoint) {
        if (dPoint == null || this.op == null) {
            return;
        }
        this.my = (float)(dPoint.y - this.op.y);
        this.mx = (float)(dPoint.x - this.op.x);
    }

    public void setMoveY(float f) {
        this.my = f;
    }

    public float getMoveY() {
        return this.my;
    }

    public void setMoveX(float f) {
        this.mx = f;
    }

    public float getMoveX() {
        return this.mx;
    }

    public void setMove(float f, float f2) {
        this.my = f;
        this.mx = f2;
    }

    public void setPunkt(Punkt punkt) {
        this.op = punkt;
        if (this.ps < 0) {
            this.ps = (byte)defaultPunktStatus;
        }
    }

    public Punkt getPunkt() {
        return this.op;
    }

    public void setPunktStatus(int n) {
        this.ps = (byte)n;
    }

    public int getPunktStatus() {
        return this.ps;
    }

    public double getDistance() {
        if (this.my == 0.0f && this.mx == 0.0f) {
            return 0.0;
        }
        return Math.sqrt(this.my * this.my + this.mx * this.mx);
    }

    @Override
    public long longHashKey() {
        if (this.op == null) {
            return 0L;
        }
        return this.op.longHashKey();
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isReady()) {
            if (this.step == 0) {
                stringBuffer.append("Punkt: ");
                if (this.op != null) {
                    stringBuffer.append(this.op.nr);
                }
            } else {
                stringBuffer.append("Verschiebung: ");
                stringBuffer.append(IFormat.f_3.format(this.getDistance()));
            }
        } else {
            stringBuffer.append(this.getExceptionableName());
            if (this.op != null) {
                stringBuffer.append(" [");
                stringBuffer.append(IFormat.f_3.format(this.getDistance()));
                stringBuffer.append("]");
            }
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Punktverschiebung";
    }

    @Override
    public String getObjectName() {
        return this.op != null ? IFormat.i.format(this.op.nr) : "";
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(Math.min(this.op.y, this.op.y + (double)this.my), Math.min(this.op.x, this.op.x + (double)this.mx), Math.abs(this.my), Math.abs(this.mx));
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return this.op;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.op == null || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        this.drawForeground(iGraphics, bl, bl2);
        if (bl2 && this.op != null) {
            this.op.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Serializable serializable;
        if (this.my == 0.0f && this.mx == 0.0f) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            serializable = KafPlotProperties.mmaColor.getColor(new Integer(67));
            if (this.getOperation() == 0) {
                serializable = IColor.getLighter(serializable, 0.4f);
            }
            graphics.setColor((Color)serializable);
        }
        if (iGraphics.contains(this.op)) {
            serializable = iGraphics.getGraphicPoint(this.op, new Point());
            Punkt.setForeground(graphics.getColor());
            this.op.drawMarkSymbol(iGraphics, ((Point)serializable).x, ((Point)serializable).y, KafPlotProperties.isPunktArtVisible, bl2);
        }
        double d = this.op.y + (double)this.my;
        double d2 = this.op.x + (double)this.mx;
        if (bl2) {
            iGraphics.drawLine(this.op.y, this.op.x, d, d2, 2);
        } else {
            iGraphics.drawLine(this.op.y, this.op.x, d, d2);
        }
        if (this.getOperation() == 1) {
            this.drawPfeil(iGraphics, iGraphics.getGraphicPoint(d, d2, new Point()), DLine.getOrientation(this.op.y, this.op.x, d, d2) + iGraphics.getRotation() - 1.5707963267948966);
        } else if (this.getOperation() == 3) {
            this.drawPfeil(iGraphics, iGraphics.getGraphicPoint(d, d2, new Point()), DLine.getOrientation(this.op.y, this.op.x, d, d2) + iGraphics.getRotation() - 1.5707963267948966);
        } else if (this.getOperation() == 2) {
            double d3 = DLine.getOrientation(this.op.y, this.op.x, d, d2) + iGraphics.getRotation() - 1.5707963267948966;
            Point point = iGraphics.getGraphicPoint(this.op.y + (double)this.my / 2.0, this.op.x + (double)this.mx / 2.0, new Point());
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            int n = (int)Math.rint(d4 * 7.0 + d5 * 7.0);
            int n2 = (int)Math.rint(d4 * 7.0 - d5 * 7.0);
            iGraphics.getGraphics().drawLine(point.x - n, point.y + n2, point.x + n, point.y - n2);
            iGraphics.getGraphics().drawLine(point.x - n2, point.y - n, point.x + n2, point.y + n);
        }
    }

    private void drawPfeil(IGraphics iGraphics, Point point, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int[] nArray = new int[]{point.x, point.x - (int)Math.rint(d2 * 10.0 + d3 * 3.0), point.x - (int)Math.rint(d2 * 10.0 - d3 * 3.0)};
        int[] nArray2 = new int[]{point.y, point.y - (int)Math.rint(d3 * 10.0 - d2 * 3.0), point.y - (int)Math.rint(d3 * 10.0 + d2 * 3.0)};
        iGraphics.getGraphics().fillPolygon(nArray, nArray2, nArray.length);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        return "PunktMove(" + this.getOperation() + "): " + IFormat.f_3.format(this.my) + ", " + IFormat.f_3.format(this.mx);
    }
}

