/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PunktNummer {
    private static final String UNDEF_STRING = "undef.";
    private static final String NR_STRING = "Nummer";
    private static final String NR5ALK_STRING = "Nummer(5)";
    private static final String NR6ALK_STRING = "Pa-Nummer(5)";
    private static final String NR7ALK_STRING = "NB2-Nummer(5)";
    private static final String NR8ALK_STRING = "NB2-PA-Nummer(5)";
    private static final String NR9ALK_STRING = "NB4-Nummer(5)";
    private static final String NR10ALK_STRING = "NB4-PA-Nummer(5)";
    private static final String NR11ALK_STRING = "M-NB4-PA_Nummer(5)";
    private static final String NR13ALK_STRING = "NB8-Nummer(5)";
    private static final String NR14ALK_STRING = "NB8-PA-Nummer(5)";
    private static final String NR14BSP_STRING = "NB8ALK-PA-Nummer(5)";
    private static final String NR6ALKIS_STRING = "Nummer(6)";
    private static final String NR8ALKIS_STRING = "NB2-Nummer(6)";
    private static final String NR10ALKIS_STRING = "NB4-Nummer(6)";
    private static final String NR12ALKIS_STRING = "NB6-Nummer(6)";
    private static final String NR14ALKIS_STRING = "NB8-Nummer(6)";
    private static final String NR15ALKIS_STRING = "NB9-Nummer(6)";
    private static final String NR_STR = "Nr";
    private static final String NR5ALK_STR = "Nr5";
    private static final String NR6ALK_STR = "PaNr5";
    private static final String NR7ALK_STR = "Nb2Nr5";
    private static final String NR8ALK_STR = "Nb2PaNr5";
    private static final String NR9ALK_STR = "Nb4Nr5";
    private static final String NR10ALK_STR = "Nb4PaNr5";
    private static final String NR11ALK_STR = "MNb4PaNr5";
    private static final String NR13ALK_STR = "Nb8Nr5";
    private static final String NR14ALK_STR = "Nb8PaNr5";
    private static final String NR14BSP_STR = "Nb8alkPaNr5";
    private static final String NR6ALKIS_STR = "Nr6";
    private static final String NR8ALKIS_STR = "Nb2Nr6";
    private static final String NR10ALKIS_STR = "Nb4Nr6";
    private static final String NR12ALKIS_STR = "Nb6Nr6";
    private static final String NR14ALKIS_STR = "Nb8Nr6";
    private static final String NR15ALKIS_STR = "Nb9Nr6";
    public static final int UNDEF = -1;
    public static final int NR = 0;
    public static final int NR5 = 5;
    public static final int NR6 = 6;
    public static final int NR7 = 7;
    public static final int NR8 = 8;
    public static final int NR9 = 9;
    public static final int NR10 = 10;
    public static final int NR11 = 11;
    public static final int NR12 = 12;
    public static final int NR13 = 13;
    public static final int NR14 = 14;
    public static final int NR15 = 15;
    public static final int NR14BSP = 94;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 99999999999999L;

    public static String createNbString(long l) {
        if (l >= 1000000L) {
            return Long.toString(l / 1000000L);
        }
        return null;
    }

    public static String createPaString(long l) {
        if (l >= 100000L) {
            return Long.toString(l / 100000L % 10L);
        }
        return null;
    }

    public static String[] getNames(int n) {
        return PunktNummer.getNames(n, false);
    }

    public static String[] getNames(int n, boolean bl) {
        String[] stringArray = null;
        if (n == 1) {
            stringArray = new String[]{NR5ALK_STRING, NR6ALK_STRING, NR7ALK_STRING, NR8ALK_STRING, NR9ALK_STRING, NR10ALK_STRING, NR11ALK_STRING, NR13ALK_STRING, NR14ALK_STRING, NR14BSP_STRING};
        } else if (n == 2) {
            stringArray = new String[bl ? 6 : 5];
            stringArray[0] = NR6ALKIS_STRING;
            stringArray[1] = NR8ALKIS_STRING;
            stringArray[2] = NR10ALKIS_STRING;
            stringArray[3] = NR12ALKIS_STRING;
            stringArray[4] = NR14ALKIS_STRING;
            if (bl) {
                stringArray[5] = NR15ALKIS_STRING;
            }
        } else {
            stringArray = new String[]{NR_STRING};
        }
        return stringArray;
    }

    public static int getRaised(int n) {
        switch (n) {
            case 5: {
                return 6;
            }
            case 6: 
            case 7: {
                return 8;
            }
            case 8: 
            case 9: {
                return 10;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 14;
            }
        }
        return -1;
    }

    public static long getMinUsableNumber(int n) {
        switch (n) {
            case 0: {
                return 1L;
            }
            case 5: {
                return 100000L;
            }
            case 6: {
                return 1000000L;
            }
            case 7: {
                return 10000000L;
            }
            case 8: {
                return 100000000L;
            }
            case 9: {
                return 1000000000L;
            }
            case 10: {
                return 10000000000L;
            }
            case 11: {
                return 100000000000L;
            }
            case 12: {
                return 1000000000000L;
            }
            case 13: {
                return 10000000000000L;
            }
            case 14: 
            case 94: {
                return 100000000000000L;
            }
        }
        return 1L;
    }

    public static String getLengthAsString(int n, int n2) {
        switch (n) {
            case 0: {
                return NR_STRING;
            }
            case 5: {
                return NR5ALK_STRING;
            }
            case 6: {
                return n2 == 1 ? NR6ALK_STRING : NR6ALKIS_STRING;
            }
            case 7: {
                return NR7ALK_STRING;
            }
            case 8: {
                return n2 == 1 ? NR8ALK_STRING : NR8ALKIS_STRING;
            }
            case 9: {
                return NR9ALK_STRING;
            }
            case 10: {
                return n2 == 1 ? NR10ALK_STRING : NR10ALKIS_STRING;
            }
            case 11: {
                return NR11ALK_STRING;
            }
            case 13: {
                return NR13ALK_STRING;
            }
            case 14: {
                return n2 == 1 ? NR14ALK_STRING : NR14ALKIS_STRING;
            }
            case 15: {
                return NR15ALKIS_STRING;
            }
            case 94: {
                return NR14BSP_STRING;
            }
        }
        return UNDEF_STRING;
    }

    public static int getLength(String string) {
        if (string.equals(NR_STRING)) {
            return 0;
        }
        if (string.equals(NR5ALK_STRING)) {
            return 5;
        }
        if (string.equals(NR6ALK_STRING)) {
            return 6;
        }
        if (string.equals(NR7ALK_STRING)) {
            return 7;
        }
        if (string.equals(NR8ALK_STRING)) {
            return 8;
        }
        if (string.equals(NR9ALK_STRING)) {
            return 9;
        }
        if (string.equals(NR10ALK_STRING)) {
            return 10;
        }
        if (string.equals(NR11ALK_STRING)) {
            return 11;
        }
        if (string.equals(NR13ALK_STRING)) {
            return 13;
        }
        if (string.equals(NR14ALK_STRING)) {
            return 14;
        }
        if (string.equals(NR14BSP_STRING)) {
            return 94;
        }
        if (string.equals(NR6ALKIS_STRING)) {
            return 6;
        }
        if (string.equals(NR8ALKIS_STRING)) {
            return 8;
        }
        if (string.equals(NR10ALKIS_STRING)) {
            return 10;
        }
        if (string.equals(NR12ALKIS_STRING)) {
            return 12;
        }
        if (string.equals(NR14ALKIS_STRING)) {
            return 14;
        }
        if (string.equals(NR15ALKIS_STRING)) {
            return 15;
        }
        return -1;
    }

    public static int getLengthOfProperty(String string) throws IException {
        if (string.equalsIgnoreCase(NR_STR)) {
            return 0;
        }
        if (string.equalsIgnoreCase(NR5ALK_STR)) {
            return 5;
        }
        if (string.equalsIgnoreCase(NR6ALK_STR)) {
            return 6;
        }
        if (string.equalsIgnoreCase(NR7ALK_STR)) {
            return 7;
        }
        if (string.equalsIgnoreCase(NR8ALK_STR)) {
            return 8;
        }
        if (string.equalsIgnoreCase(NR9ALK_STR)) {
            return 9;
        }
        if (string.equalsIgnoreCase(NR10ALK_STR)) {
            return 10;
        }
        if (string.equalsIgnoreCase(NR11ALK_STR)) {
            return 11;
        }
        if (string.equalsIgnoreCase(NR13ALK_STR)) {
            return 13;
        }
        if (string.equalsIgnoreCase(NR14ALK_STR)) {
            return 14;
        }
        if (string.equalsIgnoreCase(NR14BSP_STR)) {
            return 94;
        }
        if (string.equalsIgnoreCase(NR6ALKIS_STR)) {
            return 6;
        }
        if (string.equalsIgnoreCase(NR8ALKIS_STR)) {
            return 8;
        }
        if (string.equalsIgnoreCase(NR10ALKIS_STR)) {
            return 10;
        }
        if (string.equalsIgnoreCase(NR12ALKIS_STR)) {
            return 12;
        }
        if (string.equalsIgnoreCase(NR14ALKIS_STR)) {
            return 14;
        }
        if (string.equalsIgnoreCase(NR15ALKIS_STR)) {
            return 15;
        }
        throw new IException("\"" + string + "\" ist kein g\u00fcltiges Punktnummer-Kennzeichen");
    }

    public static void writeObject(long l, DataOutput dataOutput) throws IOException {
        if (l == 0L) {
            dataOutput.writeByte(0);
        } else if (l > -128L && l < 127L) {
            dataOutput.writeByte(2);
            dataOutput.writeByte((byte)l);
        } else if (l > -32768L && l < 32767L) {
            dataOutput.writeByte(3);
            dataOutput.writeShort((short)l);
        } else if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            dataOutput.writeByte(5);
            dataOutput.writeInt((int)l);
        } else {
            dataOutput.writeByte(6);
            dataOutput.writeLong(l);
        }
    }

    public static long readObject(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        switch (by) {
            case 0: {
                return 0L;
            }
            case 2: {
                return dataInput.readByte();
            }
            case 3: {
                return dataInput.readShort();
            }
            case 5: {
                return dataInput.readInt();
            }
            case 6: {
                return dataInput.readLong();
            }
        }
        throw new IOException("unerwarteter Wert");
    }
}

