/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktParameterALKISExt;
import de.geocalc.kafplot.PunktParameterVoid;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.util.ClearList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public abstract class PunktParameter
implements Cloneable {
    public static final int UNKNOWN = 0;
    public static final int PA = 1;
    public static final int EB = 2;
    public static final int VA = 4;
    public static final int LS = 8;
    public static final int LG = 16;
    public static final int LL = 32;
    public static final int LZ = 64;
    public static final int HS = 128;
    public static final int HG = 256;
    public static final int VVA = 512;
    public static final int VVT = 1024;
    public static final int OSKA = 2048;
    public static final int PST = 4096;
    public static final int FOLIE = 8192;
    public static final int VB = 16384;
    public static final int EA = 32768;
    public static final int EQ = 65536;
    public static final int ART = 131072;
    private static final ClearList list = new ClearList(1.0f);
    public static final PunktParameter VOID = new PunktParameterVoid();

    public static final int memoryCount() {
        return list.size();
    }

    public static void killHash() {
        list.clear();
    }

    public static PunktParameter intern(PunktParameter punktParameter) {
        if (punktParameter == null) {
            throw new NullPointerException();
        }
        if (punktParameter instanceof PunktParameterALKISExt) {
            return punktParameter;
        }
        Object object = list.get(punktParameter);
        if (object != null) {
            return (PunktParameter)object;
        }
        list.put(punktParameter);
        return punktParameter;
    }

    public abstract int getModel();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract void setParameter(int var1, long var2);

    public abstract void setParameter(int var1, int var2);

    public abstract void addParameter(PunktParameter var1);

    public boolean isVoid() {
        return this.equals(VOID);
    }

    public abstract void setPa(int var1);

    public abstract int getPa();

    public abstract int getKafPa();

    public abstract int getModPa();

    public abstract String getOutPa();

    public abstract void setVa(int var1);

    public abstract int getVa();

    public abstract int getKafVa();

    public abstract int getModVa();

    public abstract String getOutVa();

    public abstract void setVb(int var1);

    public abstract int getVb();

    public abstract int getKafVb();

    public abstract int getModVb();

    public abstract String getOutVb();

    public abstract void setVva(int var1);

    public abstract int getVva();

    public abstract int getKafVva();

    public abstract int getModVva();

    public abstract String getOutVva();

    public abstract void setVvt(int var1);

    public abstract int getVvt();

    public abstract int getKafVvt();

    public abstract int getModVvt();

    public abstract String getOutVvt();

    public abstract void setLs(int var1);

    public abstract int getLs();

    public abstract int getKafLs();

    public abstract int getModLs();

    public abstract String getOutLs();

    public abstract void setLg(int var1);

    public abstract int getLg();

    public abstract int getKafLg();

    public abstract int getModLg();

    public abstract String getOutLg();

    public abstract void setLl(float var1);

    public abstract float getLl();

    public abstract float getKafLl();

    public abstract float getModLl();

    public abstract String getOutLl();

    public abstract void setLz(int var1);

    public abstract int getLz();

    public abstract int getKafLz();

    public abstract int getModLz();

    public abstract String getOutLz();

    public abstract void setEa(int var1);

    public abstract int getEa();

    public abstract int getKafEa();

    public abstract int getModEa();

    public abstract String getOutEa();

    public abstract void setEq(int var1);

    public abstract int getEq();

    public abstract int getKafEq();

    public abstract int getModEq();

    public abstract String getOutEq();

    public abstract void setHs(int var1);

    public abstract int getHs();

    public abstract int getKafHs();

    public abstract int getModHs();

    public abstract String getOutHs();

    public abstract void setHg(int var1);

    public abstract int getHg();

    public abstract int getKafHg();

    public abstract int getModHg();

    public abstract String getOutHg();

    public abstract void setArt(int var1);

    public abstract int getArt();

    public abstract int getKafArt();

    public abstract int getModArt();

    public abstract String getOutArt();

    public abstract void setPst(int var1);

    public abstract int getPst();

    public abstract int getKafPst();

    public abstract int getModPst();

    public abstract String getOutPst();

    public abstract void setPq(int var1);

    public abstract int getPq();

    public abstract int getKafPq();

    public abstract int getModPq();

    public abstract String getOutPq();

    public abstract void setEb(int var1);

    public abstract int getEb();

    public abstract int getKafEb();

    public abstract int getModEb();

    public abstract String getOutEb();

    public abstract void setOska(int var1);

    public abstract int getOska();

    public abstract int getKafOska();

    public abstract int getModOska();

    public abstract String getOutOska();

    public abstract void setFolie(int var1);

    public abstract int getFolie();

    public abstract int getKafFolie();

    public abstract int getModFolie();

    public abstract String getOutFolie();

    public abstract boolean isKatasterElement();

    public abstract PunktParameter toAlkModel();

    public boolean equalsModel(PunktParameter punktParameter) {
        return this.getModPa() == punktParameter.getModPa() && this.getModVa() == punktParameter.getModVa() && this.getModVb() == punktParameter.getModVb() && this.getModLg() == punktParameter.getModLg() && this.getModLl() == punktParameter.getModLl() && this.getModLz() == punktParameter.getModLz() && this.getModEa() == punktParameter.getModEa() && this.getModEq() == punktParameter.getModEq() && this.getModOska() == punktParameter.getModOska() && this.getModLs() == punktParameter.getModLs();
    }

    public String differencedModelAttributes(PunktParameter punktParameter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getModPa() != punktParameter.getModPa()) {
            stringBuffer.append("PAT" + this.getModPa() + " != " + punktParameter.getModPa() + " ");
        }
        if (this.getModVa() != punktParameter.getModVa()) {
            stringBuffer.append("ABM" + this.getModVa() + " != " + punktParameter.getModVa() + " ");
        }
        if (this.getModVb() != punktParameter.getModVb()) {
            stringBuffer.append("BZA" + this.getModVb() + " != " + punktParameter.getModVb() + " ");
        }
        if (this.getModLg() != punktParameter.getModLg()) {
            stringBuffer.append("GST" + this.getModLg() + " != " + punktParameter.getModLg() + " ");
        }
        if (this.getModLl() != punktParameter.getModLl()) {
            stringBuffer.append("GWT" + this.getModLl() + " != " + punktParameter.getModLl() + " ");
        }
        if (this.getModLz() != punktParameter.getModLz()) {
            stringBuffer.append("LZK" + this.getModLz() + " != " + punktParameter.getModLz() + " ");
        }
        if (this.getModEa() != punktParameter.getModEa()) {
            stringBuffer.append("DES" + this.getModEa() + " != " + punktParameter.getModEa() + " ");
        }
        if (this.getModEq() != punktParameter.getModEq()) {
            stringBuffer.append("DEQ" + this.getModEq() + " != " + punktParameter.getModEq() + " ");
        }
        if (this.getModOska() != punktParameter.getModOska()) {
            stringBuffer.append("OS " + this.getModOska() + " != " + punktParameter.getModOska() + " ");
        }
        if (this.getModLs() != punktParameter.getModLs()) {
            stringBuffer.append("KST" + this.getModLs() + " != " + punktParameter.getModLs() + " ");
        }
        return stringBuffer.toString();
    }

    public static void writeObjects(DataOutput dataOutput) throws IOException {
        dataOutput.write(91);
        int n = list.size();
        if (n > Short.MAX_VALUE) {
            throw new IOException("overflow PunktParameter");
        }
        dataOutput.writeShort(n);
        int n2 = 1;
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            PunktParameter punktParameter = (PunktParameter)enumeration.nextElement();
            punktParameter.writeObject(dataOutput);
            KpvIOProperties.setPunktParameter(n2, punktParameter);
            ++n2;
        }
    }

    public static void readObjects(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        if (KpvIOProperties.RVER < 200) {
            for (int i = 0; i < n; ++i) {
                PunktParameter punktParameter = PunktParameterALK.readObject(dataInput);
                KpvIOProperties.setPunktParameter(i + 1, punktParameter);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte by = dataInput.readByte();
                PunktParameter punktParameter = null;
                if (by == 121) {
                    punktParameter = PunktParameterALK.readObject(dataInput);
                } else if (by == 122) {
                    punktParameter = PunktParameterALKIS.readObject(dataInput);
                } else if (by == 120) {
                    punktParameter = PunktParameterVoid.readObject(dataInput);
                } else {
                    throw new IOException("unbalanced PunktParameter");
                }
                KpvIOProperties.setPunktParameter(i + 1, punktParameter);
            }
        }
    }

    protected abstract void writeObject(DataOutput var1) throws IOException;

    public abstract boolean checkConsistency() throws Exception;

    static {
        list.put(VOID);
    }
}

