/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class PunktParameterALK
extends PunktParameter
implements Cloneable {
    private byte pa = (byte)-1;
    private byte eb = 0;
    private byte lz = 0;
    private byte hg = (byte)-1;
    private byte pst = (byte)-1;
    private short va = 0;
    private short ls = 0;
    private short hs = 0;
    private short vva = 0;
    private short vvt = 0;
    private short oska = 0;
    private short folie = 0;
    private short lg = 0;

    public PunktParameterALK() {
    }

    public PunktParameterALK(int n, int n2) {
        this.setParameter(n, n2);
    }

    public PunktParameterALK(int n, long l) {
        this.setParameter(n, l);
    }

    @Override
    public int getModel() {
        return 1;
    }

    @Override
    public void setParameter(int n, long l) {
        this.setParameter(n, (int)l);
    }

    @Override
    public void setParameter(int n, int n2) {
        switch (n) {
            case 1: {
                this.pa = (byte)n2;
                break;
            }
            case 16: {
                this.lg = (short)n2;
                break;
            }
            case 256: {
                this.hg = (byte)n2;
                break;
            }
            case 2: {
                this.eb = (byte)n2;
                break;
            }
            case 64: {
                this.lz = (byte)n2;
                break;
            }
            case 4: {
                this.va = (short)n2;
                break;
            }
            case 8: {
                this.ls = (short)n2;
                break;
            }
            case 128: {
                this.hs = (short)n2;
                break;
            }
            case 512: {
                this.vva = (short)n2;
                break;
            }
            case 1024: {
                this.vvt = (short)n2;
                break;
            }
            case 2048: {
                this.oska = (short)n2;
                break;
            }
            case 4096: {
                this.pst = (byte)n2;
                break;
            }
            case 8192: {
                this.folie = (short)n2;
            }
        }
    }

    @Override
    public void addParameter(PunktParameter punktParameter) {
        PunktParameterALK punktParameterALK = (PunktParameterALK)punktParameter;
        if (this.pa == -1 && punktParameterALK.pa != -1) {
            this.pa = punktParameterALK.pa;
        }
        if (this.lg == 0 && punktParameterALK.lg != 0) {
            this.lg = punktParameterALK.lg;
        }
        if (this.hg == 0 && punktParameterALK.hg != 0) {
            this.hg = punktParameterALK.hg;
        }
        if (this.eb <= 0 && punktParameterALK.eb > 0) {
            this.eb = punktParameterALK.eb;
        }
        if (this.lz <= 0 && punktParameterALK.lz >= 0) {
            this.lz = punktParameterALK.lz;
        }
        if (this.va <= 0 && punktParameterALK.va > 0) {
            this.va = punktParameterALK.va;
        }
        if (this.ls <= 0 && punktParameterALK.ls > 0) {
            this.ls = punktParameterALK.ls;
        }
        if (this.hs <= 0 && punktParameterALK.hs > 0) {
            this.hs = punktParameterALK.hs;
        }
        if (this.vva <= 0 && punktParameterALK.vva > 0) {
            this.vva = punktParameterALK.vva;
        }
        if (this.vvt == 0 && punktParameterALK.vvt != 0) {
            this.vvt = punktParameterALK.vvt;
        }
        if (this.oska <= 0 && punktParameterALK.oska > 0) {
            this.oska = punktParameterALK.oska;
        }
        if (this.pst <= -1 && punktParameterALK.pst > -1) {
            this.pst = punktParameterALK.pst;
        }
        if (this.folie <= 0 && punktParameterALK.folie > 0) {
            this.folie = punktParameterALK.folie;
        }
    }

    @Override
    public void setPa(int n) {
        this.pa = (byte)n;
    }

    @Override
    public int getPa() {
        return this.pa;
    }

    @Override
    public int getKafPa() {
        return PunktArt.toKafArt(this.pa);
    }

    @Override
    public int getModPa() {
        return this.pa;
    }

    @Override
    public String getOutPa() {
        return this.pa >= 0 ? Integer.toString(this.pa) : " ";
    }

    @Override
    public void setVa(int n) {
        this.va = (short)n;
    }

    @Override
    public int getVa() {
        return this.va;
    }

    @Override
    public int getKafVa() {
        return VermarkungsArt.getVermarkungsArt(this.va).getKafArt();
    }

    @Override
    public int getModVa() {
        return VermarkungsArt.getVermarkungsArt(this.va).getModArt();
    }

    @Override
    public String getOutVa() {
        return this.va > 0 ? IFormat.i03.format(this.va) : "   ";
    }

    @Override
    public void setVb(int n) {
    }

    @Override
    public int getVb() {
        return 0;
    }

    @Override
    public int getKafVb() {
        return 0;
    }

    @Override
    public int getModVb() {
        return 0;
    }

    @Override
    public String getOutVb() {
        return "    ";
    }

    @Override
    public void setVva(int n) {
        this.vva = (short)n;
    }

    @Override
    public int getVva() {
        return this.vva;
    }

    @Override
    public int getKafVva() {
        return VermarkungsArt.getVermarkungsArt(this.vva).getKafArt();
    }

    @Override
    public int getModVva() {
        return VermarkungsArt.getVermarkungsArt(this.vva).getModArt();
    }

    @Override
    public String getOutVva() {
        return this.vva > 0 ? IFormat.i03.format(this.vva) : "   ";
    }

    @Override
    public void setVvt(int n) {
        this.vvt = (short)n;
    }

    @Override
    public int getVvt() {
        return this.vvt;
    }

    @Override
    public int getKafVvt() {
        return this.vvt;
    }

    public int getAlkVvt() {
        return this.vvt;
    }

    @Override
    public int getModVvt() {
        return this.vvt;
    }

    @Override
    public String getOutVvt() {
        return this.vvt != 0 ? IFormat.i3.format(this.vvt) : "   ";
    }

    @Override
    public void setLs(int n) {
        this.ls = (short)n;
    }

    @Override
    public int getLs() {
        return this.ls;
    }

    @Override
    public int getKafLs() {
        return this.ls;
    }

    @Override
    public int getModLs() {
        return this.ls;
    }

    @Override
    public String getOutLs() {
        return this.ls > 0 ? IFormat.i03.format(this.ls) : "   ";
    }

    @Override
    public void setLg(int n) {
        this.lg = (short)n;
    }

    @Override
    public int getLg() {
        return this.lg;
    }

    @Override
    public int getKafLg() {
        switch (this.lg) {
            case 32: {
                return 0;
            }
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 55: {
                return 4;
            }
            case 56: {
                return 5;
            }
            case 57: {
                return 6;
            }
            case 65: {
                return 7;
            }
            case 80: {
                return 99;
            }
        }
        return 0;
    }

    @Override
    public int getModLg() {
        return this.lg;
    }

    @Override
    public String getOutLg() {
        return this.lg > 0 ? Character.toString((char)this.lg) : " ";
    }

    @Override
    public void setLl(float f) {
    }

    @Override
    public float getLl() {
        return 0.0f;
    }

    @Override
    public float getKafLl() {
        return 0.0f;
    }

    @Override
    public float getModLl() {
        return 0.0f;
    }

    @Override
    public String getOutLl() {
        return "";
    }

    @Override
    public void setLz(int n) {
        this.lz = (byte)n;
    }

    @Override
    public int getLz() {
        return this.lz;
    }

    @Override
    public int getKafLz() {
        return this.lz;
    }

    @Override
    public int getModLz() {
        return this.lz;
    }

    @Override
    public String getOutLz() {
        return this.lz > 0 ? IFormat.i1.format(this.lz) : " ";
    }

    @Override
    public void setEa(int n) {
    }

    @Override
    public int getEa() {
        return 0;
    }

    @Override
    public int getKafEa() {
        return 0;
    }

    @Override
    public int getModEa() {
        return 0;
    }

    @Override
    public String getOutEa() {
        return "";
    }

    @Override
    public void setEq(int n) {
    }

    @Override
    public int getEq() {
        return 0;
    }

    @Override
    public int getKafEq() {
        return 0;
    }

    @Override
    public int getModEq() {
        return 0;
    }

    @Override
    public String getOutEq() {
        return "";
    }

    @Override
    public void setHg(int n) {
        this.hg = (byte)n;
    }

    @Override
    public int getHg() {
        return this.hg;
    }

    @Override
    public int getKafHg() {
        return this.hg;
    }

    @Override
    public int getModHg() {
        return this.hg;
    }

    @Override
    public String getOutHg() {
        return this.hg > 0 ? IFormat.i1.format(this.hg) : " ";
    }

    @Override
    public void setHs(int n) {
        this.hs = (short)n;
    }

    @Override
    public int getHs() {
        return this.hs;
    }

    @Override
    public int getKafHs() {
        return this.hs;
    }

    @Override
    public int getModHs() {
        return this.hs;
    }

    @Override
    public String getOutHs() {
        return this.hs > 0 ? IFormat.i03.format(this.hs) : "   ";
    }

    @Override
    public void setEb(int n) {
        this.eb = (byte)n;
    }

    @Override
    public int getEb() {
        return this.eb;
    }

    @Override
    public int getKafEb() {
        return this.eb;
    }

    @Override
    public int getModEb() {
        return this.eb;
    }

    @Override
    public String getOutEb() {
        return this.eb > 0 ? IFormat.i02.format(this.eb) : "  ";
    }

    @Override
    public void setOska(int n) {
        this.oska = (short)n;
    }

    @Override
    public int getOska() {
        return this.oska;
    }

    @Override
    public int getKafOska() {
        return this.oska;
    }

    @Override
    public int getModOska() {
        return this.oska;
    }

    @Override
    public String getOutOska() {
        return this.oska > 0 ? IFormat.i04.format(this.oska) : "    ";
    }

    @Override
    public void setPst(int n) {
        this.pst = (byte)n;
    }

    @Override
    public int getPst() {
        return this.pst;
    }

    @Override
    public int getKafPst() {
        return this.pst;
    }

    @Override
    public int getModPst() {
        return this.pst;
    }

    @Override
    public String getOutPst() {
        return this.pst > -1 ? IFormat.i1.format(this.pst) : " ";
    }

    @Override
    public void setPq(int n) {
    }

    @Override
    public int getPq() {
        return 0;
    }

    @Override
    public int getKafPq() {
        return 0;
    }

    @Override
    public int getModPq() {
        return 0;
    }

    @Override
    public String getOutPq() {
        return "";
    }

    @Override
    public void setArt(int n) {
    }

    @Override
    public int getArt() {
        return 0;
    }

    @Override
    public int getKafArt() {
        return 0;
    }

    @Override
    public int getModArt() {
        return 0;
    }

    @Override
    public String getOutArt() {
        return "";
    }

    @Override
    public void setFolie(int n) {
        this.folie = (short)n;
    }

    @Override
    public int getFolie() {
        return this.folie;
    }

    @Override
    public int getKafFolie() {
        return this.folie;
    }

    @Override
    public int getModFolie() {
        return this.folie;
    }

    @Override
    public String getOutFolie() {
        return this.folie > 0 ? IFormat.i03.format(this.folie) : "   ";
    }

    @Override
    public boolean isKatasterElement() {
        return this.pa > 0;
    }

    @Override
    public PunktParameter toAlkModel() {
        return (PunktParameter)this.clone();
    }

    public int hashCode() {
        return this.pa * 1000000 + this.va * 1000 + this.oska;
    }

    public boolean equals(Object object) {
        if (object instanceof PunktParameterALK) {
            PunktParameterALK punktParameterALK = (PunktParameterALK)object;
            return this.pa == punktParameterALK.pa && this.lg == punktParameterALK.lg && this.hg == punktParameterALK.hg && this.eb == punktParameterALK.eb && this.lz == punktParameterALK.lz && this.va == punktParameterALK.va && this.ls == punktParameterALK.ls && this.hs == punktParameterALK.hs && this.vva == punktParameterALK.vva && this.vvt == punktParameterALK.vvt && this.oska == punktParameterALK.oska && this.folie == punktParameterALK.folie && this.pst == punktParameterALK.pst;
        }
        return false;
    }

    @Override
    public boolean isVoid() {
        return this.equals(VOID);
    }

    public String toString() {
        return "pa  = " + this.pa + "\nlg  = " + this.lg + "\nhg  = " + this.hg + "\neb  = " + this.eb + "\nlz  = " + this.lz + "\nva  = " + this.va + "\nls  = " + this.ls + "\nhs  = " + this.hs + "\nvva = " + this.vva + "\nvvt = " + this.vvt + "\nos  = " + this.oska + "\npst = " + this.pst + "\nfolie = " + this.folie;
    }

    @Override
    protected void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(121);
        dataOutput.writeByte(this.pa);
        dataOutput.writeByte(this.eb);
        dataOutput.writeByte(this.lz);
        dataOutput.writeByte(this.hg);
        dataOutput.writeByte(this.pst);
        dataOutput.writeShort(this.va);
        dataOutput.writeShort(this.ls);
        dataOutput.writeShort(this.hs);
        dataOutput.writeShort(this.vva);
        dataOutput.writeShort(this.vvt);
        dataOutput.writeShort(this.oska);
        dataOutput.writeShort(this.folie);
        dataOutput.writeChar(this.lg);
    }

    protected static PunktParameter readObject(DataInput dataInput) throws IOException {
        PunktParameterALK punktParameterALK = new PunktParameterALK();
        punktParameterALK.pa = dataInput.readByte();
        punktParameterALK.eb = dataInput.readByte();
        punktParameterALK.lz = dataInput.readByte();
        punktParameterALK.hg = dataInput.readByte();
        punktParameterALK.pst = dataInput.readByte();
        punktParameterALK.va = dataInput.readShort();
        punktParameterALK.ls = dataInput.readShort();
        punktParameterALK.hs = dataInput.readShort();
        punktParameterALK.vva = dataInput.readShort();
        punktParameterALK.vvt = dataInput.readShort();
        punktParameterALK.oska = dataInput.readShort();
        punktParameterALK.folie = dataInput.readShort();
        punktParameterALK.lg = (short)dataInput.readChar();
        return punktParameterALK;
    }

    @Override
    public boolean checkConsistency() throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = this.getModVa();
        switch (n) {
            case 98: 
            case 99: {
                bl2 = true;
            }
        }
        block3 : switch (this.pa) {
            case 0: {
                if (this.eb != 19 && this.eb != 59) {
                    bl4 = true;
                }
                if (this.oska == 0) {
                    bl6 = true;
                    break;
                }
                switch (this.oska) {
                    case 161: 
                    case 162: 
                    case 164: 
                    case 165: 
                    case 966: {
                        break block3;
                    }
                }
                bl5 = true;
                break;
            }
            case 1: {
                if (this.eb != 19 && this.eb != 59) {
                    bl4 = true;
                }
                if (this.oska == 0) {
                    bl6 = true;
                    break;
                }
                if (this.oska == 122 || this.oska == 123) break;
                bl5 = true;
                break;
            }
            case 2: {
                if (n == 0) {
                    bl3 = true;
                } else if (n < 0 || n == 41 || n == 42 || n == 43 || n == 44) {
                    bl2 = true;
                }
                switch (this.eb) {
                    case 1: 
                    case 41: 
                    case 48: 
                    case 49: {
                        break;
                    }
                    default: {
                        bl4 = true;
                    }
                }
                if (this.oska == 0) {
                    bl6 = true;
                    break;
                }
                if (this.oska == 117 || this.oska == 118 || this.oska == 119) break;
                bl5 = true;
                break;
            }
            case 3: {
                if (n == 0) {
                    bl3 = true;
                } else if (n != 70 && n != 41 && n != 42 && n != 43 && n != 44 && n != 94) {
                    bl2 = true;
                }
                if (this.eb != 2 && this.eb != 42) {
                    bl4 = true;
                }
                if (this.oska == 0) {
                    bl6 = true;
                    break;
                }
                if (this.oska == 151) break;
                bl5 = true;
                break;
            }
            case 4: {
                if (n == 0) {
                    bl3 = true;
                } else if (n < 0) {
                    bl2 = true;
                }
                switch (this.eb) {
                    case 1: 
                    case 2: 
                    case 41: 
                    case 42: 
                    case 48: 
                    case 49: {
                        bl4 = true;
                    }
                }
                if (this.oska == 0) {
                    bl6 = true;
                    break;
                }
                if (this.oska == 152) break;
                bl5 = true;
                break;
            }
            case 7: {
                if (n == 0) {
                    bl3 = true;
                } else if (n < 0) {
                    bl2 = true;
                }
                switch (this.eb) {
                    case 1: 
                    case 2: 
                    case 41: 
                    case 42: 
                    case 48: 
                    case 49: {
                        bl4 = true;
                    }
                }
                if (this.oska == 0 || this.oska == 123) break;
                bl5 = true;
                break;
            }
            case 8: 
            case 9: {
                if (n == 0) {
                    bl3 = true;
                } else if (n < 0) {
                    bl2 = true;
                }
                switch (this.eb) {
                    case 1: 
                    case 2: 
                    case 41: 
                    case 42: 
                    case 48: 
                    case 49: {
                        bl4 = true;
                    }
                }
                if (this.oska == 0 || this.oska == 148) break;
                bl5 = true;
            }
        }
        boolean bl7 = false;
        if (bl3 || bl2 || bl || bl4 || bl6 || bl5) {
            StringBuffer stringBuffer = new StringBuffer("ung\u00fcltige ");
            if (bl3 && KafkaIOProperties.isPPVa0Test()) {
                stringBuffer.append("Vermarkungsart ");
                bl7 = true;
            }
            if (bl2 && KafkaIOProperties.isPPVaTest()) {
                stringBuffer.append("Vermarkungsart ");
                bl7 = true;
            }
            if (bl && KafkaIOProperties.isPPPaTest()) {
                stringBuffer.append("Punktart ");
                bl7 = true;
            }
            if (bl4 && KafkaIOProperties.isPPEbTest()) {
                stringBuffer.append("Ebene ");
                bl7 = true;
            }
            if (bl6 && KafkaIOProperties.isPPOs0Test()) {
                stringBuffer.append("Objektschl\u00fcssel ");
                bl7 = true;
            }
            if (bl5 && KafkaIOProperties.isPPOsTest()) {
                stringBuffer.append("Objektschl\u00fcssel ");
                bl7 = true;
            }
            if (bl7) {
                throw new Exception(stringBuffer.toString());
            }
        }
        return !bl7;
    }
}

