/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.EntstehungsArt;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kataster.model.AX_Punktort;
import de.geocalc.text.IFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PunktParameterALKIS
extends PunktParameter
implements Cloneable {
    private byte pa = (byte)-1;
    private byte eb = 0;
    private byte pst = (byte)-1;
    private byte lz;
    private byte ea;
    private short va = 0;
    private short vb = 0;
    private short vva = 0;
    private short vvt;
    private short lg = 0;
    private short ls;
    private short eq;
    private short art;
    private float ll;

    public void setOrtParameters(AX_Punktort aX_Punktort) {
        this.setLz(aX_Punktort.lagezuverlaessigkeit);
        this.setLg(aX_Punktort.genauigkeitsstufe);
        this.setEa(aX_Punktort.entstehungsart);
        this.setEq(aX_Punktort.entstehungsqual);
        this.setLl(aX_Punktort.genauigkeitswert);
        this.setLs(aX_Punktort.koordinatenstatus);
        this.setPst(10);
    }

    public PunktParameterALKIS() {
    }

    public PunktParameterALKIS(int n, int n2) {
        this.setParameter(n, n2);
    }

    public PunktParameterALKIS(int n, long l) {
        this.setParameter(n, l);
    }

    @Override
    public int getModel() {
        return 2;
    }

    @Override
    public void setParameter(int n, long l) {
        this.setParameter(n, (int)l);
    }

    @Override
    public void setParameter(int n, int n2) {
        switch (n) {
            case 1: {
                this.pa = (byte)n2;
                break;
            }
            case 16: {
                this.lg = (short)n2;
                break;
            }
            case 2: {
                this.eb = (byte)n2;
                break;
            }
            case 64: {
                this.lz = (byte)n2;
                break;
            }
            case 4: {
                this.va = (short)n2;
                break;
            }
            case 512: {
                this.vva = (short)n2;
                break;
            }
            case 1024: {
                this.vvt = (short)n2;
                break;
            }
            case 4096: {
                this.pst = (byte)n2;
                break;
            }
            case 16384: {
                this.vb = (short)n2;
            }
        }
    }

    @Override
    public void addParameter(PunktParameter punktParameter) {
        PunktParameterALKIS punktParameterALKIS = (PunktParameterALKIS)punktParameter;
        if (this.pa == -1 && punktParameterALKIS.pa != -1) {
            this.pa = punktParameterALKIS.pa;
        }
        if (this.lg == 0 && punktParameterALKIS.lg != 0) {
            this.lg = punktParameterALKIS.lg;
        }
        if (this.eb <= 0 && punktParameterALKIS.eb > 0) {
            this.eb = punktParameterALKIS.eb;
        }
        if (this.lz <= 0 && punktParameterALKIS.lz >= 0) {
            this.lz = punktParameterALKIS.lz;
        }
        if (this.va <= 0 && punktParameterALKIS.va > 0) {
            this.va = punktParameterALKIS.va;
        }
        if (this.vva <= 0 && punktParameterALKIS.vva > 0) {
            this.vva = punktParameterALKIS.vva;
        }
        if (this.vvt == 0 && punktParameterALKIS.vvt != 0) {
            this.vvt = punktParameterALKIS.vvt;
        }
        if (this.pst <= -1 && punktParameterALKIS.pst > -1) {
            this.pst = punktParameterALKIS.pst;
        }
        if (this.vb <= 0 && punktParameterALKIS.vb > 0) {
            this.vb = punktParameterALKIS.vb;
        }
    }

    @Override
    public void setPa(int n) {
        this.pa = (byte)n;
        switch (n) {
            case 10: {
                this.eb = (byte)19;
                break;
            }
            case 11: {
                this.eb = (byte)19;
                break;
            }
            case 20: 
            case 29: {
                this.eb = 1;
                break;
            }
            case 30: 
            case 39: {
                this.eb = (byte)2;
                break;
            }
            case 40: 
            case 49: {
                this.eb = (byte)2;
                break;
            }
            case 50: 
            case 92: {
                this.eb = (byte)3;
                break;
            }
            case 60: {
                this.eb = (byte)19;
                break;
            }
            case 71: {
                this.eb = (byte)19;
                break;
            }
            case 72: 
            case 73: {
                this.eb = (byte)18;
                break;
            }
            case 74: {
                this.eb = (byte)19;
                break;
            }
            case 91: {
                this.eb = (byte)7;
                break;
            }
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                this.eb = (byte)50;
            }
        }
    }

    @Override
    public int getPa() {
        return this.pa;
    }

    @Override
    public int getKafPa() {
        return PunktArt.getArt(this.pa).getKafArt();
    }

    @Override
    public int getModPa() {
        return this.pa;
    }

    @Override
    public String getOutPa() {
        return IFormat.getLeftString(PunktArt.toIdString(this.pa), 3, ' ');
    }

    @Override
    public void setVa(int n) {
        this.va = (short)n;
    }

    public boolean hasVa() {
        return this.va > 0;
    }

    @Override
    public int getVa() {
        return this.va;
    }

    @Override
    public int getKafVa() {
        return VermarkungsArt.getVermarkungsArt(this.va).getKafArt();
    }

    @Override
    public int getModVa() {
        return VermarkungsArt.getVermarkungsArt(this.va).getModArt();
    }

    @Override
    public String getOutVa() {
        return this.va > 0 ? IFormat.i4.format(this.va).toString() : "    ";
    }

    @Override
    public void setVb(int n) {
        this.vb = (short)n;
    }

    public boolean hasVb() {
        return this.vb > 0;
    }

    @Override
    public int getVb() {
        return this.vb;
    }

    @Override
    public int getKafVb() {
        return this.vb;
    }

    @Override
    public int getModVb() {
        return this.vb;
    }

    @Override
    public String getOutVb() {
        return this.vb > 0 ? IFormat.i4.format(this.vb) : "    ";
    }

    @Override
    public void setVva(int n) {
        this.vva = (short)n;
    }

    public boolean hasVva() {
        return this.vva > 0;
    }

    @Override
    public int getVva() {
        return this.vva;
    }

    @Override
    public int getKafVva() {
        return VermarkungsArt.getVermarkungsArt(this.vva).getKafArt();
    }

    @Override
    public int getModVva() {
        return VermarkungsArt.getVermarkungsArt(this.vva).getModArt();
    }

    @Override
    public String getOutVva() {
        return this.vva > 0 ? IFormat.i4.format(this.vva).toString() : "    ";
    }

    @Override
    public void setVvt(int n) {
        this.vvt = (short)n;
    }

    @Override
    public int getVvt() {
        return this.vvt;
    }

    @Override
    public int getKafVvt() {
        return this.vvt;
    }

    @Override
    public int getModVvt() {
        return this.vvt;
    }

    @Override
    public String getOutVvt() {
        return this.vvt != 0 ? IFormat.i3.format(this.vvt) : "   ";
    }

    @Override
    public void setLs(int n) {
        this.ls = (short)n;
    }

    @Override
    public int getLs() {
        return this.ls;
    }

    @Override
    public int getKafLs() {
        return this.ls;
    }

    @Override
    public int getModLs() {
        return this.ls;
    }

    @Override
    public String getOutLs() {
        return this.ls <= 0 ? "    " : IFormat.i4.format(this.ls);
    }

    @Override
    public void setLg(int n) {
        this.lg = (short)n;
    }

    @Override
    public int getLg() {
        return this.lg;
    }

    @Override
    public int getKafLg() {
        switch (this.lg) {
            case 2100: {
                return 1;
            }
            case 2200: {
                return 2;
            }
            case 2300: {
                return 3;
            }
            case 3000: {
                return 4;
            }
            case 3100: {
                return 5;
            }
            case 3200: {
                return 6;
            }
            case 3300: {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public int getModLg() {
        return this.lg;
    }

    @Override
    public String getOutLg() {
        if (this.lg == 0) {
            return "    ";
        }
        return IFormat.i4.format(this.lg);
    }

    @Override
    public void setLl(float f) {
        this.ll = f;
    }

    @Override
    public float getLl() {
        return this.ll;
    }

    @Override
    public float getKafLl() {
        return this.ll;
    }

    @Override
    public float getModLl() {
        return this.ll;
    }

    @Override
    public String getOutLl() {
        return this.ll != 0.0f ? IFormat.f2_3.format(this.ll) : "      ";
    }

    @Override
    public void setLz(int n) {
        this.lz = (byte)n;
    }

    @Override
    public int getLz() {
        return this.lz;
    }

    @Override
    public int getKafLz() {
        return this.lz;
    }

    @Override
    public int getModLz() {
        return this.lz;
    }

    @Override
    public String getOutLz() {
        return this.lz > 0 ? IFormat.i1.format(this.lz) : " ";
    }

    @Override
    public void setEa(int n) {
        this.ea = (byte)n;
    }

    @Override
    public int getEa() {
        return this.ea;
    }

    @Override
    public int getKafEa() {
        return this.ea;
    }

    @Override
    public int getModEa() {
        return this.ea;
    }

    @Override
    public String getOutEa() {
        return EntstehungsArt.toStringId(this.ea);
    }

    @Override
    public void setEq(int n) {
        this.eq = (short)n;
    }

    @Override
    public int getEq() {
        return this.eq;
    }

    @Override
    public int getKafEq() {
        return this.eq;
    }

    @Override
    public int getModEq() {
        return this.eq;
    }

    @Override
    public String getOutEq() {
        if (this.eq == 0) {
            return this.getKafPa() == 0 ? IFormat.i4.format(1000L) : "    ";
        }
        return IFormat.i4.format(this.eq);
    }

    @Override
    public void setHs(int n) {
    }

    @Override
    public int getHs() {
        return 0;
    }

    @Override
    public int getKafHs() {
        return 0;
    }

    @Override
    public int getModHs() {
        return 0;
    }

    @Override
    public String getOutHs() {
        return "";
    }

    @Override
    public void setHg(int n) {
    }

    @Override
    public int getHg() {
        return 0;
    }

    @Override
    public int getKafHg() {
        return 0;
    }

    @Override
    public int getModHg() {
        return 0;
    }

    @Override
    public String getOutHg() {
        return "";
    }

    @Override
    public void setPst(int n) {
        this.pst = (byte)n;
    }

    @Override
    public int getPst() {
        return this.pst;
    }

    @Override
    public int getKafPst() {
        return this.pst;
    }

    @Override
    public int getModPst() {
        return this.pst;
    }

    @Override
    public String getOutPst() {
        if (this.pst == 14) {
            return "+";
        }
        if (this.pst == 13) {
            return "-";
        }
        if (this.pst == 15) {
            return "0";
        }
        return " ";
    }

    @Override
    public void setPq(int n) {
    }

    @Override
    public int getPq() {
        if (this.getKafPa() > 0) {
            if (this.eq == 1000 && this.ea == 1) {
                if (this.lg == 2100 || this.ll > 0.0f && this.ll <= 0.03f) {
                    if (this.lz == 2) {
                        return 1;
                    }
                    return 2;
                }
                return 3;
            }
            return 4;
        }
        return 0;
    }

    @Override
    public int getKafPq() {
        return this.getPq();
    }

    @Override
    public int getModPq() {
        return this.getPq();
    }

    @Override
    public String getOutPq() {
        return Integer.toString(this.getPq());
    }

    @Override
    public void setArt(int n) {
        this.art = (short)n;
    }

    public boolean hasArt() {
        return this.art != 0;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public int getKafArt() {
        return this.art;
    }

    @Override
    public int getModArt() {
        return this.art;
    }

    @Override
    public String getOutArt() {
        return this.art > 0 ? IFormat.i4.format(this.art) : "    ";
    }

    @Override
    public void setEb(int n) {
        this.eb = (byte)n;
    }

    @Override
    public int getEb() {
        return this.eb;
    }

    @Override
    public int getKafEb() {
        return this.eb;
    }

    @Override
    public int getModEb() {
        return this.eb;
    }

    @Override
    public String getOutEb() {
        return Integer.toString(this.eb);
    }

    @Override
    public void setOska(int n) {
    }

    @Override
    public int getOska() {
        switch (this.pa) {
            case 10: {
                return 13001;
            }
            case 11: {
                return 13002;
            }
            case 20: 
            case 29: {
                return 11003;
            }
            case 30: 
            case 39: {
                return 31005;
            }
            case 40: 
            case 49: {
                return 51011;
            }
            case 50: {
                return 61009;
            }
            case 60: {
                return 13003;
            }
            case 71: {
                return 19001;
            }
            case 72: {
                return 19002;
            }
            case 73: {
                return 19003;
            }
            case 74: {
                return 19004;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                return 61009;
            }
        }
        return 0;
    }

    @Override
    public int getKafOska() {
        return this.getOska();
    }

    @Override
    public int getModOska() {
        return this.getOska();
    }

    @Override
    public String getOutOska() {
        return IFormat.i5.format(this.getOska());
    }

    @Override
    public void setFolie(int n) {
    }

    @Override
    public int getFolie() {
        return 0;
    }

    @Override
    public int getKafFolie() {
        return 0;
    }

    @Override
    public int getModFolie() {
        return 0;
    }

    @Override
    public String getOutFolie() {
        return "";
    }

    public int hashCode() {
        return this.pa * 1000000 + this.va * 1000;
    }

    public boolean equals(Object object) {
        if (object instanceof PunktParameterALKIS) {
            PunktParameterALKIS punktParameterALKIS = (PunktParameterALKIS)object;
            return this.pa == punktParameterALKIS.pa && this.vb == punktParameterALKIS.vb && this.va == punktParameterALKIS.va && this.vva == punktParameterALKIS.vva && this.vvt == punktParameterALKIS.vvt && this.lg == punktParameterALKIS.lg && this.ll == punktParameterALKIS.ll && this.lz == punktParameterALKIS.lz && this.ea == punktParameterALKIS.ea && this.eq == punktParameterALKIS.eq && this.pst == punktParameterALKIS.pst && this.art == punktParameterALKIS.art && this.ls == punktParameterALKIS.ls && this.eb == punktParameterALKIS.eb;
        }
        return false;
    }

    @Override
    public boolean isVoid() {
        return this.equals(VOID);
    }

    @Override
    public boolean isKatasterElement() {
        return this.pa > 0;
    }

    public String toString() {
        return "pa  = " + this.pa + "\nlg  = " + this.lg + "\neb  = " + this.eb + "\nlz  = " + this.lz + "\nva  = " + this.va + "\nvb  = " + this.vb + "\nvva = " + this.vva + "\nvvt = " + this.vvt + "\npst = " + this.pst;
    }

    @Override
    protected void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(122);
        dataOutput.writeByte(this.pa);
        dataOutput.writeShort(this.va);
        dataOutput.writeShort(this.vb);
        dataOutput.writeShort(this.vva);
        dataOutput.writeShort(this.vvt);
        dataOutput.writeShort(this.lg);
        dataOutput.writeFloat(this.ll);
        dataOutput.writeByte(this.lz);
        dataOutput.writeByte(this.ea);
        dataOutput.writeShort(this.eq);
        dataOutput.writeByte(this.pst);
        dataOutput.writeShort(this.art);
        dataOutput.writeByte(this.eb);
        dataOutput.writeShort(this.getOska());
        dataOutput.writeShort(this.ls);
    }

    protected static PunktParameter readObject(DataInput dataInput) throws IOException {
        PunktParameterALKIS punktParameterALKIS = new PunktParameterALKIS();
        punktParameterALKIS.pa = dataInput.readByte();
        punktParameterALKIS.va = dataInput.readShort();
        punktParameterALKIS.vb = dataInput.readShort();
        punktParameterALKIS.vva = dataInput.readShort();
        punktParameterALKIS.vvt = dataInput.readShort();
        punktParameterALKIS.lg = dataInput.readShort();
        punktParameterALKIS.ll = dataInput.readFloat();
        punktParameterALKIS.lz = dataInput.readByte();
        punktParameterALKIS.ea = dataInput.readByte();
        punktParameterALKIS.eq = dataInput.readShort();
        punktParameterALKIS.pst = dataInput.readByte();
        punktParameterALKIS.art = dataInput.readShort();
        punktParameterALKIS.eb = dataInput.readByte();
        dataInput.readShort();
        punktParameterALKIS.ls = dataInput.readShort();
        return punktParameterALKIS;
    }

    @Override
    public PunktParameter toAlkModel() {
        PunktParameterALK punktParameterALK = new PunktParameterALK();
        punktParameterALK.setPa(PunktArt.AlkisToAlk(this.pa));
        punktParameterALK.setVa(VermarkungsArt.AlkisToAlk(this.getModVa(), this.getModVb()));
        punktParameterALK.setVva(VermarkungsArt.AlkisToAlk(this.getModVva(), 0));
        punktParameterALK.setVvt(this.getVvt());
        punktParameterALK.setLg(Lagegenauigkeit.AlkisToAlk(this.getModLg()));
        punktParameterALK.setLl(this.getModLl());
        punktParameterALK.setLz(this.getModLz());
        punktParameterALK.setPst(this.getModPst());
        punktParameterALK.setEb(this.getModEb());
        punktParameterALK.setOska(Oska.createOska(punktParameterALK.getModPa(), punktParameterALK.getModVa()));
        punktParameterALK.setFolie(Oska.getFolie(punktParameterALK.getModOska()));
        return punktParameterALK;
    }

    private String addErr(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + ", " + string2;
    }

    @Override
    public boolean checkConsistency() throws Exception {
        int n = this.getKafPa();
        boolean bl = n > 0;
        boolean bl2 = bl && this.pst != 13;
        String string = null;
        if (KafkaIOProperties.isPPLgTest()) {
            if (this.ll < 0.0f) {
                string = this.addErr(string, "GWT ung\u00fcltig");
            }
            if (this.lg == 0) {
                if (this.ll == 0.0f && bl2) {
                    string = this.addErr(string, "GST fehlt");
                }
            } else {
                if (this.ll != 0.0f) {
                    string = this.addErr(string, "nur GST oder GWT m\u00f6glich");
                }
                switch (this.lg) {
                    case 2100: 
                    case 2200: 
                    case 2300: 
                    case 3000: 
                    case 3100: 
                    case 3200: 
                    case 3300: {
                        break;
                    }
                    default: {
                        string = this.addErr(string, "GST ung\u00fcltig");
                    }
                }
            }
            if (this.lz <= 0) {
                if (bl2) {
                    string = this.addErr(string, "LZK fehlt");
                }
            } else if (this.lz != 1 && this.lz != 2) {
                string = this.addErr(string, "LZK ung\u00fcltig");
            }
            if (this.ea == 0) {
                if (bl2) {
                    string = this.addErr(string, "P (DES1) fehlt");
                }
            } else if (this.ea != 1 && this.ea != 2) {
                string = this.addErr(string, "P (DES1) ung\u00fcltig");
            }
            if (this.eq == 0) {
                if (bl2) {
                    string = this.addErr(string, "Q (DES2) fehlt");
                }
            } else if (this.eq != 1000 && this.eq != 2000 && this.eq != 4100 && this.eq != 4200 && this.eq != 4300) {
                if (this.eq == 9998) {
                    if (bl2) {
                        string = this.addErr(string, "Q (DES2) ung\u00fcltig");
                    }
                } else {
                    string = this.addErr(string, "Q (DES2) ung\u00fcltig");
                }
            }
        }
        if (KafkaIOProperties.isPPPaTest()) {
            if (this.pa == 39) {
                if (this.art == 0) {
                    string = this.addErr(string, "ART fehlt");
                } else if (this.art != 1100 && this.art != 1200 && this.art != 2100 && this.art != 2200) {
                    string = this.addErr(string, "ART ung\u00fcltig");
                }
            } else if (this.art != 0) {
                string = this.addErr(string, "ART unzul\u00e4ssig");
            }
        }
        if (KafkaIOProperties.isPPVaTest()) {
            int n2 = this.getModVa();
            switch (this.pa) {
                case 30: 
                case 39: 
                case 40: 
                case 49: 
                case 50: {
                    if (n2 == 0) break;
                    string = this.addErr(string, "ABM unzul\u00e4ssig");
                    break;
                }
                default: {
                    if (n2 <= 0) {
                        if (!bl2) break;
                        string = this.addErr(string, "ABM fehlt");
                        break;
                    }
                    if (n2 >= 1000 && n2 <= 9998 && VermarkungsArt.getVermarkungsArt(n2) != VermarkungsArt.UNKNOWN) break;
                    string = this.addErr(string, "ABM ung\u00fcltig");
                }
            }
            if (n == 1) {
                if (this.vb != 0 && this.vb != 1000 && this.vb != 4000) {
                    string = this.addErr(string, "BZA ung\u00fcltig");
                }
                if ((n2 = this.getKafVva()) != 0 && VermarkungsArt.isVermarkt(n2) && VermarkungsArt.isVermarkt(this.getKafVa()) && this.vb != 1000) {
                    string = this.addErr(string, "BZA aufgrund ABMV setzen");
                }
            } else if (this.vb != 0) {
                string = this.addErr(string, "BZA unzul\u00e4ssig");
            }
            if (this.vvt != 0 && this.getKafVa() == 0) {
                string = this.addErr(string, "RHO ohne ABM ung\u00fcltig");
            }
            n2 = this.getModVva();
            switch (this.pa) {
                case 30: 
                case 39: 
                case 40: 
                case 49: 
                case 50: {
                    break;
                }
                default: {
                    if (n2 <= 0 || n2 >= 1000 && n2 <= 9999 && VermarkungsArt.getVermarkungsArt(n2) != VermarkungsArt.UNKNOWN) break;
                    string = this.addErr(string, "ABMV ung\u00fcltig");
                }
            }
        }
        if (KafkaIOProperties.isPPLgTest() && this.ls != 1000) {
            if (bl2) {
                string = this.addErr(string, "KST unzul\u00e4ssig");
            } else if (this.ls != 0) {
                string = this.addErr(string, "KST unzul\u00e4ssig");
            }
        }
        if (string != null) {
            throw new Exception(string);
        }
        return false;
    }
}

