/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IProgressElement;
import de.geocalc.kafplot.Punkt;
import de.geocalc.util.Comparator;
import de.geocalc.util.LongHashList;
import de.geocalc.util.SortableVector;
import java.util.Enumeration;
import java.util.Vector;

public class PunktSorter
extends IProgressElement {
    public static final int SORT_BY_NUMBER = 1;
    public static final int SORT_BY_NB = 2;
    public static final int SORT_BY_LOKAL_NUMBER = 11;
    public static final int SORT_BY_LOKAL_NB = 12;
    public static final int SORT_BY_KAT_NUMBER = 21;
    public static final int SORT_BY_KAT_NB = 22;
    public static final int SORT_BY_KAT_NB_NUM6 = 23;
    private LongHashList HP;
    private Vector VP;
    private int sortModus;

    public PunktSorter(LongHashList longHashList) {
        this(longHashList, 1);
    }

    public PunktSorter(LongHashList longHashList, int n) {
        super.setEndValue(longHashList.size());
        super.setProgressBreak();
        this.HP = longHashList;
        this.sortModus = n;
    }

    public PunktSorter(Vector vector) {
        this(vector, 1);
    }

    public PunktSorter(Vector vector, int n) {
        super.setEndValue(vector.size());
        super.setProgressBreak();
        this.VP = vector;
        this.sortModus = n;
    }

    public int size() {
        return this.HP != null ? this.HP.size() : this.VP.size();
    }

    public Vector getSortedVector() {
        Enumeration enumeration;
        SortableVector sortableVector = new SortableVector(this.HP != null ? this.HP.size() : this.VP.size());
        Comparator comparator = null;
        switch (this.sortModus) {
            case 1: {
                comparator = new NumberComparator();
                break;
            }
            case 2: {
                comparator = new NbComparator();
                break;
            }
            case 11: {
                comparator = new LocalNumberComparator();
                break;
            }
            case 12: {
                comparator = new LocalNbComparator();
                break;
            }
            case 21: {
                comparator = new KatNumberComparator();
                break;
            }
            case 22: {
                comparator = new KatNbComparator();
                break;
            }
            case 23: {
                comparator = new KatNbPaComparator();
                break;
            }
            default: {
                comparator = new LocalNumberComparator();
            }
        }
        int n = 0;
        Enumeration enumeration2 = enumeration = this.HP != null ? this.HP.elements() : this.VP.elements();
        while (enumeration.hasMoreElements()) {
            sortableVector.addElement(enumeration.nextElement());
            ++n;
        }
        sortableVector.sort(comparator);
        return sortableVector;
    }

    private int c(long l) {
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    private final class NumberComparator
    implements Comparator {
        private NumberComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            return PunktSorter.this.c(((Punkt)object).getNr() - ((Punkt)object2).getNr());
        }
    }

    private final class NbComparator
    implements Comparator {
        private NbComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            Punkt punkt = (Punkt)object;
            Punkt punkt2 = (Punkt)object2;
            int n = Punkt.createNb(punkt.y, punkt.x) - Punkt.createNb(punkt2.y, punkt2.x);
            return n == 0 ? PunktSorter.this.c(punkt.getNr() - punkt2.getNr()) : n;
        }
    }

    private final class LocalNumberComparator
    implements Comparator {
        private LocalNumberComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            return PunktSorter.this.c(((Punkt)object).nr - ((Punkt)object2).nr);
        }
    }

    private final class LocalNbComparator
    implements Comparator {
        private LocalNbComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            Punkt punkt = (Punkt)object;
            Punkt punkt2 = (Punkt)object2;
            int n = Punkt.createNb(punkt.y, punkt.x) - Punkt.createNb(punkt2.y, punkt2.x);
            return n == 0 ? PunktSorter.this.c(punkt.nr - punkt2.nr) : n;
        }
    }

    private final class KatNumberComparator
    implements Comparator {
        private KatNumberComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            return PunktSorter.this.c(((Punkt)object).getKatNr() - ((Punkt)object2).getKatNr());
        }
    }

    private final class KatNbComparator
    implements Comparator {
        private KatNbComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            Punkt punkt = (Punkt)object;
            Punkt punkt2 = (Punkt)object2;
            int n = Punkt.createNb(punkt.y, punkt.x) - Punkt.createNb(punkt2.y, punkt2.x);
            return n == 0 ? PunktSorter.this.c(punkt.getKatNr() - punkt2.getKatNr()) : n;
        }
    }

    private final class KatNbPaComparator
    implements Comparator {
        private KatNbPaComparator() {
        }

        @Override
        public final int compare(Object object, Object object2) {
            Punkt punkt = (Punkt)object;
            Punkt punkt2 = (Punkt)object2;
            int n = Punkt.createNb(punkt.y, punkt.x) - Punkt.createNb(punkt2.y, punkt2.x);
            if (n != 0) {
                return n;
            }
            int n2 = punkt.getKafPa() - punkt2.getKafPa();
            if (n2 != 0) {
                return n2;
            }
            return PunktSorter.this.c(punkt.buildKatNr(6) - punkt2.buildKatNr(6));
        }
    }
}

