/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.PunktParameter;

public final class PunktStatus {
    public static final String UNDEF_STRING = "undef.Punktstatus";
    public static final String NEU_STRING = "Neupunkt";
    public static final String AUS_ART_STRING = "Aus Punktart";
    public static final String AUS_LG_STRING = "Aus Lagegenauigkeit";
    public static final String NAEHERUNG_STRING = "N\u00e4herungskoordinaten";
    public static final String FEST_STRING = "Festpunkt";
    public static final String BEWEGLICH_STRING = "beweglicher Punkt";
    public static final String HOEHE_STRING = "H\u00f6henpunkt";
    public static final String UNGUELTIG_STRING = "ung\u00fcltige Koordinaten";
    public static final int UNDEF = -9;
    public static final int AUS_LG = -3;
    public static final int NEU = -2;
    public static final int AUS_ART = -1;
    public static final int NAEHERUNG = 0;
    public static final int FEST = 1;
    public static final int BEWEGLICH = 2;
    public static final int HOEHE = 3;
    public static final int UNGUELTIG = 5;
    public static final int NORMAL = 0;
    public static final int SAP = 1;
    public static final int KATNEU = 2;

    public static String toString(int n) {
        switch (n) {
            case -3: {
                return AUS_LG_STRING;
            }
            case -2: {
                return NEU_STRING;
            }
            case -1: {
                return AUS_ART_STRING;
            }
            case 0: {
                return NAEHERUNG_STRING;
            }
            case 1: {
                return FEST_STRING;
            }
            case 2: {
                return BEWEGLICH_STRING;
            }
            case 3: {
                return HOEHE_STRING;
            }
            case 5: {
                return UNGUELTIG_STRING;
            }
        }
        return UNDEF_STRING;
    }

    public static String getString(int n) {
        return PunktStatus.toString(n);
    }

    public static int getStatus(String string) {
        if (string.equals(NEU_STRING)) {
            return -2;
        }
        if (string.equals(AUS_LG_STRING)) {
            return -3;
        }
        if (string.equals(AUS_ART_STRING)) {
            return -1;
        }
        if (string.equals(NAEHERUNG_STRING)) {
            return 0;
        }
        if (string.equals(FEST_STRING)) {
            return 1;
        }
        if (string.equals(BEWEGLICH_STRING)) {
            return 2;
        }
        if (string.equals(HOEHE_STRING)) {
            return 3;
        }
        if (string.equals(UNGUELTIG_STRING)) {
            return 5;
        }
        return -9;
    }

    public static String getKatasterStatusString(int n) {
        switch (n) {
            case 0: {
                return "KVZ";
            }
            case 1: {
                return "SAP";
            }
            case 2: {
                return "NEU";
            }
        }
        return "ohne";
    }

    public static int getDefaultPaStatus(int n) {
        switch (n) {
            case 7: 
            case 8: {
                return 1;
            }
        }
        return 2;
    }

    public static int getDefaultLgStatus(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static int getDefaultLspStatus(float f) {
        if ((double)f < KatasterParameter.LSP) {
            return 2;
        }
        return 0;
    }

    public static int getDefaultStatus(PunktParameter punktParameter) {
        int n = punktParameter.getKafLg();
        float f = punktParameter.getKafLl();
        switch (punktParameter.getKafPa()) {
            case 7: 
            case 8: {
                if (n == 0 && f > 0.0f && f <= 0.01f) {
                    return 1;
                }
                if (n == 1 || n == 2 || (double)f <= 0.03) {
                    return 2;
                }
                return 0;
            }
            case 1: 
            case 2: 
            case 3: {
                return n == 1 || n == 2 || f > 0.0f && f <= 0.03f ? 2 : 0;
            }
        }
        return 0;
    }

    public static float getDefaultGenauigkeit(PunktParameter punktParameter) {
        int n = punktParameter.getKafLg();
        float f = punktParameter.getKafLl();
        switch (punktParameter.getKafPa()) {
            case 7: 
            case 8: {
                return n == 1 || n == 0 && f > 0.0f && f <= 0.01f ? 0.015f : 0.025f;
            }
            case 1: {
                return 0.025f;
            }
            case 2: 
            case 3: {
                return 0.035f;
            }
        }
        return 0.035f;
    }

    public static boolean isFest(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }
}

