/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Punkt;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashList;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.Sorter;
import java.util.Enumeration;
import java.util.Vector;

public class PunktTable
extends LongHashList
implements Cloneable {
    public static int SEARCH_NUMBER = 0;
    public static int SEARCH_NEXT_NUMBER = 1;
    public static int SEARCH_BEFORE_NUMBER = 2;
    public static int SEARCH_FREE_NUMBER = 10;
    public static int SEARCH_RESERVED_NUMBER = 20;
    public static int SEARCH_LOKAL_NUMBER = 100;
    public static int SEARCH_UMNUM_NUMBER = 200;
    public static int INTERSECT_ONE = 1;
    public static int INTERSECT_ALL = 2;

    public PunktTable() {
    }

    public PunktTable(int n) {
        super(n);
    }

    public PunktTable(float f) {
        super(f);
    }

    public synchronized boolean intersect(PunktTable punktTable, int n) {
        if (n == INTERSECT_ALL) {
            boolean bl = false;
            Enumeration enumeration = punktTable.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (this.get(punkt.nr) == null) {
                    return false;
                }
                bl = true;
            }
            return bl;
        }
        return this.intersect(punktTable);
    }

    public synchronized boolean intersect(PunktTable punktTable) {
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            if (this.get(((Punkt)enumeration.nextElement()).nr) == null) continue;
            return true;
        }
        return false;
    }

    public synchronized int insert(PunktTable punktTable) {
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            this.put((LongHashObject)enumeration.nextElement());
        }
        return punktTable.size();
    }

    public synchronized void addElement(LongHashObject longHashObject) {
        this.put(longHashObject);
    }

    public synchronized void removeAllElements() {
        this.clear();
    }

    public synchronized void removeElement(LongHashObject longHashObject) {
        this.remove(longHashObject);
    }

    public synchronized long getNextFreeNumber(long l) {
        while (this.get(l) != null) {
            ++l;
        }
        return l;
    }

    public synchronized Punkt getSlave(Punkt punkt) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            long l;
            Punkt punkt2 = (Punkt)enumeration.nextElement();
            if (!punkt2.isSlavePoint() || (l = Long.parseLong(punkt2.getTag("REF").getValue())) != punkt.nr) continue;
            return punkt2;
        }
        return null;
    }

    public synchronized Punkt getMaster(Punkt punkt) {
        return (Punkt)this.get(Long.parseLong(punkt.getTag("REF").getValue()));
    }

    public synchronized SearchResult searchNumber(String string, int n) {
        if (IFormat.hasOnlyDigits(string)) {
            long l = 0L;
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l < 0L) {
                l = 0L;
            }
            switch (n) {
                case 0: {
                    Punkt punkt = null;
                    if (l > 0L && (punkt = (Punkt)this.get(l)) == null) {
                        punkt = this.searchUmnumPunkt(l);
                    }
                    return new SearchResult(this, Long.toString(l), punkt, (String)(punkt == null ? "Punkt nicht gefunden" : "Punkt: " + l));
                }
                case 111: {
                    while (this.get(++l) != null) {
                    }
                    return new SearchResult(this, Long.toString(l), "Nummer: " + l);
                }
                case 112: {
                    if (l > 0L) {
                        while (this.get(--l) != null) {
                        }
                    } else {
                        l = 0L;
                    }
                    return new SearchResult(this, Long.toString(l), (String)(l == 0L ? "keine freie Nummer" : "Nummer: " + l));
                }
                case 121: {
                    long l2 = Long.MAX_VALUE;
                    Enumeration enumeration = this.elements();
                    while (enumeration.hasMoreElements()) {
                        Punkt punkt = (Punkt)enumeration.nextElement();
                        if (punkt.nr <= l) continue;
                        l2 = Math.min(punkt.nr, l2);
                    }
                    if (l2 == Long.MAX_VALUE) {
                        l2 = l;
                    }
                    return new SearchResult(this, Long.toString(l2), (Punkt)this.get(l2), (String)(l2 == l ? "keine weitere belegte Nummer" : "Nummer: " + l2));
                }
                case 122: {
                    long l3 = 0L;
                    Enumeration enumeration = this.elements();
                    while (enumeration.hasMoreElements()) {
                        Punkt punkt = (Punkt)enumeration.nextElement();
                        if (punkt.nr >= l) continue;
                        l3 = Math.max(punkt.nr, l3);
                    }
                    if (l3 == 0L) {
                        l3 = l;
                    }
                    return new SearchResult(this, Long.toString(l3), (Punkt)this.get(l3), (String)(l3 == l ? "keine weitere belegte Nummer" : "Nummer: " + l3));
                }
                case 211: {
                    while (this.searchUmnumPunkt(++l) != null) {
                    }
                    return new SearchResult(this, Long.toString(l), "Nummer: " + l);
                }
                case 212: {
                    if (l > 0L) {
                        while (this.searchUmnumPunkt(--l) != null) {
                        }
                    } else {
                        l = 0L;
                    }
                    return new SearchResult(this, Long.toString(l), (String)(l == 0L ? "keine freie Nummer" : "Nummer: " + l));
                }
                case 221: {
                    long l4 = Long.MAX_VALUE;
                    Enumeration enumeration = this.elements();
                    while (enumeration.hasMoreElements()) {
                        Punkt punkt = (Punkt)enumeration.nextElement();
                        if (punkt.getUmnum() <= l) continue;
                        l4 = Math.min(punkt.getUmnum(), l4);
                    }
                    if (l4 == Long.MAX_VALUE) {
                        l4 = l;
                    }
                    return new SearchResult(this, Long.toString(l4), this.searchUmnumPunkt(l4), (String)(l4 == l ? "keine weitere belegte Nummer" : "Nummer: " + l4));
                }
                case 222: {
                    long l5 = 0L;
                    Enumeration enumeration = this.elements();
                    while (enumeration.hasMoreElements()) {
                        Punkt punkt = (Punkt)enumeration.nextElement();
                        if (punkt.getUmnum() >= l) continue;
                        l5 = Math.max(punkt.getUmnum(), l5);
                    }
                    if (l5 == 0L) {
                        l5 = l;
                    }
                    return new SearchResult(this, Long.toString(l5), this.searchUmnumPunkt(l5), (String)(l5 == l ? "keine weitere belegte Nummer" : "Nummer: " + l5));
                }
            }
            return new SearchResult(this, Long.toString(0L), "Fehler");
        }
        if (n != SEARCH_NUMBER) {
            return new SearchResult(this, string, "keine Mustersuche m\u00f6glich");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || IFormat.isPattern(c)) continue;
            return new SearchResult(this, string, "ung\u00fcltiges Suchmuster");
        }
        Vector<Punkt> vector = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!IFormat.equalsPattern(Long.toString(punkt.nr), string) && (punkt.getUmnum() <= 0L || !IFormat.equalsPattern(Long.toString(punkt.getUmnum()), string))) continue;
            if (vector == null) {
                vector = new Vector<Punkt>();
            }
            vector.addElement(punkt);
        }
        if (vector != null) {
            return new SearchResult(this, string, Sorter.sort(vector), null);
        }
        return new SearchResult(this, string, vector, "kein Punkt gefunden");
    }

    private Punkt searchUmnumPunkt(long l) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (punkt.getUmnum() != l) continue;
            return punkt;
        }
        return null;
    }

    class SearchResult {
        private String nr;
        private Punkt p;
        private String text;
        private Vector punkte;
        int i = 0;

        SearchResult(PunktTable punktTable, String string, String string2) {
            this.nr = string;
            this.text = string2;
        }

        SearchResult(PunktTable punktTable, String string, Punkt punkt, String string2) {
            this.nr = string;
            this.p = punkt;
            this.text = string2;
        }

        SearchResult(PunktTable punktTable, String string, Vector vector, String string2) {
            this.nr = string;
            this.punkte = vector;
            this.text = string2;
        }

        public String getNummer() {
            return this.nr;
        }

        public Punkt getPunkt() {
            if (this.punkte != null) {
                return this.punkte.size() > this.i ? (Punkt)this.punkte.elementAt(this.i) : null;
            }
            return this.i == 0 ? this.p : null;
        }

        public Punkt getNextPunkt() {
            if (this.punkte != null) {
                return this.punkte.size() > this.i ? (Punkt)this.punkte.elementAt(this.i++) : null;
            }
            return this.i++ == 0 ? this.p : null;
        }

        public boolean hasMoreElements() {
            if (this.punkte != null) {
                return this.punkte.size() > this.i + 1;
            }
            return this.i == 0;
        }

        public String getText() {
            if (this.punkte != null) {
                return "Punkt: " + ((Punkt)this.punkte.elementAt((int)this.i)).nr + "   (" + (this.i + 1) + " von " + this.punkte.size() + ")";
            }
            return this.text;
        }
    }
}

