/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFileDialogPanel;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.io.GeoFile;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ImportOptionDialog;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.AgaKooReader;
import de.geocalc.kafplot.io.CaddyKooReader;
import de.geocalc.kafplot.io.CsvReader;
import de.geocalc.kafplot.io.DbkReader;
import de.geocalc.kafplot.io.EdbsReader;
import de.geocalc.kafplot.io.FreeFormatReader;
import de.geocalc.kafplot.io.GeografPunktReader;
import de.geocalc.kafplot.io.GsbReader;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kafplot.io.IdbReader;
import de.geocalc.kafplot.io.K_SoftReader;
import de.geocalc.kafplot.io.KivReader;
import de.geocalc.kafplot.io.Lt3Reader;
import de.geocalc.kafplot.io.Lt7Reader;
import de.geocalc.kafplot.io.LtaReader;
import de.geocalc.kafplot.io.PdbReader;
import de.geocalc.kafplot.io.PdkReader;
import de.geocalc.kafplot.io.TtpReader;
import de.geocalc.kafplot.io.UmnumReader;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class ReadMengeDialog
extends IDialog
implements ActionListener {
    private static final String DO_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    IFileDialogPanel fp;
    private IProgressBar progressBar;
    private ExceptionList exceptions;
    private PunktTable MENGE;

    public ReadMengeDialog(IFrame iFrame, String string, PunktTable punktTable) {
        super(iFrame, string, false);
        this.MENGE = punktTable;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createFilePanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
        this.exceptions = new ExceptionList();
    }

    private IPanel createFilePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        gridBagConstraints.anchor = 17;
        this.fp = new IFileDialogPanel();
        iPanel.add(this.fp);
        this.fp.addFile("Mengedatei", null, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.fp, gridBagConstraints);
        this.progressBar = new IProgressBar();
        iPanel.add(this.progressBar);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        Button button = new Button(DO_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(ABORT_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DO_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.doAbortAction();
        }
    }

    @Override
    protected void doStandardAction() {
        IDialog iDialog;
        DataBase dataBase = DataBase.getInstance();
        File file = this.fp.getFile(0);
        this.progressBar.setValue(0);
        if (file == null) {
            return;
        }
        int n = -1;
        IFileReader iFileReader = null;
        int n2 = DataBase.MENGE.size();
        try {
            GeoFile geoFile = new GeoFile(file);
            n = geoFile.getFileTyp();
            switch (n) {
                case 121: {
                    iFileReader = new K_SoftReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 123: {
                    iFileReader = new GsbReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 125: {
                    iFileReader = new DbkReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 124: {
                    iFileReader = new EdbsReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 122: {
                    iFileReader = new GeografPunktReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 127: {
                    iFileReader = new TtpReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 128: {
                    iFileReader = new PdbReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 129: {
                    iFileReader = new PdkReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 130: {
                    iFileReader = new IdbReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 133: {
                    iFileReader = new KivReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 103: {
                    iFileReader = new Lt3Reader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 107: {
                    iFileReader = new Lt7Reader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 131: {
                    iFileReader = new AgaKooReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 132: {
                    iFileReader = new CsvReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 134: {
                    iFileReader = new CaddyKooReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 520: {
                    iFileReader = new UmnumReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case 609: {
                    iFileReader = new LtaReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                    break;
                }
                case -1: {
                    iFileReader = new FreeFormatReader(file, DataBase.P, (IProgressViewer)this.progressBar);
                }
            }
            iFileReader.setMode(16394);
            if (geoFile.isKatFileTyp()) {
                iDialog = new ImportOptionDialog(this.parent, "Optionen", geoFile, iFileReader);
                iDialog.setVisible(true);
            }
        }
        catch (Exception exception) {
            iDialog = new ErrorDialog(this.parent, exception);
            iDialog.setVisible(true);
        }
        try {
            if (iFileReader != null) {
                iFileReader.setExceptionList(this.exceptions);
                iFileReader.read();
                if (iFileReader.getFinalMessage() != null) {
                    this.exceptions.addException(new Exception(iFileReader.getFinalMessage()));
                }
            } else {
                throw new IException("ung\u00fcltiger Dateityp");
            }
            int n3 = DataBase.MENGE.size();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
            this.progressBar.setValue(100);
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
            if (this.messageListener != null) {
                boolean bl = n2 == 0;
                int n4 = n3 - n2;
                String string = bl ? "Neue Menge aus " + n4 + " Punkten gebildet." : "Der Menge wurde " + n4 + " Punkt hinzugef\u00fcgt.";
                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, string));
            }
        }
        catch (Exception exception) {
            iDialog = new ErrorDialog(this.parent, exception);
            iDialog.setVisible(true);
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

