/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktStatus;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.RissInfoDialog;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.StatElement;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class RecorderDialog
extends ObjectInfoDialog
implements ITableListener,
DataBaseListener,
ActionListener,
ItemListener {
    private static final String SET_COMMAND = "Setzen";
    private static final String EP_FILTER = "EP";
    private static final String NV_FILTER = "NV";
    private static final String GF_FILTER = "GF";
    private static final String RS_FILTER = "RS";
    private ElementFilter filter = new VoidFilter(this);
    private String titel = "";
    private TextField inputField;
    private Checkbox nrCheckbox;
    private Checkbox epCheckbox;
    private Checkbox nvCheckbox;
    private Checkbox gfCheckbox;
    private Checkbox rsCheckbox;
    private Button setButton;

    public RecorderDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Object)null);
    }

    public RecorderDialog(IFrame iFrame, String string, Object object) {
        super(iFrame, string, (Object)null);
        this.titel = string;
        this.setObject(object);
    }

    @Override
    public void setObject(Object object) {
        this.setObject(object, null);
    }

    public void setObject(Object object, String string) {
        if (object == null) {
            this.filter = new VoidFilter(this);
        } else if (object instanceof Punkt) {
            this.filter = new PunktFilter(this, (Punkt)object);
        } else if (object instanceof Float) {
            this.filter = EP_FILTER.equals(string) ? new EpFilter(this, ((Float)object).floatValue()) : (GF_FILTER.equals(string) ? new GfFilter(this, ((Float)object).floatValue()) : new NvFilter(this, ((Float)object).floatValue()));
        } else if (object instanceof String) {
            if (RS_FILTER.equals(string)) {
                this.filter = new RsFilter(this, (String)object);
            }
        } else {
            this.filter = new VoidFilter(this);
        }
        this.setTitle(this.title + " (" + String.valueOf(this.filter) + ")");
        this.setObjects(this.filter);
        this.showObject(object);
    }

    @Override
    protected Panel createInfoPanel() {
        Panel panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Filter:"));
        this.inputField = new TextField(20);
        panel.add(this.inputField);
        this.inputField.addActionListener(this);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.nrCheckbox = new Checkbox("Punktnummer", false, checkboxGroup);
        panel.add(this.nrCheckbox);
        this.epCheckbox = new Checkbox("Einfluss Punktlage", false, checkboxGroup);
        panel.add(this.epCheckbox);
        this.nvCheckbox = new Checkbox("Normierte Verb.", false, checkboxGroup);
        panel.add(this.nvCheckbox);
        this.gfCheckbox = new Checkbox("Grober Fehler", false, checkboxGroup);
        panel.add(this.gfCheckbox);
        this.rsCheckbox = new Checkbox("Riss", false, checkboxGroup);
        panel.add(this.rsCheckbox);
        this.nrCheckbox.addItemListener(this);
        this.epCheckbox.addItemListener(this);
        this.nvCheckbox.addItemListener(this);
        this.gfCheckbox.addItemListener(this);
        this.rsCheckbox.addItemListener(this);
        this.setButton = new Button(SET_COMMAND);
        panel.add(this.setButton);
        this.setButton.addActionListener(this);
        return panel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(16);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Liste", 0), new ITableCell("Riss", 0), new ITableCell("Element", 0), new ITableCell("Punkt1", 0), new ITableCell("Punkt2", 0), new ITableCell("Punkt3", 0), new ITableCell("Wert1", 0), new ITableCell("Wert2", 0), new ITableCell("SA VA", 0), new ITableCell("SA NA", 0), new ITableCell("EV", 0), new ITableCell(EP_FILTER, 0), new ITableCell(NV_FILTER, 0), new ITableCell(GF_FILTER, 0), new ITableCell("GRZW", 0), new ITableCell("EGK", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    public void setObjects(ElementFilter elementFilter) {
        Object e;
        this.table.removeLines();
        Enumeration enumeration = DataBase.punkte();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (!elementFilter.contains(e)) continue;
            this.addObjectToTable(e);
        }
        enumeration = DataBase.messungen();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (!elementFilter.contains(e)) continue;
            this.addObjectToTable(e);
        }
        enumeration = DataBase.trafoPunkte();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (!elementFilter.contains(e)) continue;
            this.addObjectToTable(e);
        }
        enumeration = DataBase.allBedingungen();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (!elementFilter.contains(e)) continue;
            this.addObjectToTable(e);
        }
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    protected void showObject(Object object) {
        this.inputField.setText(this.filter.getValue());
        if (this.filter instanceof PunktFilter) {
            this.nrCheckbox.setState(true);
        } else if (this.filter instanceof NvFilter) {
            this.nvCheckbox.setState(true);
        }
    }

    protected void addObjectToTable(Object object) {
        ITableCell[] iTableCellArray = new ITableCell[16];
        if (object instanceof Punkt) {
            Punkt punkt = (Punkt)object;
            iTableCellArray[0] = new ITableCell(punkt.getClassName(), -10);
            Object object2 = "";
            if (punkt.getInternalPs() != 0) {
                object2 = (String)object2 + PunktStatus.getKatasterStatusString(punkt.getInternalPs()) + ": ";
            }
            if (punkt.getRiss() != null) {
                object2 = (String)object2 + punkt.getRiss();
            }
            iTableCellArray[1] = new ITableCell(punkt.getRiss() != null ? punkt.getRiss() : "", -10);
            iTableCellArray[2] = new ITableCell("Punkt", -10);
            iTableCellArray[3] = new ITableCell(Long.toString(punkt.nr), 10);
            iTableCellArray[4] = new ITableCell("", 10);
            iTableCellArray[5] = new ITableCell("", 10);
            if (punkt.getPs() == 1) {
                iTableCellArray[6] = new ITableCell(IFormat.f_3.format(punkt.y), 10);
                iTableCellArray[7] = new ITableCell(IFormat.f_3.format(punkt.x), 10);
                iTableCellArray[8] = new ITableCell(IFormat.f_3.format(0.0), 10);
            } else if (punkt.getPs() == 2) {
                iTableCellArray[6] = new ITableCell(IFormat.f_3.format(punkt.y), 10);
                iTableCellArray[7] = new ITableCell(IFormat.f_3.format(punkt.x), 10);
                iTableCellArray[8] = new ITableCell(IFormat.f_3.format(punkt.g), 10);
            } else if (punkt.getPs() == 0) {
                iTableCellArray[6] = new ITableCell(IFormat.f_3.format(punkt.y - (double)punkt.dy), 10);
                iTableCellArray[7] = new ITableCell(IFormat.f_3.format(punkt.x - (double)punkt.dx), 10);
                iTableCellArray[8] = new ITableCell("", 10);
            } else {
                iTableCellArray[6] = new ITableCell("", 10);
                iTableCellArray[7] = new ITableCell("", 10);
                iTableCellArray[8] = new ITableCell("", 10);
            }
            iTableCellArray[9] = new ITableCell(IFormat.f_3.format(punkt.getSP()), 10);
            this.addStatCells(punkt.getStatistik(), iTableCellArray);
            ITableLine iTableLine = new ITableLine(iTableCellArray, object);
            if (punkt.getPs() == 5) {
                iTableLine.setForeground(Color.red);
            } else if (!punkt.isOn()) {
                iTableLine.setForeground(Color.gray);
            }
            this.table.addLine(iTableLine);
        } else if (object instanceof Messung) {
            Messung messung = (Messung)object;
            iTableCellArray[0] = new ITableCell(messung.getContainer().getRissInfo().getListAsString(), -10);
            iTableCellArray[1] = new ITableCell(messung.getContainer().getRissInfo().getName(), -10);
            iTableCellArray[2] = new ITableCell(messung.getClassName(), -10);
            iTableCellArray[3] = new ITableCell(messung.getP1() != null && messung.getP1().nr != 0L ? Long.toString(messung.getP1().nr) : "", 10);
            iTableCellArray[4] = new ITableCell(messung.getP2() != null && messung.getP2().nr != 0L ? Long.toString(messung.getP2().nr) : "", 10);
            iTableCellArray[5] = new ITableCell("", 10);
            iTableCellArray[6] = new ITableCell(messung.getFormatedValue(1), 10);
            iTableCellArray[7] = new ITableCell(messung.getFormatedValue(2), 10);
            this.addStatCells(messung.getStatistik(), iTableCellArray);
            ITableLine iTableLine = new ITableLine(iTableCellArray, object);
            if (messung.isFehler()) {
                iTableLine.setForeground(Color.red);
            } else if (!messung.isOn()) {
                iTableLine.setForeground(Color.gray);
            }
            this.table.addLine(iTableLine);
        } else if (object instanceof Bedingung) {
            Bedingung bedingung = (Bedingung)object;
            iTableCellArray[0] = new ITableCell(bedingung.getContainer().getRissInfo().getListAsString(), -10);
            iTableCellArray[1] = new ITableCell(bedingung.getContainer().getRissInfo().getName(), -10);
            iTableCellArray[2] = new ITableCell(bedingung.getClassName(), -10);
            iTableCellArray[3] = new ITableCell(bedingung.getP1() != null && bedingung.getP1().nr != 0L ? Long.toString(bedingung.getP1().nr) : "", 10);
            iTableCellArray[4] = new ITableCell(bedingung.getP2() != null && bedingung.getP2().nr != 0L ? Long.toString(bedingung.getP2().nr) : "", 10);
            iTableCellArray[5] = new ITableCell(bedingung.getP3() != null && bedingung.getP3().nr != 0L ? Long.toString(bedingung.getP3().nr) : "", 10);
            iTableCellArray[6] = new ITableCell(bedingung.getFormatedValue(1), 10);
            iTableCellArray[7] = new ITableCell("", 10);
            this.addStatCells(bedingung.getStatistik(), iTableCellArray);
            ITableLine iTableLine = new ITableLine(iTableCellArray, object);
            if (!bedingung.isOn()) {
                iTableLine.setForeground(Color.gray);
            }
            this.table.addLine(iTableLine);
        } else if (object instanceof TrafoPunkt) {
            TrafoPunkt trafoPunkt = (TrafoPunkt)object;
            iTableCellArray[0] = new ITableCell(trafoPunkt.getContainer().getRissInfo().getListAsString(), -10);
            iTableCellArray[1] = new ITableCell(trafoPunkt.getContainer().getRissInfo().getName(), -10);
            iTableCellArray[2] = new ITableCell(trafoPunkt.getClassName(), -10);
            iTableCellArray[3] = new ITableCell(trafoPunkt.getPunkt() != null && trafoPunkt.getPunkt().nr != 0L ? Long.toString(trafoPunkt.getPunkt().nr) : "", 10);
            iTableCellArray[4] = new ITableCell("", 10);
            iTableCellArray[5] = new ITableCell("", 10);
            iTableCellArray[6] = new ITableCell(IFormat.f_3.format(trafoPunkt.y), 10);
            iTableCellArray[7] = new ITableCell(IFormat.f_3.format(trafoPunkt.x), 10);
            this.addStatCells(trafoPunkt.getStatistik(), iTableCellArray);
            ITableLine iTableLine = new ITableLine(iTableCellArray, object);
            if (!trafoPunkt.isOn()) {
                iTableLine.setForeground(Color.gray);
            }
            this.table.addLine(iTableLine);
        }
    }

    private void addStatCells(Stat stat, ITableCell[] iTableCellArray) {
        if (stat != null) {
            iTableCellArray[8] = new ITableCell(Stat.toString((short)stat.getMidSaV(), 0.001f), 10);
            short s = (short)stat.getMidSaN();
            iTableCellArray[9] = new ITableCell(s != 0 ? Stat.toString(s, 0.001f) : "", 10);
            iTableCellArray[10] = new ITableCell(Stat.toString((short)stat.getMidEv()), 10);
            iTableCellArray[11] = new ITableCell(Stat.toString((short)stat.getMaxEp(), 0.001f), 10);
            iTableCellArray[12] = new ITableCell(Stat.toString((short)stat.getMaxNv(), 0.1f), 10);
            short s2 = (short)stat.getMaxGf();
            iTableCellArray[13] = new ITableCell(s2 != 0 ? Stat.toString(s2, 0.001f) : "", 10);
            iTableCellArray[14] = new ITableCell(Stat.toString((short)stat.getMaxGrzw(), 0.001f), 10);
            iTableCellArray[15] = new ITableCell(Stat.toString((short)stat.getMaxEgk(), 0.001f), 10);
        } else {
            iTableCellArray[8] = new ITableCell("", 10);
            iTableCellArray[9] = new ITableCell("", 10);
            iTableCellArray[10] = new ITableCell("", 10);
            iTableCellArray[11] = new ITableCell("", 10);
            iTableCellArray[12] = new ITableCell("", 10);
            iTableCellArray[13] = new ITableCell("", 10);
            iTableCellArray[14] = new ITableCell("", 10);
            iTableCellArray[15] = new ITableCell("", 10);
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        this.setObjects(this.filter);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.nrCheckbox) {
            this.inputField.setText(IFormat.getNumbers(this.inputField.getText()));
            this.actionPerformed(new ActionEvent(this, 1001, SET_COMMAND));
        } else if (object == this.epCheckbox) {
            this.inputField.setText("0.20");
            this.actionPerformed(new ActionEvent(this, 1001, SET_COMMAND));
        } else if (object == this.nvCheckbox) {
            this.inputField.setText("3.00");
            this.actionPerformed(new ActionEvent(this, 1001, SET_COMMAND));
        } else if (object == this.gfCheckbox) {
            this.inputField.setText("0.00");
            this.actionPerformed(new ActionEvent(this, 1001, SET_COMMAND));
        } else if (object == this.rsCheckbox) {
            RissInfoDialog rissInfoDialog = new RissInfoDialog(this.parent, "Rissauswahl");
            rissInfoDialog.setModal(true);
            rissInfoDialog.setVisible(true);
            Object object2 = rissInfoDialog.getObject();
            if (object2 != null) {
                RissInfo rissInfo = null;
                if (object2 instanceof Riss) {
                    rissInfo = ((Riss)object2).getRissInfo();
                } else if (object2 instanceof TrafoSystem) {
                    rissInfo = ((TrafoSystem)object2).getRissInfo();
                }
                this.inputField.setText((String)(rissInfo != null ? rissInfo.getListAsString() + ":" + rissInfo.getName() : ""));
            }
            this.actionPerformed(new ActionEvent(this, 1001, SET_COMMAND));
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        Object object = iTableEvent.getContent();
        if (this.elementListener != null) {
            this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), object, iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals(SET_COMMAND) || object == this.inputField) {
            if (this.nrCheckbox.getState()) {
                try {
                    String string2 = IFormat.getNumbers(this.inputField.getText());
                    this.setObject(DataBase.P.get(Long.parseLong(string2)));
                }
                catch (Exception exception) {
                    this.setObject(null);
                }
            } else if (this.nvCheckbox.getState()) {
                try {
                    this.setObject(new Float(this.inputField.getText()));
                }
                catch (Exception exception) {
                    this.setObject(null);
                }
            } else if (this.gfCheckbox.getState()) {
                try {
                    this.setObject(new Float(this.inputField.getText()), GF_FILTER);
                }
                catch (Exception exception) {
                    this.setObject(null);
                }
            } else if (this.epCheckbox.getState()) {
                try {
                    this.setObject(new Float(this.inputField.getText()), EP_FILTER);
                }
                catch (Exception exception) {
                    this.setObject(null);
                }
            } else if (this.rsCheckbox.getState()) {
                try {
                    this.setObject(this.inputField.getText(), RS_FILTER);
                }
                catch (Exception exception) {
                    this.setObject(null);
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public class VoidFilter
    extends ElementFilter {
        public VoidFilter(RecorderDialog recorderDialog) {
            super(recorderDialog);
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        public String toString() {
            return "ohne";
        }
    }

    public abstract class ElementFilter {
        public ElementFilter(RecorderDialog recorderDialog) {
        }

        public abstract String getValue();

        public abstract boolean contains(Object var1);
    }

    public class PunktFilter
    extends ElementFilter {
        Punkt p;

        public PunktFilter(RecorderDialog recorderDialog, Punkt punkt) {
            super(recorderDialog);
            this.p = punkt;
        }

        @Override
        public String getValue() {
            return Long.toString(this.p.nr);
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof PunktContainer) {
                return ((PunktContainer)object).contains(this.p);
            }
            return false;
        }

        public String toString() {
            return "Punktnummer = " + this.p.nr;
        }
    }

    public class EpFilter
    extends ElementFilter {
        float minEp = 0.05f;

        public EpFilter(RecorderDialog recorderDialog, float f) {
            super(recorderDialog);
            this.minEp = f;
        }

        @Override
        public String getValue() {
            return Float.toString(this.minEp);
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof StatElement) {
                StatElement statElement = (StatElement)object;
                if (!statElement.hasStatistik()) {
                    return false;
                }
                Stat stat = statElement.getStatistik();
                return (float)stat.getMaxEp() * 0.001f >= this.minEp;
            }
            return false;
        }

        public String toString() {
            return "Einfluss auf die Punktlage >= " + this.minEp;
        }
    }

    public class GfFilter
    extends ElementFilter {
        float minGf = 0.2f;

        public GfFilter(RecorderDialog recorderDialog, float f) {
            super(recorderDialog);
            this.minGf = f;
        }

        @Override
        public String getValue() {
            return Float.toString(this.minGf);
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof StatElement) {
                StatElement statElement = (StatElement)object;
                if (!statElement.hasStatistik()) {
                    return false;
                }
                Stat stat = statElement.getStatistik();
                return (float)stat.getMaxGf() * 0.001f > this.minGf;
            }
            return false;
        }

        public String toString() {
            return "Grober Fehler > " + this.minGf;
        }
    }

    public class NvFilter
    extends ElementFilter {
        float minNv = 3.3f;

        public NvFilter(RecorderDialog recorderDialog, float f) {
            super(recorderDialog);
            this.minNv = f;
        }

        @Override
        public String getValue() {
            return Float.toString(this.minNv);
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof StatElement) {
                StatElement statElement = (StatElement)object;
                if (!statElement.hasStatistik()) {
                    return false;
                }
                Stat stat = statElement.getStatistik();
                return (float)stat.getMaxNv() * 0.1f >= this.minNv;
            }
            return false;
        }

        public String toString() {
            return "Normierte Verbesserung >= " + this.minNv;
        }
    }

    public class RsFilter
    extends ElementFilter {
        String list;
        String name;

        public RsFilter(RecorderDialog recorderDialog, String string) {
            super(recorderDialog);
            int n = string.indexOf(":");
            if (n > 0) {
                this.list = string.substring(0, n);
                this.name = string.substring(n + 1);
            } else {
                this.name = string;
            }
        }

        @Override
        public String getValue() {
            return this.list != null ? this.list + ":" + this.name : this.name;
        }

        @Override
        public boolean contains(Object object) {
            if (this.name == null) {
                return false;
            }
            RissInfo rissInfo = null;
            if (object instanceof Messung) {
                rissInfo = ((Messung)object).getContainer().getRissInfo();
            } else if (object instanceof Bedingung) {
                rissInfo = ((Bedingung)object).getContainer().getRissInfo();
            } else if (object instanceof TrafoPunkt) {
                rissInfo = ((TrafoPunkt)object).getContainer().getRissInfo();
            }
            if (rissInfo != null) {
                if (this.list != null) {
                    return this.name.equals(rissInfo.getName()) && this.list.equals(rissInfo.getListAsString());
                }
                return this.name.equals(rissInfo.getName());
            }
            return false;
        }

        public String toString() {
            return "Riss = " + this.getValue();
        }
    }
}

