/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Riss;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReweightMessungDialog
extends IDialog
implements ActionListener {
    private DataBase db;
    protected ExceptionList exceptions;
    private static final String OK_COMMAND = "Ausf\u00fchren";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String HELP_TEXT = "Die Messungselemente des Katasternachweises werden umgewichtet. Nur die Messungen des Bestimmungsrisses behalten ihr urspr\u00fcngliches Gewicht. Alle Folgemessungen werden herabgewichtet. Bestimmend ist die Reihenfolge der Eingabe. Ziel soll es sein, dass die in der Regel korrelierten Folgemessungen ihren Einfluss auf die Bestimmung der Punktgenauigkeit verlieren. Mit der Datenpr\u00fcfung k\u00f6nnen Abweichungen gegen\u00fcber den Ursprungsma\u00dfen aufgedeckt werden.";
    private Button okButton;
    private Button abortButton;
    private Label gewichtLabel;
    private ITextField gewichtTextField;
    private Label progressLabel;
    private IProgressBar progressBar;

    public ReweightMessungDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        iPanel.setBorder(new IBorder(1));
        FlowText flowText = new FlowText(HELP_TEXT, false);
        iPanel.add(flowText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        this.gewichtLabel = new Label("Gewicht: ");
        iPanel.add(this.gewichtLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.gewichtLabel, gridBagConstraints);
        this.gewichtTextField = new ITextField("0.01");
        iPanel.add(this.gewichtTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.gewichtTextField, gridBagConstraints);
        this.progressBar = new IProgressBar();
        iPanel.add(this.progressBar);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints);
        this.progressLabel = new Label("Riss: ");
        iPanel.add(this.progressLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.progressLabel, gridBagConstraints);
        this.add("Center", iPanel);
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        this.add("South", panel);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void create() {
        float f = 0.01f;
        try {
            f = new Float(this.gewichtTextField.getText().trim()).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Hashtable<Cloneable, Cloneable> hashtable = new Hashtable<Cloneable, Cloneable>();
        Hashtable<Punkt, Punkt> hashtable2 = new Hashtable<Punkt, Punkt>();
        MessungGewicht messungGewicht = MessungGewicht.intern(new MessungGewicht(f, f, f, f));
        Enumeration enumeration = DataBase.MK.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Riss riss = (Riss)enumeration.nextElement();
            System.out.println(riss);
            Enumeration enumeration2 = riss.elements();
            while (enumeration2.hasMoreElements()) {
                boolean bl;
                cloneable = (Messung)enumeration2.nextElement();
                boolean bl2 = ((Messung)cloneable).ps == null || hashtable.get(((Messung)cloneable).ps) != null;
                boolean bl3 = bl = ((Messung)cloneable).pz == null || hashtable.get(((Messung)cloneable).pz) != null;
                if (bl2 && bl) {
                    ((Messung)cloneable).setGewichte(messungGewicht);
                    System.out.println(cloneable);
                    continue;
                }
                if (((Messung)cloneable).ps != null) {
                    hashtable2.put(((Messung)cloneable).ps, ((Messung)cloneable).ps);
                }
                if (((Messung)cloneable).pz == null) continue;
                hashtable2.put(((Messung)cloneable).pz, ((Messung)cloneable).pz);
            }
            enumeration2 = hashtable2.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (Punkt)enumeration2.nextElement();
                hashtable.put(cloneable, cloneable);
            }
            hashtable2.clear();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.create();
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Erzeugenn der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.create();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

