/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.lang.Control;
import de.geocalc.lang.Exceptionable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class Riss
extends ValueDataContainer
implements PunktContainer,
PaintObject,
Drawable,
Exceptionable,
DatContainer {
    public Riss(int n, int n2) {
        this(null, n, n2);
    }

    public Riss(String string, int n, int n2) {
        this.rissInfo = new RissInfo(string, n, n2);
    }

    @Override
    public void initGeom() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DRectangle dRectangle = ((Drawable)enumeration.nextElement()).getBounds();
            d = Math.min(d, dRectangle.y);
            d2 = Math.min(d2, dRectangle.x);
            d3 = Math.max(d3, dRectangle.y + dRectangle.width);
            d4 = Math.max(d4, dRectangle.x + dRectangle.height);
        }
        this.setBounds(d, d2, d3 - d, d4 - d2);
        this.createHull();
    }

    public String getNameWithList() {
        String string = super.getName();
        String string2 = this.rissInfo.getListAsString();
        if (string != null && string2 != null) {
            return string2.substring(0, Math.min(string2.length(), 3)) + ":" + string;
        }
        if (string != null) {
            return string;
        }
        return null;
    }

    public void addObject(Drawable drawable) {
        this.addElement(drawable);
        DRectangle dRectangle = drawable.getBounds();
        DRectangle dRectangle2 = this.getBounds();
        double d = Math.min(dRectangle2.y, dRectangle.y);
        double d2 = Math.min(dRectangle2.x, dRectangle.x);
        this.setBounds(d, d2, Math.abs(Math.max(dRectangle2.y + dRectangle2.width, dRectangle.y + dRectangle.width) - d), Math.abs(Math.max(dRectangle2.x + dRectangle2.height, dRectangle.x + dRectangle.height) - d2));
    }

    @Override
    public void addElement(Object object) {
        if (object instanceof Messung) {
            ((Messung)object).setContainer(this);
        } else if (object instanceof Bedingung) {
            ((Bedingung)object).setContainer(this);
        }
        super.addElement(object);
    }

    public int compareTo(DataContainer dataContainer) {
        if (this.equals(dataContainer)) {
            return 0;
        }
        return 1;
    }

    @Override
    public RissInfo getRissInfo() {
        return this.rissInfo;
    }

    @Override
    public String getClassName() {
        return "Riss";
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        Enumeration enumeration;
        printWriter.print(this.rissInfo.getTyp() == 2 ? "C!Riss:" : "C!Blatt:");
        printWriter.print(" ");
        printWriter.println(this.rissInfo.toString());
        KafkaIOProperties.lastMessungGewicht = null;
        if (!KafkaIOProperties.writeMenge) {
            enumeration = this.elements();
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            boolean bl2 = false;
            int n9 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n10 = 0;
            boolean bl6 = false;
            int n11 = 0;
            block22: for (int i = 0; i < this.size(); ++i) {
                Control control;
                DatObject datObject = (DatObject)this.elementAt(i);
                if (datObject instanceof Messung) {
                    control = (Messung)datObject;
                    switch (((Messung)control).getMessungsArtIgnoreErr()) {
                        case 220: {
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).ps)) continue block22;
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).pz)) continue block22;
                            printWriter.println(((Messung)control).toDatLine());
                            continue block22;
                        }
                        case 260: {
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).ps)) continue block22;
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).pz)) continue block22;
                            Messung messung = (Messung)((Messung)control).clone();
                            messung.setMessungsArt(220);
                            ((Messung)control).cloneErrParam(messung);
                            printWriter.println(((Messung)control).toDatLine());
                            continue block22;
                        }
                        case 240: {
                            if (n8 >= 0 || !KafkaIOProperties.hasPunkt(((Messung)control).ps) || !KafkaIOProperties.hasPunkt(((Messung)control).pz)) break;
                            Messung messung = (Messung)((Messung)control).clone();
                            messung.setMessungsArt(220);
                            messung.l1 = messung.l2;
                            messung.l2 = 0.0;
                            messung.setWerteBelegung(1);
                            ((Messung)control).cloneErrParam(messung);
                            printWriter.println(messung.toDatLine());
                            continue block22;
                        }
                        case 210: {
                            n3 = 0;
                            n8 = -1;
                            n11 = 0;
                        }
                        case 200: {
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).ps) && !KafkaIOProperties.hasPunkt(((Messung)control).pz)) break;
                            ++n3;
                            if (n8 < 0) {
                                n8 = i;
                            }
                            n10 = i;
                            if (((Messung)control).getWerteBelegung() <= 0) break;
                            ++n11;
                            continue block22;
                        }
                        case 290: {
                            Messung messung;
                            Messung messung2;
                            if (KafkaIOProperties.hasPunkt(((Messung)control).ps) || KafkaIOProperties.hasPunkt(((Messung)control).pz)) {
                                ++n3;
                                n10 = i;
                                if (((Messung)control).getWerteBelegung() > 0) {
                                    ++n11;
                                }
                            }
                            if (n3 <= 1) break;
                            if (n3 == 2) {
                                if (n11 < 2) continue block22;
                                Messung messung3 = (Messung)this.elementAt(n8);
                                messung2 = (Messung)this.elementAt(n10);
                                if (messung3.l1 == messung2.l1) {
                                    if (!KafkaIOProperties.hasPunkt(messung3.ps) || !KafkaIOProperties.hasPunkt(messung2.ps)) break;
                                    messung = new Messung(220, messung3.ps, messung2.ps, Math.abs(messung3.l2 - messung2.l2), 0.0);
                                    messung.setWerteBelegung(1);
                                    messung.setGewichte(MessungGewicht.intern(new MessungGewicht(messung3.getGewichte().getG2(), 1.0f, 1.0f, 1.0f)));
                                    messung3.cloneErrParam(messung);
                                    printWriter.println(messung.toDatLine());
                                    continue block22;
                                }
                            }
                            boolean bl7 = false;
                            block23: for (int j = n8; j <= n10; ++j) {
                                control = (Messung)this.elementAt(j);
                                switch (((Messung)control).getMessungsArtIgnoreErr()) {
                                    case 200: 
                                    case 210: 
                                    case 290: {
                                        if (!KafkaIOProperties.hasPunkt(((Messung)control).ps) && !KafkaIOProperties.hasPunkt(((Messung)control).pz) || !bl7 && n11 >= 2 && ((Messung)control).getWerteBelegung() == 0) continue block23;
                                        messung = (Messung)((Messung)control).clone();
                                        if (!KafkaIOProperties.hasPunkt(((Messung)control).ps)) {
                                            messung.ps = messung.pz;
                                            messung.pz = null;
                                            messung.l2 = 0.0;
                                            messung.setWerteBelegung(1);
                                        } else if (((Messung)control).pz != null && !KafkaIOProperties.hasPunkt(((Messung)control).pz)) {
                                            messung.pz = null;
                                        }
                                        if (!bl7) {
                                            messung.setMessungsArt(210);
                                            ((Messung)control).cloneErrParam(messung);
                                        } else if (j == n10) {
                                            messung.setMessungsArt(290);
                                            ((Messung)control).cloneErrParam(messung);
                                        }
                                        printWriter.println(messung.toDatLine());
                                        bl7 = true;
                                        continue block23;
                                    }
                                    case 240: {
                                        if (!bl7) continue block23;
                                        if (KafkaIOProperties.hasPunkt(((Messung)control).pz)) {
                                            printWriter.println(((Messung)control).toDatLine());
                                            continue block23;
                                        }
                                        if (!KafkaIOProperties.hasPunkt(((Messung)control).ps)) continue block23;
                                        messung = (Messung)((Messung)control).clone();
                                        messung.setMessungsArt(200);
                                        messung.pz = null;
                                        messung.l2 = 0.0;
                                        messung.setWerteBelegung(1);
                                        ((Messung)control).cloneErrParam(messung);
                                        printWriter.println(messung.toDatLine());
                                        continue block23;
                                    }
                                }
                            }
                            continue block22;
                        }
                        case 230: {
                            Punkt punkt;
                            Messung messung2;
                            if (((Messung)control).ps != null) {
                                n2 = 0;
                            }
                            n7 = -1;
                            Punkt punkt2 = punkt = ((Messung)control).ps != null ? ((Messung)control).ps : ((Messung)control).getReferenz().ps;
                            if (!KafkaIOProperties.hasPunkt(punkt) || !KafkaIOProperties.hasPunkt(((Messung)control).pz)) break;
                            if (((Messung)control).ps != null) {
                                n7 = i;
                                printWriter.println(((Messung)control).toDatLine());
                            } else if (n7 < 0) {
                                messung2 = (Messung)((Messung)control).clone();
                                messung2.ps = punkt;
                                printWriter.println(messung2.toDatLine());
                                n7 = i;
                            } else {
                                printWriter.println(((Messung)control).toDatLine());
                            }
                            ++n2;
                            continue block22;
                        }
                        case 270: {
                            Messung messung2;
                            if (((Messung)control).ps != null) {
                                n = 0;
                            }
                            n6 = -1;
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).pz)) break;
                            if (n6 < 0) {
                                n6 = i;
                            } else {
                                if (n == 1) {
                                    messung2 = (Messung)((Messung)this.elementAt(n6)).clone();
                                    if (messung2.ps == null) {
                                        messung2.ps = messung2.getReferenz().ps;
                                    }
                                    printWriter.println(messung2.toDatLine());
                                }
                                printWriter.println(((Messung)control).toDatLine());
                            }
                            ++n;
                            continue block22;
                        }
                        case 280: {
                            if (!KafkaIOProperties.hasPunkt(((Messung)control).ps) || !KafkaIOProperties.hasPunkt(((Messung)control).pz)) break;
                            printWriter.println(((Messung)control).toDatLine());
                        }
                    }
                    continue;
                }
                if (!(datObject instanceof Bedingung)) continue;
                control = (Bedingung)datObject;
                switch (((Bedingung)control).ba) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        if (((Bedingung)control).p1 != null && !KafkaIOProperties.hasPunkt(((Bedingung)control).p1) || ((Bedingung)control).p2 != null && !KafkaIOProperties.hasPunkt(((Bedingung)control).p2) || ((Bedingung)control).p3 != null && !KafkaIOProperties.hasPunkt(((Bedingung)control).p3)) continue block22;
                        printWriter.println(((Bedingung)control).toDatLine());
                        continue block22;
                    }
                    case 3: {
                        n4 = 0;
                        if (!KafkaIOProperties.hasPunkt(((Bedingung)control).p1) || !KafkaIOProperties.hasPunkt(((Bedingung)control).p2)) continue block22;
                        n9 = i;
                        ++n4;
                        continue block22;
                    }
                    case 0: {
                        if (!KafkaIOProperties.hasPunkt(((Bedingung)control).p1) || !KafkaIOProperties.hasPunkt(((Bedingung)control).p2)) continue block22;
                        if (n4 == 0) {
                            n9 = i;
                        } else {
                            if (n4 == 1) {
                                Bedingung bedingung = (Bedingung)this.elementAt(n9);
                                bedingung = (Bedingung)bedingung.clone();
                                bedingung.ba = 3;
                                printWriter.println(bedingung.toDatLine());
                            }
                            printWriter.println(((Bedingung)control).toDatLine());
                        }
                        ++n4;
                        continue block22;
                    }
                    case 6: {
                        n5 = 0;
                        if (KafkaIOProperties.hasPunkt(((Bedingung)control).p1) && KafkaIOProperties.hasPunkt(((Bedingung)control).p2) && KafkaIOProperties.hasPunkt(((Bedingung)control).p3)) {
                            printWriter.println(((Bedingung)control).toDatLine());
                            ++n5;
                        }
                    }
                    case 9: {
                        if (n5 > 0) {
                            if (!KafkaIOProperties.hasPunkt(((Bedingung)control).p1)) continue block22;
                            printWriter.println(((Bedingung)control).toDatLine());
                            continue block22;
                        }
                        if (!KafkaIOProperties.hasPunkt(((Bedingung)control).getReferenz().p1) || !KafkaIOProperties.hasPunkt(((Bedingung)control).getReferenz().p2) || !KafkaIOProperties.hasPunkt(((Bedingung)control).p1)) continue block22;
                        Bedingung bedingung = (Bedingung)((Bedingung)control).clone();
                        bedingung.p3 = ((Bedingung)control).p1;
                        bedingung.p1 = ((Bedingung)control).getReferenz().p1;
                        bedingung.p2 = ((Bedingung)control).getReferenz().p2;
                        printWriter.println(bedingung.toDatLine());
                        ++n5;
                        continue block22;
                    }
                }
            }
            return;
        }
        while (enumeration.hasMoreElements()) {
            DatObject datObject = (DatObject)enumeration.nextElement();
            if (!KafkaIOProperties.writeOffline && !datObject.isOn()) continue;
            printWriter.println(datObject.toDatLine());
        }
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        String[] stringArray = new String[]{XmlIOProperties.att("name", this.rissInfo.toString())};
        printWriter.println(XmlIOProperties.open("riss", stringArray));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Messung) {
                printWriter.println(((Messung)e).toXmlLine());
                continue;
            }
            if (!(e instanceof Bedingung)) continue;
            printWriter.println(((Bedingung)e).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("riss"));
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.rissInfo.getTyp());
        dataOutput.writeInt(this.rissInfo.getList());
        KafPlotIOConstants.writeString(dataOutput, this.rissInfo.toString());
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Messung) {
                ((Messung)e).writeObject(dataOutput);
                continue;
            }
            if (!(e instanceof Bedingung)) continue;
            ((Bedingung)e).writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
    }

    public static Riss readObject(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        int n = 0;
        if (KpvIOProperties.RVER >= 110) {
            n = dataInput.readInt();
        }
        Riss riss = new Riss(KafPlotIOConstants.readString(dataInput), by, n);
        byte by2 = 0;
        while ((by2 = dataInput.readByte()) != -1) {
            if (by2 == 12) {
                riss.addElement(Messung.readObject(dataInput));
                continue;
            }
            if (by2 != 16) break;
            riss.addElement(Bedingung.readObject(dataInput));
        }
        return riss;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Drawable)enumeration.nextElement()).drawObject(iGraphics, bl, bl2);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Drawable)enumeration.nextElement()).drawBackground(iGraphics, bl, bl2);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Drawable)enumeration.nextElement()).drawForeground(iGraphics, bl, bl2);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Drawable)enumeration.nextElement()).drawInscription(iGraphics, bl, bl2);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public String toString() {
        return "Riss: " + this.getName() + ", " + this.size() + " Elemente";
    }
}

