/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.text.IFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class RissInfo {
    private static final Hashtable KEYS = new Hashtable();
    private static int idCount = 0;
    public static final int UNDEF = 0;
    public static final int MESSUNGEN = 1;
    public static final int NACHWEIS = 2;
    public static final int HOEHEN = 3;
    public static final int BEDINGUNGEN = 6;
    public static final int TRAFO = 8;
    public static final int DIGIT = 9;
    public static final int LISTE_OHNE = 0;
    public static final int LISTE_PUNKT = 101;
    public static final int LISTE_POLAR = 201;
    public static final int LISTE_GPS = 202;
    public static final int LISTE_EIGENE = 203;
    public static final int LISTE_NACHWEIS = 204;
    public static final int LISTE_VORGABEN = 205;
    public static final int LISTE_EINRECHNUNG = 206;
    public static final int LISTE_NIVELLEMENT = 301;
    public static final int LISTE_POLARHOEHEN = 302;
    public static final int LISTE_TRAFO = 401;
    public static final int LISTE_DIGIT = 402;
    public static final int LISTE_HOMOGENISIERUNG = 601;
    public static final int LISTE_BEDINGUNGEN = 602;
    private int typ = 0;
    private int list = 0;
    private int id = 0;
    private String name = null;
    private String date = null;
    private String ent = null;
    private String bem = null;
    private String file = null;
    private String gmk = null;

    public RissInfo(int n, int n2) {
        this(null, n, n2);
    }

    public RissInfo(String string, int n, int n2) {
        this.typ = n;
        this.list = n2;
        this.parseString(string);
    }

    public void setTyp(int n) {
        this.typ = n;
    }

    public int getTyp() {
        return this.typ;
    }

    public void setList(int n) {
        this.list = n;
    }

    public int getList() {
        return this.list;
    }

    public String getListAsString() {
        return RissInfo.listToString(this.list);
    }

    public static String listToString(int n) {
        switch (n) {
            case 101: {
                return "Punkte";
            }
            case 201: {
                return "Polare Messungen";
            }
            case 202: {
                return "GPS-Basislinien";
            }
            case 203: {
                return "Messband-Messungen";
            }
            case 204: {
                return "KatasterNachweis";
            }
            case 205: {
                return "Vorgaben";
            }
            case 206: {
                return "Einrechnung";
            }
            case 301: {
                return "Nivellement";
            }
            case 302: {
                return "Polare H\u00f6hen";
            }
            case 401: {
                return "Transformation";
            }
            case 402: {
                return "Digitalisierung";
            }
            case 601: {
                return "Homogenisierung";
            }
            case 602: {
                return "Bedingungen";
            }
        }
        return "ohne";
    }

    public int getId() {
        return this.id;
    }

    public void setName(String string) {
        this.parseString(string);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyString() {
        return this.name != null ? this.name.replace(' ', '_') : null;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public boolean hasDate() {
        return this.date != null;
    }

    public String getDate() {
        return this.date;
    }

    public void setEntstehung(String string) {
        this.ent = string;
    }

    public boolean hasEntstehung() {
        return this.ent != null;
    }

    public String getEntstehung() {
        return this.ent;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public String getFile() {
        return this.file;
    }

    public void setGmk(String string) {
        this.gmk = string;
    }

    public boolean hasGmk() {
        return this.gmk != null;
    }

    public String getGmk() {
        return this.gmk;
    }

    public void parseString(String string) {
        this.name = null;
        this.date = null;
        if (string != null) {
            Object object;
            Object object2;
            try {
                object2 = new RissTokenizer(this, string);
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    int n = ((String)object).indexOf(61);
                    if (n >= 0) {
                        String string2 = ((String)object).substring(0, n).trim().toUpperCase();
                        String string3 = ((String)object).substring(n + 1).trim();
                        if (string2.equals("D")) {
                            this.date = string3;
                            continue;
                        }
                        if (string2.equals("E")) {
                            this.ent = string3;
                            continue;
                        }
                        if (string2.equals("ENT")) {
                            this.ent = string3;
                            continue;
                        }
                        if (string2.equals("F")) {
                            this.file = string3;
                            continue;
                        }
                        if (string2.equals("G")) {
                            this.gmk = string3;
                            continue;
                        }
                        if (string2.equals("B")) {
                            this.bem = string3;
                            continue;
                        }
                        if (!string2.equals("BEM")) continue;
                        this.bem = string3;
                        continue;
                    }
                    if (this.name == null) {
                        this.name = object;
                        continue;
                    }
                    this.name = this.name + " " + (String)object;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.name != null) {
                object2 = this.getKeyString();
                object = (Integer)KEYS.get(object2);
                if (object != null) {
                    this.id = (Integer)object;
                } else {
                    this.id = idCount++;
                    KEYS.put(object2, new Integer(this.id));
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name != null) {
            stringBuffer.append(this.name);
            if (this.name.length() < 16) {
                stringBuffer.append(IFormat.getSpaces(16 - this.name.length()));
            }
        }
        if (this.gmk != null) {
            stringBuffer.append("  G=" + this.gmk);
        }
        if (this.file != null) {
            stringBuffer.append("  F=" + this.file);
        }
        if (this.date != null) {
            stringBuffer.append("  D=" + this.date);
        }
        if (this.ent != null) {
            stringBuffer.append("  E=" + this.ent);
        }
        if (this.bem != null) {
            stringBuffer.append("  B=" + this.bem);
        }
        return stringBuffer.toString();
    }

    private class RissTokenizer
    implements Enumeration {
        String value;
        int curStart = 0;
        int curEnd = 0;
        int curDelim = -1;
        int endPos = -1;

        public RissTokenizer(RissInfo rissInfo, String string) {
            this.value = string;
            this.endPos = this.value.length();
            this.setNext();
        }

        private void setNext() {
            this.curDelim = this.value.indexOf(61, this.curDelim + 1);
            this.curStart = this.curEnd;
            if (this.curDelim > 0) {
                boolean bl = false;
                this.curEnd = this.curDelim - 1;
                while (this.curEnd >= 0) {
                    char c = this.value.charAt(this.curEnd);
                    if (c == ' ') {
                        if (bl) {
                            break;
                        }
                    } else {
                        bl = true;
                    }
                    --this.curEnd;
                }
            } else {
                this.curEnd = this.endPos;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.curStart < this.endPos;
        }

        public Object nextElement() {
            String string = this.value.substring(this.curStart, this.curEnd).trim();
            this.setNext();
            return string;
        }
    }
}

