/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.event.DataBaseEvent;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public class RissInfoDialog
extends ObjectInfoDialog
implements ITableListener {
    private Label listLabel;
    private Label nameLabel;
    private Label sizeLabel;

    public RissInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null, false);
    }

    public RissInfoDialog(IFrame iFrame, String string, RissInfo rissInfo) {
        this(iFrame, string, rissInfo, false);
    }

    public RissInfoDialog(IFrame iFrame, String string, RissInfo rissInfo, boolean bl) {
        super(iFrame, string, rissInfo, bl);
    }

    @Override
    protected Panel createInfoPanel() {
        if (this.isModal()) {
            return new Panel();
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Rissinformation"));
        this.listLabel = new Label("", 0);
        iPanel.add(this.listLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.listLabel, gridBagConstraints);
        this.nameLabel = new Label("", 0);
        iPanel.add(this.nameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        this.sizeLabel = new Label("", 0);
        iPanel.add(this.sizeLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.sizeLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(2);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Liste", -10), new ITableCell("Name", -10)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        this.addRisse(iTable, DataBase.MG);
        this.addRisse(iTable, DataBase.MP);
        this.addRisse(iTable, DataBase.MM);
        this.addRisse(iTable, DataBase.MK);
        this.addRisse(iTable, DataBase.ME);
        this.addRisse(iTable, DataBase.MV);
        this.addRisse(iTable, DataBase.HN);
        this.addRisse(iTable, DataBase.HP);
        this.addRisse(iTable, DataBase.T);
        this.addRisse(iTable, DataBase.BH);
        this.addRisse(iTable, DataBase.BB);
        iTable.addTableListener(this);
        return iTable;
    }

    private void addRisse(ITable iTable, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            RissInfo rissInfo = null;
            if (e instanceof Riss) {
                rissInfo = ((Riss)e).getRissInfo();
            } else if (e instanceof TrafoSystem) {
                rissInfo = ((TrafoSystem)e).getRissInfo();
            }
            if (rissInfo == null) continue;
            ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(rissInfo.getListAsString(), -10), new ITableCell(rissInfo.getName(), -10)};
            iTable.addLine(new ITableLine(iTableCellArray, e));
        }
    }

    @Override
    public void setObject(Object object) {
        this.table.select(object);
        super.setObject(object);
    }

    @Override
    public void showObject(Object object) {
        if (!this.isModal()) {
            RissInfo rissInfo = null;
            if (object instanceof TrafoSystem) {
                rissInfo = ((TrafoSystem)object).getRissInfo();
            } else if (object instanceof Riss) {
                rissInfo = ((Riss)object).getRissInfo();
            }
            if (rissInfo == null) {
                this.listLabel.setText("");
                this.nameLabel.setText("");
                this.sizeLabel.setText("");
            } else {
                this.table.select(object);
                this.listLabel.setText(rissInfo.getListAsString());
                this.nameLabel.setText(rissInfo.getName());
                this.sizeLabel.setText(Integer.toString(((DataContainer)object).size()) + " Elemente");
            }
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.setObject(iTableEvent.getContent());
        if (this.isModal() && iTableEvent.getClickCount() > 1) {
            this.endDialog();
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }
}

