/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RissMerger {
    private File dir;
    private boolean rename = true;
    private ColumnSet STANDARD_COLSET = new ColumnSet(this, 0, 1, 2, 3, 4, 5, 6);

    public void setDirectory(File file) {
        this.dir = file;
    }

    public File getDirectory() {
        return this.dir;
    }

    public boolean renameFiles() {
        return this.rename;
    }

    public void renameFiles(boolean bl) {
        this.rename = bl;
    }

    public Vector getRisse() {
        if (this.dir != null && this.dir.isDirectory()) {
            Object object;
            Object object2;
            RissData rissData;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            int n;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            int n2 = 0;
            String[] stringArray = this.dir.list();
            for (n = 0; n < stringArray.length; ++n) {
                object6 = stringArray[n];
                if (!((String)object6).toLowerCase().endsWith(".txt")) continue;
                try {
                    ColumnSet columnSet = this.STANDARD_COLSET;
                    object5 = new LineNumberReader(new FileReader(String.valueOf(this.dir) + File.separator + (String)object6));
                    while ((object4 = ((LineNumberReader)object5).readLine()) != null) {
                        if (!((String)object4).startsWith("|")) continue;
                        if (((String)object4).indexOf("Identnummer") > 0) {
                            columnSet = new ColumnSet(this);
                            columnSet.read((String)object4);
                            continue;
                        }
                        object3 = new RissData(this);
                        if (!((RissData)object3).parse((String)object4, columnSet)) continue;
                        hashtable.put(((RissData)object3).ident, object3);
                        n2 = Math.max(n2, ((RissData)object3).ident.length());
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                int n3;
                object6 = stringArray[n];
                if (((String)object6).toLowerCase().endsWith(".txt") || (n3 = ((String)object6).lastIndexOf(46)) < 0) continue;
                object5 = ((String)object6).substring(0, n3);
                object4 = ((String)object6).substring(n3 + 1);
                object3 = null;
                if (((String)object5).length() > n2) {
                    object3 = ((String)object5).substring(n2);
                    object5 = ((String)object5).substring(0, n2);
                    if (((String)(object3 = IFormat.trimLeft((String)object3, '_'))).length() == 0) {
                        object3 = null;
                    }
                }
                if ((rissData = (RissData)hashtable.get(object5)) == null) continue;
                if (this.rename) {
                    object2 = new File(String.valueOf(this.dir) + File.separator + (String)object6);
                    object = new File(String.valueOf(this.dir) + File.separator + rissData.getFileName((String)object3) + "." + (String)object4);
                    boolean bl = ((File)object2).renameTo((File)object);
                    if (object3 != null) continue;
                    rissData.file = bl ? rissData.getFileName((String)object3) + "." + (String)object4 : object6;
                    continue;
                }
                if (object3 != null) continue;
                rissData.file = object6;
            }
            Object[] objectArray = new String[hashtable.size()];
            object6 = new Hashtable();
            int n4 = 0;
            object5 = hashtable.elements();
            while (object5.hasMoreElements()) {
                object4 = (RissData)object5.nextElement();
                objectArray[n4] = object3 = ((RissData)object4).getName();
                ((Hashtable)object6).put(object3, object4);
                ++n4;
            }
            try {
                Arrays.sort(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object5 = new Vector();
            for (int i = 0; i < objectArray.length; ++i) {
                object3 = objectArray[i];
                if (((String)object3).length() == 0 || (rissData = (RissData)((Hashtable)object6).get(object3)) == null || rissData.typ != null && rissData.typ.equals("GN")) continue;
                object2 = new Riss("", 2, 0);
                object = ((Riss)object2).getRissInfo();
                ((RissInfo)object).setName(rissData.getRissName());
                ((RissInfo)object).setGmk(rissData.getGmk());
                if (rissData.jahr.length() > 1) {
                    ((RissInfo)object).setDate(rissData.jahr);
                }
                if (rissData.file != null) {
                    ((RissInfo)object).setFile(rissData.file);
                }
                if (rissData.auftr != null) {
                    ((RissInfo)object).setEntstehung(rissData.auftr.replace(' ', '_'));
                }
                ((Vector)object5).addElement(object2);
            }
            return object5;
        }
        return new Vector();
    }

    private class ColumnSet {
        int ident = -1;
        int gmkName = -1;
        int gmkNr = -1;
        int flur = -1;
        int riss = -1;
        int jahr = -1;
        int auftr = -1;

        public ColumnSet(RissMerger rissMerger) {
        }

        public ColumnSet(RissMerger rissMerger, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.ident = n;
            this.gmkName = n2;
            this.gmkNr = n3;
            this.flur = n4;
            this.riss = n5;
            this.jahr = n6;
            this.auftr = n7;
        }

        public void read(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equalsIgnoreCase("Identnummer")) {
                    this.ident = n;
                } else if (string2.equalsIgnoreCase("Ablagegemarkung")) {
                    this.gmkName = n;
                } else if (string2.equalsIgnoreCase("Gemarkungskennzeichen")) {
                    this.gmkNr = n;
                } else if (string2.equalsIgnoreCase("Ablageflur")) {
                    this.flur = n;
                } else if (string2.equalsIgnoreCase("Rissnummer")) {
                    this.riss = n;
                } else if (string2.equalsIgnoreCase("Jahrgang")) {
                    this.jahr = n;
                } else if (string2.equalsIgnoreCase("Auftr.buchnr.")) {
                    this.auftr = n;
                }
                ++n;
            }
        }
    }

    private class RissData {
        String ident;
        String gmkName;
        String gmkNr;
        String flur;
        String riss;
        String typ;
        String jahr;
        String auftr;
        String file;

        private RissData(RissMerger rissMerger) {
        }

        public boolean parse(String string, ColumnSet columnSet) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() > 0) {
                    if (n == columnSet.ident) {
                        this.ident = string2;
                    } else if (n == columnSet.gmkName) {
                        this.gmkName = string2;
                    } else if (n == columnSet.gmkNr) {
                        this.gmkNr = string2;
                    } else if (n == columnSet.flur) {
                        this.flur = string2;
                    } else if (n == columnSet.jahr) {
                        this.jahr = string2;
                    } else if (n == columnSet.auftr) {
                        this.auftr = string2;
                    } else if (n == columnSet.riss) {
                        int n2 = string2.indexOf(32);
                        if (n2 > 0) {
                            this.typ = string2.substring(0, n2).trim();
                            this.riss = string2.substring(n2 + 1).trim();
                        } else {
                            this.riss = string2;
                        }
                    }
                }
                ++n;
            }
            if (this.ident == null || !IFormat.isNumber(this.ident)) {
                return false;
            }
            if (this.gmkNr == null || !IFormat.isNumber(this.gmkNr)) {
                return false;
            }
            if (this.flur == null || !IFormat.isNumber(this.flur)) {
                return false;
            }
            return this.riss != null;
        }

        public String getName() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(IFormat.getRightString(this.gmkNr, 4, '0'));
            stringBuffer.append("-");
            stringBuffer.append(IFormat.getRightString(this.flur, 3, '0'));
            stringBuffer.append("-");
            stringBuffer.append(IFormat.getRightString(this.riss, 5, '0'));
            if (this.typ != null) {
                stringBuffer.append("-");
                stringBuffer.append(this.typ);
            }
            return stringBuffer.toString();
        }

        public String getFileName(String string) {
            Object object = this.getName();
            if (this.jahr.length() > 1) {
                object = (String)object + "(" + this.jahr + ")";
            }
            if (string != null && string.length() > 0) {
                object = (String)object + "_" + string;
            }
            return object;
        }

        public String getRissName() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.typ != null) {
                stringBuffer.append(this.typ);
            }
            stringBuffer.append(this.riss);
            if (this.jahr.length() > 1) {
                stringBuffer.append("/");
                stringBuffer.append(this.jahr);
            }
            return stringBuffer.toString();
        }

        public String getGmk() {
            String string = this.gmkName + " Flur" + this.flur;
            return string.replace(' ', '_');
        }

        public String getEnt() {
            return this.auftr;
        }
    }
}

