/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IAngleSlider;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IButton;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.KafPlotProperties;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class RotationDialog
extends IOptionDialog
implements ActionListener,
AdjustmentListener,
TextListener {
    private static final String NORTH_COMMAND = "Nord";
    private static final String LEFT_COMMAND = "_left";
    private static final String RIGHT_COMMAND = "_right";
    private TextField rotTextField;
    private IAngleSlider slider;
    private IButton northButton;
    private IButton leftButton;
    private IButton rightButton;
    private int angle = 0;

    public RotationDialog(IFrame iFrame, String string) {
        super(iFrame, string, true);
        this.setLocationOfParent(iFrame, 11);
        this.angle = (int)Math.rint(KafPlotProperties.getGrafikRotation() * 200.0 / Math.PI);
        this.rotTextField.setText(new Integer(this.angle).toString());
        this.setResizable(true);
        this.setDirectlyActivatable(true, KafPlotProperties.isDirectlyDialogs());
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = null;
        label = new Label("Drehung: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints2.fill = 2;
        Panel panel = new Panel(gridBagLayout2);
        gridBagConstraints2.gridwidth = 2;
        this.northButton = new IButton(NORTH_COMMAND);
        panel.add(this.northButton);
        this.northButton.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(this.northButton, gridBagConstraints2);
        this.rotTextField = new TextField(new Integer(this.angle).toString(), 3);
        panel.add(this.rotTextField);
        this.rotTextField.addTextListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagLayout2.setConstraints(this.rotTextField, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        this.leftButton = new IButton(1207, LEFT_COMMAND);
        panel.add(this.leftButton);
        this.leftButton.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagLayout2.setConstraints(this.leftButton, gridBagConstraints2);
        this.rightButton = new IButton(1203, RIGHT_COMMAND);
        panel.add(this.rightButton);
        this.rightButton.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagLayout2.setConstraints(this.rightButton, gridBagConstraints2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        iPanel.add(panel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.slider = new IAngleSlider(0);
        iPanel.add(this.slider);
        this.slider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.slider, gridBagConstraints);
        return iPanel;
    }

    public void update() {
        this.angle = (int)Math.rint(KafPlotProperties.getGrafikRotation() * 200.0 / Math.PI);
        this.rotTextField.setText(new Integer(this.angle).toString());
    }

    @Override
    public void setOptions() {
        try {
            KafPlotProperties.setGrafikRotation(this.getTextValue() * Math.PI / 200.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.slider.setValue((int)Math.rint(this.getTextValue() * 0.9));
        if (this.isDirectly()) {
            this.use();
        } else {
            super.textValueChanged(textEvent);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.angle = (int)Math.rint((double)adjustmentEvent.getValue() / 0.9);
        this.rotTextField.setText(Integer.toString(this.angle));
        if (this.isDirectly()) {
            this.use();
        } else {
            super.adjustmentValueChanged(adjustmentEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(NORTH_COMMAND)) {
            this.angle = 0;
            this.slider.setValue(this.angle);
            this.rotTextField.setText(Integer.toString(this.angle));
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged();
            }
        } else if (string.equals(LEFT_COMMAND)) {
            --this.angle;
            if (this.angle < -200) {
                this.angle += 400;
            }
            this.slider.setValue((int)((double)this.angle * 0.9));
            this.rotTextField.setText(Integer.toString(this.angle));
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged();
            }
        } else if (string.equals(RIGHT_COMMAND)) {
            ++this.angle;
            if (this.angle > 200) {
                this.angle -= 400;
            }
            this.slider.setValue((int)((double)this.angle * 0.9));
            this.rotTextField.setText(Integer.toString(this.angle));
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private double getTextValue() {
        try {
            String string = this.rotTextField.getText().trim().replace(',', '.');
            return new Double(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private void use() {
        if (this.actionListener != null) {
            this.setOptions();
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
        }
    }
}

