/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoPanel;
import de.geocalc.awt.IPanel;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.text.IFormat;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class SearchKooDialog
extends IDialog
implements ActionListener,
FocusListener {
    private static final String NOT_A_NUMBER = "ung\u00fcltige Eingabe";
    private static final String NOT_KOO = "ung\u00fcltige Lage";
    private static final String SEARCH_COMMAND = "Suchen";
    private TextField kooTextField;
    private Button searchButton;
    private IInfoPanel ergPanel;
    private ActionListener actionListener;
    private String actionCommand;
    private DPoint searchPoint = null;
    private String searchString;

    public SearchKooDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        IPanel iPanel = new IPanel(new FlowLayout(0));
        iPanel.setBorder(new IBorder(1));
        iPanel.addFocusListener(this);
        iPanel.add(new Label("Koordinate:"));
        this.kooTextField = new TextField(20);
        iPanel.add(this.kooTextField);
        this.kooTextField.addActionListener(this);
        this.searchButton = new Button(SEARCH_COMMAND);
        iPanel.add(this.searchButton);
        this.searchButton.addActionListener(this);
        this.add("North", iPanel);
        this.ergPanel = new IInfoPanel();
        this.ergPanel.addFocusListener(this);
        this.add("South", this.ergPanel);
        this.pack();
        this.setLocationOfParent(iFrame, 11);
        this.addFocusListener(this);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setText(String string) {
        if (string == null) {
            this.kooTextField.setText("");
        } else {
            this.kooTextField.setText(string);
        }
    }

    public void setInfoText(String string) {
        this.ergPanel.setText(string);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public DPoint getPoint() {
        return this.searchPoint;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object instanceof TextField || string.equals(SEARCH_COMMAND)) {
            this.doStandardAction();
        }
        this.kooTextField.requestFocus();
    }

    @Override
    public void endDialog() {
        this.searchString = null;
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.searchPoint = null;
        try {
            int n;
            int n2;
            DPoint dPoint = new DPoint();
            this.searchString = this.kooTextField.getText().trim();
            boolean bl = false;
            int n3 = 0;
            int n4 = 0;
            block11: for (n2 = 0; n2 < this.searchString.length(); ++n2) {
                switch (this.searchString.charAt(n2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        bl = true;
                        continue block11;
                    }
                    case '.': {
                        if (!bl) continue block11;
                        ++n3;
                        bl = false;
                        continue block11;
                    }
                    case ',': {
                        if (!bl) continue block11;
                        ++n4;
                        bl = false;
                        continue block11;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            n2 = 0;
            if (n3 > 1) {
                n2 = 46;
            } else if (n4 > 1) {
                n2 = 44;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = false;
            boolean bl3 = false;
            this.searchString = this.searchString + " ";
            for (n = 0; n < this.searchString.length(); ++n) {
                boolean bl4 = false;
                char c = this.searchString.charAt(n);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        stringBuffer.append(c);
                        bl3 = true;
                        break;
                    }
                    case ',': 
                    case '.': {
                        if (!bl2 && c == n2 && bl3) {
                            stringBuffer.append('.');
                            bl2 = true;
                            break;
                        }
                        if (!bl3) break;
                        double d = 0.0;
                        if (n2 != 0 && bl2 || n2 == 0 && !bl2) {
                            d = new Double(stringBuffer.toString());
                            bl3 = false;
                            bl2 = false;
                        }
                        stringBuffer = new StringBuffer();
                        if (dPoint.y == 0.0) {
                            dPoint.y = d;
                            break;
                        }
                        if (dPoint.x == 0.0) {
                            dPoint.x = d;
                            break;
                        }
                        bl4 = true;
                        break;
                    }
                    default: {
                        if (!bl3) break;
                        double d = 0.0;
                        if (n2 != 0 && bl2 || n2 == 0 && !bl2) {
                            d = new Double(stringBuffer.toString());
                            bl3 = false;
                            bl2 = false;
                        }
                        stringBuffer = new StringBuffer();
                        if (dPoint.y == 0.0) {
                            dPoint.y = d;
                            break;
                        }
                        if (dPoint.x == 0.0) {
                            dPoint.x = d;
                            break;
                        }
                        bl4 = true;
                    }
                }
                if (bl4) break;
            }
            if (dPoint.y != 0.0 && dPoint.x != 0.0) {
                n = 0;
                if (DataBase.isInArea(dPoint.y, dPoint.x)) {
                    n = 1;
                } else if (DataBase.isInArea(dPoint.x, dPoint.y)) {
                    double d = dPoint.x;
                    dPoint.x = dPoint.y;
                    dPoint.y = d;
                    n = 1;
                } else if (Math.abs(dPoint.y) < 360.0 && Math.abs(dPoint.x) < 360.0 && dPoint.y < DataBase.ymin) {
                    dPoint = this.latLonToYX(dPoint.y, dPoint.x);
                    n = DataBase.isInArea(dPoint.y, dPoint.x) ? 1 : 0;
                }
                if (n == 0) {
                    double d;
                    DPoint dPoint2 = KafPlotProperties.getGrafikCenter();
                    if (dPoint2 == null) {
                        dPoint2 = DataBase.getAreaCenter();
                    }
                    double d2 = DPoint.ptDist(DataBase.ymin, DataBase.xmin, DataBase.ymax, DataBase.xmax) * 10.0;
                    double d3 = this.regular(dPoint.y, dPoint2.y);
                    if (DataBase.isInArea(d3, d = this.regular(dPoint.x, dPoint2.x))) {
                        dPoint.y = d3;
                        dPoint.x = d;
                        n = 1;
                    } else if (DataBase.isInArea(d, d3)) {
                        dPoint.y = d;
                        dPoint.x = d3;
                        n = 1;
                    } else if (DPoint.ptDist(d3, d, dPoint2.y, dPoint2.x) < d2) {
                        dPoint.y = d3;
                        dPoint.x = d;
                        n = 1;
                    } else if (DPoint.ptDist(d, d3, dPoint2.y, dPoint2.x) < d2) {
                        dPoint.y = d;
                        dPoint.x = d3;
                        n = 1;
                    } else {
                        n = 0;
                    }
                }
                if (n != 0) {
                    this.searchPoint = dPoint;
                    this.ergPanel.setText(IFormat.f_3.format(dPoint.y) + " : " + IFormat.f_3.format(dPoint.x));
                    if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                } else {
                    this.ergPanel.setText(NOT_KOO);
                }
            } else {
                this.ergPanel.setText(NOT_A_NUMBER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.searchString = null;
        }
        this.kooTextField.selectAll();
        this.kooTextField.requestFocus();
    }

    private DPoint latLonToYX(double d, double d2) {
        if (d < d2) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        double[] dArray = new double[2];
        int n = KoordinatenSystem.LatLonToUTMXY(d * Math.PI / 180.0, d2 * Math.PI / 180.0, KoordinatenSystem.getZone(DataBase.ymin), dArray);
        return new DPoint(dArray[0] + (double)(n % 10) * 1000000.0, dArray[1]);
    }

    private double regular(double d, double d2) {
        try {
            String string = IFormat.f_3.format(d2);
            int n = string.indexOf(".");
            String string2 = IFormat.f_3.format(d);
            String string3 = string2.substring(0, string2.indexOf("."));
            String string4 = string2.substring(string2.indexOf(".") + 1);
            int n2 = string3.length();
            if (n2 > n) {
                return new Double(string3.substring(n2 - n) + "." + string4);
            }
            if (n2 < n) {
                return new Double(string.substring(0, n - n2) + string3 + "." + string4);
            }
            return d;
        }
        catch (Exception exception) {
            return d;
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.kooTextField.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

