/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomException;
import de.geocalc.geom.YComparator;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.ExtendedPunktFilter;
import de.geocalc.kafplot.ExtendedPunktFilterDialog;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.Punkt;
import de.geocalc.util.Comparator;
import de.geocalc.util.SortableVector;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SearchNearPointsDialog
extends IDialog
implements ActionListener,
ItemListener {
    private static final String DO_COMMAND = "Suchen";
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String FILTER_COMMAND = "Einstellen";
    private static final int ACTION_NO = 0;
    private static final int ACTION_FILTER = 1;
    private static final int ACTION_MENGE = 2;
    private static final int ACTION_ERROR = 3;
    private static final int ACTION_IDENT = 4;
    protected ActionListener listener;
    protected DataBase db;
    protected IProgressBar progressBar;
    protected Label progressLabel;
    private TextField radiusTextfield;
    private Checkbox searchMengeCheckbox;
    private Checkbox actionMengeCheckbox;
    private Checkbox actionErrorCheckbox;
    private Checkbox actionIdentCheckbox;
    private Checkbox finalIdentCheckbox;
    private Checkbox actionIdentNoCheckbox;
    private Checkbox actionIdentFilterCheckbox;
    private Checkbox actionIdentMengeCheckbox;
    private Checkbox actionIdentStatusCheckbox;
    private Checkbox actionIdentAmtlCheckbox;
    private Checkbox actionIdentBalanceCheckbox;
    private Label sollLabel;
    protected Button doButton;
    protected Button okButton;
    protected Button abortButton;
    protected Button filterButton;
    protected Hashtable ergs;
    private int action = 0;
    private ExtendedPunktFilter filter;

    public SearchNearPointsDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        this.filter = new ExtendedPunktFilter(dataBase);
        this.setLayout(new BorderLayout());
        this.add("North", this.createDialogPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(false);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    protected Panel createDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        Panel panel = new Panel(gridBagLayout);
        IPanel iPanel = null;
        iPanel = this.createOptionPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        iPanel = this.createActionPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        iPanel = this.createProgressPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        return panel;
    }

    private IPanel createOptionPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Optionen"));
        Label label = new Label("Suchradius: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.radiusTextfield = new TextField(12);
        iPanel.add(this.radiusTextfield);
        this.radiusTextfield.setText("0.001");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.radiusTextfield, gridBagConstraints);
        SearchNearPointsDialog searchNearPointsDialog = this;
        this.searchMengeCheckbox = new Checkbox("nur Menge untersuchen", searchNearPointsDialog.db.hasMenge());
        iPanel.add(this.searchMengeCheckbox);
        SearchNearPointsDialog searchNearPointsDialog2 = this;
        this.searchMengeCheckbox.setEnabled(searchNearPointsDialog2.db.hasMenge());
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.searchMengeCheckbox, gridBagConstraints);
        return iPanel;
    }

    private IPanel createActionPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Aktion"));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.actionMengeCheckbox = new Checkbox("Menge erzeugen", true, checkboxGroup);
        iPanel.add(this.actionMengeCheckbox);
        this.actionMengeCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.actionMengeCheckbox, gridBagConstraints);
        this.actionErrorCheckbox = new Checkbox("Fehlermeldung erzeugen", false, checkboxGroup);
        iPanel.add(this.actionErrorCheckbox);
        this.actionErrorCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.actionErrorCheckbox, gridBagConstraints);
        this.actionIdentCheckbox = new Checkbox("Punktidentit\u00e4t erzeugen", false, checkboxGroup);
        iPanel.add(this.actionIdentCheckbox);
        this.actionIdentCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.actionIdentCheckbox, gridBagConstraints);
        this.finalIdentCheckbox = new Checkbox("endg\u00fcltig", false);
        iPanel.add(this.finalIdentCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.finalIdentCheckbox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 30, 1, 1);
        checkboxGroup = new CheckboxGroup();
        this.sollLabel = new Label("Sollpunktentscheidung: ");
        iPanel.add(this.sollLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.sollLabel, gridBagConstraints);
        this.actionIdentNoCheckbox = new Checkbox("kein Sollpunkt", true, checkboxGroup);
        iPanel.add(this.actionIdentNoCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.actionIdentNoCheckbox, gridBagConstraints);
        this.actionIdentFilterCheckbox = new Checkbox("Filter", true, checkboxGroup);
        iPanel.add(this.actionIdentFilterCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.actionIdentFilterCheckbox, gridBagConstraints);
        this.actionIdentMengeCheckbox = new Checkbox("Mengenpunke", false, checkboxGroup);
        iPanel.add(this.actionIdentMengeCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.actionIdentMengeCheckbox, gridBagConstraints);
        this.actionIdentStatusCheckbox = new Checkbox("Punktstatus", false, checkboxGroup);
        iPanel.add(this.actionIdentStatusCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.actionIdentStatusCheckbox, gridBagConstraints);
        this.actionIdentAmtlCheckbox = new Checkbox("amtliche Punkte", false, checkboxGroup);
        iPanel.add(this.actionIdentAmtlCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.actionIdentAmtlCheckbox, gridBagConstraints);
        this.actionIdentBalanceCheckbox = new Checkbox("Schwerpunkt", false, checkboxGroup);
        iPanel.add(this.actionIdentBalanceCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagLayout.setConstraints(this.actionIdentBalanceCheckbox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.filterButton = new Button(FILTER_COMMAND);
        iPanel.add(this.filterButton);
        this.filterButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.filterButton, gridBagConstraints);
        this.setBoxes();
        return iPanel;
    }

    private IPanel createProgressPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1));
        this.progressBar = new IProgressBar();
        iPanel.add("North", this.progressBar);
        this.progressLabel = new Label("   ");
        iPanel.add("South", this.progressLabel);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        this.doButton = new Button(DO_COMMAND);
        this.doButton.addActionListener(this);
        panel.add(this.doButton);
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DO_COMMAND)) {
            this.doStandardAction();
            this.okButton.setEnabled(true);
        } else if (string.equals(OK_COMMAND)) {
            this.saveErgs();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
            }
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals(FILTER_COMMAND)) {
            ExtendedPunktFilterDialog extendedPunktFilterDialog = new ExtendedPunktFilterDialog(this.parent, "Filter", this.db, this.filter, false);
            extendedPunktFilterDialog.setVisible(true);
            if (extendedPunktFilterDialog.getFilter() != null) {
                this.filter = extendedPunktFilterDialog.getFilter();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.setBoxes();
    }

    private void setBoxes() {
        if (this.actionMengeCheckbox.getState()) {
            this.finalIdentCheckbox.setEnabled(false);
            this.sollLabel.setEnabled(true);
            this.actionIdentNoCheckbox.setEnabled(true);
            this.actionIdentFilterCheckbox.setEnabled(true);
            this.filterButton.setEnabled(true);
            this.actionIdentMengeCheckbox.setEnabled(true);
            this.actionIdentStatusCheckbox.setEnabled(true);
            this.actionIdentAmtlCheckbox.setEnabled(true);
            this.actionIdentBalanceCheckbox.setEnabled(true);
        } else if (this.actionErrorCheckbox.getState()) {
            this.finalIdentCheckbox.setEnabled(false);
            this.sollLabel.setEnabled(false);
            this.actionIdentNoCheckbox.setEnabled(false);
            this.actionIdentFilterCheckbox.setEnabled(false);
            this.filterButton.setEnabled(false);
            this.actionIdentMengeCheckbox.setEnabled(false);
            this.actionIdentStatusCheckbox.setEnabled(false);
            this.actionIdentAmtlCheckbox.setEnabled(false);
            this.actionIdentBalanceCheckbox.setEnabled(false);
        } else if (this.actionIdentCheckbox.getState()) {
            this.finalIdentCheckbox.setEnabled(true);
            this.sollLabel.setEnabled(true);
            this.actionIdentNoCheckbox.setEnabled(false);
            this.actionIdentFilterCheckbox.setEnabled(true);
            this.filterButton.setEnabled(true);
            this.actionIdentMengeCheckbox.setEnabled(true);
            this.actionIdentStatusCheckbox.setEnabled(true);
            this.actionIdentAmtlCheckbox.setEnabled(true);
            this.actionIdentBalanceCheckbox.setEnabled(true);
            if (this.actionIdentNoCheckbox.getState()) {
                this.actionIdentFilterCheckbox.setState(true);
            }
        }
    }

    @Override
    protected void doStandardAction() {
        this.action = this.actionMengeCheckbox.getState() ? 2 : (this.actionErrorCheckbox.getState() ? 3 : (this.actionIdentCheckbox.getState() ? 4 : 0));
        this.ergs = new Hashtable(100);
        double d = 0.0;
        try {
            d = Math.abs(new Double(this.radiusTextfield.getText()));
        }
        catch (Exception exception) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Ung\u00fcltiger Suchradius '" + this.radiusTextfield.getText() + "'");
            errorDialog.setVisible(true);
            return;
        }
        this.progressLabel.setText("Suche vorbereiten...");
        this.progressBar.setValue(0);
        this.sleep();
        SortableVector sortableVector = null;
        SearchNearPointsDialog searchNearPointsDialog = this;
        sortableVector = searchNearPointsDialog.db.hasMenge() && this.searchMengeCheckbox.getState() ? new SortableVector(DataBase.MENGE.elements(), (Comparator)new YComparator()) : new SortableVector(DataBase.P.elements(), (Comparator)new YComparator());
        this.progressBar.setValue(10);
        this.progressLabel.setText("Suchen...");
        this.sleep();
        int n = Math.max(sortableVector.size() / 20, 1);
        double d2 = d * d;
        int n2 = 0;
        int n3 = sortableVector.size();
        Vector<Punkt> vector = new Vector<Punkt>(10);
        for (int i = 0; i < n3; ++i) {
            vector.removeAllElements();
            Punkt punkt = (Punkt)sortableVector.elementAt(i);
            for (int j = n2; j < n3; ++j) {
                if (j == i) continue;
                Punkt punkt2 = (Punkt)sortableVector.elementAt(j);
                double d3 = punkt.y - punkt2.y;
                if (d3 > d) {
                    n2 = j + 1;
                    continue;
                }
                if (d3 < -d) break;
                double d4 = punkt.x - punkt2.x;
                if (!(d3 * d3 + d4 * d4 <= d2)) continue;
                vector.addElement(punkt2);
            }
            if (vector.size() > 0) {
                SearchResult searchResult = new SearchResult(this, punkt, vector);
                this.ergs.put(searchResult, searchResult);
            }
            if (i % n != 0) continue;
            this.progressBar.setValue(i * 90 / n3 + 10);
            this.progressLabel.setText("Suchen... (" + this.ergs.size() + ")");
            this.sleep();
        }
        this.progressBar.setValue(100);
        this.progressLabel.setText("Gefunden (" + this.ergs.size() + ")");
        this.sleep();
    }

    private void saveErgs() {
        boolean bl = this.finalIdentCheckbox.getState();
        if (this.action == 2) {
            SearchNearPointsDialog searchNearPointsDialog = this;
            searchNearPointsDialog.db.removeMenge();
        } else if (this.action == 3 || this.action == 4) {
            // empty if block
        }
        this.progressBar.setValue(0);
        this.progressLabel.setText("Speichern...");
        this.sleep();
        int n = Math.max(this.ergs.size() / 20, 1);
        int n2 = 0;
        Enumeration enumeration = this.ergs.elements();
        while (enumeration.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)enumeration.nextElement();
            Punkt[] punktArray = searchResult.points();
            if (this.action == 2) {
                var7_7 = this.getMasterPointIndex(punktArray);
                if (var7_7 >= 0 || var7_7 == -2) {
                    for (int i = 0; i < punktArray.length; ++i) {
                        if (i == var7_7) continue;
                        DataBase.MENGE.put(punktArray[i]);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer(30);
                    stringBuffer.append("Punkwolke ");
                    this.appendPointNames(stringBuffer, punktArray, 0);
                    stringBuffer.append(" hat " + (var7_7 == -1 ? "keine" : "mehrere") + " Sollpunkte");
                    DataBase.ERR.addElement(new ErrorObject("SearchNearPoints", new GeomException(punktArray[0], punktArray[0], stringBuffer.toString())));
                }
            } else if (this.action == 3) {
                StringBuffer stringBuffer = new StringBuffer(30);
                stringBuffer.append("Punkt ");
                stringBuffer.append(punktArray[0].nr);
                stringBuffer.append(" doppelt mit ");
                this.appendPointNames(stringBuffer, punktArray, 1);
                DataBase.ERR.addElement(new ErrorObject("SearchNearPoints", new GeomException(punktArray[0], punktArray[0], stringBuffer.toString())));
            } else if (this.action == 4) {
                var7_7 = this.getMasterPointIndex(punktArray);
                if (var7_7 >= 0) {
                    for (int i = 0; i < punktArray.length; ++i) {
                        if (i == var7_7) continue;
                        Identitaet identitaet = new Identitaet(punktArray[i], punktArray[var7_7], bl ? 2 : 1);
                        if (DataBase.PI.get(identitaet.longHashKey()) != null) continue;
                        DataBase.PI.put(identitaet);
                        DataBase.isSaved = false;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer(30);
                    stringBuffer.append("Punkwolke ");
                    this.appendPointNames(stringBuffer, punktArray, 0);
                    stringBuffer.append(" hat " + (var7_7 == -1 ? "keine" : "mehrere") + " Sollpunkte");
                    DataBase.ERR.addElement(new ErrorObject("SearchNearPoints", new GeomException(punktArray[0], punktArray[0], stringBuffer.toString())));
                }
            }
            if (n2 % n == 0) {
                this.progressBar.setValue(n2 * 100 / this.ergs.size());
                this.sleep();
            }
            ++n2;
        }
    }

    private int getMasterPointIndex(Punkt[] punktArray) {
        int n;
        if (this.actionIdentNoCheckbox.getState()) {
            return -2;
        }
        int n2 = -1;
        int n3 = -2147483647;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        if (this.actionIdentBalanceCheckbox.getState()) {
            for (n = 0; n < punktArray.length; ++n) {
                d += punktArray[n].y;
                d2 += punktArray[n].x;
            }
            d /= (double)n;
            d2 /= (double)n;
        }
        for (n = 0; n < punktArray.length; ++n) {
            double d4;
            if (this.actionIdentFilterCheckbox.getState()) {
                if (!this.filter.isPunktEnabled(punktArray[n])) continue;
                n2 = n2 == -1 ? n : -9;
                continue;
            }
            if (this.actionIdentMengeCheckbox.getState()) {
                if (!DataBase.MENGE.contains(punktArray[n])) continue;
                n2 = n2 == -1 ? n : -9;
                continue;
            }
            if (this.actionIdentStatusCheckbox.getState()) {
                if (punktArray[n].getPs() > n3) {
                    n3 = punktArray[n].getPs();
                    n2 = n;
                    continue;
                }
                if (punktArray[n].getPs() != n3) continue;
                n2 = -9;
                continue;
            }
            if (this.actionIdentAmtlCheckbox.getState()) {
                if (!punktArray[n].isKatasterPunkt()) continue;
                n2 = n2 == -1 ? n : -9;
                continue;
            }
            if (!this.actionIdentBalanceCheckbox.getState() || !((d4 = DPoint.ptDistSq(d, d2, punktArray[n].y, punktArray[n].x)) < d3)) continue;
            d3 = d4;
            n2 = n;
        }
        return n2;
    }

    private void appendPointNames(StringBuffer stringBuffer, Punkt[] punktArray, int n) {
        boolean bl = false;
        for (int i = n; i < punktArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(punktArray[i].nr);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    private class SearchResult {
        Punkt[] pp;
        long minNr;

        SearchResult(SearchNearPointsDialog searchNearPointsDialog, Punkt punkt, Vector vector) {
            this.pp = new Punkt[vector.size() + 1];
            this.pp[0] = punkt;
            this.minNr = punkt.nr;
            for (int i = 0; i < vector.size(); ++i) {
                this.pp[i + 1] = punkt = (Punkt)vector.elementAt(i);
                this.minNr = Math.min(this.minNr, punkt.nr);
            }
        }

        Punkt[] points() {
            return this.pp;
        }

        public int hashCode() {
            return (int)(this.minNr ^ this.minNr >> 32);
        }

        public boolean equals(Object object) {
            Punkt[] punktArray = ((SearchResult)object).points();
            if (this.pp.length != punktArray.length) {
                return false;
            }
            for (int i = 0; i < this.pp.length; ++i) {
                Punkt punkt = this.pp[i];
                boolean bl = false;
                for (int j = 0; j < punktArray.length; ++j) {
                    if (punkt.nr != punktArray[j].nr) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
    }
}

