/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.ICardPanel;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoPanel;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectListSource;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.TopObject;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.IntegerComparator;
import de.geocalc.util.SortableVector;
import de.geocalc.util.StringComparator;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SearchObjectDialog
extends IDialog
implements ActionListener,
ItemListener,
FocusListener,
ObjectListSource {
    private static final String SEARCH_COMMAND = "Suchen";
    private static final String LIST_COMMAND = "Liste";
    private static final String LIST_FLST = "Flurst\u00fccksliste";
    private static final String SEARCH_FLST = "Flurst\u00fcck";
    private static final String LIST_GEB = "Geb\u00e4udeliste";
    private static final String SEARCH_GEB = "Geb\u00e4ude";
    private static final String LIST_TOP = "Topographieliste";
    private static final String SEARCH_TOP = "Topographie";
    private static final String LIST_BUCH = "Eigent\u00fcmerliste";
    private static final String SEARCH_BUCH = "Eigent\u00fcmer";
    private static final String VOID_GEM = "           ";
    private static final String VOID_FLUR = "     ";
    private TextField inTextField;
    private Button flstButton;
    private Button gebButton;
    private Button topButton;
    private Button buchButton;
    private IInfoPanel ergPanel;
    private ActionListener actionListener;
    private String actionCommand;
    private String searchString;
    private Choice gmkChoice;
    private Choice flurChoice;
    private TextField nummerTextField;
    private TextField flstTextField;
    private Choice gmdChoice;
    private Choice strChoice;
    private TextField hsnrTextField;
    private TextField gebTextField;
    private TextField topTextField;
    private Choice bzkChoice;
    private Choice blattChoice;
    private TextField nameTextField;
    private TextField buchTextField;
    private ICardPanel cardPanel = null;
    private Vector searchResult = new Vector();
    private Vector searchNames = new Vector();
    private int searchResultIndex = -1;

    public SearchObjectDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.cardPanel = new ICardPanel();
        this.cardPanel.addCard(SEARCH_FLST, this.createFlstPanel());
        this.cardPanel.addCard(SEARCH_GEB, this.createGebPanel());
        this.cardPanel.addCard(SEARCH_TOP, this.createTopPanel());
        this.cardPanel.addCard(SEARCH_BUCH, this.createBuchPanel());
        this.cardPanel.addItemListener(this);
        this.add("North", this.cardPanel);
        this.ergPanel = new IInfoPanel();
        this.ergPanel.addFocusListener(this);
        this.add("South", this.ergPanel);
        this.pack();
        this.setLocationOfParent(iFrame, 11);
        this.addFocusListener(this);
    }

    private IPanel createFlstPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Gemarkung: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmkChoice = new Choice();
        iPanel.add(this.gmkChoice);
        this.gmkChoice.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.gmkChoice, gridBagConstraints);
        label = new Label("Flur: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.flurChoice = new Choice();
        iPanel.add(this.flurChoice);
        this.flurChoice.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.flurChoice, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        label = new Label("Flurst\u00fcck: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.nummerTextField = new TextField(10);
        iPanel.add(this.nummerTextField);
        this.nummerTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.nummerTextField, gridBagConstraints);
        label = new Label("Inhalt: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.flstTextField = new TextField(10);
        iPanel.add(this.flstTextField);
        this.flstTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.flstTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 10);
        gridBagConstraints.fill = 0;
        Panel panel = this.createButtonPanel();
        iPanel.add(panel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.flstButton = (Button)panel.getComponent(0);
        this.fillFlstChoices(-1);
        return iPanel;
    }

    private IPanel createGebPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Gemeinde: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmdChoice = new Choice();
        iPanel.add(this.gmdChoice);
        this.gmdChoice.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.gmdChoice, gridBagConstraints);
        label = new Label("Stra\u00dfe: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.strChoice = new Choice();
        iPanel.add(this.strChoice);
        this.strChoice.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.strChoice, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        label = new Label("Hausnummer: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.hsnrTextField = new TextField(10);
        iPanel.add(this.hsnrTextField);
        this.hsnrTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.hsnrTextField, gridBagConstraints);
        label = new Label("Inhalt: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gebTextField = new TextField(10);
        iPanel.add(this.gebTextField);
        this.gebTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.gebTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 9);
        gridBagConstraints.fill = 0;
        Panel panel = this.createButtonPanel();
        iPanel.add(panel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.gebButton = (Button)panel.getComponent(0);
        this.fillGebChoices(-1);
        return iPanel;
    }

    private IPanel createTopPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        Panel panel = new Panel();
        iPanel.add(panel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        Label label = new Label("Inhalt: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 1, 12, 1);
        this.topTextField = new TextField(10);
        iPanel.add(this.topTextField);
        this.topTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.topTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(1, 10, 12, 10);
        gridBagConstraints.fill = 0;
        panel = this.createButtonPanel();
        iPanel.add(panel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.topButton = (Button)panel.getComponent(0);
        return iPanel;
    }

    private IPanel createBuchPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Grundbuchbezirk: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bzkChoice = new Choice();
        iPanel.add(this.bzkChoice);
        this.bzkChoice.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.bzkChoice, gridBagConstraints);
        label = new Label("Grundbuchblatt: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.blattChoice = new Choice();
        iPanel.add(this.blattChoice);
        this.blattChoice.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.blattChoice, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        label = new Label("Name: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.nameTextField = new TextField(10);
        iPanel.add(this.nameTextField);
        this.nameTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.nameTextField, gridBagConstraints);
        label = new Label("Inhalt: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.buchTextField = new TextField(10);
        iPanel.add(this.buchTextField);
        this.buchTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.buchTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 10);
        gridBagConstraints.fill = 0;
        Panel panel = this.createButtonPanel();
        iPanel.add(panel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.buchButton = (Button)panel.getComponent(0);
        this.fillBuchChoices(-1);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new GridLayout(2, 0, 2, 2));
        Button button = new Button(LIST_COMMAND);
        panel.add(button);
        button.addActionListener(this);
        button.setEnabled(false);
        button = new Button(SEARCH_COMMAND);
        panel.add(button);
        button.addActionListener(this);
        return panel;
    }

    private void fillFlstChoices(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            int n4;
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            int n5 = flurstueck.getGemarkung();
            if (n <= 0 && n5 != n2 && n5 > -1) {
                Gemarkung gemarkung = Gemarkung.getGemarkung(n5);
                if (gemarkung != null) {
                    hashtable.put(gemarkung.getName(), gemarkung.getName());
                } else {
                    hashtable.put(Integer.toString(n5), Integer.toString(n5));
                }
                n2 = n5;
            }
            if (n > 0 && n != n5 || (n4 = flurstueck.getFlur()) == n3 || n4 <= -1) continue;
            hashtable2.put(IFormat.i03.format(n4), IFormat.i03.format(n4));
            n3 = n4;
        }
        if (n <= 0) {
            this.gmkChoice.removeAll();
            this.gmkChoice.addItem(VOID_GEM);
            enumeration = new SortableVector(hashtable, (Comparator)new StringComparator()).elements();
            while (enumeration.hasMoreElements()) {
                this.gmkChoice.addItem(enumeration.nextElement().toString());
            }
        }
        this.flurChoice.removeAll();
        this.flurChoice.addItem(VOID_FLUR);
        enumeration = new SortableVector(hashtable2, (Comparator)new StringComparator()).elements();
        while (enumeration.hasMoreElements()) {
            this.flurChoice.addItem(enumeration.nextElement().toString());
        }
    }

    private void fillGebChoices(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = DataBase.GEB.elements();
        while (enumeration.hasMoreElements()) {
            int n4;
            Gebaeude gebaeude = (Gebaeude)enumeration.nextElement();
            if (!gebaeude.hasLeitzeichen()) continue;
            GebaeudeKennzeichen gebaeudeKennzeichen = gebaeude.getLeitzeichen();
            int n5 = gebaeudeKennzeichen.getGemeinde();
            if (n <= 0 && n5 != n2 && n5 > 0) {
                Gemeinde gemeinde = Gemeinde.getGemeinde(n5);
                if (gemeinde != null) {
                    hashtable.put(gemeinde.getName(), gemeinde.getName());
                } else {
                    hashtable.put(Integer.toString(n5), Integer.toString(n5));
                }
                n2 = n5;
            }
            if (n > 0 && n != n5 || (n4 = gebaeudeKennzeichen.getStrasse()) == n3 || n4 <= 0) continue;
            hashtable2.put(gebaeudeKennzeichen.getStrasseAsString(), gebaeudeKennzeichen.getStrasseAsString());
            n3 = n4;
        }
        if (n <= 0) {
            this.gmdChoice.removeAll();
            this.gmdChoice.addItem(VOID_GEM);
            enumeration = new SortableVector(hashtable, (Comparator)new StringComparator()).elements();
            while (enumeration.hasMoreElements()) {
                this.gmdChoice.addItem(enumeration.nextElement().toString());
            }
        }
        this.strChoice.removeAll();
        this.strChoice.addItem(VOID_GEM);
        enumeration = new SortableVector(hashtable2, (Comparator)new StringComparator()).elements();
        while (enumeration.hasMoreElements()) {
            this.strChoice.addItem(enumeration.nextElement().toString());
        }
    }

    private void fillBuchChoices(int n) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        int n2 = 0;
        Object object = null;
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            Enumeration enumeration2 = flurstueck.buchungen();
            while (enumeration2.hasMoreElements()) {
                Object object2;
                Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration2.nextElement();
                String string = buchungsstelle.getGrundbuchblattName();
                int n3 = Grundbuchblatt.getBezirk(string);
                if (n <= 0 && n3 != n2 && n3 > 0) {
                    object2 = new Integer(n3);
                    hashtable.put(object2, object2);
                    n2 = n3;
                }
                if (n > 0 && n != n3 || (object2 = Grundbuchblatt.getBlatt(string)) == null || ((String)object2).length() <= 0 || ((String)object2).equals(object)) continue;
                hashtable2.put(object2, object2);
                object = object2;
            }
        }
        if (n <= 0) {
            this.bzkChoice.removeAll();
            this.bzkChoice.addItem(VOID_GEM);
            enumeration = new SortableVector(hashtable, (Comparator)new IntegerComparator()).elements();
            while (enumeration.hasMoreElements()) {
                this.bzkChoice.addItem(enumeration.nextElement().toString());
            }
        }
        this.blattChoice.removeAll();
        this.blattChoice.addItem(VOID_FLUR);
        enumeration = new SortableVector(hashtable2, (Comparator)new StringComparator()).elements();
        while (enumeration.hasMoreElements()) {
            this.blattChoice.addItem(enumeration.nextElement().toString());
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    public GObject getResult() {
        if (this.searchResultIndex < 0) {
            return null;
        }
        try {
            return (GObject)this.searchResult.elementAt(this.searchResultIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Enumeration getObjects() {
        return this.cardPanel.getVisibleCard().equals(SEARCH_BUCH) ? this.searchNames.elements() : this.searchResult.elements();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        int n = -1;
        if (object == this.gmkChoice) {
            String string = this.gmkChoice.getSelectedItem().trim();
            if (string.length() > 0) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n = Gemarkung.getGemarkung(null, string).getNummer();
                }
            }
            this.fillFlstChoices(n);
        } else if (object == this.gmdChoice) {
            String string = this.gmdChoice.getSelectedItem().trim();
            if (string.length() > 0) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n = Gemeinde.getGemeinde(string).getNummer();
                }
            }
            this.fillGebChoices(n);
        }
        this.searchResultIndex = -1;
        this.searchResult.removeAllElements();
        this.searchString = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object instanceof TextField || string.equals(SEARCH_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(LIST_COMMAND)) {
            String string2 = this.cardPanel.getVisibleCard();
            if (string2.equals(SEARCH_FLST)) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_list_flst"));
            } else if (string2.equals(SEARCH_GEB)) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_list_geb"));
            } else if (string2.equals(SEARCH_TOP)) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_list_top"));
            } else if (string2.equals(SEARCH_BUCH)) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_list_buch"));
            }
        }
    }

    @Override
    protected void doStandardAction() {
        String string = this.cardPanel.getVisibleCard();
        Object object = null;
        if (string.equals(SEARCH_FLST)) {
            object = this.gmkChoice.getSelectedItem().trim() + this.flurChoice.getSelectedItem().trim() + this.nummerTextField.getText().trim() + this.flstTextField.getText().trim();
        } else if (string.equals(SEARCH_GEB)) {
            object = this.gmdChoice.getSelectedItem().trim() + this.strChoice.getSelectedItem().trim() + this.hsnrTextField.getText().trim() + this.gebTextField.getText().trim();
        } else if (string.equals(SEARCH_TOP)) {
            object = this.topTextField.getText().trim();
        } else if (string.equals(SEARCH_BUCH)) {
            object = this.bzkChoice.getSelectedItem().trim() + this.blattChoice.getSelectedItem().trim() + this.nameTextField.getText().trim() + this.buchTextField.getText().trim();
        }
        if (object == null) {
            return;
        }
        if (((String)object).length() == 0) {
            this.ergPanel.setText("");
            this.searchResult.removeAllElements();
            this.searchNames.removeAllElements();
        } else if (((String)object).equals(this.searchString)) {
            if (this.searchResult.size() > 1) {
                ++this.searchResultIndex;
                if (this.searchResultIndex >= this.searchResult.size()) {
                    this.searchResultIndex = 0;
                }
                GObject gObject = (GObject)this.searchResult.elementAt(this.searchResultIndex);
                this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName() + "   (" + (this.searchResultIndex + 1) + " von " + this.searchResult.size() + ")");
            }
            if (this.actionListener != null && this.actionCommand != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
        } else {
            this.flstButton.setEnabled(false);
            this.gebButton.setEnabled(false);
            this.topButton.setEnabled(false);
            this.buchButton.setEnabled(false);
            if (string.equals(SEARCH_FLST)) {
                this.createFlstSearchResult();
                this.flstButton.setEnabled(this.searchResult.size() > 0);
            } else if (string.equals(SEARCH_GEB)) {
                this.createGebSearchResult();
                this.gebButton.setEnabled(this.searchResult.size() > 0);
            } else if (string.equals(SEARCH_TOP)) {
                this.createTopSearchResult();
                this.topButton.setEnabled(this.searchResult.size() > 0);
            } else if (string.equals(SEARCH_BUCH)) {
                this.createBuchSearchResult();
                this.buchButton.setEnabled(this.searchResult.size() > 0);
            }
            if (this.searchResultIndex >= 0) {
                if (this.searchResult.size() == 0) {
                    this.ergPanel.setText("kein Objekt gefunden");
                } else {
                    GObject gObject = (GObject)this.searchResult.elementAt(0);
                    if (this.searchResult.size() == 1) {
                        this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName());
                    } else {
                        this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName() + "   (" + (this.searchResultIndex + 1) + " von " + this.searchResult.size() + ")");
                    }
                    if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                }
            }
        }
        this.searchString = object;
    }

    private void createFlstSearchResult() {
        Object object;
        Object object2;
        String string;
        Object object3;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block18: {
            n5 = -1;
            n4 = -1;
            n3 = -1;
            n2 = -1;
            n = -1;
            String string2 = this.gmkChoice.getSelectedItem().trim();
            if (string2.length() > 0) {
                try {
                    n5 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    object3 = Gemarkung.getGemarkung(null, string2);
                    if (object3 == null) break block18;
                    n5 = ((Gemarkung)object3).getNummer();
                }
            }
        }
        if ((string = this.flurChoice.getSelectedItem().trim()).length() > 0) {
            try {
                n4 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (((String)(object3 = this.nummerTextField.getText().trim())).length() > 0) {
            object2 = new StringTokenizer((String)object3, " ,:-/\\");
            int n6 = 0;
            try {
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    switch (n6) {
                        case 0: {
                            n3 = Integer.parseInt((String)object);
                            break;
                        }
                        case 1: {
                            n2 = Integer.parseInt((String)object);
                            break;
                        }
                        case 2: {
                            n = Integer.parseInt((String)object);
                            break;
                        }
                        default: {
                            throw new NumberFormatException();
                        }
                    }
                    ++n6;
                }
            }
            catch (Exception exception) {
                this.ergPanel.setText("Ung\u00fcltige Flurst\u00fccksnummer: " + (String)object3);
                this.searchResultIndex = -1;
                return;
            }
        }
        object2 = this.flstTextField.getText().trim();
        Vector vector = null;
        if (((String)object2).length() > 0) {
            vector = this.createSearchHash((String)object2);
        } else {
            object2 = null;
        }
        this.searchResult.removeAllElements();
        object = DataBase.FLST.elements();
        while (object.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)object.nextElement();
            if (n5 >= 0 && n5 != flurstueck.getGemarkung() || n4 >= 0 && n4 != flurstueck.getFlur() || n3 >= 0 && n3 != flurstueck.getZaehler() || n2 >= 0 && n2 != flurstueck.getNenner() || n >= 0 && n != flurstueck.getTeil() || object2 != null && !this.compareObjectContent(flurstueck.toDatLine(), vector)) continue;
            this.searchResult.addElement(flurstueck);
        }
        this.searchResultIndex = 0;
    }

    private void createGebSearchResult() {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        boolean bl;
        String string2;
        int n;
        int n2;
        int n3;
        int n4;
        block27: {
            n4 = -1;
            n3 = -1;
            n2 = -1;
            n = -1;
            string2 = null;
            bl = false;
            String string3 = this.gmdChoice.getSelectedItem().trim();
            if (string3.length() > 0) {
                try {
                    n4 = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    object4 = Gemeinde.getGemeinde(string3);
                    if (object4 == null) break block27;
                    n4 = ((Gemeinde)object4).getNummer();
                }
            }
        }
        if ((string = this.strChoice.getSelectedItem().trim()).length() > 0) {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (((String)(object4 = this.hsnrTextField.getText().trim())).length() > 0) {
            object3 = new StringTokenizer((String)object4, " ,:-/\\");
            int n5 = 0;
            try {
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    switch (n5) {
                        case 0: {
                            if (((String)object2).charAt(0) == 'p' || ((String)object2).charAt(0) == 'P') {
                                bl = true;
                                object2 = ((String)object2).substring(1);
                            }
                            if (((String)(object = IFormat.getFirstNumbers((String)object2))).length() > 0) {
                                n2 = Integer.parseInt((String)object);
                            }
                            if (((String)object2).length() <= ((String)object).length()) break;
                            string2 = ((String)object2).substring(((String)object).length());
                            break;
                        }
                        case 1: {
                            n = Integer.parseInt((String)object2);
                            break;
                        }
                        default: {
                            throw new NumberFormatException();
                        }
                    }
                    ++n5;
                }
            }
            catch (Exception exception) {
                this.ergPanel.setText("Ung\u00fcltige Hausnummer: " + (String)object4);
                this.searchResultIndex = -1;
                return;
            }
        }
        object3 = this.gebTextField.getText().trim();
        Vector vector = null;
        object2 = null;
        if (((String)object3).length() > 0) {
            if (((String)object3).indexOf("=") >= 0) {
                vector = this.createSearchHash((String)object3);
            } else {
                object2 = this.createTextHash((String)object3);
            }
        } else {
            object3 = null;
        }
        this.searchResult.removeAllElements();
        object = DataBase.GEB.elements();
        while (object.hasMoreElements()) {
            Gebaeude gebaeude = (Gebaeude)object.nextElement();
            boolean bl2 = false;
            boolean bl3 = false;
            if (gebaeude.hasLeitzeichen()) {
                bl2 = this.compareGebaeudeKennzeichen(gebaeude.getLeitzeichen(), n4, n3, bl, n2, string2, n);
                if (bl2 && object2 != null) {
                    bl2 = this.searchDecors(gebaeude, (String[])object2) ? true : this.compareObjectText(gebaeude.getLeitzeichen().createEntLage(), (String[])object2);
                }
                if (!bl2 && gebaeude.hasKennzeichen()) {
                    Enumeration enumeration = gebaeude.kennzeichen();
                    while (enumeration.hasMoreElements()) {
                        GebaeudeKennzeichen gebaeudeKennzeichen = (GebaeudeKennzeichen)enumeration.nextElement();
                        bl2 = this.compareGebaeudeKennzeichen(gebaeudeKennzeichen, n4, n3, bl, n2, string2, n);
                        if (bl2 && object2 != null) {
                            bl2 = this.compareObjectText(gebaeudeKennzeichen.createEntLage(), (String[])object2);
                        }
                        if (!bl2) continue;
                        break;
                    }
                }
            }
            if (vector != null && !this.compareObjectContent(gebaeude.toDatLine(), vector)) {
                bl2 = false;
            }
            if (!bl2) continue;
            this.searchResult.addElement(gebaeude);
        }
        this.searchResultIndex = 0;
    }

    private boolean compareGebaeudeKennzeichen(GebaeudeKennzeichen gebaeudeKennzeichen, int n, int n2, boolean bl, int n3, String string, int n4) {
        if (n > 0 && n != gebaeudeKennzeichen.getGemeinde() || n2 > 0 && n2 != gebaeudeKennzeichen.getStrasse() || n4 > 0 && n4 != gebaeudeKennzeichen.getLfdNummer()) {
            return false;
        }
        if (bl || n3 > 0 || string != null) {
            if (bl != gebaeudeKennzeichen.isPseudoNummer()) {
                return false;
            }
            if (n3 != gebaeudeKennzeichen.getHausNummer()) {
                return false;
            }
            if (string != null ? !string.equals(gebaeudeKennzeichen.getAdressenZusatz()) : gebaeudeKennzeichen.hasAdressenZusatz()) {
                return false;
            }
        }
        return true;
    }

    private void createTopSearchResult() {
        this.searchResult.removeAllElements();
        String string = this.topTextField.getText().trim();
        String[] stringArray = null;
        if (string.length() <= 0) {
            string = null;
            this.searchResultIndex = -1;
            return;
        }
        stringArray = this.createTextHash(string);
        Enumeration enumeration = DataBase.TOP.elements();
        while (enumeration.hasMoreElements()) {
            TopObject topObject = (TopObject)enumeration.nextElement();
            if (!this.compareObjectText(topObject.getName(), stringArray) && !this.compareObjectText(topObject.getBezeichnung(), stringArray) && !this.searchDecors(topObject, stringArray)) continue;
            this.searchResult.addElement(topObject);
        }
        this.searchResultIndex = 0;
    }

    private void createBuchSearchResult() {
        String string;
        int n = -1;
        String string2 = null;
        String string3 = this.bzkChoice.getSelectedItem().trim();
        if (string3.length() > 0) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.blattChoice.getSelectedItem().trim()).length() > 0) {
            string2 = string;
        }
        String string4 = this.nameTextField.getText().trim();
        Vector vector = null;
        if (string4.length() > 0) {
            vector = this.createSearchHash(string4);
        } else {
            string4 = null;
        }
        String string5 = this.buchTextField.getText().trim();
        Vector vector2 = null;
        if (string5.length() > 0) {
            vector2 = this.createSearchHash(string5);
        } else {
            string5 = null;
        }
        this.searchResult.removeAllElements();
        this.searchNames.removeAllElements();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<Name> vector3 = new Vector<Name>();
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            Enumeration enumeration2 = flurstueck.buchungen();
            while (enumeration2.hasMoreElements()) {
                Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration2.nextElement();
                String string6 = buchungsstelle.getGrundbuchblattName();
                if (string6 == null || hashtable.put(string6, string6) != null || n >= 0 && n != Grundbuchblatt.getBezirk(string6) || string2 != null && !string2.equals(Grundbuchblatt.getBlatt(string6))) continue;
                if (string4 != null || string5 != null) {
                    Grundbuchblatt grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(string6);
                    if (grundbuchblatt == null) continue;
                    if (string4 != null) {
                        boolean bl = false;
                        Enumeration enumeration3 = grundbuchblatt.elements();
                        while (enumeration3.hasMoreElements()) {
                            Name name = (Name)enumeration3.nextElement();
                            if (!name.hasName() || !this.compareObjectContent(name.getNameAsString(), vector)) continue;
                            bl = true;
                            vector3.addElement(name);
                        }
                        if (!bl) continue;
                    }
                    if (string5 != null && !this.compareObjectContent(grundbuchblatt.toDatLine(), vector2)) continue;
                }
                this.searchResult.addElement(flurstueck);
                for (int i = 0; i < vector3.size(); ++i) {
                    this.searchNames.addElement(vector3.elementAt(i));
                }
                vector3.removeAllElements();
            }
        }
        this.searchResultIndex = 0;
    }

    private boolean searchDecors(GObject gObject, String[] stringArray) {
        Enumeration enumeration = gObject.decors();
        while (enumeration.hasMoreElements()) {
            ObjectDecor objectDecor = (ObjectDecor)enumeration.nextElement();
            if (!(objectDecor instanceof ObjectText) || !this.compareObjectText(((ObjectText)objectDecor).getText(), stringArray)) continue;
            return true;
        }
        return false;
    }

    private boolean compareObjectContent(String string, Vector vector) {
        string = string.toUpperCase();
        Vector vector2 = this.createObjectHash(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(32) >= 0) {
                if (string.indexOf(string2) >= 0) continue;
                return false;
            }
            boolean bl = false;
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                if (string3.indexOf(string2) < 0) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean compareObjectText(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = string.indexOf(stringArray[i]);
            if (n2 < n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    private Vector createObjectHash(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("C!")) continue;
            vector.addElement(string2.replace('_', ' '));
        }
        return vector;
    }

    private Vector createSearchHash(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (bl2) continue;
                if (bl) {
                    vector.addElement(string.substring(n, i).toUpperCase());
                }
                bl = false;
                continue;
            }
            if (c == '\"') {
                if (bl) {
                    vector.addElement(string.substring(n, i).toUpperCase());
                }
                bl = false;
                bl2 = !bl2;
                continue;
            }
            if (bl) continue;
            n = i;
            bl = true;
        }
        if (bl) {
            vector.addElement(string.substring(n).toUpperCase());
        }
        return vector;
    }

    private String[] createTextHash(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().toLowerCase();
        }
        return stringArray;
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    @Override
    public void endDialog() {
        this.searchString = null;
        super.endDialog();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

