/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoPanel;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktSupplier;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SearchPunktDialog
extends IDialog
implements ActionListener,
ItemListener,
FocusListener,
DataBaseListener,
PunktSupplier {
    private static final String NOT_A_NUMBER = "ung\u00fcltige Eingabe";
    private static final String SEARCH_COMMAND = "Suchen";
    private static final String DECREASE_COMMAND = ">>";
    private static final String INCREASE_COMMAND = "<<";
    private static final String NEW_SEARCH = "neue Suche ...";
    private static boolean NEXT = true;
    private static boolean LOKAL = true;
    private static boolean FREE = true;
    private TextField pnrTextField;
    private Button searchButton;
    private Button extendButton;
    private IPanel extendPanel;
    private IInfoPanel ergPanel;
    private Checkbox nextCheckbox;
    private Checkbox beforeCheckbox;
    private Checkbox lokalCheckbox;
    private Checkbox umnumCheckbox;
    private Checkbox freeCheckbox;
    private Checkbox reservedCheckbox;
    private ActionListener actionListener;
    private String actionCommand;
    private int searchAction = PunktTable.SEARCH_NUMBER;
    private String searchString;
    private PunktTable.SearchResult searchResult;

    public SearchPunktDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        IPanel iPanel = new IPanel(new FlowLayout(0));
        iPanel.setBorder(new IBorder(1));
        iPanel.addFocusListener(this);
        iPanel.add(new Label("Punktnummer:"));
        this.pnrTextField = new TextField(10);
        iPanel.add(this.pnrTextField);
        this.pnrTextField.addActionListener(this);
        this.searchButton = new Button(SEARCH_COMMAND);
        iPanel.add(this.searchButton);
        this.searchButton.addActionListener(this);
        this.extendButton = new Button(DECREASE_COMMAND);
        iPanel.add(this.extendButton);
        this.extendButton.addActionListener(this);
        this.add("North", iPanel);
        this.extendPanel = this.createExtendPanel();
        this.extendPanel.addFocusListener(this);
        this.ergPanel = new IInfoPanel();
        this.ergPanel.addFocusListener(this);
        this.add("South", this.ergPanel);
        this.pack();
        this.setLocationOfParent(iFrame, 11);
        this.addFocusListener(this);
    }

    private IPanel createExtendPanel() {
        IPanel iPanel = new IPanel();
        iPanel.setBorder(new IBorder(1));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        CheckboxGroup checkboxGroup3 = new CheckboxGroup();
        iPanel.setLayout(new GridLayout(2, 3));
        this.nextCheckbox = new Checkbox("n\u00e4chste");
        iPanel.add(this.nextCheckbox);
        this.nextCheckbox.setCheckboxGroup(checkboxGroup);
        this.nextCheckbox.addItemListener(this);
        this.freeCheckbox = new Checkbox("freie");
        iPanel.add(this.freeCheckbox);
        this.freeCheckbox.setCheckboxGroup(checkboxGroup3);
        this.freeCheckbox.addItemListener(this);
        this.lokalCheckbox = new Checkbox("lokale");
        iPanel.add(this.lokalCheckbox);
        this.lokalCheckbox.setCheckboxGroup(checkboxGroup2);
        this.lokalCheckbox.addItemListener(this);
        this.beforeCheckbox = new Checkbox("vorherige");
        iPanel.add(this.beforeCheckbox);
        this.beforeCheckbox.setCheckboxGroup(checkboxGroup);
        this.beforeCheckbox.addItemListener(this);
        this.reservedCheckbox = new Checkbox("belegte");
        iPanel.add(this.reservedCheckbox);
        this.reservedCheckbox.setCheckboxGroup(checkboxGroup3);
        this.reservedCheckbox.addItemListener(this);
        this.umnumCheckbox = new Checkbox("umnum.");
        iPanel.add(this.umnumCheckbox);
        this.umnumCheckbox.setCheckboxGroup(checkboxGroup2);
        this.umnumCheckbox.addItemListener(this);
        checkboxGroup.setCurrent(NEXT ? this.nextCheckbox : this.beforeCheckbox);
        checkboxGroup2.setCurrent(LOKAL ? this.lokalCheckbox : this.umnumCheckbox);
        checkboxGroup3.setCurrent(FREE ? this.freeCheckbox : this.reservedCheckbox);
        return iPanel;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setText(String string) {
        if (string == null) {
            this.pnrTextField.setText("");
        } else {
            this.pnrTextField.setText(string);
        }
    }

    public void setInfoText(String string) {
        this.ergPanel.setText(string);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getSearchAction() {
        return this.searchAction;
    }

    public void setSearchResult(PunktTable.SearchResult searchResult) {
        this.pnrTextField.setText(searchResult.getNummer());
        this.ergPanel.setText(searchResult.getText());
        this.searchResult = searchResult;
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        this.searchResult = null;
    }

    @Override
    public Punkt getPunkt() {
        if (this.searchResult != null) {
            return this.searchResult.getPunkt();
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        NEXT = this.nextCheckbox.getState();
        FREE = this.freeCheckbox.getState();
        LOKAL = this.lokalCheckbox.getState();
        this.pnrTextField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object instanceof TextField || string.equals(SEARCH_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(DECREASE_COMMAND)) {
            this.add("Center", this.extendPanel);
            this.extendButton.setLabel(INCREASE_COMMAND);
            this.extendButton.setActionCommand(INCREASE_COMMAND);
            this.pack();
        } else if (string.equals(INCREASE_COMMAND)) {
            this.remove(this.extendPanel);
            this.extendButton.setLabel(DECREASE_COMMAND);
            this.extendButton.setActionCommand(DECREASE_COMMAND);
            this.pack();
        }
        this.pnrTextField.requestFocus();
    }

    @Override
    public void endDialog() {
        this.searchString = null;
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        try {
            if (this.extendButton.getLabel().equals(DECREASE_COMMAND)) {
                this.searchAction = PunktTable.SEARCH_NUMBER;
                String string = this.pnrTextField.getText().trim();
                if (string.equals(this.searchString) && this.searchResult != null && this.searchResult.hasMoreElements()) {
                    this.searchResult.getNextPunkt();
                    this.ergPanel.setText(this.searchResult.getText());
                    if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_view_punkt"));
                    }
                } else {
                    this.searchString = string;
                    this.ergPanel.setText(NEW_SEARCH);
                    if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                }
            } else {
                this.searchString = this.pnrTextField.getText().trim();
                this.searchAction = PunktTable.SEARCH_NUMBER;
                this.searchAction += this.nextCheckbox.getState() ? PunktTable.SEARCH_NEXT_NUMBER : PunktTable.SEARCH_BEFORE_NUMBER;
                this.searchAction += this.lokalCheckbox.getState() ? PunktTable.SEARCH_LOKAL_NUMBER : PunktTable.SEARCH_UMNUM_NUMBER;
                this.searchAction += this.freeCheckbox.getState() ? PunktTable.SEARCH_FREE_NUMBER : PunktTable.SEARCH_RESERVED_NUMBER;
                this.searchString = this.pnrTextField.getText().trim();
                this.ergPanel.setText(NEW_SEARCH);
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.searchString = null;
            this.ergPanel.setText(NOT_A_NUMBER);
        }
        this.pnrTextField.selectAll();
        this.pnrTextField.requestFocus();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.pnrTextField.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

