/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.ICardPanel;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoPanel;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IPasswordDialog;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DPoint;
import de.geocalc.gml.GmlFeature;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GeoObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.ObjectListSource;
import de.geocalc.text.IFormat;
import de.geocalc.util.Base64;
import de.geocalc.xml.XMLElement;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SearchWwwDialog
extends IDialog
implements ActionListener,
ItemListener,
FocusListener,
ObjectListSource,
TextListener {
    private static final boolean debug = false;
    private static final String SEARCH_COMMAND = "Suchen";
    private static final String LIST_COMMAND = "Liste";
    private static final String WFSG_COMMAND = "Gazetteer";
    private static final String WFSG_CONNECT_COMMAND = "Gazetteer_Connect";
    private static final String LGBG_COMMAND = "LGB";
    private static final Hashtable<String, Boolean> removedAttributes = new Hashtable();
    private Hashtable nameSpaces = new Hashtable();
    private Hashtable systems = new Hashtable();
    private Hashtable wfsgFeatures = new Hashtable();
    private Choice wfsgChoice;
    private IPanel wfsgPanel;
    private GridBagLayout wfsggbl;
    private GridBagConstraints wfsggbc;
    private CheckboxGroup wfsgGroup;
    private Checkbox wfsgBoxCheckbox;
    private TextField wfsgTextField;
    private TextField lgbgTextField;
    private Button listButton;
    private Button searchButton;
    private Button wfsgButton;
    private IInfoPanel ergPanel;
    private ActionListener actionListener;
    private String actionCommand;
    private String searchString;
    private ICardPanel cardPanel = null;
    private Vector<GeoObject> searchResult = new Vector();
    private int searchResultIndex = -1;
    private Hashtable urlPw = new Hashtable();

    public SearchWwwDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.cardPanel = new ICardPanel();
        this.cardPanel.addCard(LGBG_COMMAND, this.createLgbgPanel());
        this.cardPanel.addItemListener(this);
        this.add("North", this.cardPanel);
        this.add("Center", this.createButtonPanel());
        this.ergPanel = new IInfoPanel();
        this.ergPanel.addFocusListener(this);
        this.add("South", this.ergPanel);
        this.pack();
        this.setLocationOfParent(iFrame, 11);
        this.addFocusListener(this);
    }

    private IPanel createLgbgPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        iPanel.setBorder(new IBorder(1));
        Label label = null;
        label = new Label("Suche nach Text:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("  Ort oder Plz, Stra\u00dfe Hausnummer");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("oder nach Schl\u00fcssel:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("  Gemeinde-Stra\u00dfe-Hausnummer");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("  Gemarkung-Flur-Flurst\u00fcck");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.lgbgTextField = new TextField(50);
        iPanel.add(this.lgbgTextField);
        this.lgbgTextField.addTextListener(this);
        this.lgbgTextField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.lgbgTextField, gridBagConstraints);
        return iPanel;
    }

    private IPanel createWfsgPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Panel panel = new Panel();
        this.wfsgChoice = new Choice();
        panel.add(this.wfsgChoice);
        this.wfsgChoice.add("http://isk.geobasis-bb.de/ows/gaz.php");
        this.wfsgButton = new Button("Verbinde...");
        panel.add(this.wfsgButton);
        this.wfsgButton.setActionCommand(WFSG_CONNECT_COMMAND);
        this.wfsgButton.addActionListener(this);
        iPanel.add(panel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.wfsggbl = gridBagLayout;
        this.wfsggbc = gridBagConstraints;
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        this.listButton = new Button(LIST_COMMAND);
        panel.add(this.listButton);
        this.listButton.addActionListener(this);
        this.listButton.setEnabled(false);
        this.searchButton = new Button(SEARCH_COMMAND);
        panel.add(this.searchButton);
        this.searchButton.addActionListener(this);
        this.searchButton.setEnabled(false);
        return panel;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    public GObject getResult() {
        if (this.searchResultIndex < 0) {
            return null;
        }
        try {
            return this.searchResult.elementAt(this.searchResultIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Enumeration getObjects() {
        return this.searchResult.elements();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.lgbgTextField) {
            this.searchButton.setEnabled(this.lgbgTextField.getText().trim().length() > 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string2.equals(WFSG_CONNECT_COMMAND)) {
            this.connectWfsg();
        } else if (object instanceof TextField || string2.equals(SEARCH_COMMAND)) {
            this.doStandardAction();
        } else if (string2.equals(LIST_COMMAND) && (string = this.cardPanel.getVisibleCard()).equals(WFSG_COMMAND)) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_list_flst"));
        }
    }

    @Override
    protected void doStandardAction() {
        String string = this.cardPanel.getVisibleCard();
        if (string.equals(WFSG_COMMAND)) {
            if (this.wfsgGroup == null || this.wfsgTextField == null) {
                return;
            }
            String string2 = this.wfsgGroup.getSelectedCheckbox().getLabel();
            String string3 = this.wfsgTextField.getText().trim();
            String string4 = string2 + ":" + string3 + ":" + this.wfsgBoxCheckbox.getState();
            if (string3.length() == 0) {
                this.ergPanel.setText("");
                this.searchResult.removeAllElements();
            } else if (string4.equals(this.searchString)) {
                if (this.searchResult.size() > 1) {
                    ++this.searchResultIndex;
                    if (this.searchResultIndex >= this.searchResult.size()) {
                        this.searchResultIndex = 0;
                    }
                    GObject gObject = this.searchResult.elementAt(this.searchResultIndex);
                    this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName() + "   (" + (this.searchResultIndex + 1) + " von " + this.searchResult.size() + ")");
                }
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                }
            } else {
                this.searchWfsg(this.wfsgChoice.getSelectedItem(), string2, string3);
                if (this.searchResult.size() > 0) {
                    this.searchResultIndex = 0;
                    GObject gObject = this.searchResult.elementAt(this.searchResultIndex);
                    this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName() + "   (" + (this.searchResultIndex + 1) + " von " + this.searchResult.size() + ")");
                    if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                } else {
                    this.ergPanel.setText("Keine Features gefunden");
                }
            }
            this.searchString = string4;
        } else if (string.equals(LGBG_COMMAND)) {
            String string5 = this.lgbgTextField.getText().trim();
            if (string5.length() == 0) {
                this.ergPanel.setText("");
                this.searchResult.removeAllElements();
            } else if (string5.equals(this.searchString) && this.searchResult.size() > 0) {
                ++this.searchResultIndex;
                if (this.searchResultIndex >= this.searchResult.size()) {
                    this.searchResultIndex = 0;
                }
                GObject gObject = this.searchResult.elementAt(this.searchResultIndex);
                this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName() + "   (" + (this.searchResultIndex + 1) + " von " + this.searchResult.size() + ")");
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                }
            } else {
                this.searchResult.removeAllElements();
                this.searchLgbg(string5);
                if (this.searchResult.size() > 0) {
                    this.searchResultIndex = 0;
                    GObject gObject = this.searchResult.elementAt(this.searchResultIndex);
                    this.ergPanel.setText(gObject.getClassName() + ": " + gObject.getName() + "   (" + (this.searchResultIndex + 1) + " von " + this.searchResult.size() + ")");
                    if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                }
            }
            this.searchString = string5;
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    @Override
    public void endDialog() {
        this.searchString = null;
        super.endDialog();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string = this.cardPanel.getVisibleCard();
        if (string.equals(LGBG_COMMAND)) {
            this.lgbgTextField.requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void searchLgbg(String string) {
        String string2 = "http://isk.geobasis-bb.de/ows/gaz.php";
        int n = 0;
        try {
            URL uRL = new URL(string2);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (IFormat.hasOnlyChars(string, "0123456789?-_\\/*. ")) {
                String string7;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-_\\/*. ");
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Ung\u00fcltige Suchangabe");
                }
                String string8 = stringTokenizer.nextToken();
                String string9 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                String string10 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                String string11 = string7 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                if (stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Zu viele Trennzeichen");
                }
                if (string8.length() == 8) {
                    if (n == 0 && string10 != null) {
                        n = this.searchLGBG(uRL, "app:Hauskoordinaten", string8, string9, string10, null, true);
                    }
                    if (n == 0 && string9 != null) {
                        n = this.searchLGBG(uRL, "app:Strassen", string8, string9, null, null, true);
                    }
                    if (n == 0 && string8 != null) {
                        n = this.searchLGBG(uRL, "app:Gemeinden", string8, null, null, null, true);
                    }
                } else if (string8.length() == 5 && string9 != null) {
                    if (n == 0 && string9 != null) {
                        n = this.searchLGBG(uRL, "app:Hauskoordinaten", null, string8, string9, null, true);
                    }
                } else if (string.length() > 5) {
                    if (n == 0 && string10 != null) {
                        n = this.searchLGBG(uRL, "app:Flurstuecke", string8, string9, string10, string7, true);
                    }
                    if (n == 0 && string9 != null) {
                        n = this.searchLGBG(uRL, "app:Flur", string8, string9, null, null, true);
                    }
                    if (n == 0 && string8 != null) {
                        n = this.searchLGBG(uRL, "app:Gemarkung", string8, null, null, null, true);
                    }
                } else {
                    if (n == 0 && string8 != null) {
                        n = this.searchLGBG(uRL, "app:Postleitzahlgebiete", string8, null, null, null, true);
                    }
                    if (n == 0 && string8 != null) {
                        n = this.searchLGBG(uRL, "app:Gemarkung", string8, null, null, null, true);
                    }
                }
            } else {
                String string12;
                StringTokenizer stringTokenizer;
                String string13;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",;");
                if (stringTokenizer2.hasMoreTokens()) {
                    string13 = stringTokenizer2.nextToken();
                    stringTokenizer = new StringTokenizer(string13, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string12 = stringTokenizer.nextToken();
                        if (IFormat.isNumber(string12)) {
                            if (string3 != null) {
                                throw new Exception("Mehrere PLZ: " + string3 + " " + string12);
                            }
                            string3 = string12;
                            continue;
                        }
                        string4 = string4 == null ? string12 : string4 + " " + string12;
                    }
                }
                if (stringTokenizer2.hasMoreTokens()) {
                    string13 = stringTokenizer2.nextToken();
                    stringTokenizer = new StringTokenizer(string13, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string12 = stringTokenizer.nextToken();
                        if (Character.isDigit(string12.charAt(0))) {
                            if (string6 != null) {
                                throw new Exception("Mehrere Hausnummern: " + string6 + " " + string12);
                            }
                            string6 = string12;
                            continue;
                        }
                        string5 = string5 == null ? string12 : string5 + " " + string12;
                    }
                }
                if (stringTokenizer2.hasMoreTokens()) {
                    throw new Exception("Zu viele Angaben: " + stringTokenizer2.nextToken());
                }
                string13 = null;
                string13 = string6 != null ? "app:Hauskoordinaten" : (string5 != null ? "app:Strassen" : (string3 != null ? "app:Postleitzahlgebiete" : "app:Gemarkung"));
                n = this.searchLGBG(uRL, string13, string3, string4, string5, string6, false);
                if (n == 0 && string6 != null) {
                    n = this.searchLGBG(uRL, "app:Strassen", string3, string4, string5, null, false);
                }
                if (n == 0 && string5 != null) {
                    if (string3 != null) {
                        n = this.searchLGBG(uRL, "app:Postleitzahlgebiete", string3, string4, null, null, false);
                    } else if (string4 != null) {
                        n = this.searchLGBG(uRL, "app:Gemeinden", string3, string4, null, null, false);
                    }
                }
                if (n == 0 && string4 != null) {
                    n = this.searchLGBG(uRL, "app:Gemeindeteile", string3, string4, null, null, false);
                }
                if (n == 0 && string4 != null) {
                    n = this.searchLGBG(uRL, "app:Ortsteile", string3, string4, null, null, false);
                }
                if (n == 0 && string4 != null) {
                    n = this.searchLGBG(uRL, "app:Wohnplaetze", string3, string4, null, null, false);
                }
                if (n == 0 && string4 != null) {
                    n = this.searchLGBG(uRL, "app:Gemarkung", null, string4, null, null, false);
                }
            }
            this.ergPanel.setText((n > 0 ? Integer.toString(n) : "keine") + " Features gefunden");
        }
        catch (Exception exception) {
            this.ergPanel.setText("Fehler: " + exception.getMessage());
        }
        this.searchResultIndex = n > 0 ? 0 : -1;
    }

    private int searchLGBG(URL uRL, String string, String string2, String string3, String string4, String string5, boolean bl) throws Exception {
        int n = 0;
        this.ergPanel.setText("Suche nach " + string.substring(4) + "...");
        n = this.parseWfsResult(this.getWfsRequest(uRL, this.getLGBGFeaturePost(string, string2, string3, string4, string5, bl)));
        this.ergPanel.setText(n + " " + string.substring(4) + " gefunden");
        return n;
    }

    private String getLGBGFeaturePost(String string, String string2, String string3, String string4, String string5, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuffer.append("<wfs:GetFeature version=\"1.1.0\" maxFeatures=\"50\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" resultType=\"results\">");
        stringBuffer.append("<wfs:Query xmlns:app=\"http://www.deegree.org/app\" typeName=\"" + string + "\" srsName=\"EPSG:325833\">");
        stringBuffer.append("<Filter xmlns=\"http://www.opengis.net/ogc\">");
        if (bl) {
            if (string.equals("app:Hauskoordinaten")) {
                if (string2 != null || string3 != null && string4 != null) {
                    stringBuffer.append("<And>");
                }
                if (string2 != null) {
                    int n = string2.length();
                    if (n > 0) {
                        stringBuffer.append(this.getSearchTag("app:land", string2.substring(0, Math.min(2, n))));
                    }
                    if (n > 2) {
                        stringBuffer.append(this.getSearchTag("app:regierungsbezirk", string2.substring(2, Math.min(3, n))));
                    }
                    if (n > 3) {
                        stringBuffer.append(this.getSearchTag("app:kreis", string2.substring(3, Math.min(5, n))));
                    }
                    if (n > 5) {
                        stringBuffer.append(this.getSearchTag("app:gemeinde", string2.substring(5) + "*"));
                    }
                }
                if (string3 != null) {
                    stringBuffer.append(this.getSearchTag("app:strassenschluessel", string3 + "*"));
                }
                if (string4 != null) {
                    stringBuffer.append(this.getSearchTag("app:hausnummer", string4));
                }
                if (string2 != null || string3 != null && string4 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Strassen")) {
                if (string2 != null) {
                    stringBuffer.append("<And>");
                }
                if (string2 != null) {
                    int n = string2.length();
                    if (n > 0) {
                        stringBuffer.append(this.getSearchTag("app:land", string2.substring(0, Math.min(2, n))));
                    }
                    if (n > 2) {
                        stringBuffer.append(this.getSearchTag("app:regbez", string2.substring(2, Math.min(3, n))));
                    }
                    if (n > 3) {
                        stringBuffer.append(this.getSearchTag("app:kreis", string2.substring(3, Math.min(5, n))));
                    }
                    if (n > 5) {
                        stringBuffer.append(this.getSearchTag("app:gemeinde", string2.substring(5) + "*"));
                    }
                }
                if (string3 != null) {
                    stringBuffer.append(this.getSearchTag("app:strassenSchluessel", "*" + string3 + "*"));
                }
                if (string2 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Gemeinden")) {
                if (string2 != null) {
                    stringBuffer.append("<And>");
                    int n = string2.length();
                    if (n > 0) {
                        stringBuffer.append(this.getSearchTag("app:land", string2.substring(0, Math.min(2, n))));
                    }
                    if (n > 2) {
                        stringBuffer.append(this.getSearchTag("app:regierungsbezirk", string2.substring(2, Math.min(3, n))));
                    }
                    if (n > 3) {
                        stringBuffer.append(this.getSearchTag("app:kreis", string2.substring(3, Math.min(5, n))));
                    }
                    if (n > 5) {
                        stringBuffer.append(this.getSearchTag("app:gemeinde", string2.substring(5) + "*"));
                    }
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Flurstuecke")) {
                if (string3 != null) {
                    stringBuffer.append("<And>");
                }
                if (string2 != null) {
                    stringBuffer.append(this.getSearchTag("app:Gemarkungsnummer", "*" + string2 + "*"));
                }
                if (string3 != null) {
                    stringBuffer.append(this.getSearchTag("app:Flurnummer", IFormat.i03.format(Integer.parseInt(string3))));
                }
                if (string4 != null) {
                    stringBuffer.append(this.getSearchTag("app:Zaehlernummer", IFormat.i05.format(Integer.parseInt(string4))));
                }
                if (string5 != null) {
                    stringBuffer.append(this.getSearchTag("app:Nennernummer", IFormat.i03.format(Integer.parseInt(string5))));
                }
                if (string3 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Flur")) {
                if (string2 != null && string3 != null) {
                    stringBuffer.append(this.getSearchTag("app:Flurkennzeichen", "*" + string2 + "*" + IFormat.i03.format(Integer.parseInt(string3))));
                }
            } else if (string.equals("app:Gemarkung")) {
                if (string2 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", "*" + string2 + "*"));
                }
            } else if (string.equals("app:Postleitzahlgebiete") && string2 != null) {
                stringBuffer.append(this.getSearchTag("app:geographicIdentifier", string2 + "*"));
            }
        } else {
            String string6 = string2;
            String string7 = string3;
            String string8 = string4;
            String string9 = string5;
            if (string.equals("app:Hauskoordinaten")) {
                if (string8 != null || string7 != null || string6 != null) {
                    stringBuffer.append("<And>");
                }
                if (string9 != null) {
                    stringBuffer.append(this.getSearchTag("app:hausnummer", string9));
                }
                if (string8 != null) {
                    stringBuffer.append(this.getSearchTag("app:strassenname", "*" + string8 + "*"));
                }
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:ortsname", "*" + string7 + "*"));
                }
                if (string6 != null) {
                    stringBuffer.append(this.getSearchTag("app:plz", string6 + "*"));
                }
                if (string8 != null || string7 != null || string6 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Strassen")) {
                if (string7 != null || string6 != null) {
                    stringBuffer.append("<And>");
                }
                if (string8 != null) {
                    stringBuffer.append(this.getSearchTag("app:strassenname", "*" + string8 + "*"));
                }
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:postalischerOrtsname", "*" + string7 + "*"));
                }
                if (string6 != null) {
                    stringBuffer.append(this.getSearchTag("app:plzParentIdentifier", string6 + "*"));
                }
                if (string7 != null || string6 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Postleitzahlgebiete")) {
                if (string6 != null && string7 != null) {
                    stringBuffer.append("<And>");
                }
                if (string6 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", string6 + "*"));
                }
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:postalischerOrtsname", "*" + string7 + "*"));
                }
                if (string6 != null && string7 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Gemeinden")) {
                stringBuffer.append("<Or>");
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", "*" + string7 + "*"));
                }
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:ortsname", "*" + string7 + "*"));
                }
                stringBuffer.append("</Or>");
            } else if (string.equals("app:Gemeindeteile")) {
                if (string7 != null && string6 != null) {
                    stringBuffer.append("<And>");
                }
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", "*" + string7 + "*"));
                }
                if (string6 != null) {
                    stringBuffer.append(this.getSearchTag("app:postleitzahl", string6 + "*"));
                }
                if (string7 != null && string6 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Ortsteile")) {
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", "*" + string7 + "*"));
                }
            } else if (string.equals("app:Wohnplaetze")) {
                if (string7 != null && string6 != null) {
                    stringBuffer.append("<And>");
                }
                if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", "*" + string7 + "*"));
                }
                if (string6 != null) {
                    stringBuffer.append(this.getSearchTag("app:postleitzahl", string6 + "*"));
                }
                if (string7 != null && string6 != null) {
                    stringBuffer.append("</And>");
                }
            } else if (string.equals("app:Gemarkung")) {
                if (string6 != null) {
                    stringBuffer.append(this.getSearchTag("app:geographicIdentifier", "*" + string6 + "*"));
                } else if (string7 != null) {
                    stringBuffer.append(this.getSearchTag("app:Gemarkungsname", "*" + string7 + "*"));
                }
            }
        }
        stringBuffer.append("</Filter>");
        stringBuffer.append("<SortBy xmlns=\"http://www.opengis.net/ogc\">");
        stringBuffer.append("<SortProperty>");
        stringBuffer.append("<PropertyName>");
        stringBuffer.append("app:geographicIdentifier");
        stringBuffer.append("</PropertyName>");
        stringBuffer.append("</SortProperty>");
        stringBuffer.append("</SortBy>");
        stringBuffer.append("</wfs:Query>");
        stringBuffer.append("</wfs:GetFeature>");
        return stringBuffer.toString();
    }

    private XMLElement getWfsRequest(URL uRL, String string) throws Exception {
        Object object;
        String string2 = this.getEncPw(uRL);
        HttpURLConnection httpURLConnection = null;
        httpURLConnection = this.createConnection(uRL, true);
        httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        httpURLConnection.setRequestProperty("Content-Length", "" + string.length());
        try {
            object = new OutputStreamWriter((OutputStream)new BufferedOutputStream(httpURLConnection.getOutputStream()), "UTF8");
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).flush();
        }
        catch (Exception exception) {
            throw new Exception("Keine Verbindung zu " + String.valueOf(uRL));
        }
        object = new XMLElement(new Hashtable(), false, false);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(httpURLConnection.getInputStream()), "UTF8");
        }
        catch (Exception exception) {
            throw new Exception("Verbindung abgebrochen");
        }
        try {
            ((XMLElement)object).parseFromReader(inputStreamReader);
        }
        catch (Exception exception) {
            throw new Exception("Fehler XML-Auswertung, invalid");
        }
        return object;
    }

    private void connectWfsg() {
        String string = this.wfsgChoice.getSelectedItem();
        this.ergPanel.setText("Verbinde: " + string);
        try {
            XMLElement xMLElement;
            HttpURLConnection httpURLConnection = this.createConnection(new URL(string), false);
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader(new BufferedInputStream(httpURLConnection.getInputStream()));
            }
            catch (Exception exception) {
                throw new Exception("keine Verbindung zu " + string);
            }
            XMLElement xMLElement2 = new XMLElement(new Hashtable(), false, false);
            this.ergPanel.setText("Werte Capabilities aus...");
            try {
                xMLElement2.parseFromReader(inputStreamReader);
            }
            catch (Exception exception) {
                throw new Exception("Fehler XML-Auswertung, invalid");
            }
            XMLElement xMLElement3 = null;
            try {
                xMLElement3 = xMLElement2.getChildren("wfs:FeatureTypeList");
            }
            catch (Exception exception) {
                throw new Exception("FeatureTypeList nicht gefunden");
            }
            Vector<XMLElement> vector = new Vector<XMLElement>();
            Enumeration enumeration = xMLElement3.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                xMLElement = (XMLElement)enumeration.nextElement();
                if (!xMLElement.getName().equals("wfs:FeatureType")) continue;
                vector.addElement(xMLElement);
            }
            inputStreamReader.close();
            this.ergPanel.setText("Hole FeatureTypen...");
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2;
                httpURLConnection = this.createConnection(new URL(string), true);
                xMLElement = (XMLElement)enumeration.nextElement();
                String string3 = xMLElement.getChildren("wfs:Name").getContent();
                String string4 = null;
                Object object = xMLElement.enumeratePropertyNames();
                while (object.hasMoreElements()) {
                    string2 = (String)object.nextElement();
                    if (!string2.startsWith("xmlns:")) continue;
                    string4 = string2 + "=\"" + xMLElement.getStringAttribute(string2) + "\"";
                }
                this.ergPanel.setText("Hole Feature " + string3 + "...");
                object = new OutputStreamWriter((OutputStream)new BufferedOutputStream(httpURLConnection.getOutputStream()), "UTF8");
                string2 = this.getDescribeFeaturePost(string4, string3);
                ((Writer)object).write(string2);
                ((OutputStreamWriter)object).flush();
                XMLElement xMLElement4 = new XMLElement(new Hashtable(), false, false);
                InputStreamReader inputStreamReader2 = new InputStreamReader((InputStream)new BufferedInputStream(httpURLConnection.getInputStream()), "UTF8");
                xMLElement4.parseFromReader(inputStreamReader2);
                inputStreamReader2.close();
            }
            this.ergPanel.setText("");
        }
        catch (Exception exception) {
            this.ergPanel.setText("Fehler: " + exception.getMessage());
        }
    }

    private String getSearchTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PropertyIsLike wildCard=\"*\" singleChar=\"?\" escape=\"!\" matchCase=\"false\">");
        stringBuffer.append("<PropertyName>");
        stringBuffer.append(string);
        stringBuffer.append("</PropertyName>");
        stringBuffer.append("<Literal>");
        stringBuffer.append(string2);
        stringBuffer.append("</Literal>");
        stringBuffer.append("</PropertyIsLike>");
        return stringBuffer.toString();
    }

    private void searchWfsg(String string, String string2, String string3) {
        Object object;
        XMLElement xMLElement = new XMLElement();
        String string4 = (String)this.wfsgFeatures.get(string2);
        if (string4 == null) {
            return;
        }
        String string5 = null;
        String string6 = null;
        int n = string4.indexOf(":");
        if (n > 0) {
            string6 = string4.substring(0, n).toLowerCase();
            object = (String)this.nameSpaces.get(string6);
            if (object == null) {
                return;
            }
            string5 = string6 + "=\"" + (String)object + "\"";
        }
        try {
            this.ergPanel.setText("Verbinde: " + string);
            object = this.createConnection(new URL(string), true);
            this.ergPanel.setText("Sende Anfrage...");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(((URLConnection)object).getOutputStream()), "UTF8");
            String string7 = this.getHTTPPOSTFeature(string6, string5, string4, string3);
            outputStreamWriter.write(string7);
            outputStreamWriter.flush();
            this.ergPanel.setText("Warte auf Antwort...");
            try {
                xMLElement.parseFromReader(new InputStreamReader((InputStream)new BufferedInputStream(((URLConnection)object).getInputStream()), "UTF8"));
            }
            catch (Exception exception) {
                throw new Exception("Fehler XML-Auswertung, invalid");
            }
            this.ergPanel.setText("Werte Ergebnis aus...");
            this.parseWfsResult(xMLElement);
            this.searchResultIndex = this.searchResult.size() > 0 ? 0 : -1;
        }
        catch (Exception exception) {
            this.ergPanel.setText("Fehler: " + exception.getMessage());
        }
    }

    public String getDescribeFeaturePost(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuffer.append("<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\"");
        stringBuffer.append(" xmlns:wfs=\"http://www.opengis.net/wfs\"");
        if (string != null) {
            stringBuffer.append(" " + string);
        }
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.0.0/WFS-basic.xsd\"");
        stringBuffer.append(">");
        stringBuffer.append("<wfs:TypeName>");
        stringBuffer.append(string2);
        stringBuffer.append("</wfs:TypeName>");
        stringBuffer.append("</wfs:DescribeFeatureType>");
        return stringBuffer.toString();
    }

    public String getHTTPPOSTFeature(String string, String string2, String string3, String string4) {
        boolean bl = this.wfsgBoxCheckbox.getState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuffer.append("<wfs:GetFeature version=\"1.1.0\" maxFeatures=\"50\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" resultType=\"results\">");
        stringBuffer.append("  <wfs:Query ");
        if (string2 != null) {
            stringBuffer.append("xmlns:" + string2);
        }
        stringBuffer.append(" typeName=\"");
        stringBuffer.append(string3);
        stringBuffer.append("\" srsName=\"");
        stringBuffer.append("EPSG:325833");
        stringBuffer.append("\">");
        stringBuffer.append("    <Filter xmlns=\"http://www.opengis.net/ogc\">");
        if (bl) {
            stringBuffer.append("      <And>");
        }
        stringBuffer.append("      <PropertyIsLike wildCard=\"*\" singleChar=\"_\" escape=\"!\" matchCase=\"false\">");
        stringBuffer.append("        <PropertyName>");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("geographicIdentifier");
        stringBuffer.append("</PropertyName>");
        stringBuffer.append("          <Literal>");
        stringBuffer.append(string4);
        stringBuffer.append("</Literal>");
        stringBuffer.append("        </PropertyIsLike>");
        if (bl) {
            stringBuffer.append("<BBOX>");
            stringBuffer.append("<PropertyName>");
            if (string != null) {
                stringBuffer.append(string + ":");
            }
            stringBuffer.append("geographicExtent");
            stringBuffer.append("</PropertyName>");
            stringBuffer.append("<gml:Envelope srsName=\"EPSG:325833\">");
            IViewport iViewport = KafPlotProperties.getViewport();
            stringBuffer.append("<gml:pos srsDimension=\"2\">");
            stringBuffer.append(IFormat.f_3.format(iViewport.y) + " " + IFormat.f_3.format(iViewport.x));
            stringBuffer.append("</gml:pos>");
            stringBuffer.append("<gml:pos srsDimension=\"2\">");
            stringBuffer.append(IFormat.f_3.format(iViewport.y + iViewport.height) + " " + IFormat.f_3.format(iViewport.x + iViewport.width));
            stringBuffer.append("</gml:pos>");
            stringBuffer.append("</gml:Envelope>");
            stringBuffer.append("</BBOX>");
            stringBuffer.append("      </And>");
        }
        stringBuffer.append("    </Filter>");
        stringBuffer.append("    <SortBy xmlns=\"http://www.opengis.net/ogc\">");
        stringBuffer.append("      <SortProperty>");
        stringBuffer.append("        <PropertyName>");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("geographicIdentifier");
        stringBuffer.append("</PropertyName>");
        stringBuffer.append("      </SortProperty>");
        stringBuffer.append("    </SortBy>");
        stringBuffer.append("  </wfs:Query>");
        stringBuffer.append("</wfs:GetFeature>");
        return stringBuffer.toString();
    }

    private HttpURLConnection createConnection(URL uRL, boolean bl) throws Exception {
        String string = this.getEncPw(uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", KafPlotVersion.getUserAgent());
            httpURLConnection.setDoInput(true);
            if (bl) {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
            }
        }
        catch (Exception exception) {
            throw new Exception("Ung\u00fcltige URL " + String.valueOf(uRL) + " ," + exception.getMessage());
        }
        try {
            if (string != null) {
                this.ergPanel.setText("Setze Authorization...");
                httpURLConnection.setRequestProperty("Proxy-Authorization", string);
            }
        }
        catch (Exception exception) {
            throw new Exception("Proxy-Authorization fehlgeschlagen");
        }
        return httpURLConnection;
    }

    private String getEncPw(URL uRL) {
        String string = (String)this.urlPw.get(uRL);
        if (string != null) {
            return string;
        }
        try {
            String string2 = System.getProperty("proxyPW");
            String string3 = System.getProperty("nonProxyHosts");
            if ("true".equalsIgnoreCase(string2)) {
                String string4;
                Object object;
                if (string3 != null) {
                    object = new StringTokenizer(string3, ", ");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string4 = ((StringTokenizer)object).nextToken();
                        if (!string4.equalsIgnoreCase(uRL.getHost())) continue;
                        return null;
                    }
                }
                object = new IPasswordDialog(this.getParentFrame(), "ProxyPasswort", "Bitte geben Sie das Passwort f\u00fcr den Proxyserver ein!");
                ((IDialog)object).setVisible(true);
                string4 = ((IPasswordDialog)object).getUsername();
                String string5 = ((IPasswordDialog)object).getPassword();
                if (string4 != null && string5 != null) {
                    string = Base64.encode(string4.trim() + ":" + string5.trim());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private int parseWfsResult(XMLElement xMLElement) {
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getName();
            if (string.equals("gml:boundedBy") || !string.equals("gml:featureMember")) continue;
            try {
                Object object;
                GmlFeature gmlFeature = GmlFeature.parse(xMLElement2.getChildrenAt(0));
                GeoObject geoObject = new GeoObject();
                geoObject.setClassName(gmlFeature.getClassName());
                geoObject.setName(gmlFeature.getName());
                geoObject.setTextAngle(1.5707963267948966);
                Object object2 = gmlFeature.attributes();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (removedAttributes.containsKey(object)) continue;
                    geoObject.setAttribute((String)object, gmlFeature.getAttribute((String)object).toString());
                }
                geoObject.setBounds(gmlFeature.getBounds());
                object2 = gmlFeature.getPosition();
                if (object2 != null) {
                    geoObject.y = ((DPoint)object2).y;
                    geoObject.x = ((DPoint)object2).x;
                }
                object = gmlFeature.geometries();
                while (object.hasMoreElements()) {
                    geoObject.addElement(object.nextElement());
                }
                geoObject.initGeom();
                this.searchResult.addElement(geoObject);
                ++n;
            }
            catch (Exception exception) {}
        }
        return n;
    }

    static {
        Boolean bl = new Boolean(true);
        removedAttributes.put("eastBoundLongitude", bl);
        removedAttributes.put("westBoundLongitude", bl);
        removedAttributes.put("northBoundLatitude", bl);
        removedAttributes.put("southBoundLatitude", bl);
        removedAttributes.put("geographicIdentifier", bl);
        removedAttributes.put("gid", bl);
    }
}

