/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Stat2;
import de.geocalc.kafplot.Stat3;
import de.geocalc.kafplot.Stat4;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.IFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Stat {
    public static final short VOID = Short.MIN_VALUE;
    public static final short MIN_VALUE = -32766;
    public static final short MAX_VALUE = 32765;
    public static final short UNDERFLOW = -32767;
    public static final short OVERFLOW = 32766;
    public static final short ERR_VALUE = Short.MAX_VALUE;
    protected static final DecimalFormat dec = IFormat.f_3;
    protected short v1 = Short.MIN_VALUE;
    protected short sav1 = Short.MIN_VALUE;
    protected short san1 = Short.MIN_VALUE;
    protected short ep1 = Short.MIN_VALUE;
    protected short ev1 = Short.MIN_VALUE;
    protected short nv1 = Short.MIN_VALUE;
    protected short gf1 = Short.MIN_VALUE;

    public int count() {
        return 1;
    }

    public static final boolean isValue(short s) {
        return s != Short.MIN_VALUE && s != Short.MAX_VALUE;
    }

    public static final boolean isValue(int n) {
        return n != Short.MIN_VALUE && n != Short.MAX_VALUE;
    }

    public void setV(int n, short s) {
        if (n == 1) {
            this.v1 = s;
        }
    }

    public short getV(int n) {
        return n == 1 ? (short)this.v1 : (short)Short.MIN_VALUE;
    }

    public int getSumV() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getV(i);
            if (!Stat.isValue((int)s)) continue;
            n += Math.abs(s);
        }
        return n;
    }

    public void setSaV(int n, short s) {
        if (n == 1) {
            this.sav1 = s;
        }
    }

    public short getSaV(int n) {
        return n == 1 ? (short)this.sav1 : (short)Short.MIN_VALUE;
    }

    public int getSumSaV() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getSaV(i);
            if (!Stat.isValue((int)s)) continue;
            n += s;
        }
        return n;
    }

    public int getMidSaV() {
        int n = 0;
        int n2 = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getSaV(i);
            if (!Stat.isValue((int)s)) continue;
            n += s;
            ++n2;
        }
        return n == 0 ? 0 : (int)((float)n / (float)n2);
    }

    public int getMaxSaV() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getSaV(i);
            if (!Stat.isValue((int)s)) continue;
            n = Math.max(n, s);
        }
        return n;
    }

    public void setSaN(int n, short s) {
        if (n == 1) {
            this.san1 = s;
        }
    }

    public short getSaN(int n) {
        return n == 1 ? (short)this.san1 : (short)Short.MIN_VALUE;
    }

    public int getSumSaN() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getSaN(i);
            if (!Stat.isValue((int)s)) continue;
            n = s;
        }
        return n;
    }

    public int getMidSaN() {
        int n = 0;
        int n2 = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getSaN(i);
            if (!Stat.isValue((int)s)) continue;
            n = s;
            ++n2;
        }
        return n == 0 ? n : (int)((float)n / (float)n2);
    }

    public int getMaxSaN() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getSaN(i);
            if (!Stat.isValue((int)s)) continue;
            n = Math.max(n, s);
        }
        return n;
    }

    public void setEv(int n, short s) {
        if (n == 1) {
            this.ev1 = s;
        }
    }

    public short getEv(int n) {
        return n == 1 ? (short)this.ev1 : (short)Short.MIN_VALUE;
    }

    public int getMidEv() {
        int n = 0;
        int n2 = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getEv(i);
            if (!Stat.isValue((int)s)) continue;
            n += s;
            ++n2;
        }
        return n == 0 ? 0 : (int)((float)n / (float)n2);
    }

    public int getMinEv() {
        int n = 1000;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getEv(i);
            if (!Stat.isValue((int)s)) continue;
            n = Math.min(n, s);
        }
        return n == 1000 ? 0 : n;
    }

    public int getMaxEv() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getEv(i);
            if (!Stat.isValue((int)s)) continue;
            n = Math.max(n, s);
        }
        return n;
    }

    public void setEp(int n, short s) {
        if (n == 1) {
            this.ep1 = s;
        }
    }

    public short getEp(int n) {
        return n == 1 ? (short)this.ep1 : (short)Short.MIN_VALUE;
    }

    public int getSumEp() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getEp(i);
            if (!Stat.isValue((int)s)) continue;
            n += Math.abs(s);
        }
        return n;
    }

    public int getMidEp() {
        int n = 0;
        int n2 = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getEp(i);
            if (!Stat.isValue((int)s)) continue;
            n += s;
            ++n2;
        }
        return n == 0 ? 0 : (int)((float)n / (float)n2);
    }

    public int getMaxEp() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getEp(i);
            if (!Stat.isValue((int)s)) continue;
            n = Math.max(n, s);
        }
        return n;
    }

    public void setNv(int n, short s) {
        if (n == 1) {
            this.nv1 = s;
        }
    }

    public short getNv(int n) {
        return n == 1 ? (short)this.nv1 : (short)Short.MIN_VALUE;
    }

    public int getMaxNv() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getNv(i);
            if (!Stat.isValue((int)s)) continue;
            n = Math.max(n, s);
        }
        return n;
    }

    public void setGf(int n, short s) {
        if (n == 1) {
            this.gf1 = s;
        }
    }

    public short getGf(int n) {
        return n == 1 ? (short)this.gf1 : (short)Short.MIN_VALUE;
    }

    public int getSumGf() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getGf(i);
            if (!Stat.isValue((int)s)) continue;
            n += Math.abs(s);
        }
        return n;
    }

    public int getMaxGf() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            short s = this.getGf(i);
            if (!Stat.isValue((int)s) || Math.abs(s) <= Math.abs(n)) continue;
            n = s;
        }
        return n;
    }

    public int getGrzw(int n) {
        if (n > this.count()) {
            return Short.MIN_VALUE;
        }
        short s = this.getSaV(n);
        short s2 = this.getEv(n);
        if (s2 == 0) {
            return Short.MIN_VALUE;
        }
        double d = DataBase.getNvGrenz();
        if (s == 0) {
            return Short.MIN_VALUE;
        }
        if (s2 == 0) {
            return Short.MIN_VALUE;
        }
        double d2 = (double)s / Math.sqrt((double)s2 / 100.0) * d;
        if (d2 == -32768.0) {
            d2 += 1.0;
        }
        return (int)Math.rint(d2);
    }

    public int getMaxGrzw() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            int n2 = this.getGrzw(i);
            if (!Stat.isValue(n2)) continue;
            n = Math.max(n, n2);
        }
        return n;
    }

    public int getEgk(int n) {
        if (n > this.count()) {
            return Short.MIN_VALUE;
        }
        short s = this.getEv(n);
        if (s == 0) {
            return Short.MIN_VALUE;
        }
        double d = (1.0 - (double)s / 100.0) * (double)this.getGrzw(n);
        if (d == -32768.0) {
            d += 1.0;
        }
        return (int)Math.rint(d);
    }

    public int getMaxEgk() {
        int n = 0;
        for (int i = this.count(); i > 0; --i) {
            int n2 = this.getEgk(i);
            if (!Stat.isValue(n2)) continue;
            n = Math.max(n, n2);
        }
        return n;
    }

    public int getAG2() {
        return this.getAG(1, 2);
    }

    public int getAG4() {
        return this.getAG(3, 4);
    }

    private int getAG(int n, int n2) {
        double d = 0.0;
        for (int i = Math.max(this.count(), n2); i >= n; --i) {
            short s = this.getSaV(i);
            if (!Stat.isValue(s)) continue;
            short s2 = this.getNv(i);
            if (!Stat.isValue(s2)) {
                s2 = 0;
            }
            double d2 = (double)s * 0.001 * Math.max((double)s2 * 0.1, 1.0);
            d += d2 * d2;
        }
        return (int)Math.rint(Math.sqrt(d) * 1000.0);
    }

    public int getAZ2() {
        return this.getAZ(1, 2);
    }

    public int getAZ4() {
        return this.getAZ(3, 4);
    }

    private int getAZ(int n, int n2) {
        double d = 0.0;
        for (int i = Math.max(this.count(), n2); i >= n; --i) {
            short s = this.getSaV(i);
            if (!Stat.isValue(s)) continue;
            short s2 = this.getNv(i);
            if (!Stat.isValue(s2)) {
                s2 = 0;
            }
            double d2 = (double)s * 0.001 * Math.max((double)s2 * 0.1, 1.0);
            short s3 = this.getEv(i);
            if (!Stat.isValue(s3) || s3 == 0) {
                s3 = 1;
            }
            double d3 = Math.sqrt((double)s3 * 0.01);
            d += (d2 /= d3) * d2;
        }
        return (int)Math.rint(Math.sqrt(d) * 1000.0);
    }

    public String toString() {
        return "(" + this.v1 + "," + this.sav1 + "," + this.san1 + "," + this.ev1 + "," + this.ep1 + "," + this.nv1 + "," + this.gf1 + ")";
    }

    public static final String toString(short s) {
        if (s == Short.MIN_VALUE) {
            return "";
        }
        if (s == -32767) {
            return "<-32766";
        }
        if (s == 32766) {
            return ">32765";
        }
        if (s == Short.MAX_VALUE) {
            return "***";
        }
        return "" + s;
    }

    public static final String toString(short s, float f) {
        if (s == Short.MIN_VALUE) {
            return "";
        }
        if (s == -32767) {
            return "<" + dec.format(-32766.0f * f);
        }
        if (s == 32766) {
            return ">" + dec.format(32765.0f * f);
        }
        if (s == Short.MAX_VALUE) {
            return "***";
        }
        return dec.format((float)s * f);
    }

    public static final String toString(int n, float f) {
        if (n == Short.MIN_VALUE) {
            return "";
        }
        return dec.format((float)n * f);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.count());
        for (int i = 1; i <= this.count(); ++i) {
            dataOutput.writeShort(this.getV(i));
            dataOutput.writeShort(this.getSaV(i));
            dataOutput.writeShort(this.getSaN(i));
            dataOutput.writeShort(this.getEp(i));
            dataOutput.writeShort(this.getEv(i));
            dataOutput.writeShort(this.getNv(i));
            dataOutput.writeShort(this.getGf(i));
        }
    }

    public static Stat readObject(DataInput dataInput) throws IOException {
        int n = dataInput.readByte();
        Stat stat = null;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            stat = new Stat();
        } else if (n == 2) {
            stat = new Stat2();
        } else if (n == 3) {
            stat = new Stat3();
        } else if (n == 4) {
            stat = new Stat4();
        } else {
            throw new IOException("Unknown Stat(" + n + ")");
        }
        for (int i = 1; i <= n; ++i) {
            stat.setV(i, dataInput.readShort());
            stat.setSaV(i, dataInput.readShort());
            stat.setSaN(i, dataInput.readShort());
            stat.setEp(i, dataInput.readShort());
            stat.setEv(i, dataInput.readShort());
            stat.setNv(i, dataInput.readShort());
            stat.setGf(i, dataInput.readShort());
        }
        return stat;
    }

    public Stat clone(int n) {
        Stat stat = new Stat();
        stat.setV(1, this.getV(n));
        stat.setSaV(1, this.getSaV(n));
        stat.setSaN(1, this.getSaN(n));
        stat.setEp(1, this.getEp(n));
        stat.setEv(1, this.getEv(n));
        stat.setNv(1, this.getNv(n));
        stat.setGf(1, this.getGf(n));
        return stat;
    }

    public Stat() {
    }

    public Stat(Stat stat) {
        if (stat != null) {
            this.v1 = stat.v1;
            this.sav1 = stat.sav1;
            this.san1 = stat.san1;
            this.ep1 = stat.ep1;
            this.ev1 = stat.ev1;
            this.nv1 = stat.nv1;
            this.gf1 = stat.gf1;
        }
    }
}

