/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IInfoPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.awt.event.IMessageListener;
import de.geocalc.awt.event.IQuestionEvent;
import de.geocalc.awt.event.IQuestionListener;
import de.geocalc.awt.event.Question;
import de.geocalc.kafplot.DataBase;
import de.geocalc.text.IFormat;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class StatusBar
extends Panel
implements IQuestionListener,
ActionListener,
KeyListener,
IMessageListener {
    private static final String MESSAGE = "message";
    private static final String QUESTION = "question";
    private Panel userPanel;
    private IInfoPanel textPanel;
    private IInfoPanel mengePanel;
    private IInfoPanel statePanel;
    private IInfoPanel numPanel;
    private IInfoPanel kooPanel;
    private IInfoPanel querryPanel;
    private ITextField querryField;
    private CardLayout card;
    private Question question;

    private Panel createUserPanel() {
        this.card = new CardLayout(0, 0);
        Panel panel = new Panel(this.card);
        this.textPanel = new IInfoPanel();
        panel.add((Component)this.textPanel, MESSAGE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel2 = new Panel(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.querryPanel = new IInfoPanel();
        panel2.add(this.querryPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.querryPanel, gridBagConstraints);
        this.querryField = new ITextField(15);
        panel2.add(this.querryField);
        this.querryField.addKeyListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.querryField, gridBagConstraints);
        panel.add((Component)panel2, QUESTION);
        return panel;
    }

    public StatusBar() {
        this((String)null);
    }

    public StatusBar(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.userPanel = this.createUserPanel();
        this.add(this.userPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.userPanel, gridBagConstraints);
        this.mengePanel = new IInfoPanel(10);
        this.add(this.mengePanel);
        this.mengePanel.setAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.mengePanel, gridBagConstraints);
        this.statePanel = new IInfoPanel(3);
        this.add(this.statePanel);
        this.statePanel.setAlignment(2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.statePanel, gridBagConstraints);
        this.numPanel = new IInfoPanel(8);
        this.add(this.numPanel);
        this.numPanel.setAlignment(2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.numPanel, gridBagConstraints);
        this.kooPanel = new IInfoPanel(8);
        this.add(this.kooPanel);
        this.kooPanel.setAlignment(2);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.kooPanel, gridBagConstraints);
    }

    public void setText() {
        if (!DataBase.isEmpty()) {
            this.mengePanel.setText(DataBase.hasMenge() ? new Integer(DataBase.MENGE.size()).toString() : " ");
            if (!DataBase.isTested) {
                this.statePanel.setForeground(Color.red);
                this.statePanel.setStyle(1);
                this.statePanel.setText("!");
            } else {
                this.statePanel.setText(null);
            }
            this.numPanel.setText(DataBase.getNumSystemName());
            this.kooPanel.setText(DataBase.getKooSystemName());
        } else {
            this.textPanel.setText(null);
            this.mengePanel.setText(null);
            this.statePanel.setText(null);
            this.numPanel.setText(null);
            this.kooPanel.setText(null);
        }
        this.doLayout();
    }

    public void setText(String string, Color color) {
        this.card.show(this.userPanel, MESSAGE);
        this.textPanel.setText(string, color);
    }

    public void setText(String string) {
        this.card.show(this.userPanel, MESSAGE);
        this.textPanel.setText(string);
    }

    public String getText() {
        return this.textPanel.getText();
    }

    public void removeText(String string) {
        this.textPanel.removeText(string);
    }

    public void enableToolTips() {
        if (this.mengePanel != null) {
            this.mengePanel.setToolTipText("Menge");
        }
        if (this.statePanel != null) {
            this.statePanel.setToolTipText("Status");
        }
        if (this.numPanel != null) {
            this.numPanel.setToolTipText("Nummerierungsbezirk");
        }
        if (this.kooPanel != null) {
            this.kooPanel.setToolTipText("Koordinatensystem");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.querryField && this.question != null) {
            String string;
            Object object = this.question.getAnswer();
            if (object == null) {
                object = new String();
            }
            if ((string = actionEvent.getActionCommand()) != null) {
                try {
                    if (object instanceof Float) {
                        object = new Float(IFormat.getFloats(string));
                    } else if (object instanceof Double) {
                        object = new Double(IFormat.getFloats(string));
                    } else if (object instanceof Integer) {
                        object = new Integer(IFormat.getDigits(string));
                    } else if (object instanceof Long) {
                        object = new Long(IFormat.getDigits(string));
                    } else if (object instanceof String) {
                        object = string;
                    }
                }
                catch (Exception exception) {
                    return;
                }
                this.question.getQuestioner().answerPerformed(object);
            } else {
                this.question.getQuestioner().answerPerformed(null);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.actionPerformed(new ActionEvent(this.querryField, 1001, this.querryField.getText()));
                break;
            }
            case 27: {
                this.actionPerformed(new ActionEvent(this.querryField, 1001, null));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void questionPerformed(IQuestionEvent iQuestionEvent) {
        if (iQuestionEvent.getID() == 3) {
            this.question = null;
            this.card.show(this.userPanel, MESSAGE);
            ((Component)((Object)iQuestionEvent.getQuestioner())).removeKeyListener(this);
        } else {
            this.card.show(this.userPanel, QUESTION);
            if (this.question != null && this.question.equals(iQuestionEvent.getQuestion())) {
                this.querryField.requestFocus();
                return;
            }
            ((Component)((Object)iQuestionEvent.getQuestioner())).addKeyListener(this);
            this.question = iQuestionEvent.getQuestion();
            this.querryPanel.setText(this.question.getQuestion());
            this.querryField.setText(this.question.getAnswerString());
            this.querryField.selectAll();
        }
    }

    @Override
    public void messagePerformed(IMessageEvent iMessageEvent) {
        if (iMessageEvent.getID() == 1001) {
            this.setText(iMessageEvent.getMessage());
        } else if (iMessageEvent.getID() == 1003) {
            this.setText(iMessageEvent.getMessage(), Color.red);
        } else if (iMessageEvent.getID() == 1002) {
            this.setText();
        } else if (iMessageEvent.getID() == 1009) {
            this.removeText(iMessageEvent.getMessage());
        }
    }
}

