/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public final class Strasse
implements IntegerHashObject,
Comparable {
    private static final IntegerHashList codes = new IntegerHashList();
    private int nr;
    private String name;
    private Gemeinde gmd;
    private static int codeCounter = 0;

    public Strasse() {
    }

    public Strasse(int n, String string, Gemeinde gemeinde) {
        this.nr = n;
        this.name = string;
        this.gmd = gemeinde;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Strasse) {
            Strasse strasse = (Strasse)object;
            if (this.nr == strasse.getNummer()) {
                return 0;
            }
            if (this.nr > strasse.getNummer()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public void setGemeinde(Gemeinde gemeinde) {
        this.gmd = gemeinde;
    }

    public Gemeinde getGemeinde() {
        return this.gmd;
    }

    public void setNummer(int n) {
        this.nr = n;
    }

    public int getNummer() {
        return this.nr;
    }

    public String getNummerAsString() {
        return Strasse.toKeyString(this.gmd != null ? this.gmd.getNummer() : 0, this.nr);
    }

    public String toKeyString() {
        return Strasse.toKeyString(this.gmd != null ? this.gmd.getNummer() : 0, this.nr);
    }

    @Override
    public int intHashKey() {
        return this.nr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public static final String toKeyString(int n, int n2) {
        if (n2 < 0) {
            CodedStrasse codedStrasse = (CodedStrasse)codes.get(n2);
            return codedStrasse != null ? codedStrasse.getCode() : Integer.toString(n2);
        }
        if (n2 > 99999) {
            return new Character((char)(n2 / 10000)) + IFormat.i04.format(n2 % 10000);
        }
        return IFormat.i05.format(n2).toString();
    }

    public static final int parseKey(int n, String string) {
        if (string == null) {
            return 0;
        }
        if ((string = string.trim()).length() <= 5 && IFormat.hasOnlyNumbersFrom(string, 1)) {
            if (!Character.isDigit(string.charAt(0))) {
                return string.charAt(0) * 10000 + Integer.parseInt(string.substring(1));
            }
            return Integer.parseInt(string);
        }
        CodedStrasse codedStrasse = new CodedStrasse(n, string);
        codes.put(codedStrasse);
        return codedStrasse.intHashKey();
    }

    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer("C!KatLag:");
        stringBuffer.append(' ');
        stringBuffer.append(this.gmd.getNummer());
        stringBuffer.append('.');
        stringBuffer.append(this.getNummerAsString());
        stringBuffer.append(' ');
        stringBuffer.append("L=");
        stringBuffer.append(this.getName().replace(' ', '_'));
        return stringBuffer.toString();
    }

    public static Strasse parseDatLine(String string) throws IException {
        Object object;
        Strasse strasse = new Strasse();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IException("Lagekennzeichen fehlt");
        }
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-/\\.");
        if (stringTokenizer2.countTokens() != 2) {
            throw new IException("ung\u00fcltiges Lagekennzeichen: " + string2);
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(stringTokenizer2.nextToken());
            n2 = Strasse.parseKey(n, stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            throw new IException("Lagekennzeichen nicht numerisch: " + string2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n3 = ((String)object).indexOf("=");
            if (n3 < 0) {
                throw new IException("Kennung oder Wert fehlen im Feld \"" + (String)object + "\"");
            }
            String string3 = ((String)object).substring(0, n3);
            String string4 = ((String)object).substring(n3 + 1);
            if (!string3.equalsIgnoreCase("L")) continue;
            strasse.setName(string4.replace('_', ' '));
        }
        if (strasse.getName() == null) {
            throw new IException("Angabe Lagebezeichnung fehlt");
        }
        strasse.setNummer(n2);
        object = Gemeinde.getGemeinde(n);
        if (object == null) {
            throw new IException("Gemeindeschl\u00fcssel " + n + " nicht in Katalogliste enthalten");
        }
        strasse.setGemeinde((Gemeinde)object);
        ((Gemeinde)object).addStrasse(strasse);
        return strasse;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.nr)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("strassen", stringArray);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nr);
        KafPlotIOConstants.writeString(dataOutput, this.name);
    }

    public static Strasse readObject(DataInput dataInput) throws IOException {
        Strasse strasse = new Strasse();
        strasse.nr = dataInput.readInt();
        strasse.name = KafPlotIOConstants.readString(dataInput);
        return strasse;
    }

    public static void load(InputStream inputStream) throws IOException {
        boolean bl = false;
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            Gemeinde gemeinde = null;
            int n = 0;
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.length() == 0 || string.startsWith("#")) continue;
                if ((string = string.trim()).startsWith("[") && string.endsWith("]")) {
                    try {
                        n = Integer.parseInt(string.substring(1, string.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("nicht numerischer Gemeindeschl\u00fcssel");
                    }
                    gemeinde = Gemeinde.getGemeinde(n);
                    if (gemeinde != null) continue;
                    throw new IOException("unbekannter Gemeindeschl\u00fcssel '" + n + "', pr\u00fcfe 'Gemarkungen.properties'");
                }
                if (gemeinde == null) {
                    throw new IOException("Stra\u00dfe ohne zugeh\u00f6rigen Gemeindeschl\u00fcssel");
                }
                int n2 = 0;
                int n3 = string.lastIndexOf("=");
                if (n3 < 0) {
                    throw new IOException("fehlende Werte");
                }
                String string2 = string.substring(0, n3).trim();
                try {
                    n2 = Strasse.parseKey(n, string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("ung\u00fcltiger Stra\u00dfenschl\u00fcssel " + string2);
                }
                String string3 = string.substring(n3 + 1).trim();
                gemeinde.addStrasse(new Strasse(n2, string3, gemeinde));
            }
        }
        catch (IOException iOException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
    }

    private static class CodedStrasse
    implements IntegerHashObject {
        int key;
        String code;

        public CodedStrasse(int n, String string) {
            this.key = -(n % 100000 * 10000 + ++codeCounter);
            this.code = string;
        }

        public String getCode() {
            return this.code;
        }

        @Override
        public int intHashKey() {
            return this.key;
        }
    }
}

