/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.GemeindeInfoDialog;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class StrasseInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
ItemListener {
    private Button gmdButton;
    private Gemeinde gemeinde;
    private Choice gmdChoice;
    private Label gmdLabel;
    private IFrame parent;

    public StrasseInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null, null);
    }

    public StrasseInfoDialog(IFrame iFrame, String string, Gemeinde gemeinde, Strasse strasse) {
        super(iFrame, string, strasse);
        this.parent = iFrame;
        this.gemeinde = gemeinde;
        if (strasse == null && this.gmdChoice.getSelectedItem() != null) {
            this.setObject(Gemeinde.getGemeinde(Integer.parseInt(IFormat.getFirstNumbers(this.gmdChoice.getSelectedItem()))));
        }
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Gemeinde"));
        this.gmdChoice = new Choice();
        iPanel.add(this.gmdChoice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.gmdChoice, gridBagConstraints);
        this.gmdButton = new Button("...");
        iPanel.add(this.gmdButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.gmdButton, gridBagConstraints);
        this.gmdButton.addActionListener(this);
        Enumeration enumeration = Gemeinde.sortedElements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde = (Gemeinde)enumeration.nextElement();
            this.gmdChoice.addItem(Integer.toString(gemeinde.getNummer()) + "  " + gemeinde.getName());
        }
        this.gmdChoice.addItemListener(this);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(2);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Schl\u00fcssel", 0), new ITableCell("Name", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        if (object instanceof Gemeinde) {
            this.gemeinde = (Gemeinde)object;
            this.table.removeLines();
            if (this.gemeinde != null) {
                Enumeration enumeration = this.gemeinde.strassen();
                while (enumeration.hasMoreElements()) {
                    Strasse strasse = (Strasse)enumeration.nextElement();
                    ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(strasse.toKeyString(), 0), new ITableCell(strasse.getName(), -10)};
                    this.table.addLine(new ITableLine(iTableCellArray, strasse));
                }
                this.table.sort(0);
                this.table.doLayout();
                this.gmdChoice.select(Integer.toString(this.gemeinde.getNummer()) + "  " + this.gemeinde.getName());
            }
        } else if (object instanceof Strasse) {
            Strasse strasse = (Strasse)object;
            if (strasse != null && strasse.getGemeinde() != null && !strasse.getGemeinde().equals(this.gemeinde)) {
                this.setObject(strasse.getGemeinde());
            }
            this.table.select(strasse);
        }
    }

    @Override
    protected void showObject(Object object) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("...")) {
            GemeindeInfoDialog gemeindeInfoDialog = new GemeindeInfoDialog(this.parent, "Gemeinden ausw\u00e4hlen", null, true);
            gemeindeInfoDialog.setModal(true);
            gemeindeInfoDialog.setVisible(true);
            this.setObject(gemeindeInfoDialog.getObject());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.setObject(iTableEvent.getContent());
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.gmdChoice && itemEvent.getStateChange() == 1) {
            this.setObject(Gemeinde.getGemeinde(Integer.parseInt(IFormat.getFirstNumbers(this.gmdChoice.getSelectedItem()))));
        }
    }
}

