/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.io.DxfConstants;
import de.geocalc.io.DxfFileWriter;
import de.geocalc.kafplot.SymbolElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Symbol
implements Cloneable {
    public static Symbol VOID;
    public static Symbol OHNE;
    public static Symbol UNDEF;
    public static Symbol UNKNOWN;
    public static Symbol TP;
    public static Symbol AP;
    public static Symbol SP;
    public static Symbol VP;
    public static Symbol MB;
    public static Symbol ST;
    public static Symbol ST_;
    public static Symbol R;
    public static Symbol R_;
    public static Symbol KR;
    public static Symbol UV;
    public static Symbol GEB;
    public static Symbol GH;
    public static Symbol LB;
    public static Symbol NB;
    public static Symbol GP;
    public static Symbol TOP;
    public static Symbol POLAR_PFEIL;
    public static Symbol WINKEL2;
    public static Symbol TIEF;
    public static Symbol GEZOGEN;
    public static Symbol INLINIE;
    public static Symbol NEW;
    private static final int UNKNOWN_R = 20;
    private static final int UNDEF_R = 20;
    private static final int TP_R = 34;
    private static final int AP_R = 30;
    private static final int SP_R = 15;
    private static final int VP_R = 20;
    private static final int MB_R = 34;
    private static final int GP_R = 24;
    private static final int KR_R = 20;
    private static final int GB_R = 70;
    private static final int UV_R = 14;
    private static final int GEB_R = 10;
    private static final int TOP_R = 34;
    private static final int POLAR_PFEIL_R = 50;
    private static final int WINKEL2_R = 25;
    private static final int TIEF_R = 40;
    private static final int GEZOGEN_R = 40;
    private static final int INLINIE_R = 50;
    private static final int FL_E = 30;
    private static final int FL_O = 100;
    private static double WIDTH;
    public static final byte NO_FILL = 0;
    public static final byte ONLY_FILL = 1;
    public static final byte BOTH = 2;
    private static final Hashtable symbole;
    private static final SymbolElement SYM_TIEF;
    private static final SymbolElement SYM_HOCH;
    private static Color fgColor;
    private static Color bgColor;
    private String name;
    private int elements = 0;
    private int width = 0;
    private SymbolElement[] SE;
    private int x;
    private int y;
    private double startAngle;
    private boolean isAbsolute = false;

    public static Symbol getSymbol(String string) throws IException {
        if (string == null) {
            return null;
        }
        Symbol symbol = (Symbol)symbole.get(string);
        if (symbol != null) {
            return symbol;
        }
        throw new IException("unbekanntes Symbol: " + string);
    }

    public static Symbol getSymbol(int n) throws IException {
        return Symbol.getSymbol(Integer.toString(n));
    }

    public static Enumeration elements() {
        return symbole.elements();
    }

    public Symbol(String string, int n, int n2) {
        this(string, n, n2, 0, 0, 0.0, false);
    }

    public Symbol(String string, int n, int n2, boolean bl) {
        this(string, n, n2, 0, 0, 0.0, bl);
    }

    public Symbol(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, 0.0, false);
    }

    public Symbol(String string, int n, int n2, int n3, int n4, boolean bl) {
        this(string, n, n2, n3, n4, 0.0, bl);
    }

    public Symbol(String string, int n, int n2, int n3, int n4, double d) {
        this(string, n, n2, n3, n4, d, false);
    }

    public Symbol(String string, int n, int n2, int n3, int n4, double d, boolean bl) {
        this.name = string;
        this.SE = new SymbolElement[n];
        this.width = n2;
        this.x = n3;
        this.y = n4;
        this.startAngle = d;
        this.isAbsolute = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public void addElement(SymbolElement symbolElement) {
        this.SE[this.elements++] = symbolElement;
    }

    public static void setForeground(Color color) {
        fgColor = color;
    }

    public static void setBackground(Color color) {
        bgColor = color;
    }

    public void draw(Graphics graphics, int n, int n2, double d, double d2, byte by) {
        if (this.elements <= 0) {
            return;
        }
        d = this.isAbsolute ? -this.startAngle : -d - this.startAngle;
        double d3 = (double)this.width / WIDTH * d2;
        double d4 = Math.sin(d) * d3;
        double d5 = Math.cos(d) * d3;
        int n3 = n - (int)Math.rint((double)this.x * d5 + (double)this.y * d4);
        int n4 = n2 - (int)Math.rint((double)this.y * d5 - (double)this.x * d4);
        for (int i = 0; i < this.elements; ++i) {
            SymbolElement symbolElement = this.SE[i];
            symbolElement.setForeground(fgColor);
            symbolElement.setBackground(bgColor);
            symbolElement.draw(graphics, n3, n4, d4, d5, d, d3, by);
        }
    }

    public void writeAsDxfBlock(DxfFileWriter dxfFileWriter, double d) {
        if (this.elements <= 0) {
            return;
        }
        String string = DxfConstants.getDxfString(this.getName());
        double d2 = (double)this.width / 10000.0 * d / WIDTH;
        dxfFileWriter.writeVar(0, "BLOCK");
        dxfFileWriter.writeVar(8, "0");
        dxfFileWriter.writeVar(2, string);
        dxfFileWriter.writeVar(70, 64);
        dxfFileWriter.writeVar(10, (double)this.x * d2);
        dxfFileWriter.writeVar(20, (double)(-this.y) * d2);
        dxfFileWriter.writeVar(30, 0.0);
        dxfFileWriter.writeVar(3, string);
        for (int i = 0; i < this.elements; ++i) {
            this.SE[i].writeAsDxf(dxfFileWriter, d2);
        }
        dxfFileWriter.writeVar(0, "ENDBLK");
        dxfFileWriter.writeVar(8, "0");
    }

    static {
        WIDTH = 100.0;
        symbole = new Hashtable();
        SYM_TIEF = new SymbolElement(1, -150, -150, 150, 150);
        SYM_HOCH = new SymbolElement(1, 0, -150, 0, 0);
        fgColor = Color.black;
        bgColor = Color.white;
        int[] nArray = new int[]{-100, -75, 0, 75, 100, 75, 0, -75};
        int[] nArray2 = new int[]{0, -75, -100, -75, 0, 75, 100, 75};
        Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
        try {
            VOID = new Symbol("VOID", 0, 0);
            symbole.put(VOID.getName(), VOID);
            UNDEF = new Symbol("UNDEF", 1, 20);
            UNDEF.addElement(new SymbolElement(5, 0, 0, 100, 2));
            symbole.put(UNDEF.getName(), UNDEF);
            UNKNOWN = new Symbol("Unbekannt", 2, 20);
            UNKNOWN.addElement(new SymbolElement(1, -100, -100, 100, 100));
            UNKNOWN.addElement(new SymbolElement(1, 100, -100, -100, 100));
            symbole.put(UNKNOWN.getName(), UNKNOWN);
            OHNE = new Symbol("OHNE", 1, 20);
            OHNE.addElement(new SymbolElement(5, 0, 0, 100, 2));
            symbole.put(OHNE.getName(), OHNE);
            TP = new Symbol("TP", 2, 34);
            TP.addElement(new SymbolElement(2, 0, -100, 100, 100, -100, 100, 2));
            TP.addElement(new SymbolElement(0, 0, 0));
            symbole.put(TP.getName(), TP);
            AP = new Symbol("AP", 2, 30);
            AP.addElement(new SymbolElement(5, 0, 0, 100, 2));
            AP.addElement(new SymbolElement(0, 0, 0));
            symbole.put(AP.getName(), AP);
            SP = new Symbol("SP", 2, 15);
            SP.addElement(new SymbolElement(5, 0, 0, 100, 2));
            SP.addElement(new SymbolElement(0, 0, 0));
            VP = new Symbol("VP", 2, 20);
            VP.addElement(new SymbolElement(5, 0, 0, 100, 2));
            VP.addElement(new SymbolElement(0, 0, 0));
            MB = new Symbol("MB", 2, 34);
            MB.addElement(new SymbolElement(5, 0, 0, 100, 2));
            MB.addElement(new SymbolElement(5, 0, 0, 60, 0));
            ST = new Symbol("ST", 2, 24);
            ST.addElement(new SymbolElement(4, 0, 0, 100, 2));
            ST.addElement(new SymbolElement(0, 0, 0));
            symbole.put(ST.getName(), ST);
            ST_ = new Symbol("ST-", 3, 24);
            ST_.addElement(new SymbolElement(1, -100, -100, 100, 100));
            ST_.addElement(new SymbolElement(4, 0, 0, 100, 2));
            ST_.addElement(new SymbolElement(0, 0, 0));
            symbole.put(ST_.getName(), ST_);
            R = new Symbol("R", 2, 24);
            R.addElement(new SymbolElement(5, 0, 0, 100, 2));
            R.addElement(new SymbolElement(0, 0, 0));
            symbole.put(R.getName(), R);
            R_ = new Symbol("R-", 3, 24);
            R_.addElement(new SymbolElement(1, -120, -120, 120, 120));
            R_.addElement(new SymbolElement(5, 0, 0, 100, 2));
            R_.addElement(new SymbolElement(0, 0, 0));
            symbole.put(R_.getName(), R_);
            KR = new Symbol("KR", 4, 24);
            KR.addElement(new SymbolElement(1, -100, -100, 100, 100));
            KR.addElement(new SymbolElement(1, 100, -100, -100, 100));
            KR.addElement(new SymbolElement(5, 0, 0, 30, 1));
            KR.addElement(new SymbolElement(0, 0, 0));
            symbole.put(KR.getName(), KR);
            UV = new Symbol("UV", 2, 14);
            UV.addElement(new SymbolElement(5, 0, 0, 100, 1));
            UV.addElement(new SymbolElement(5, 0, 0, 20, 0));
            symbole.put(UV.getName(), UV);
            GEB = new Symbol("GEB", 2, 10);
            GEB.addElement(new SymbolElement(5, 0, 0, 100, 1));
            GEB.addElement(new SymbolElement(5, 0, 0, 50, 2));
            symbole.put(GEB.getName(), GEB);
            GH = new Symbol("GH", 6, 24);
            GH.addElement(new SymbolElement(5, 0, 0, 100, 2));
            GH.addElement(new SymbolElement(1, -120, -120, -77, -77));
            GH.addElement(new SymbolElement(1, 120, -120, 77, -77));
            GH.addElement(new SymbolElement(1, 120, 120, 77, 77));
            GH.addElement(new SymbolElement(1, -120, 120, -77, 77));
            GH.addElement(new SymbolElement(0, 0, 0));
            symbole.put(GH.getName(), GH);
            LB = new Symbol("LB", 4, 70, 0, 80, true);
            LB.addElement(new SymbolElement(5, 0, 80, 20, 2));
            LB.addElement(new SymbolElement(0, 0, 80));
            LB.addElement(new SymbolElement(1, 0, 60, 0, 30));
            Object object = new int[]{0, 20, 35, 40, 33, 40, 35, 22, 25, 20, 0, -20, -25, -22, -35, -40, -33, -40, -35, -20};
            int[] nArray3 = new int[]{25, 34, 30, 2, -5, -17, -50, -60, -80, -90, -99, -90, -80, -60, -50, -17, -5, 2, 30, 34};
            LB.addElement(new SymbolElement(8, new Polygon((int[])object, nArray3, ((int[])object).length), 2));
            symbole.put(LB.getName(), LB);
            NB = new Symbol("NB", 4, 70, 0, 80, true);
            NB.addElement(new SymbolElement(5, 0, 80, 20, 2));
            NB.addElement(new SymbolElement(0, 0, 80));
            NB.addElement(new SymbolElement(1, 0, 60, 0, 30));
            object = new int[]{45, 20, 40, 20, 35, 20, 30, 0, -30, -20, -35, -20, -40, -20, -45};
            nArray3 = new int[]{40, 10, 10, -20, -20, -50, -50, -99, -50, -50, -20, -20, 10, 10, 40};
            NB.addElement(new SymbolElement(8, new Polygon((int[])object, nArray3, ((int[])object).length), 2));
            symbole.put(NB.getName(), NB);
            GP = new Symbol("GP", 2, 24);
            GP.addElement(new SymbolElement(5, 0, 0, 100, 2));
            symbole.put(GP.getName(), GP);
            POLAR_PFEIL = new Symbol("POLAR_PFEIL", 2, 50, 0, 100, false);
            POLAR_PFEIL.addElement(new SymbolElement(2, 0, 100, 20, 60, -20, 60, 2));
            POLAR_PFEIL.addElement(new SymbolElement(1, 0, 100, 0, -100));
            symbole.put(POLAR_PFEIL.getName(), POLAR_PFEIL);
            WINKEL2 = new Symbol("WINKEL2", 2, 25, 100, 100, false);
            WINKEL2.addElement(new SymbolElement(6, 100, 100, 200, 0, 90, 0));
            WINKEL2.addElement(new SymbolElement(6, 100, 100, 140, 0, 90, 0));
            symbole.put(WINKEL2.getName(), WINKEL2);
            TIEF = new Symbol("TIEF", 1, 40);
            TIEF.addElement(new SymbolElement(1, 100, 100, -100, -100));
            symbole.put(TIEF.getName(), TIEF);
            GEZOGEN = new Symbol("GEZOGEN", 2, 40);
            GEZOGEN.addElement(new SymbolElement(1, 100, 100, -100, -100));
            GEZOGEN.addElement(new SymbolElement(1, 100, -100, -100, 100));
            symbole.put(GEZOGEN.getName(), GEZOGEN);
            INLINIE = new Symbol("INLINIE", 1, 50);
            INLINIE.addElement(new SymbolElement(6, 0, 0, 100, 0, -180, 0));
            symbole.put(INLINIE.getName(), INLINIE);
            NEW = new Symbol("NEU", 1, 100);
            object = new int[]{0, 100, 100};
            nArray3 = new int[]{0, -30, 30};
            NEW.addElement(new SymbolElement(8, new Polygon((int[])object, nArray3, ((int[])object).length), 2));
            symbole.put(NEW.getName(), NEW);
            TOP = new Symbol("TOP", 1, 34);
            TOP.addElement(new SymbolElement(5, 0, 0, 100, 0));
            symbole.put(TOP.getName(), TOP);
            symbole.put("0", TOP);
            object = new Symbol("292", 3, 80);
            ((Symbol)object).addElement(new SymbolElement(1, 0, -100, 0, 100));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 100, 20, 80));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 100, -20, 80));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("293", object);
            object = new Symbol("914", 2, 40);
            ((Symbol)object).addElement(new SymbolElement(1, -100, -100, 100, 100));
            ((Symbol)object).addElement(new SymbolElement(1, -100, 100, 100, -100));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("1141", 2, 50);
            ((Symbol)object).addElement(new SymbolElement(1, 0, 100, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, -60, -60, 60, -60));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("1142", 6, 60);
            ((Symbol)object).addElement(new SymbolElement(1, -90, 50, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, 0, -100, 90, 50));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 50, -90, 50));
            ((Symbol)object).addElement(new SymbolElement(1, -90, -50, 0, 100));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 100, 90, -50));
            ((Symbol)object).addElement(new SymbolElement(1, 90, -50, -90, -50));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("1194", 4, 60);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 100, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -60, -50, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -60, 50, 20));
            ((Symbol)object).addElement(new SymbolElement(6, 0, 20, 50, 0, 180, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("1195", 3, 60);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 100, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 0, -30, 30, 45, -225, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 0, 30, 30, 90, 225, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("1771", 4, 60);
            ((Symbol)object).addElement(new SymbolElement(1, -50, 50, 50, -50));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 50, -50, -50));
            nArray3 = new int[]{20, 40, 80, 80, 60};
            int[] nArray4 = new int[]{-70, -90, -50, -30, -30};
            ((Symbol)object).addElement(new SymbolElement(8, new Polygon(nArray3, nArray4, nArray3.length), 1));
            nArray3 = new int[]{-20, -40, -90, -70};
            nArray4 = new int[]{-70, -90, -40, -20};
            ((Symbol)object).addElement(new SymbolElement(8, new Polygon(nArray3, nArray4, nArray3.length), 1));
            symbole.put(((Symbol)object).getName(), object);
            try {
                object = (Symbol)object.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            ((Symbol)object).setName("1772");
            ((Symbol)object).setStartAngle(Math.PI);
            symbole.put(((Symbol)object).getName(), object);
            try {
                object = (Symbol)object.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            ((Symbol)object).setName("1773");
            ((Symbol)object).setStartAngle(1.5707963267948966);
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("2361", 5, 60);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 100, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 70, -30, -70));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -70, 0, -70));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 0, 0, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 0, -35, 35, 90, 180, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("2362", object);
            symbole.put("2363", object);
            symbole.put("2368", object);
            symbole.put("2369", object);
            object = new Symbol("2523", 5, 60);
            ((Symbol)object).addElement(new SymbolElement(1, -20, -90, -30, 5));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 5, 30, -5));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -5, 20, 90));
            ((Symbol)object).addElement(new SymbolElement(1, 20, 90, -10, 60));
            ((Symbol)object).addElement(new SymbolElement(1, 20, 90, 50, 60));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("5901", 1, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 100, 225, 270, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("5902", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(6, -50, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("5903", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(1, -50, 0, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 0, 0, -100));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6110", 1, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6900", object);
            symbole.put("6910", object);
            object = new Symbol("6111", 7, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -80, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 80, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6120", 3, 30);
            ((Symbol)object).addElement(new SymbolElement(6, -50, -40, 40, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 0, -50, 40));
            ((Symbol)object).addElement(new SymbolElement(6, 50, 0, 5, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6121", 10, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -10, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 0, 0, 10));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -50, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -40, -40, -30));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 30, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, 40, -40, 50));
            ((Symbol)object).addElement(new SymbolElement(6, -80, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 80, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6130", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(1, -100, -100, 100, 100));
            ((Symbol)object).addElement(new SymbolElement(1, 100, -100, -100, 100));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6131", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, -10, 10, 10));
            ((Symbol)object).addElement(new SymbolElement(1, 10, -10, -10, 10));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -50, -30, -30));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -50, -50, -30));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 50, -30, 30));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 50, -50, 30));
            ((Symbol)object).addElement(new SymbolElement(1, -90, -10, -70, 10));
            ((Symbol)object).addElement(new SymbolElement(1, -70, -10, -90, 10));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -50, 30, -30));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -50, 50, -30));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 50, 30, 30));
            ((Symbol)object).addElement(new SymbolElement(1, 30, 50, 50, 30));
            ((Symbol)object).addElement(new SymbolElement(1, 90, -10, 70, 10));
            ((Symbol)object).addElement(new SymbolElement(1, 70, -10, 90, 10));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6140", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(1, -50, 0, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 0, 0, -100));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6141", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -40, -40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -40, -40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 40, -40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 40, -40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -90, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -40, 40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -40, 40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 40, 40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 30, 40, 40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 70, 0, 80, -20));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6210", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(6, -50, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6200", object);
            symbole.put("6920", object);
            object = new Symbol("6211", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(6, -10, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 10, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -50, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -30, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -50, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -30, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -90, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -70, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 30, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 30, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 90, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 70, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6201", object);
            object = new Symbol("6220", 4, 30);
            ((Symbol)object).addElement(new SymbolElement(6, -50, -40, 40, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 0, -50, 40));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 0, 5, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 90, 0, 5, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6220", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -10, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 0, 0, 10));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -50, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -40, -40, -30));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 30, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, 40, -40, 50));
            ((Symbol)object).addElement(new SymbolElement(6, -90, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -70, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 30, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, -40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 30, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, 40, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 70, 0, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 90, 0, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6310", 3, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -80, 5, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -80, 30, 5, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 80, 30, 5, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6300", object);
            symbole.put("6930", object);
            object = new Symbol("6311", 21, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -10, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 10, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -50, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -50, -30, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -30, -30, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 30, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -50, 50, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -30, 50, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -80, -10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -90, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -70, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -50, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, -30, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 30, -30, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 30, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 50, 50, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 30, 50, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 80, -10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 90, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 70, 10, 2, 0, 360, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6301", object);
            object = new Symbol("6320", 9, 100);
            ((Symbol)object).addElement(new SymbolElement(6, -60, -10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -70, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -50, 10, 2, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 0, -40, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 7, -33, 17, -33));
            ((Symbol)object).addElement(new SymbolElement(6, 60, 0, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -10, 40, 0, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 40, 0, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 40, 20, 40));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6400", 1, 30);
            ((Symbol)object).addElement(new SymbolElement(1, 0, 0, 0, -100));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6940", object);
            object = new Symbol("6401", 7, 100);
            ((Symbol)object).addElement(new SymbolElement(1, 0, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -40, -40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -40, 40, -40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -80, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 40, -40, 40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 40, 40, 40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 80, 0, 80, -20));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6500", 6, 30);
            ((Symbol)object).addElement(new SymbolElement(1, -40, 0, 40, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -40, -70, -70));
            ((Symbol)object).addElement(new SymbolElement(1, -20, -50, -40, -90));
            ((Symbol)object).addElement(new SymbolElement(1, 0, -55, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, 40, -40, 70, -70));
            ((Symbol)object).addElement(new SymbolElement(1, 20, -50, 40, -90));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6950", object);
            object = new Symbol("6501", 42, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, 0, 10, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -10, -10, -20, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -5, -12, -10, -26));
            ((Symbol)object).addElement(new SymbolElement(1, 0, -13, 0, -30));
            ((Symbol)object).addElement(new SymbolElement(1, 5, -12, 10, -26));
            ((Symbol)object).addElement(new SymbolElement(1, 10, -10, 20, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -40, -30, -40));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -50, -60, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -45, -52, -50, -66));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -53, -40, -70));
            ((Symbol)object).addElement(new SymbolElement(1, -35, -52, -30, -66));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -50, -20, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 40, -30, 40));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 30, -60, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -45, 28, -50, 14));
            ((Symbol)object).addElement(new SymbolElement(1, -40, 27, -40, 10));
            ((Symbol)object).addElement(new SymbolElement(1, -35, 28, -30, 14));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 30, -20, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -90, 0, -70, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -90, -10, -100, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -85, -12, -90, -26));
            ((Symbol)object).addElement(new SymbolElement(1, -80, -13, -80, -30));
            ((Symbol)object).addElement(new SymbolElement(1, -75, -12, -70, -26));
            ((Symbol)object).addElement(new SymbolElement(1, -70, -10, -60, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -40, 30, -40));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -50, 60, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 45, -52, 50, -66));
            ((Symbol)object).addElement(new SymbolElement(1, 40, -53, 40, -70));
            ((Symbol)object).addElement(new SymbolElement(1, 35, -52, 30, -66));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -50, 20, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 40, 30, 40));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 30, 60, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 45, 28, 50, 14));
            ((Symbol)object).addElement(new SymbolElement(1, 40, 27, 40, 10));
            ((Symbol)object).addElement(new SymbolElement(1, 35, 28, 30, 14));
            ((Symbol)object).addElement(new SymbolElement(1, 30, 30, 20, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 70, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 90, -10, 100, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 85, -12, 90, -26));
            ((Symbol)object).addElement(new SymbolElement(1, 80, -13, 80, -30));
            ((Symbol)object).addElement(new SymbolElement(1, 75, -12, 70, -26));
            ((Symbol)object).addElement(new SymbolElement(1, 70, -10, 60, -20));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6600", 6, 30);
            ((Symbol)object).addElement(new SymbolElement(1, -20, 0, -20, -40));
            ((Symbol)object).addElement(new SymbolElement(1, -20, -40, -30, -80));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 0, -60, -40));
            ((Symbol)object).addElement(new SymbolElement(1, 20, 0, 20, -40));
            ((Symbol)object).addElement(new SymbolElement(1, 20, -40, 30, -80));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 0, 60, -40));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6960", object);
            object = new Symbol("6601", 42, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -5, 0, -5, -10));
            ((Symbol)object).addElement(new SymbolElement(1, -5, -10, -10, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -10, 0, -15, -10));
            ((Symbol)object).addElement(new SymbolElement(1, 5, 0, 5, -10));
            ((Symbol)object).addElement(new SymbolElement(1, 5, -10, 10, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 15, -10));
            ((Symbol)object).addElement(new SymbolElement(1, -45, -40, -45, -50));
            ((Symbol)object).addElement(new SymbolElement(1, -45, -50, -50, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -40, -55, -50));
            ((Symbol)object).addElement(new SymbolElement(1, -35, -40, -35, -50));
            ((Symbol)object).addElement(new SymbolElement(1, -35, -50, -30, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -40, -25, -50));
            ((Symbol)object).addElement(new SymbolElement(1, -45, 40, -45, 30));
            ((Symbol)object).addElement(new SymbolElement(1, -45, 30, -50, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 40, -55, 30));
            ((Symbol)object).addElement(new SymbolElement(1, -35, 40, -35, 30));
            ((Symbol)object).addElement(new SymbolElement(1, -35, 30, -30, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 40, -25, 30));
            ((Symbol)object).addElement(new SymbolElement(1, -85, 0, -85, -10));
            ((Symbol)object).addElement(new SymbolElement(1, -85, -10, -90, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -90, 0, -95, -10));
            ((Symbol)object).addElement(new SymbolElement(1, -75, 0, -75, -10));
            ((Symbol)object).addElement(new SymbolElement(1, -75, -10, -70, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -65, -10));
            ((Symbol)object).addElement(new SymbolElement(1, 45, -40, 45, -50));
            ((Symbol)object).addElement(new SymbolElement(1, 45, -50, 50, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -40, 55, -50));
            ((Symbol)object).addElement(new SymbolElement(1, 35, -40, 35, -50));
            ((Symbol)object).addElement(new SymbolElement(1, 35, -50, 30, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -40, 25, -50));
            ((Symbol)object).addElement(new SymbolElement(1, 45, 40, 45, 30));
            ((Symbol)object).addElement(new SymbolElement(1, 45, 30, 50, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 40, 55, 30));
            ((Symbol)object).addElement(new SymbolElement(1, 35, 40, 35, 30));
            ((Symbol)object).addElement(new SymbolElement(1, 35, 30, 30, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 30, 40, 25, 30));
            ((Symbol)object).addElement(new SymbolElement(1, 85, 0, 85, -10));
            ((Symbol)object).addElement(new SymbolElement(1, 85, -10, 90, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 95, -10));
            ((Symbol)object).addElement(new SymbolElement(1, 75, 0, 75, -10));
            ((Symbol)object).addElement(new SymbolElement(1, 75, -10, 70, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 70, 0, 65, -10));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6710", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -70, 30, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 0, -40, 0, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6700", object);
            symbole.put("6970", object);
            object = new Symbol("6711", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -20, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 0, -10, 0, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -60, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -50, -40, -40));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 20, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, 30, -40, 40));
            ((Symbol)object).addElement(new SymbolElement(6, -80, -20, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -80, -10, -80, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -60, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 40, -50, 40, -40));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 20, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 40, 30, 40, 40));
            ((Symbol)object).addElement(new SymbolElement(6, 80, -20, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 80, -10, 80, 0));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("6701", object);
            object = new Symbol("6720", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 80, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 0, 0, 80));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("6721", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, 0, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 0, 10, 0, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -40, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, -40, -40, -30));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 40, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -40, 40, -40, 50));
            ((Symbol)object).addElement(new SymbolElement(6, -80, 0, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -80, 10, -80, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -40, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 40, -40, 40, -30));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 40, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 40, 40, 40, 50));
            ((Symbol)object).addElement(new SymbolElement(6, 80, 0, 10, 0, 360, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 80, 10, 80, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7100", 2, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -40, 40, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -10, 60, -10));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7101", 14, 100);
            ((Symbol)object).addElement(new SymbolElement(6, 0, -10, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 7, -2, 17, -2));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -50, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -33, -42, -23, -42));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 30, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -33, 38, -23, 38));
            ((Symbol)object).addElement(new SymbolElement(6, -80, -10, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -73, -2, -63, -2));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -50, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 47, -42, 57, -42));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 30, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 47, 38, 57, 38));
            ((Symbol)object).addElement(new SymbolElement(6, 80, -10, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 87, -2, 97, -2));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7200", 3, 30);
            ((Symbol)object).addElement(new SymbolElement(1, -50, 0, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 0, 0, -100));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 0, 80, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7201", 21, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 15, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -50, -40, -40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -40, -40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, -30, -40, -25, -40));
            ((Symbol)object).addElement(new SymbolElement(1, -50, 40, -40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 40, -40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -30, 40, -25, 40));
            ((Symbol)object).addElement(new SymbolElement(1, -90, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -65, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -40, 40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 30, -40, 40, -60));
            ((Symbol)object).addElement(new SymbolElement(1, 50, -40, 55, -40));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 40, 40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 30, 40, 40, 20));
            ((Symbol)object).addElement(new SymbolElement(1, 50, 40, 55, 40));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 70, 0, 80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 95, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7300", 5, 30);
            ((Symbol)object).addElement(new SymbolElement(6, 50, -25, 40, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 75, 0, 100, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -100, 0, -60, -80));
            ((Symbol)object).addElement(new SymbolElement(1, -20, 0, -60, -80));
            ((Symbol)object).addElement(new SymbolElement(1, -20, 0, 0, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7301", 17, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 15, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -50, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -33, -42, -23, -42));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 30, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -33, 38, -23, 38));
            ((Symbol)object).addElement(new SymbolElement(1, -90, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -65, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -50, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 47, -42, 57, -42));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 30, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 47, 38, 57, 38));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 70, 0, 80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 95, 0));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7400", 5, 30);
            ((Symbol)object).addElement(new SymbolElement(6, -50, -25, 40, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 100, 0, 60, -80));
            ((Symbol)object).addElement(new SymbolElement(1, 20, 0, 60, -80));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("7401", 17, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 10, 0, 0, -20));
            ((Symbol)object).addElement(new SymbolElement(6, -40, -50, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(6, -40, 30, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, -90, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, -70, 0, -80, -20));
            ((Symbol)object).addElement(new SymbolElement(6, 40, -50, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(6, 40, 30, 10, 225, 270, 0));
            ((Symbol)object).addElement(new SymbolElement(1, 90, 0, 80, -20));
            ((Symbol)object).addElement(new SymbolElement(1, 70, 0, 80, -20));
            symbole.put(((Symbol)object).getName(), object);
            object = new Symbol("31002", 20, 100);
            ((Symbol)object).addElement(new SymbolElement(1, -10, -20, 10, 20));
            ((Symbol)object).addElement(new SymbolElement(1, -10, 20, 10, -20));
            symbole.put(((Symbol)object).getName(), object);
            symbole.put("9999", VOID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
        }
    }
}

