/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DPoint;
import de.geocalc.io.DxfFileWriter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class SymbolElement {
    public static final int PUNKT = 0;
    public static final int LINIE = 1;
    public static final int DREIECK = 2;
    public static final int RECHTECK = 3;
    public static final int QUADRAT = 4;
    public static final int KREIS = 5;
    public static final int BOGEN = 6;
    public static final int POLYLINIE = 7;
    public static final int POLYGON = 8;
    public static final int TEXT = 9;
    private static final String ILLEGAL_ARGUMENT_EXCEPTION = "Falsche Elementkennung beim Erzeugen des Symbolelements";
    private Color fgColor = Color.black;
    private Color bgColor = Color.white;
    private Polygon poly;
    private int el;
    private int x1;
    private int x2;
    private int x3;
    private int y1;
    private int y2;
    private int y3;
    private byte fillModus;

    public SymbolElement(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0, 0, 0, n == 0);
    }

    public SymbolElement(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0, 0, 0, n == 1);
    }

    public SymbolElement(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte by) {
        this(n, n2, n3, n4, n5, n6, n7, by, n == 2);
    }

    public SymbolElement(int n, int n2, int n3, int n4, int n5, byte by) {
        this(n, n2, n3, n4, n5, 0, 0, by, n == 3);
    }

    public SymbolElement(int n, int n2, int n3, int n4, int n5, int n6, byte by) {
        this(n, n2, n3, n4, n4, (int)Math.rint(n5), (int)Math.rint(n6), by, n == 6);
    }

    public SymbolElement(int n, int n2, int n3, int n4, byte by) {
        this(n, n2, n3, n4, n4, 0, 0, by, n == 4 || n == 5);
    }

    public SymbolElement(int n, Polygon polygon, byte by) {
        if (n != 7 && n != 8) {
            throw new IllegalArgumentException("Falsche Elementkennung beim Erzeugen des Symbolelements:" + n);
        }
        this.el = n;
        this.poly = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        this.fillModus = by;
    }

    private SymbolElement(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte by, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("Falsche Elementkennung beim Erzeugen des Symbolelements:" + n);
        }
        this.el = n;
        this.x1 = n2;
        this.y1 = n3;
        this.x2 = n4;
        this.y2 = n5;
        this.x3 = n6;
        this.y3 = n7;
        this.fillModus = by;
    }

    public void scale(double d) {
        this.x1 = (int)Math.rint((double)this.x1 * d);
        this.x2 = (int)Math.rint((double)this.x2 * d);
        this.x3 = (int)Math.rint((double)this.x3 * d);
        this.y1 = (int)Math.rint((double)this.y1 * d);
        this.y2 = (int)Math.rint((double)this.y2 * d);
        this.y3 = (int)Math.rint((double)this.y3 * d);
        if (this.poly != null) {
            for (int i = 0; i < this.poly.npoints; ++i) {
                this.poly.xpoints[i] = (int)Math.rint((double)this.poly.xpoints[i] * d);
                this.poly.ypoints[i] = (int)Math.rint((double)this.poly.ypoints[i] * d);
            }
        }
    }

    public void setForeground(Color color) {
        this.fgColor = color;
    }

    public void setBackground(Color color) {
        this.bgColor = color;
    }

    public void draw(Graphics graphics, int n, int n2, double d, double d2, double d3, double d4, byte by) {
        switch (this.el) {
            case 0: {
                graphics.setColor(this.fgColor);
                int n3 = n + (int)Math.rint((double)this.x1 * d2 + (double)this.y1 * d);
                int n4 = n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x1 * d);
                if (by == 1) break;
                graphics.drawLine(n3, n4, n3, n4);
                break;
            }
            case 1: {
                graphics.setColor(this.fgColor);
                if (by == 1) break;
                graphics.drawLine(n + (int)Math.rint((double)this.x1 * d2 + (double)this.y1 * d), n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x1 * d), n + (int)Math.rint((double)this.x2 * d2 + (double)this.y2 * d), n2 + (int)Math.rint((double)this.y2 * d2 - (double)this.x2 * d));
                break;
            }
            case 2: {
                Polygon polygon = new Polygon();
                polygon.addPoint(n + (int)Math.rint((double)this.x1 * d2 + (double)this.y1 * d), n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x1 * d));
                polygon.addPoint(n + (int)Math.rint((double)this.x2 * d2 + (double)this.y2 * d), n2 + (int)Math.rint((double)this.y2 * d2 - (double)this.x2 * d));
                polygon.addPoint(n + (int)Math.rint((double)this.x3 * d2 + (double)this.y3 * d), n2 + (int)Math.rint((double)this.y3 * d2 - (double)this.x3 * d));
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillPolygon(polygon);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawPolygon(polygon);
                break;
            }
            case 3: {
                Polygon polygon = new Polygon();
                polygon.addPoint(n + (int)Math.rint((double)this.x1 * d2 + (double)this.y1 * d), n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x1 * d));
                polygon.addPoint(n + (int)Math.rint((double)this.x1 * d2 + (double)this.y3 * d), n2 + (int)Math.rint((double)this.y3 * d2 - (double)this.x1 * d));
                polygon.addPoint(n + (int)Math.rint((double)this.x3 * d2 + (double)this.y3 * d), n2 + (int)Math.rint((double)this.y3 * d2 - (double)this.x3 * d));
                polygon.addPoint(n + (int)Math.rint((double)this.x3 * d2 + (double)this.y1 * d), n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x3 * d));
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillPolygon(polygon);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawPolygon(polygon);
                break;
            }
            case 4: {
                Polygon polygon = new Polygon();
                polygon.addPoint(n + (int)Math.rint((double)(this.x1 - this.x2) * d2 + (double)(this.y1 - this.y2) * d), n2 + (int)Math.rint((double)(this.y1 - this.y2) * d2 - (double)(this.x1 - this.x2) * d));
                polygon.addPoint(n + (int)Math.rint((double)(this.x1 + this.x2) * d2 + (double)(this.y1 - this.y2) * d), n2 + (int)Math.rint((double)(this.y1 - this.y2) * d2 - (double)(this.x1 + this.x2) * d));
                polygon.addPoint(n + (int)Math.rint((double)(this.x1 + this.x2) * d2 + (double)(this.y1 + this.y2) * d), n2 + (int)Math.rint((double)(this.y1 + this.y2) * d2 - (double)(this.x1 + this.x2) * d));
                polygon.addPoint(n + (int)Math.rint((double)(this.x1 - this.x2) * d2 + (double)(this.y1 + this.y2) * d), n2 + (int)Math.rint((double)(this.y1 + this.y2) * d2 - (double)(this.x1 - this.x2) * d));
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillPolygon(polygon);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawPolygon(polygon);
                break;
            }
            case 5: {
                int n5 = (int)Math.rint((double)this.x2 * d4);
                int n6 = n + (int)Math.rint((double)this.x1 * d2 + (double)this.y1 * d) - n5;
                int n7 = n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x1 * d) - n5;
                int n8 = Math.max(n5 * 2, 1);
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillOval(n6, n7, n8, n8);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawOval(n6, n7, n8, n8);
                break;
            }
            case 6: {
                int n9 = (int)Math.rint((double)this.x2 * d4);
                if (n9 < 1) {
                    n9 = 1;
                }
                int n10 = n + (int)Math.rint((double)this.x1 * d2 + (double)this.y1 * d);
                int n11 = n2 + (int)Math.rint((double)this.y1 * d2 - (double)this.x1 * d);
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillArc(n10 - n9, n11 - n9, 2 * n9 + 1, 2 * n9 + 1, this.x3 + (int)Math.rint(180.0 * d3 / Math.PI), -this.y3);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawArc(n10 - n9, n11 - n9, 2 * n9, 2 * n9, this.x3 + (int)Math.rint(180.0 * d3 / Math.PI), -this.y3);
                break;
            }
            case 7: {
                int[] nArray = new int[this.poly.npoints];
                int[] nArray2 = new int[this.poly.npoints];
                for (int i = 0; i < this.poly.npoints; ++i) {
                    nArray[i] = n + (int)Math.rint((double)this.poly.xpoints[i] * d2 + (double)this.poly.ypoints[i] * d);
                    nArray2[i] = n2 + (int)Math.rint((double)this.poly.ypoints[i] * d2 - (double)this.poly.xpoints[i] * d);
                }
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillPolygon(nArray, nArray2, this.poly.npoints);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawPolyline(nArray, nArray2, this.poly.npoints);
                break;
            }
            case 8: {
                int[] nArray = new int[this.poly.npoints];
                int[] nArray3 = new int[this.poly.npoints];
                for (int i = 0; i < this.poly.npoints; ++i) {
                    nArray[i] = n + (int)Math.rint((double)this.poly.xpoints[i] * d2 + (double)this.poly.ypoints[i] * d);
                    nArray3[i] = n2 + (int)Math.rint((double)this.poly.ypoints[i] * d2 - (double)this.poly.xpoints[i] * d);
                }
                if (by != 0 && this.fillModus != 0) {
                    graphics.setColor(this.bgColor);
                    graphics.fillPolygon(nArray, nArray3, this.poly.npoints);
                }
                if (by == 1 || this.fillModus == 1) break;
                graphics.setColor(this.fgColor);
                graphics.drawPolygon(nArray, nArray3, this.poly.npoints);
                break;
            }
        }
    }

    public void writeAsDxf(DxfFileWriter dxfFileWriter, double d) {
        switch (this.el) {
            case 0: {
                dxfFileWriter.writeCircle(new DPoint((double)this.x1 * d, (double)(-this.y1) * d), 1.0 * d, "0", 0);
                break;
            }
            case 1: {
                dxfFileWriter.writeLine(new DPoint((double)this.x1 * d, (double)(-this.y1) * d), new DPoint((double)this.x2 * d, (double)(-this.y2) * d), "0", 0);
                break;
            }
            case 2: {
                dxfFileWriter.writeLine(new DPoint((double)this.x1 * d, (double)(-this.y1) * d), new DPoint((double)this.x2 * d, (double)(-this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)this.x2 * d, (double)(-this.y2) * d), new DPoint((double)this.x3 * d, (double)(-this.y3) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)this.x3 * d, (double)(-this.y3) * d), new DPoint((double)this.x1 * d, (double)(-this.y1) * d), "0", 0);
                break;
            }
            case 3: {
                dxfFileWriter.writeLine(new DPoint((double)this.x1 * d, (double)(-this.y1) * d), new DPoint((double)this.x1 * d, (double)(-this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)this.x1 * d, (double)(-this.y2) * d), new DPoint((double)this.x2 * d, (double)(-this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)this.x2 * d, (double)(-this.y2) * d), new DPoint((double)this.x1 * d, (double)(-this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)this.x1 * d, (double)(-this.y2) * d), new DPoint((double)this.x1 * d, (double)(-this.y1) * d), "0", 0);
                break;
            }
            case 4: {
                dxfFileWriter.writeLine(new DPoint((double)(this.x1 - this.x2) * d, (double)(this.y1 + this.y2) * d), new DPoint((double)(this.x1 + this.x2) * d, (double)(this.y1 + this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)(this.x1 + this.x2) * d, (double)(this.y1 + this.y2) * d), new DPoint((double)(this.x1 + this.x2) * d, (double)(this.y1 - this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)(this.x1 + this.x2) * d, (double)(this.y1 - this.y2) * d), new DPoint((double)(this.x1 - this.x2) * d, (double)(this.y1 - this.y2) * d), "0", 0);
                dxfFileWriter.writeLine(new DPoint((double)(this.x1 - this.x2) * d, (double)(this.y1 - this.y2) * d), new DPoint((double)(this.x1 - this.x2) * d, (double)(this.y1 + this.y2) * d), "0", 0);
                break;
            }
            case 5: {
                dxfFileWriter.writeCircle(new DPoint((double)this.x1 * d, (double)(-this.y1) * d), (double)this.x2 * d, "0", 0);
                break;
            }
            case 6: {
                dxfFileWriter.writeArc(new DPoint((double)this.x1 * d, (double)(-this.y1) * d), (double)this.x2 * d, this.x3, this.y3, "0", 0);
                break;
            }
            case 7: {
                for (int i = 1; i < this.poly.npoints; ++i) {
                    dxfFileWriter.writeLine(new DPoint((double)this.poly.xpoints[i - 1] * d, (double)(-this.poly.ypoints[i - 1]) * d), new DPoint((double)this.poly.xpoints[i] * d, (double)(-this.poly.ypoints[i]) * d), "0", 0);
                }
                break;
            }
            case 8: {
                for (int i = 1; i < this.poly.npoints; ++i) {
                    dxfFileWriter.writeLine(new DPoint((double)this.poly.xpoints[i - 1] * d, (double)(-this.poly.ypoints[i - 1]) * d), new DPoint((double)this.poly.xpoints[i] * d, (double)(-this.poly.ypoints[i]) * d), "0");
                }
                dxfFileWriter.writeLine(new DPoint((double)this.poly.xpoints[this.poly.npoints - 1] * d, (double)(-this.poly.ypoints[this.poly.npoints - 1]) * d), new DPoint((double)this.poly.xpoints[0] * d, (double)(-this.poly.ypoints[0]) * d), "0", 0);
            }
        }
    }
}

