/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.NummerZuschlag;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.io.sta.StaIOProperties;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SystraExportOptionDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private Checkbox unusedPointsCheckbox;
    private Checkbox umnumPointsCheckbox;
    private Checkbox pointMfCheckbox;
    private Checkbox errMessungCheckbox;
    private Checkbox bogenSchnittCheckbox;
    private Checkbox sysMfCheckbox;
    private Checkbox individualMfCheckbox;
    private Checkbox allAsDigitCheckbox;
    private Checkbox naeherungDigCheckbox;
    private Checkbox dateAsTextCheckbox;
    private Choice pointNrChoice;
    private TextField pzLokTextField;
    private TextField mfFactorTextField;

    public SystraExportOptionDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        this.unusedPointsCheckbox = new Checkbox("Offlinepunkte", StaIOProperties.writeUnusedPoints());
        iPanel.add(this.unusedPointsCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.unusedPointsCheckbox, gridBagConstraints);
        this.umnumPointsCheckbox = new Checkbox("umnummerierte Punktnummern", StaIOProperties.writeUmnumPoints());
        iPanel.add(this.umnumPointsCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.umnumPointsCheckbox, gridBagConstraints);
        Label label = new Label("Punktnummernbildung f\u00fcr amtliche Punkte:");
        iPanel.add(label);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.pointNrChoice = new Choice();
        iPanel.add(this.pointNrChoice);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        int n = DataBase.model.getModel();
        this.pointNrChoice.addItem(PunktNummer.getLengthAsString(0, n));
        String[] stringArray = PunktNummer.getNames(n, true);
        for (int i = 0; i < stringArray.length; ++i) {
            this.pointNrChoice.addItem(stringArray[i]);
        }
        this.pointNrChoice.select(PunktNummer.getLengthAsString(StaIOProperties.getPnrModus(), n));
        gridBagLayout.setConstraints(this.pointNrChoice, gridBagConstraints);
        label = new Label("Punktnummernbildung f\u00fcr lokale Punkte:");
        iPanel.add(label);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.pzLokTextField = new TextField("", 13);
        iPanel.add(this.pzLokTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        try {
            StringBuffer stringBuffer = new StringBuffer(15);
            if (DataBase.gemarkung != null && DataBase.flur != null) {
                stringBuffer.append(StaIOProperties.createGmkFlurString());
                stringBuffer.append("0#####");
            }
            this.pzLokTextField.setText(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gridBagLayout.setConstraints(this.pzLokTextField, gridBagConstraints);
        this.pointMfCheckbox = new Checkbox("Punktgenauigkeiten", StaIOProperties.writePointMf());
        iPanel.add(this.pointMfCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.pointMfCheckbox, gridBagConstraints);
        this.errMessungCheckbox = new Checkbox("fehlermarkierte Messungen", StaIOProperties.writeErrorValues());
        iPanel.add(this.errMessungCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.errMessungCheckbox, gridBagConstraints);
        this.bogenSchnittCheckbox = new Checkbox("Bogenschnittdefinitionen \u00fcbertragen", StaIOProperties.writeBogenSchnittDef());
        iPanel.add(this.bogenSchnittCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.bogenSchnittCheckbox, gridBagConstraints);
        this.sysMfCheckbox = new Checkbox("Systemgenauigkeit gewichtsabh\u00e4ngig", StaIOProperties.writeSystemGewicht());
        iPanel.add(this.sysMfCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.sysMfCheckbox, gridBagConstraints);
        label = new Label("zus\u00e4tzlicher Faktor Standardabweichung:");
        iPanel.add(label);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.mfFactorTextField = new TextField(new Float(StaIOProperties.getMfFactor()).toString(), 8);
        iPanel.add(this.mfFactorTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.mfFactorTextField, gridBagConstraints);
        this.individualMfCheckbox = new Checkbox("individuelle Standardabweichungen", StaIOProperties.writeIndividualGewicht());
        iPanel.add(this.individualMfCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagLayout.setConstraints(this.individualMfCheckbox, gridBagConstraints);
        this.naeherungDigCheckbox = new Checkbox("ausgeglichene Koordinaten als Digitalisierung", StaIOProperties.writeApproxPoints());
        iPanel.add(this.naeherungDigCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagLayout.setConstraints(this.naeherungDigCheckbox, gridBagConstraints);
        this.allAsDigitCheckbox = new Checkbox("alle Transformationssysteme als Digitalisierung", StaIOProperties.writeAllAsDigit());
        iPanel.add(this.allAsDigitCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagLayout.setConstraints(this.allAsDigitCheckbox, gridBagConstraints);
        this.dateAsTextCheckbox = new Checkbox("Rissdatum als freier Text", StaIOProperties.writeDateAsText());
        iPanel.add(this.dateAsTextCheckbox);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagLayout.setConstraints(this.dateAsTextCheckbox, gridBagConstraints);
        return iPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
    }

    @Override
    protected void setOptions() {
        StaIOProperties.writeUnusedPoints(this.unusedPointsCheckbox.getState());
        StaIOProperties.writeUmnumPoints(this.umnumPointsCheckbox.getState());
        StaIOProperties.setPnrModus(PunktNummer.getLength(this.pointNrChoice.getSelectedItem()));
        try {
            StaIOProperties.setLokalNrZuschlag(NummerZuschlag.parseNummerZuschlag(this.pzLokTextField.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        StaIOProperties.writePointMf(this.pointMfCheckbox.getState());
        StaIOProperties.writeErrorValues(this.errMessungCheckbox.getState());
        StaIOProperties.writeBogenSchnittDef(this.bogenSchnittCheckbox.getState());
        StaIOProperties.writeSystemGewicht(this.sysMfCheckbox.getState());
        try {
            StaIOProperties.setMfFactor(new Float(this.mfFactorTextField.getText()).floatValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StaIOProperties.writeIndividualGewicht(this.individualMfCheckbox.getState());
        StaIOProperties.writeApproxPoints(this.naeherungDigCheckbox.getState());
        StaIOProperties.writeAllAsDigit(this.allAsDigitCheckbox.getState());
        StaIOProperties.writeDateAsText(this.dateAsTextCheckbox.getState());
    }
}

