/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import java.awt.Font;

public class TextArt {
    private static final double FONT_SCALE = 1.25;
    public static final int MODE_SCREEN = 0;
    public static final int MODE_PRINTER = 1;
    public static final int MASS = 1;
    public static final int GEBAEUDE = 2;
    public static final int ATTRIBUTE = 3;
    public static final int BESCHRIFTUNG10 = 10;
    public static final int BESCHRIFTUNG14 = 11;
    private static final int H_MASS = 12;
    private static final int H_GEBAEUDE = 12;
    private static final int H_ATTRIBUTE = 9;
    private static final int H_BESCHRIFTUNG10 = 10;
    private static final int H_BESCHRIFTUNG14 = 14;
    private static final Font S_GEBAEUDE = new Font("Dialog", 0, (int)Math.rint(15.0));
    private static final Font S_MASS = new Font("Dialog", 0, (int)Math.rint(15.0));
    private static final Font S_ATTRIBUTE = new Font("Dialog", 0, (int)Math.rint(11.25));
    private static final Font S_BESCHRIFTUNG10 = new Font("Dialog", 0, (int)Math.rint(12.5));
    private static final Font S_BESCHRIFTUNG14 = new Font("Dialog", 0, (int)Math.rint(17.5));
    private static int MODE = 0;
    private int art;
    private int height;
    private int slant;
    private int charSpace;
    private Font font = new Font("Dialog", 0, 14);
    private static final TextArt ALK_MASS = new TextArt(1);
    private static final TextArt ALK_GEBAEUDE = new TextArt(2);
    private static final TextArt ALK_ATTRIBUTE = new TextArt(3);
    private static final TextArt ALK_BESCHRIFTUNG10 = new TextArt(10);
    private static final TextArt ALK_BESCHRIFTUNG14 = new TextArt(11);

    public static void setMedium(int n) {
        MODE = n;
    }

    public static final TextArt create(int n) {
        switch (n) {
            case 1: {
                return ALK_MASS;
            }
            case 2: {
                return ALK_GEBAEUDE;
            }
            case 3: {
                return ALK_ATTRIBUTE;
            }
            case 10: {
                return ALK_BESCHRIFTUNG10;
            }
            case 11: {
                return ALK_BESCHRIFTUNG14;
            }
        }
        return ALK_MASS;
    }

    private TextArt(int n) {
        this.art = n;
        switch (n) {
            case 1: {
                this.height = 12;
                this.font = S_MASS;
                break;
            }
            case 2: {
                this.height = 12;
                this.font = S_GEBAEUDE;
                break;
            }
            case 3: {
                this.height = 9;
                this.font = S_ATTRIBUTE;
                break;
            }
            case 10: {
                this.height = 10;
                this.font = S_BESCHRIFTUNG10;
                break;
            }
            case 11: {
                this.height = 14;
                this.font = S_BESCHRIFTUNG14;
                break;
            }
            default: {
                this.height = 12;
                this.font = S_MASS;
            }
        }
    }

    public int getHeight() {
        if (MODE == 1) {
            return (int)Math.rint((double)this.height / 1.25);
        }
        return this.height;
    }

    public int getSlant() {
        return this.slant;
    }

    public int getCharSpace() {
        return this.charSpace;
    }

    public Font getFont() {
        return this.font;
    }

    public String toString(int n) {
        switch (n) {
            case 2: {
                return "Geb\u00e4udebezeichnung";
            }
            case 1: {
                return "Ma\u00df";
            }
        }
        return "Text";
    }
}

