/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DDimension;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.KafPlotProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public abstract class TextBox {
    private String text;
    private int pos = -99;
    private Point loc = new Point();
    private int width;
    private int height;
    private Color foreground = Color.white;
    private Color background = Color.black;
    private static final int ARC = 6;
    private static final int PFL = 8;

    public TextBox() {
        this(null);
    }

    public TextBox(String string) {
        this.setText(string);
        this.calculatePosition();
    }

    public abstract DPoint getCatchPoint();

    public DDimension getSize() {
        return new DDimension(this.width, this.height);
    }

    public void setText(String string) {
        this.text = string;
        this.layoutText();
        this.calculateSize();
    }

    public void addText(String string) {
        if (this.text == null) {
            this.setText(string);
        } else if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(this.text);
            if (!string.startsWith("\n") || !this.text.endsWith("\n")) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
            this.setText(stringBuffer.toString());
        }
    }

    public String getText() {
        return this.text;
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.loc.x = n;
        this.loc.y = n2;
    }

    public Point getLocation() {
        return this.loc;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    private boolean isFormated() {
        return this.text.indexOf(10) > 0;
    }

    public void setPosition(int n) {
        this.pos = n;
    }

    public int getPosition() {
        return this.pos;
    }

    private void layoutText() {
        if (this.text == null || this.isFormated()) {
            return;
        }
        Font font = KafPlotProperties.getBemFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.stringWidth(" ");
        int n2 = fontMetrics.getHeight();
        StringTokenizer stringTokenizer = new StringTokenizer(this.text);
        int n3 = stringTokenizer.countTokens();
        int[] nArray = new int[n3];
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n7] = fontMetrics.stringWidth(stringTokenizer.nextToken());
            n4 = Math.min(n4, nArray[n7]);
            n5 = Math.max(n5, nArray[n7]);
            n6 += nArray[n7];
            ++n7;
        }
        n6 += (n3 - 1) * n;
        for (int i = n2; n6 / 4 > i; i *= 2) {
            n6 /= 2;
        }
        n6 = Math.max(n6, n5);
        stringTokenizer = new StringTokenizer(this.text);
        StringBuffer stringBuffer = new StringBuffer();
        n7 = 0;
        int n8 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (n7 == 0) {
                stringBuffer.append(string);
                n8 = nArray[n7];
            } else if (n8 + n + nArray[n7] < n6) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                n8 += n + nArray[n7];
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(string);
                n8 = nArray[n7];
            }
            ++n7;
        }
        this.text = stringBuffer.toString();
    }

    public void calculateSize() {
        this.width = 0;
        this.height = 0;
        if (this.text != null) {
            Font font = KafPlotProperties.getBemFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
            int n = this.calculateLineHeight(fontMetrics);
            while (stringTokenizer.hasMoreTokens()) {
                this.width = Math.max(this.width, fontMetrics.stringWidth(stringTokenizer.nextToken()));
                this.height += n;
            }
            this.width += 2 * this.calculateHBorder(fontMetrics);
            this.height += 2 * this.calculateVBorder(fontMetrics);
        }
    }

    protected int calculateHBorder(FontMetrics fontMetrics) {
        return Math.max(2, fontMetrics.getHeight() / 4);
    }

    protected int calculateVBorder(FontMetrics fontMetrics) {
        return Math.min(2, fontMetrics.getLeading());
    }

    protected int calculateLineHeight(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    protected void calculatePosition() {
        this.pos = 11;
    }

    public void paint(Graphics graphics) {
        if (this.text == null) {
            return;
        }
        if (this.pos == -99) {
            this.calculatePosition();
        }
        Font font = KafPlotProperties.getBemFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = this.calculateHBorder(fontMetrics);
        int n2 = this.calculateVBorder(fontMetrics);
        int n3 = this.calculateLineHeight(fontMetrics);
        graphics.setFont(font);
        Point point = this.getLocation();
        Point point2 = null;
        Point point3 = null;
        Point point4 = null;
        switch (this.pos) {
            case -9: {
                point2 = new Point(point.x + 8, point.y - 16);
                point3 = new Point(point.x + 16, point.y - 8);
                point4 = new Point(point.x + 8, point.y - 8 - this.height);
                break;
            }
            case -10: {
                point2 = new Point(point.x + 8, point.y - 8);
                point3 = new Point(point.x + 8, point.y + 8);
                point4 = new Point(point.x + 8, point.y - this.height / 2);
                break;
            }
            case -11: {
                point2 = new Point(point.x + 8, point.y + 16);
                point3 = new Point(point.x + 16, point.y + 8);
                point4 = new Point(point.x + 8, point.y + 8);
                break;
            }
            case 1: {
                point2 = new Point(point.x - 8, point.y - 8);
                point3 = new Point(point.x + 8, point.y - 8);
                point4 = new Point(point.x - this.width / 2, point.y - 8 - this.height);
                break;
            }
            case -1: {
                point2 = new Point(point.x - 8, point.y + 8);
                point3 = new Point(point.x + 8, point.y + 8);
                point4 = new Point(point.x - this.width / 2, point.y + 8);
                break;
            }
            case 11: {
                point2 = new Point(point.x - 8, point.y - 16);
                point3 = new Point(point.x - 16, point.y - 8);
                point4 = new Point(point.x - 8 - this.width, point.y - 8 - this.height);
                break;
            }
            case 10: {
                point2 = new Point(point.x - 8, point.y - 8);
                point3 = new Point(point.x - 8, point.y + 8);
                point4 = new Point(point.x - 8 - this.width, point.y - this.height / 2);
                break;
            }
            case 9: {
                point2 = new Point(point.x - 8, point.y + 16);
                point3 = new Point(point.x - 16, point.y + 8);
                point4 = new Point(point.x - 8 - this.width, point.y + 8);
                break;
            }
            default: {
                point2 = point;
                point3 = point;
                point4 = new Point(point.x - this.width / 2, point.y - this.height / 2);
            }
        }
        graphics.setColor(this.getBackground());
        Polygon polygon = new Polygon();
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point3.x, point3.y);
        graphics.fillPolygon(polygon);
        if (this.text.length() > 0) {
            graphics.fillRoundRect(point4.x, point4.y, this.width, this.height, 6, 6);
        }
        graphics.setColor(this.getForeground());
        if (this.text.length() > 0) {
            graphics.drawRoundRect(point4.x, point4.y, this.width, this.height, 6, 6);
        }
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.drawLine(point.x, point.y, point3.x, point3.y);
        if (this.text.length() > 0) {
            Point point5 = new Point(point4.x + n, point4.y + n2 + fontMetrics.getAscent());
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
            graphics.setFont(font);
            while (stringTokenizer.hasMoreTokens()) {
                graphics.drawString(stringTokenizer.nextToken(), point5.x, point5.y);
                point5.y += n3;
            }
        } else {
            graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        }
    }
}

