/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.LineDisplayProp;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectLine;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TopObject
extends GObject
implements PaintObject,
DatObject,
Comparable,
Exceptionable,
Messager {
    private int idNr = 0;
    private int count = 0;
    private String name = null;
    private int funktion;
    private static final Text text = new Text(2, 2, null, 0.0, 0.0, 0.0, 1, 0);
    private static final TextSymbol sym = new TextSymbol(text, new Point());
    private static final Point p = new Point();

    public void setFunktion(int n) {
        this.funktion = n;
    }

    public int getFunktion() {
        return this.funktion;
    }

    @Override
    public LinieParameter getLineDefaults() {
        int n = this.getOska();
        switch (n) {
            case 51001: {
                return new LinieParameter(4, 2, n, 2001);
            }
            case 51002: {
                if (this.funktion <= 1220) {
                    return LinieParameter.intern(new LinieParameter(4, 2, n, 4002));
                }
                return LinieParameter.intern(new LinieParameter(4, 9, n, 4001));
            }
            case 51003: {
                return LinieParameter.intern(new LinieParameter(4, 2, n, 2001));
            }
            case 51004: 
            case 51005: 
            case 51006: 
            case 51007: 
            case 51008: {
                return LinieParameter.intern(new LinieParameter(4, 9, n, 4001));
            }
            case 51009: {
                int n2 = 4001;
                switch (this.funktion) {
                    case 1610: 
                    case 1611: {
                        n2 = 4003;
                        break;
                    }
                    case 1700: 
                    case 1703: {
                        n2 = 4005;
                        break;
                    }
                    case 1701: {
                        n2 = 4007;
                        break;
                    }
                    case 1702: {
                        n2 = 4006;
                        break;
                    }
                    case 1720: 
                    case 1723: {
                        n2 = 4008;
                        break;
                    }
                    case 1721: {
                        n2 = 4010;
                        break;
                    }
                    case 1722: {
                        n2 = 4009;
                        break;
                    }
                    case 1740: {
                        n2 = 4004;
                    }
                }
                return LinieParameter.intern(new LinieParameter(4, 9, n, n2));
            }
            case 51010: {
                return LinieParameter.intern(new LinieParameter(4, 9, n, 4001));
            }
            case 53001: 
            case 53002: 
            case 53003: {
                return LinieParameter.intern(new LinieParameter(4, 4, n, 4001));
            }
            case 53004: 
            case 53006: {
                return LinieParameter.intern(new LinieParameter(4, 11, n, 4001));
            }
            case 53005: 
            case 53007: {
                return LinieParameter.intern(new LinieParameter(4, 9, n, 4001));
            }
            case 53008: 
            case 53009: {
                return LinieParameter.intern(new LinieParameter(4, 8, n, 4001));
            }
            case 54001: {
                return new LinieParameter(4, 7, n, 4001);
            }
            case 55001: 
            case 55002: 
            case 57001: 
            case 57002: {
                return LinieParameter.intern(new LinieParameter(4, 8, n, 4001));
            }
            case 61001: 
            case 61002: 
            case 61003: 
            case 61005: 
            case 61006: 
            case 61007: 
            case 61008: 
            case 62040: {
                return LinieParameter.intern(new LinieParameter(4, 5, n, 5000));
            }
        }
        return LinieParameter.intern(new LinieParameter(4, 9, n, 4001));
    }

    @Override
    public boolean defMultiArea() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return this.idNr == 0 && this.count == 0;
    }

    @Override
    public void deleteName() {
        this.idNr = 0;
        this.count = 0;
    }

    public boolean equals(Object object) {
        if (object instanceof TopObject) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        TopObject topObject = (TopObject)object;
        if (this.idNr != 0 || topObject.idNr != 0) {
            if (this.idNr == topObject.idNr) {
                return 0;
            }
            if (this.idNr > topObject.idNr) {
                return 1;
            }
            return -1;
        }
        if (this.count == topObject.count) {
            return 0;
        }
        if (this.count > topObject.count) {
            return 1;
        }
        return -1;
    }

    public void setNummer(int n) {
        this.idNr = n;
    }

    public int getNummer() {
        return this.idNr;
    }

    public String getNummerAsString() {
        return this.idNr > 0 ? IFormat.i05.format(this.idNr).toString() : "";
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    public void setBezeichnung(String string) {
        this.name = string;
    }

    public String getBezeichnung() {
        return this.name;
    }

    public String getBezeichnungAsString() {
        return this.name != null ? this.name : "";
    }

    @Override
    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.idNr != 0) {
            stringBuffer.append(IFormat.i05.format(this.idNr).toString());
            if (this.name != null) {
                stringBuffer.append(" ");
                stringBuffer.append(this.name);
            }
        } else {
            stringBuffer.append("o.Nr. (");
            stringBuffer.append(IFormat.i.format(this.count).toString());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "TopObjekt";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.idNr != 0) {
            stringBuffer.append(IFormat.i05.format(this.idNr).toString());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_1.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_1.format(this.x).toString());
        }
        if (this.getOska() != 0) {
            stringBuffer.append(" O=");
            stringBuffer.append(this.getOska());
        }
        if (this.name != null) {
            stringBuffer.append(" L=");
            stringBuffer.append(this.getBezeichnung());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    public static DataContainer parseDatLine(String string) throws IException {
        TopObject topObject = new TopObject();
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    if (n == 0 && Character.isDigit(string2.charAt(0))) {
                        try {
                            topObject.setNummer(Integer.parseInt(string2));
                        }
                        catch (Exception exception) {
                            throw new IException("fehlerhaftes Objektkennzeichen");
                        }
                    } else if (n == 0 && string2.startsWith("TP")) {
                        try {
                            topObject.setNummer(Integer.parseInt(string2.substring(2)));
                        }
                        catch (Exception exception) {
                            throw new IException("fehlerhaftes Objektkennzeichen");
                        }
                    } else {
                        int n2 = string2.indexOf(61);
                        String string3 = string2.substring(0, n2);
                        String string4 = string2.substring(n2 + 1);
                        if (string3.equalsIgnoreCase("O")) {
                            int n3 = string4.indexOf(".");
                            if (n3 > 0) {
                                topObject.setFolie(Integer.parseInt(string4.substring(0, n3)));
                                topObject.setOska(Integer.parseInt(string4.substring(n3 + 1)));
                            } else {
                                topObject.setOska(Integer.parseInt(string4));
                            }
                        } else if (string3.equalsIgnoreCase("Y")) {
                            topObject.y = Double.valueOf(string4);
                        } else if (string3.equalsIgnoreCase("X")) {
                            topObject.x = Double.valueOf(string4);
                        } else if (string3.equalsIgnoreCase("L")) {
                            topObject.setBezeichnung(string4.replace('_', ' '));
                        } else if (string3.equalsIgnoreCase("C")) {
                            topObject.setColor(IFormat.parseColor(string4));
                        } else {
                            throw new IException("unzul\u00e4ssige Variable: " + string3);
                        }
                    }
                    ++n;
                }
                catch (Exception exception) {
                    throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
            }
        }
        return topObject;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Top:");
        stringBuffer.append(" ");
        if (this.idNr != 0) {
            stringBuffer.append("TP");
            stringBuffer.append(IFormat.i06.format(this.idNr).toString());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_3.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_3.format(this.x).toString());
        }
        if (this.getOska() != 0) {
            stringBuffer.append(" O=");
            if (this.getFolie() > 0) {
                stringBuffer.append(IFormat.i03.format(this.getFolie()) + ".");
            }
            stringBuffer.append(this.getOska());
        }
        if (this.name != null) {
            stringBuffer.append(" L=");
            stringBuffer.append(this.getBezeichnung().replace(' ', '_'));
        }
        if (super.getColor() != null) {
            stringBuffer.append(" C=");
            stringBuffer.append(IFormat.colorString(super.getColor()));
        }
        return stringBuffer.toString();
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        printWriter.println(XmlIOProperties.openln("topobjekt"));
        if (this.idNr != 0) {
            printWriter.println(XmlIOProperties.data("idnr", Integer.toString(this.idNr)));
        }
        if (this.name != null) {
            printWriter.println(XmlIOProperties.data("lage", this.name));
        }
        if (this.hasLocation()) {
            printWriter.println(XmlIOProperties.data("y", IFormat.f_3.format(this.y).toString()));
            printWriter.println(XmlIOProperties.data("x", IFormat.f_3.format(this.x).toString()));
        }
        if (this.getOska() != 0) {
            printWriter.println(XmlIOProperties.data("os", IFormat.i04.format(this.getOska()).toString()));
        }
        printWriter.println(XmlIOProperties.open("linien"));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Linie)enumeration.nextElement()).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("linien"));
        printWriter.println(XmlIOProperties.close("topobjekt"));
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(this.getFolie());
        dataOutput.writeInt(this.getOska());
        dataOutput.writeFloat(this.getTextAngle());
        dataOutput.writeInt(this.idNr);
        dataOutput.writeShort(this.count);
        dataOutput.writeShort(this.getFunktion());
        KafPlotIOConstants.writeString(dataOutput, this.name);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Linie)enumeration.nextElement()).writeObject(dataOutput);
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ((ObjectDecor)enumeration.nextElement()).writeObject(dataOutput);
            }
        }
        if (this.att != null) {
            enumeration = this.attributes();
            while (enumeration.hasMoreElements()) {
                dataOutput.writeByte(110);
                String string = (String)enumeration.nextElement();
                KafPlotIOConstants.writeString(dataOutput, string);
                KafPlotIOConstants.writeString(dataOutput, this.getAttribute(string).toString());
            }
        }
        dataOutput.writeByte(0);
    }

    public static TopObject readObject(DataInput dataInput) throws IOException {
        TopObject topObject = new TopObject();
        topObject.y = dataInput.readDouble();
        topObject.x = dataInput.readDouble();
        if (KpvIOProperties.RVER >= 106 && dataInput.readByte() != 0) {
            topObject.yt = dataInput.readDouble();
            topObject.xt = dataInput.readDouble();
        }
        topObject.setFolie(dataInput.readShort());
        if (KpvIOProperties.RVER >= 202) {
            topObject.setOska(dataInput.readInt());
        } else {
            topObject.setOska(dataInput.readShort());
        }
        topObject.setTextAngle(dataInput.readFloat());
        topObject.idNr = dataInput.readInt();
        topObject.count = dataInput.readShort();
        if (KpvIOProperties.RVER >= 202) {
            topObject.setFunktion(dataInput.readShort());
        }
        topObject.name = KafPlotIOConstants.readString(dataInput);
        byte by = 0;
        while ((by = dataInput.readByte()) != -1) {
            if (by == 15) {
                topObject.addElement(Linie.readObject(dataInput));
                continue;
            }
            if (by == 61) {
                topObject.addDecor(ObjectText.readObject(dataInput));
                continue;
            }
            if (by == 62) {
                topObject.addDecor(ObjectSymbol.readObject(dataInput));
                continue;
            }
            if (by == 63) {
                topObject.addDecor(ObjectLine.readObject(dataInput));
                continue;
            }
            if (by != 110) break;
            topObject.setAttribute(KafPlotIOConstants.readString(dataInput), KafPlotIOConstants.readString(dataInput));
        }
        return topObject;
    }

    @Override
    public Vector getKatasterNachweisLinien(ExceptionList exceptionList) {
        return new Vector(1);
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2 || KafPlotProperties.isFlaecheFillVisible && KafPlotProperties.isTopFillVisible) {
            this.drawBackground(iGraphics, bl, bl2);
        }
        if (bl2 || KafPlotProperties.isFlaechePolyVisible && KafPlotProperties.isTopPolyVisible) {
            this.drawForeground(iGraphics, bl, bl2);
        }
        if (KafPlotProperties.isFlaecheTextVisible) {
            this.drawInscription(iGraphics, bl, bl2);
        }
        if (bl2) {
            this.drawHashpoint(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Linie.objectDisplayProp = LineDisplayProp.getObjectProp(this.getOska());
        if (super.getColor() != null) {
            if (Linie.objectDisplayProp != null) {
                Linie.objectDisplayProp = new LineDisplayProp(Linie.objectDisplayProp);
                Linie.objectDisplayProp.setColor(super.getColor());
            } else {
                Linie.objectDisplayProp = new LineDisplayProp(0, super.getColor(), 1, 0);
            }
        }
        super.drawForeground(iGraphics, bl, bl2);
        Linie.objectDisplayProp = null;
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.isArea()) {
            if (bl2) {
                super.drawBackground(iGraphics, bl, bl2);
                return;
            }
            if (DataBase.model.getModel() != 2) {
                if (super.getColor() != null) {
                    iGraphics.getGraphics().setColor(super.getColor().brighter());
                } else if (KafPlotProperties.getColorSwitch() == 1009) {
                    iGraphics.getGraphics().setColor(IColor.getBrighter(KafPlotProperties.aBgColor.getColor("O"), 0.7f));
                } else if (KafPlotProperties.getColorSwitch() == 1006) {
                    iGraphics.getGraphics().setColor(KafPlotProperties.aKaColor.getColor("T"));
                } else {
                    Linie linie = (Linie)this.elementAt(0);
                    iGraphics.getGraphics().setColor(KafPlotProperties.aStColor.getColor(new Integer(linie.getEb())));
                }
            } else {
                switch (this.getOska()) {
                    case 51001: 
                    case 51002: 
                    case 51003: {
                        Color color = null;
                        if (KafPlotProperties.isShadowing) {
                            color = KafPlotColor.DARK_SHADOW;
                        } else {
                            switch (KafPlotProperties.getColorSwitch()) {
                                case 1009: {
                                    color = IColor.getBrighter(KafPlotProperties.aBgColor.getColor("O"), 0.7f);
                                    break;
                                }
                                case 1004: {
                                    color = KafPlotProperties.aFoColor.getColor(this.isFortfuehrung() ? "G1" : "G0");
                                    break;
                                }
                                case 1005: 
                                case 1010: {
                                    color = KafPlotColor.BACKGROUND;
                                    break;
                                }
                                case 1002: 
                                case 1003: {
                                    color = Color.gray;
                                    break;
                                }
                                case 1006: {
                                    color = KafPlotProperties.aKaColor.getColor("I");
                                    break;
                                }
                                case 1007: 
                                case 1008: 
                                case 1011: {
                                    return;
                                }
                                default: {
                                    color = super.getColor();
                                }
                            }
                        }
                        iGraphics.getGraphics().setColor(color != null ? color : Ebene.getFlaecheColor(2));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            super.drawBackground(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Color color = null;
        int n = KafPlotProperties.getColorSwitch();
        color = n == 1009 ? KafPlotProperties.aBgColor.getColor("O") : (n == 1004 ? IColor.getDarker(KafPlotProperties.aBgColor.getColor("T"), 0.85f) : (DataBase.model.getModel() == 2 ? (n == 1001 ? KafPlotColor.TOP_FG : (n == 1006 && this.getOska() == 61001 ? Ebene.getColor(5) : Color.black)) : Color.black));
        graphics.setColor(color);
        if (this.name != null && this.hasLocation() && KafPlotProperties.isTopNameVisible && iGraphics.contains(this.y, this.x)) {
            TopObject.text.text = this.name;
            text.setTextWinkel(this.getTextAngle());
            TopObject.sym.t = text;
            TopObject.sym.p = iGraphics.getGraphicPoint(this.y, this.x, p);
            sym.paint(graphics);
        }
        if (this.hasDecor()) {
            iGraphics.setStroke(Alkis.STROKE_DECOR);
            Enumeration enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ObjectDecor objectDecor = (ObjectDecor)enumeration.nextElement();
                objectDecor.setColor(color);
                if (objectDecor instanceof ObjectText) {
                    if (!KafPlotProperties.isTopTextVisible) continue;
                    objectDecor.drawObject(iGraphics, bl, bl2);
                    continue;
                }
                if (!KafPlotProperties.isTopSymVisible) continue;
                objectDecor.drawObject(iGraphics, bl, bl2);
            }
            iGraphics.setStroke(IGraphics.DEFAULT_STROKE);
        }
    }
}

