/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class TopObjectInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
DataBaseListener {
    private Label idLabel;
    private Label oskaLabel;

    public TopObjectInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (TopObject)null);
    }

    public TopObjectInfoDialog(IFrame iFrame, String string, TopObject topObject) {
        super(iFrame, string, topObject);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(0));
        Label label = new Label("Kennzeichen: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.idLabel = new Label("", 0);
        iPanel.add(this.idLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.idLabel, gridBagConstraints);
        label = new Label("Oska: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.oskaLabel = new Label("", 0);
        iPanel.add(this.oskaLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.oskaLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(3);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Kennzeichen", 0), new ITableCell("Name", 0), new ITableCell("Oska", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        TopObject topObject = (TopObject)object;
        this.table.removeLines();
        if (topObject != null) {
            this.addObjectToTable(topObject);
        }
        super.setObject(object);
    }

    public void setObjects(Enumeration enumeration) {
        this.table.removeLines();
        while (enumeration.hasMoreElements()) {
            this.addObjectToTable(enumeration.nextElement());
        }
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    protected void showObject(Object object) {
        TopObject topObject = (TopObject)object;
        if (topObject != null) {
            this.idLabel.setText(topObject.getNummerAsString());
            String string = Alkis.getObjectName(topObject.getOska());
            this.oskaLabel.setText("(" + topObject.getOska() + ") " + (string != null ? string : ""));
        } else {
            this.idLabel.setText("");
            this.oskaLabel.setText("");
        }
    }

    private void addObjectToTable(Object object) {
        TopObject topObject = (TopObject)object;
        ITableCell[] iTableCellArray = new ITableCell[3];
        iTableCellArray[0] = new ITableCell(topObject.getNummerAsString(), -10);
        iTableCellArray[1] = new ITableCell(topObject.getBezeichnungAsString(), -10);
        StringBuffer stringBuffer = new StringBuffer();
        if (topObject.getFolie() > 0) {
            stringBuffer.append(IFormat.i03.format(topObject.getFolie()));
            stringBuffer.append(".");
        }
        stringBuffer.append(topObject.getOska());
        iTableCellArray[2] = new ITableCell(stringBuffer.toString(), 10);
        this.table.addLine(new ITableLine(iTableCellArray, topObject));
        Enumeration enumeration = topObject.decors();
        while (enumeration.hasMoreElements()) {
            ObjectDecor objectDecor = (ObjectDecor)enumeration.nextElement();
            iTableCellArray = new ITableCell[3];
            if (objectDecor instanceof ObjectText) {
                iTableCellArray[0] = new ITableCell("Text", -10);
                iTableCellArray[1] = new ITableCell(((ObjectText)objectDecor).getText(), -10);
                iTableCellArray[2] = new ITableCell(IFormat.i04.format(objectDecor.getOska()), 10);
            } else if (objectDecor instanceof ObjectSymbol) {
                iTableCellArray[0] = new ITableCell("Symbol", -10);
                iTableCellArray[1] = new ITableCell("", -10);
                iTableCellArray[2] = new ITableCell(IFormat.i04.format(objectDecor.getOska()), 10);
            }
            this.table.addLine(new ITableLine(iTableCellArray, topObject));
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.object = iTableEvent.getContent();
        this.showObject(iTableEvent.getContent());
        if (iTableEvent.getClickCount() > 1 && this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }
}

