/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.ClearList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public final class TrafoGewicht {
    private static final ClearList list = new ClearList();
    private float g1;
    private float g2;

    public static TrafoGewicht intern(TrafoGewicht trafoGewicht) {
        if (trafoGewicht == null) {
            throw new NullPointerException();
        }
        Object object = list.put(trafoGewicht);
        return object != null ? (TrafoGewicht)object : trafoGewicht;
    }

    public TrafoGewicht(float f, float f2) {
        this.g1 = f;
        this.g2 = f2;
    }

    public boolean hasG1() {
        return this.g1 != 0.0f;
    }

    public void setG1(float f) {
        this.g1 = f;
    }

    public float getG1() {
        return this.g1;
    }

    public boolean hasG2() {
        return this.g2 != 0.0f;
    }

    public void setG2(float f) {
        this.g2 = f;
    }

    public float getG2() {
        return this.g2;
    }

    public int hashCode() {
        return (int)this.g1 * 100 + (int)this.g2 * 100;
    }

    public String toDatString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hasG1() ? IFormat.f3_3.format(this.g1) : "       ");
        stringBuffer.append(" ");
        stringBuffer.append(this.hasG2() ? IFormat.f3_3.format(this.g2) : "       ");
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof TrafoGewicht) {
            TrafoGewicht trafoGewicht = (TrafoGewicht)object;
            return trafoGewicht.g1 == this.g1 && trafoGewicht.g2 == this.g2;
        }
        return false;
    }

    public static void writeObjects(DataOutput dataOutput) throws IOException {
        dataOutput.write(95);
        int n = list.size();
        if (n > Short.MAX_VALUE) {
            throw new IOException("overflow TrafoGew");
        }
        dataOutput.writeShort(n);
        int n2 = 1;
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            TrafoGewicht trafoGewicht = (TrafoGewicht)enumeration.nextElement();
            trafoGewicht.writeObject(dataOutput);
            KpvIOProperties.setTrafoGewicht(n2, trafoGewicht);
            ++n2;
        }
    }

    public static void readObjects(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        for (int i = 0; i < n; ++i) {
            TrafoGewicht trafoGewicht = TrafoGewicht.intern(TrafoGewicht.readObject(dataInput));
            KpvIOProperties.setTrafoGewicht(i + 1, trafoGewicht);
        }
    }

    private void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.g1);
        dataOutput.writeFloat(this.g2);
    }

    private static TrafoGewicht readObject(DataInput dataInput) throws IOException {
        return new TrafoGewicht(dataInput.readFloat(), dataInput.readFloat());
    }
}

