/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IInfoField;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class TrafoInfoDialog
extends IDialog
implements ActionListener {
    private static final String NEXT_COMMAND = "      >>      ";
    private static final String BEFORE_COMMAND = "      <<      ";
    private static final String OK_COMMAND = "OK";
    private static final String VOID = "                 ";
    private Object o;
    private Button nextButton;
    private Button beforeButton;
    private Label nr1Label;
    private Label ma1Label;
    private Label ma2Label;
    private Label dim1Label;
    private Label dim2Label;
    private Label listLabel;
    private Label rissLabel;
    private IInfoField nr1Field;
    private IInfoField ma1Field;
    private IInfoField ma2Field;
    private IInfoField ag1Field;
    private IInfoField rg1Field;
    private IInfoField vs1Field;
    private IInfoField vs2Field;
    private IInfoField rs1Field;
    private IInfoField rs2Field;
    private IInfoField listField;
    private IInfoField rissField;
    private IInfoField bemField;
    private Label[] typLabel = new Label[2];
    private IInfoField[] vvvField = new IInfoField[2];
    private IInfoField[] savField = new IInfoField[2];
    private IInfoField[] sanField = new IInfoField[2];
    private IInfoField[] evvField = new IInfoField[2];
    private IInfoField[] epvField = new IInfoField[2];
    private IInfoField[] nvvField = new IInfoField[2];
    private IInfoField[] gfvField = new IInfoField[2];
    private IInfoField[] grzField = new IInfoField[4];
    private IInfoField[] egkField = new IInfoField[4];
    private String dialogName;
    private boolean hasStat = false;
    private Vector trafops = new Vector();
    int aktIdx = 0;

    public TrafoInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Object)null);
    }

    public TrafoInfoDialog(IFrame iFrame, String string, Object object) {
        super(iFrame, string, true);
        this.o = object;
        this.hasStat = DataBase.hasStatistik;
        this.dialogName = string;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createInfoPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setObject(object);
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(false);
    }

    private Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        IPanel iPanel = this.createValPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        if (this.hasStat) {
            iPanel = this.createStatPanel();
            panel.add(iPanel);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        }
        iPanel = this.createBemPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        return panel;
    }

    private IPanel createValPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Werte"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.nr1Label = new Label("Punktnummer");
        panel.add(this.nr1Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nr1Label, gridBagConstraints);
        this.nr1Field = new IInfoField(15, 2);
        panel.add(this.nr1Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nr1Field, gridBagConstraints);
        Label label = new Label("Sp");
        panel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ag1Field = new IInfoField(6, 2);
        panel.add(this.ag1Field);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ag1Field, gridBagConstraints);
        label = new Label("m");
        panel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Sn");
        panel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rg1Field = new IInfoField(6, 2);
        panel.add(this.rg1Field);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rg1Field, gridBagConstraints);
        label = new Label("m");
        panel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ma1Label = new Label("Y-Koordinate");
        panel.add(this.ma1Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ma1Label, gridBagConstraints);
        this.ma1Field = new IInfoField(15, 2);
        panel.add(this.ma1Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ma1Field, gridBagConstraints);
        this.dim1Label = new Label("m");
        panel.add(this.dim1Label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.dim1Label, gridBagConstraints);
        label = new Label("Vy");
        panel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.vs1Field = new IInfoField(6, 2);
        panel.add(this.vs1Field);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.vs1Field, gridBagConstraints);
        label = new Label("m");
        panel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Ry");
        panel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rs1Field = new IInfoField(6, 2);
        panel.add(this.rs1Field);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rs1Field, gridBagConstraints);
        label = new Label("m");
        panel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ma2Label = new Label("X-Koordinate ");
        panel.add(this.ma2Label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ma2Label, gridBagConstraints);
        this.ma2Field = new IInfoField(15, 2);
        panel.add(this.ma2Field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.ma2Field, gridBagConstraints);
        this.dim2Label = new Label("m");
        panel.add(this.dim2Label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.dim2Label, gridBagConstraints);
        label = new Label("Vx");
        panel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.vs2Field = new IInfoField(6, 2);
        panel.add(this.vs2Field);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.vs2Field, gridBagConstraints);
        label = new Label("m");
        panel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Rx");
        panel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rs2Field = new IInfoField(6, 2);
        panel.add(this.rs2Field);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rs2Field, gridBagConstraints);
        label = new Label("m");
        panel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rissLabel = new Label("Riss: ");
        panel.add(this.rissLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rissLabel, gridBagConstraints);
        this.rissField = new IInfoField(40, 1);
        panel.add(this.rissField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rissField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private IPanel createStatPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Statistik"));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        Label label = new Label("Verbesserung");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("SA V.A.");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("SA N.A.");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("EV");
        iPanel.add(label);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("EP");
        iPanel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("NV");
        iPanel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("GF");
        iPanel.add(label);
        gridBagConstraints.gridx = 7;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("GRZW");
        iPanel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("EGK");
        iPanel.add(label);
        gridBagConstraints.gridx = 9;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        label = new Label("Art des Wertes");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[%]");
        iPanel.add(label);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("  ");
        iPanel.add(label);
        gridBagConstraints.gridx = 6;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 7;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 8;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("[m]");
        iPanel.add(label);
        gridBagConstraints.gridx = 9;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        for (int i = 0; i < 2; ++i) {
            gridBagConstraints.gridy = i + 2;
            this.createValLine(i, iPanel, gridBagLayout, gridBagConstraints);
        }
        gridBagConstraints.gridy = 6;
        label = new Label("SA:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Standardabweichung vor und nach der Ausgleichung");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        label = new Label("EV:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Kontrollierbarkeit der Messung in %");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        label = new Label("EP:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Einfluss der Beobachtung auf die relative Punktlage");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        label = new Label("NV:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Normierte Verbesserung");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        label = new Label("GF:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Gesch\u00e4tzter grober Fehler");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        label = new Label("GRZW:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Grenzwert der Erkennbarkeit eines groben Fehlers");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        label = new Label("EGK:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Einfluss eines nicht erkannten GF auf die relative Punktlage");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        return iPanel;
    }

    private void createValLine(int n, IPanel iPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        this.typLabel[n] = new Label("Art der Angabe:");
        iPanel.add(this.typLabel[n]);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.typLabel[n], gridBagConstraints);
        this.vvvField[n] = new IInfoField(8, 2);
        iPanel.add(this.vvvField[n]);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.vvvField[n], gridBagConstraints);
        this.savField[n] = new IInfoField(6, 2);
        iPanel.add(this.savField[n]);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this.savField[n], gridBagConstraints);
        this.sanField[n] = new IInfoField(6, 2);
        iPanel.add(this.sanField[n]);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.sanField[n], gridBagConstraints);
        this.evvField[n] = new IInfoField(3, 2);
        iPanel.add(this.evvField[n]);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.evvField[n], gridBagConstraints);
        this.epvField[n] = new IInfoField(6, 2);
        iPanel.add(this.epvField[n]);
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(this.epvField[n], gridBagConstraints);
        this.nvvField[n] = new IInfoField(6, 2);
        iPanel.add(this.nvvField[n]);
        gridBagConstraints.gridx = 6;
        gridBagLayout.setConstraints(this.nvvField[n], gridBagConstraints);
        this.gfvField[n] = new IInfoField(6, 2);
        iPanel.add(this.gfvField[n]);
        gridBagConstraints.gridx = 7;
        gridBagLayout.setConstraints(this.gfvField[n], gridBagConstraints);
        this.grzField[n] = new IInfoField(6, 2);
        iPanel.add(this.grzField[n]);
        gridBagConstraints.gridx = 8;
        gridBagLayout.setConstraints(this.grzField[n], gridBagConstraints);
        this.egkField[n] = new IInfoField(6, 2);
        iPanel.add(this.egkField[n]);
        gridBagConstraints.gridx = 9;
        gridBagLayout.setConstraints(this.egkField[n], gridBagConstraints);
    }

    private IPanel createBemPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1, "Bemerkungen"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        this.bemField = new IInfoField(40, 1, 0);
        panel.add(this.bemField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.bemField, gridBagConstraints);
        iPanel.add("West", panel);
        return iPanel;
    }

    private Panel createButtonPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        Panel panel = new Panel(gridBagLayout);
        this.beforeButton = new Button(BEFORE_COMMAND);
        panel.add(this.beforeButton);
        this.beforeButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.beforeButton, gridBagConstraints);
        this.nextButton = new Button(NEXT_COMMAND);
        panel.add(this.nextButton);
        this.nextButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.nextButton, gridBagConstraints);
        Button button = new Button(OK_COMMAND);
        panel.add(button);
        button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.endDialog();
        } else if (string.equals(BEFORE_COMMAND)) {
            --this.aktIdx;
            this.setTrafoPoint();
        } else if (string.equals(NEXT_COMMAND)) {
            ++this.aktIdx;
            this.setTrafoPoint();
        }
    }

    private void fillValLine(int n, TrafoPunkt trafoPunkt) {
        int n2 = n + 1;
        if (trafoPunkt != null && trafoPunkt.hasStatistik()) {
            Stat stat = trafoPunkt.getStatistik();
            String string = trafoPunkt.getFormatedStatistikName(n2);
            this.typLabel[n].setText((String)(string.length() > 0 ? string + ":" : ""));
            Color color = Color.black;
            if (stat.getGf(n2) != Short.MIN_VALUE) {
                color = Color.red;
            } else if (stat.getEv(n2) == Short.MIN_VALUE) {
                color = Color.gray;
            }
            this.vvvField[n].setForeground(color);
            this.savField[n].setForeground(color);
            this.sanField[n].setForeground(color);
            this.evvField[n].setForeground(color);
            this.epvField[n].setForeground(color);
            this.nvvField[n].setForeground(color);
            this.gfvField[n].setForeground(color);
            this.vvvField[n].setText(Stat.toString(stat.getV(n2), 0.001f));
            this.savField[n].setText(Stat.toString(stat.getSaV(n2), 0.001f));
            this.sanField[n].setText(Stat.toString(stat.getSaN(n2), 0.001f));
            this.evvField[n].setText(Stat.toString(stat.getEv(n2)));
            this.epvField[n].setText(Stat.toString(stat.getEp(n2), 0.001f));
            this.nvvField[n].setText(Stat.toString(stat.getNv(n2), 0.1f));
            this.gfvField[n].setText(Stat.toString(stat.getGf(n2), 0.001f));
            this.grzField[n].setText(Stat.toString(stat.getGrzw(n2), 0.001f));
            this.egkField[n].setText(Stat.toString(stat.getEgk(n2), 0.001f));
        } else {
            this.typLabel[n].setText("Art der Angabe:");
            this.vvvField[n].setText("");
            this.savField[n].setText("");
            this.sanField[n].setText("");
            this.evvField[n].setText("");
            this.epvField[n].setText("");
            this.nvvField[n].setText("");
            this.gfvField[n].setText("");
            this.grzField[n].setText("");
            this.egkField[n].setText("");
        }
    }

    private void setTrafoPoint() {
        TrafoPunkt trafoPunkt = null;
        int n = this.trafops.size();
        if (n > 0) {
            this.aktIdx = Math.max(0, this.aktIdx);
            this.aktIdx = Math.min(this.trafops.size() - 1, this.aktIdx);
            trafoPunkt = (TrafoPunkt)this.trafops.elementAt(this.aktIdx);
        }
        if (trafoPunkt != null) {
            this.setTitle(this.dialogName + " (" + n + (n == 1 ? " System)" : " Systeme)"));
            this.nr1Field.setText(Long.toString(trafoPunkt.getPunkt().nr));
            this.ma1Field.setText(IFormat.f_3.format(trafoPunkt.y));
            this.ma2Field.setText(IFormat.f_3.format(trafoPunkt.x));
            if (trafoPunkt.hasGewichte()) {
                this.ag1Field.setText(IFormat.f_3.format(trafoPunkt.getGewichte().getG1()));
                this.rg1Field.setText(IFormat.f_3.format(trafoPunkt.getGewichte().getG2()));
            } else {
                this.ag1Field.setText("");
                this.rg1Field.setText("");
            }
            if (KafkaIOProperties.isLT8Read()) {
                this.vs1Field.setText(IFormat.f_3.format(trafoPunkt.getVy()));
                this.vs2Field.setText(IFormat.f_3.format(trafoPunkt.getVx()));
            } else {
                this.vs1Field.setText("");
                this.vs1Field.setText("");
            }
            if (KafkaIOProperties.isLT9Read()) {
                this.rs1Field.setText(IFormat.f_3.format(trafoPunkt.getRy()));
                this.rs2Field.setText(IFormat.f_3.format(trafoPunkt.getRx()));
            } else {
                this.rs1Field.setText("");
                this.rs1Field.setText("");
            }
            this.rissField.setText(trafoPunkt.getContainer().getName());
            if (this.hasStat) {
                for (int i = 0; i < 2; ++i) {
                    this.fillValLine(i, trafoPunkt);
                }
            }
            this.bemField.setText(trafoPunkt.getBemerkungText());
            this.beforeButton.setEnabled(this.aktIdx > 0);
            this.nextButton.setEnabled(this.aktIdx < n - 1);
        } else {
            this.setTitle(this.dialogName);
            this.nr1Field.setText("");
            this.ma1Field.setText("");
            this.ma2Field.setText("");
            this.ag1Field.setText("");
            this.rg1Field.setText("");
            this.vs1Field.setText("");
            this.vs2Field.setText("");
            this.rs1Field.setText("");
            this.rs2Field.setText("");
            this.rissField.setText("");
            if (this.hasStat) {
                for (int i = 0; i < 2; ++i) {
                    this.fillValLine(i, null);
                }
            }
            this.bemField.setText("");
            this.beforeButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
    }

    public void setObject(Object object) {
        this.trafops.removeAllElements();
        Punkt punkt = null;
        if (object instanceof Punkt) {
            punkt = (Punkt)object;
        } else if (object instanceof TrafoPunkt) {
            punkt = ((TrafoPunkt)object).getPunkt();
        }
        this.aktIdx = -1;
        Enumeration enumeration = DataBase.T.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            Enumeration enumeration2 = trafoSystem.elements();
            while (enumeration2.hasMoreElements()) {
                TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                if (trafoPunkt.getPunkt() != punkt) continue;
                this.trafops.addElement(trafoPunkt);
                if (object instanceof TrafoPunkt) {
                    if (trafoPunkt != object) continue;
                    this.aktIdx = this.trafops.size() - 1;
                    continue;
                }
                if (!trafoSystem.isVisible() || this.aktIdx >= 0) continue;
                this.aktIdx = this.trafops.size() - 1;
            }
        }
        this.setTrafoPoint();
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

